/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.export.CFAToPixelsWriter;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ConditionFolder;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.cwriter.ARGToCTranslator;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="residualprogram")
public class ResidualProgramConstructionAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="strategy", description="which strategy to use to generate the residual program")
    private ResidualGenStrategy constructionStrategy = ResidualGenStrategy.CONDITION;
    @Option(secure=true, name="file", description="write residual program to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path residualProgram = Path.of("residualProgram.c", new String[0]);
    @Option(secure=true, name="assumptionGuider", description="set specification file to automaton which guides analysis along assumption produced by incomplete analysis,e.g., config/specification/AssumptionGuidingAutomaton.spc, to enable residual program from combination of program and assumption condition")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path conditionSpec = null;
    @Option(secure=true, name="assumptionFile", description="set path to file which contains the condition")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path condition = null;
    @Option(secure=true, name="cfa.pixelGraphicFile", description="Export CFA of residual program as pixel graphic to the given file name. The suffix is added corresponding to the value of option pixelgraphic.export.formatIf set to 'null', no pixel graphic is exported.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportPixelFile = Path.of("residProgPixel", new String[0]);
    @Option(secure=true, name="export.pixel", description="Export residual program as pixel graphic")
    private boolean exportPixelGraphic = false;
    @Option(secure=true, name="statistics.size", description="Collect statistical data about size of residual program")
    private boolean collectResidualProgramSizeStatistics = false;
    private final CFA cfa;
    private final Specification spec;
    private final Configuration configuration;
    protected final LogManager logger;
    protected final ShutdownNotifier shutdown;
    private @Nullable CPAAlgorithm cpaAlgorithm;
    private final ARGToCTranslator translator;
    private final @Nullable ConditionFolder folder;
    protected final ProgramGenerationStatistics statistic = new ProgramGenerationStatistics();

    public ResidualProgramConstructionAlgorithm(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdown, Specification pSpec, ConfigurableProgramAnalysis pCpa, Algorithm pInnerAlgorithm) throws InvalidConfigurationException {
        this(pCfa, pConfig, pLogger, pShutdown, pSpec);
        if (!(pInnerAlgorithm instanceof CPAAlgorithm)) {
            throw new InvalidConfigurationException("For residual program generation, only the CPAAlgorithm is required.");
        }
        this.cpaAlgorithm = (CPAAlgorithm)pInnerAlgorithm;
        this.checkCPAConfiguration(pCpa);
    }

    protected ResidualProgramConstructionAlgorithm(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdown, Specification pSpec) throws InvalidConfigurationException {
        pConfig.inject((Object)this, ResidualProgramConstructionAlgorithm.class);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.shutdown = pShutdown;
        this.spec = pSpec;
        this.configuration = pConfig;
        this.translator = new ARGToCTranslator(this.logger, pConfig, this.cfa.getMachineModel());
        this.checkConfiguration();
        this.folder = this.getStrategy() == ResidualGenStrategy.CONDITION_PLUS_FOLD ? ConditionFolder.createFolder(pConfig, this.cfa) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Preconditions.checkState((boolean)this.checkInitialState(pReachedSet.getFirstState()), (Object)"CONDITION, CONDITION_PLUS_FOLD, and COMBINATION strategy require assumption automaton (condition) and assumption guiding automaton in specification");
        Preconditions.checkNotNull((Object)this.cpaAlgorithm);
        this.logger.log(Level.INFO, new Object[]{"Start construction of residual program."});
        try {
            this.statistic.modelBuildTimer.start();
            this.cpaAlgorithm.run(pReachedSet);
        }
        finally {
            this.statistic.modelBuildTimer.stop();
        }
        argRoot = (ARGState)pReachedSet.getFirstState();
        mainFunction = AbstractStates.extractLocation(argRoot);
        if (!ResidualProgramConstructionAlgorithm.$assertionsDisabled && mainFunction == null) {
            throw new AssertionError();
        }
        if (pReachedSet.hasWaitingState()) {
            this.logger.log(Level.SEVERE, new Object[]{"Analysis run to get structure of residual program is incomplete. ", "Ensure that you use cpa.automaton.breakOnTargetState=-1 in your configuration."});
            throw new CPAException("Failed to construct residual program");
        }
        try {
            this.statistic.collectPragmaPointsTimer.start();
            switch (1.$SwitchMap$org$sosy_lab$cpachecker$core$algorithm$residualprogram$ResidualProgramConstructionAlgorithm$ResidualGenStrategy[this.constructionStrategy.ordinal()]) {
                case 1: {
                    addPragma = this.getAllTargetStates(pReachedSet);
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 2: {
                    addPragma = this.getAllTargetStatesNotFullyExplored(pReachedSet);
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                default: {
                    addPragma = null;
                    break;
                }
            }
        }
        finally {
            this.statistic.collectPragmaPointsTimer.stop();
        }
        this.logger.log(Level.INFO, new Object[]{"Write residual program to file."});
        if (!this.writeResidualProgram(argRoot, addPragma)) {
            try {
                Files.deleteIfExists(this.residualProgram);
            }
            catch (IOException var5_7) {
                // empty catch block
            }
            throw new CPAException("Failed to write residual program.");
        }
        this.logger.log(Level.INFO, new Object[]{"Finished construction of residual program. ", "If the selected strategy is SLICING or COMBINATION, please continue with the slicing tool (Frama-C)"});
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }

    protected Set<ARGState> getAllTargetStates(ReachedSet pReachedSet) {
        this.logger.log(Level.INFO, new Object[]{"All target states in residual program are relevant and will be considered in slicing."});
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)pReachedSet, ARGState.class), state -> state.isTarget()));
    }

    private Set<ARGState> getAllTargetStatesNotFullyExplored(ReachedSet pNodesOfInlinedProg) {
        this.logger.log(Level.INFO, new Object[]{"Identify all target states in original program which are not fully explored according to condition and are relevant for slicing."});
        Multimap<CFANode, CallstackStateEqualsWrapper> unexploredTargetStates = this.getUnexploredTargetStates(AbstractStates.extractLocation(pNodesOfInlinedProg.getFirstState()));
        if (unexploredTargetStates == null) {
            this.logger.log(Level.WARNING, new Object[]{"Failed to identify target locations in program which have not been explored completely. ", "Assume that all target locations are unexplored."});
            return this.getAllTargetStates(pNodesOfInlinedProg);
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)pNodesOfInlinedProg, ARGState.class), state -> unexploredTargetStates.containsEntry((Object)AbstractStates.extractLocation(state), (Object)new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(state, CallstackState.class)))));
    }

    private @Nullable Multimap<CFANode, CallstackStateEqualsWrapper> getUnexploredTargetStates(CFANode mainFunction) {
        Preconditions.checkState((this.condition != null ? 1 : 0) != 0, (Object)"Please set option residualprogram.assumptionFile.");
        try {
            ConfigurationBuilder configBuilder = Configuration.builder();
            configBuilder.setOption("cpa", "cpa.arg.ARGCPA");
            configBuilder.setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA");
            configBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPA,cpa.callstack.CallstackCPA");
            configBuilder.setOption("cpa.automaton.breakOnTargetState", "-1");
            Configuration config = configBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(config, this.logger, this.shutdown, AggregatedReachedSets.empty());
            Specification constrSpec = this.spec.withAdditionalSpecificationFile((Set<Path>)ImmutableSet.of((Object)this.conditionSpec, (Object)this.condition), this.cfa, config, this.logger, this.shutdown);
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, constrSpec);
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition()), cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition()));
            CPAAlgorithm algo = CPAAlgorithm.create(cpa, this.logger, config, this.shutdown);
            algo.run(reached);
            if (reached.hasWaitingState()) {
                this.logger.log(Level.SEVERE, new Object[]{"Analysis run to get structure of residual program is incomplete"});
                return null;
            }
            HashMultimap result = HashMultimap.create((int)this.cfa.getAllNodes().size(), (int)this.cfa.getNumberOfFunctions());
            for (AbstractState targetState : AbstractStates.getTargetStates(reached)) {
                result.put((Object)AbstractStates.extractLocation(targetState), (Object)new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(targetState, CallstackState.class)));
            }
            return result;
        }
        catch (IllegalArgumentException | InterruptedException | InvalidConfigurationException | CPAException e1) {
            this.logger.log(Level.SEVERE, new Object[]{"Analysis to build structure of residual program failed", e1});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResidualProgramText(ARGState pARGRoot, @Nullable Set<ARGState> pAddPragma) throws CPAException, IOException {
        ARGState root = pARGRoot;
        if (this.constructionStrategy == ResidualGenStrategy.CONDITION_PLUS_FOLD) {
            Preconditions.checkState((pAddPragma == null ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)this.folder);
            try {
                this.statistic.foldTimer.start();
                this.statistic.modelBuildTimer.start();
                root = this.folder.foldARG(pARGRoot);
            }
            finally {
                this.statistic.modelBuildTimer.stop();
                this.statistic.foldTimer.stop();
            }
        }
        try {
            this.statistic.translationTimer.start();
            String string = this.translator.translateARG(root, pAddPragma, this.hasDeclarationGotoProblem());
            return string;
        }
        finally {
            this.statistic.translationTimer.stop();
        }
    }

    private boolean hasDeclarationGotoProblem() {
        return this.constructionStrategy != ResidualGenStrategy.CONDITION_PLUS_FOLD || this.folder.getType() != ConditionFolder.FOLDER_TYPE.CFA;
    }

    protected boolean writeResidualProgram(ARGState pArgRoot, @Nullable Set<ARGState> pAddPragma) throws InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Generate residual program"});
        try (Writer writer = IO.openOutputFile((Path)this.residualProgram, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            writer.write(this.getResidualProgramText(pArgRoot, pAddPragma));
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write residual program to file");
            return false;
        }
        catch (CPAException e) {
            this.logger.logException(Level.SEVERE, (Throwable)e, "Failed to generate residual program.");
            return false;
        }
        String mainFunction = AbstractStates.extractLocation(pArgRoot).getFunctionName();
        if (!this.translator.addsIncludeDirectives()) assert (this.isValidResidualProgram(mainFunction));
        return true;
    }

    private boolean isValidResidualProgram(String mainFunction) throws InterruptedException {
        try {
            CFACreator cfaCreator = new CFACreator(Configuration.builder().setOption("analysis.entryFunction", mainFunction).setOption("analysis.useLoopStructure", "false").build(), this.logger, this.shutdown);
            cfaCreator.parseFileAndCreateCFA(Lists.newArrayList((Object[])new String[]{this.residualProgram.toString()}));
        }
        catch (InvalidConfigurationException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Default configuration unsuitable for parsing residual program.", e});
            return false;
        }
        catch (IOException | ParserException e) {
            this.logger.log(Level.SEVERE, new Object[]{"No valid residual program generated. ", e});
            return false;
        }
        return true;
    }

    protected void checkConfiguration() throws InvalidConfigurationException {
        if (this.constructionStrategy == ResidualGenStrategy.SLICING && (this.conditionSpec == null || this.condition == null)) {
            throw new InvalidConfigurationException("When selection SLICING strategy, also the options residualprogram.assumptionGuider and residualprogram.assumptionFile must be set.");
        }
    }

    private void checkCPAConfiguration(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        if (pCpa instanceof ARGCPA && ((ARGCPA)pCpa).getWrappedCPAs().get(0) instanceof CompositeCPA) {
            CompositeCPA comCpa = (CompositeCPA)((ARGCPA)pCpa).getWrappedCPAs().get(0);
            boolean considersLocation = false;
            boolean considersCallstack = false;
            for (ConfigurableProgramAnalysis innerCPA : comCpa.getWrappedCPAs()) {
                if (innerCPA instanceof LocationCPA) {
                    considersLocation = true;
                    continue;
                }
                if (!(innerCPA instanceof CallstackCPA)) continue;
                considersCallstack = true;
            }
            if (!considersLocation || !considersCallstack) {
                throw new InvalidConfigurationException("For residual program generation location and callstack information is required.");
            }
        } else {
            throw new InvalidConfigurationException("Require an ARGCPA which wraps a CompositeCPA for residual program generation.");
        }
    }

    private boolean checkInitialState(AbstractState initState) {
        if (this.usesParallelCompositionOfProgramAndCondition()) {
            boolean considersAssumption = false;
            boolean considersAssumptionGuider = false;
            for (AbstractState component : AbstractStates.asIterable(initState)) {
                if (!(component instanceof AutomatonState)) continue;
                if (((AutomatonState)component).getOwningAutomatonName().equals("AssumptionAutomaton")) {
                    considersAssumption = true;
                }
                if (!((AutomatonState)component).getOwningAutomatonName().equals("AssumptionGuidingAutomaton")) continue;
                considersAssumptionGuider = true;
            }
            if (!considersAssumption || !considersAssumptionGuider) {
                return false;
            }
        }
        return true;
    }

    protected boolean usesParallelCompositionOfProgramAndCondition() {
        return this.getStrategy() == ResidualGenStrategy.CONDITION || this.getStrategy() == ResidualGenStrategy.COMBINATION || this.getStrategy() == ResidualGenStrategy.CONDITION_PLUS_FOLD;
    }

    protected ResidualGenStrategy getStrategy() {
        return this.constructionStrategy;
    }

    protected Specification getSpecification() {
        return this.spec;
    }

    protected @Nullable Path getAssumptionGuider() {
        return this.conditionSpec;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.cpaAlgorithm.collectStatistics(pStatsCollection);
        pStatsCollection.add(this.statistic);
    }

    protected class ProgramGenerationStatistics
    implements Statistics {
        private final Timer translationTimer = new Timer();
        private final Timer foldTimer = new Timer();
        protected final Timer modelBuildTimer = new Timer();
        protected final Timer collectPragmaPointsTimer = new Timer();

        protected ProgramGenerationStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            CFA residProg;
            StatisticsWriter statWriter = StatisticsWriter.writingStatisticsTo(pOut);
            statWriter.put("Time for residual program model construction", this.modelBuildTimer);
            if (ResidualProgramConstructionAlgorithm.this.getStrategy() == ResidualGenStrategy.CONDITION_PLUS_FOLD) {
                statWriter = statWriter.beginLevel();
                statWriter.put("Time for folding", this.foldTimer);
                statWriter = statWriter.endLevel();
            }
            if (ResidualProgramConstructionAlgorithm.this.getStrategy() == ResidualGenStrategy.SLICING || ResidualProgramConstructionAlgorithm.this.getStrategy() == ResidualGenStrategy.COMBINATION) {
                statWriter.put("Time for identifying pragma locations", this.collectPragmaPointsTimer);
            }
            statWriter.put("Time for C translation", this.translationTimer);
            if ((ResidualProgramConstructionAlgorithm.this.collectResidualProgramSizeStatistics || ResidualProgramConstructionAlgorithm.this.exportPixelGraphic && ResidualProgramConstructionAlgorithm.this.exportPixelFile != null) && (residProg = this.getResidualProgram(pReached.getFirstState())) != null) {
                if (ResidualProgramConstructionAlgorithm.this.collectResidualProgramSizeStatistics) {
                    int residProgSize = residProg.getAllNodes().size();
                    statWriter.put("Original program size (#loc)", ResidualProgramConstructionAlgorithm.this.cfa.getAllNodes().size());
                    statWriter.put("Generated program size (#loc)", residProgSize);
                    statWriter.put("Size increase", (double)residProgSize / (double)ResidualProgramConstructionAlgorithm.this.cfa.getAllNodes().size());
                }
                if (ResidualProgramConstructionAlgorithm.this.exportPixelGraphic && ResidualProgramConstructionAlgorithm.this.exportPixelFile != null) {
                    try {
                        new CFAToPixelsWriter(ResidualProgramConstructionAlgorithm.this.configuration).write(residProg.getMainFunction(), ResidualProgramConstructionAlgorithm.this.exportPixelFile);
                    }
                    catch (IOException | InvalidConfigurationException e) {
                        ResidualProgramConstructionAlgorithm.this.logger.logUserException(Level.WARNING, e, "Pixel export of residual program failed.");
                    }
                }
            }
        }

        private @Nullable CFA getResidualProgram(AbstractState root) {
            try {
                CFACreator cfaCreator = new CFACreator(Configuration.builder().setOption("analysis.entryFunction", AbstractStates.extractLocation(root).getFunctionName()).setOption("parser.usePreprocessor", "true").setOption("parser.useClang", "true").setOption("analysis.useLoopStructure", "false").build(), ResidualProgramConstructionAlgorithm.this.logger, ResidualProgramConstructionAlgorithm.this.shutdown);
                CFA residProg = cfaCreator.parseFileAndCreateCFA(Lists.newArrayList((Object[])new String[]{ResidualProgramConstructionAlgorithm.this.residualProgram.toString()}));
                return residProg;
            }
            catch (IOException | InterruptedException | InvalidConfigurationException | ParserException e) {
                return null;
            }
        }

        @Override
        public @Nullable String getName() {
            return "Residual Program Generation";
        }
    }

    public static enum ResidualGenStrategy {
        REACHABILITY,
        SLICING,
        CONDITION,
        CONDITION_PLUS_FOLD,
        COMBINATION;

    }
}

