/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.IGoalFindingStrategy;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.LeafGoalStrategy;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.LeafGoalWithPropagationStrategy;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.stopatleaves.StopAtLeavesCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Triple;

@Options(prefix="conditional_testing")
public class TestGoalToConditionConverterAlgorithm
extends NestingAlgorithm {
    private final Algorithm outerAlgorithm;
    private final ConfigurableProgramAnalysis outerCpa;
    private final IGoalFindingStrategy goalFindingStrategy;
    @Option(secure=true, name="strategy", required=true, description="The strategy to use")
    Strategy strategy;
    private Algorithm backwardsCpaAlgorithm;
    private ConfigurableProgramAnalysis backwardsCpa;
    @Option(secure=true, required=true, name="inputfile", description="The input file with all goals that were previously reached")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path inputfile;
    private final CFA cfa;

    public TestGoalToConditionConverterAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Algorithm pOuter, ConfigurableProgramAnalysis pOuterCpa) throws InvalidConfigurationException, InterruptedException {
        super(pConfig, pLogger, pShutdownNotifier, Specification.alwaysSatisfied());
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        switch (this.strategy) {
            case NAIVE: {
                this.goalFindingStrategy = new LeafGoalStrategy();
                break;
            }
            case PROPAGATION: {
                this.goalFindingStrategy = new LeafGoalWithPropagationStrategy();
                break;
            }
            default: {
                throw new InvalidConfigurationException("A strategy must be selected!");
            }
        }
        try {
            Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> backwardsCpaTriple = this.createAlgorithm(Path.of("config/components/goalConverterBackwardsSearch.properties", new String[0]), pCfa.getMainFunction(), pCfa, ShutdownManager.createWithParent((ShutdownNotifier)pShutdownNotifier), AggregatedReachedSets.empty(), (Collection<String>)ImmutableList.of((Object)"analysis.testGoalConverter", (Object)"cpa", (Object)"specification", (Object)"ARGCPA.cpa", (Object)"cpa.property_reachability.noFollowBackwardsUnreachable", (Object)"analysis.initialStatesFor", (Object)"CompositeCPA.cpas", (Object)"cpa.callstack.traverseBackwards", (Object)"analysis.collectAssumptions", (Object)"assumptions.automatonFile"), new HashSet<Statistics>());
            this.backwardsCpaAlgorithm = backwardsCpaTriple.getFirst();
            this.backwardsCpa = backwardsCpaTriple.getSecond();
        }
        catch (IOException | CPAException e) {
            throw new InvalidConfigurationException("Couldn't create backwards CPA algorithm!", (Throwable)e);
        }
        if (pOuter == null || pOuterCpa == null) {
            throw new InvalidConfigurationException("A valid pOuter algorithm must be specified!");
        }
        this.outerAlgorithm = pOuter;
        this.outerCpa = pOuterCpa;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        try {
            Map<LeafStates, List<CFANode>> leafGoals = this.getPartitionedLeafGoals();
            StopAtLeavesCPA stopAtLeavesCpa = CPAs.retrieveCPAOrFail(this.outerCpa, StopAtLeavesCPA.class, StopAtLeavesCPA.class);
            stopAtLeavesCpa.setLeaves(leafGoals.get((Object)LeafStates.UNCOVERED));
            return this.outerAlgorithm.run(reachedSet);
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException(e.getLocalizedMessage());
        }
    }

    private Set<String> getCoveredGoals() throws CPAException {
        Set set;
        block8: {
            Stream<String> lines = Files.lines(this.inputfile);
            try {
                set = (Set)lines.collect(ImmutableSet.toImmutableSet());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CPAException(e.getLocalizedMessage());
                }
            }
            lines.close();
        }
        return set;
    }

    private Map<LeafStates, List<CFANode>> getPartitionedLeafGoals() throws CPAException, InterruptedException {
        ReachedSet reachedSet = this.buildBackwardsReachedSet();
        Set<String> coveredGoals = this.getCoveredGoals();
        this.backwardsCpaAlgorithm.run(reachedSet);
        ArrayDeque<ARGState> waitList = new ArrayDeque<ARGState>();
        waitList.add((ARGState)reachedSet.getFirstState());
        return this.goalFindingStrategy.findGoals(waitList, coveredGoals);
    }

    private ReachedSet buildBackwardsReachedSet() throws InterruptedException {
        PartitionedReachedSet reachedSet = new PartitionedReachedSet(this.backwardsCpa, Waitlist.TraversalMethod.DFS);
        ImmutableSet initialLocations = ImmutableSet.builder().addAll(CFAUtils.getProgramSinks(this.cfa, this.cfa.getLoopStructure().orElseThrow(), this.cfa.getMainFunction())).build();
        for (CFANode loc : initialLocations) {
            StateSpacePartition partition = StateSpacePartition.getDefaultPartition();
            AbstractState state = this.backwardsCpa.getInitialState(loc, partition);
            Precision precision = this.backwardsCpa.getInitialPrecision(loc, partition);
            reachedSet.add(state, precision);
        }
        return reachedSet;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
    }

    public static enum Strategy {
        NAIVE,
        PROPAGATION;

    }

    static enum LeafStates {
        COVERED(true),
        UNCOVERED(false);

        private final boolean isCovered;

        private LeafStates(boolean b) {
            this.isCovered = b;
        }

        public boolean isCovered() {
            return this.isCovered;
        }
    }
}

