/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class ClassVariables {
    private DeclarationCollectionCFAVisitor visitor;

    private ClassVariables(DeclarationCollectionCFAVisitor visitor, CFA pCfa) {
        this.visitor = visitor;
        for (CFANode cFANode : pCfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverseOnce(cFANode, visitor);
        }
    }

    public static ClassVariables collectDeclarations(CFA pCfa) {
        Preconditions.checkNotNull((Object)pCfa);
        return new ClassVariables(new DeclarationCollectionCFAVisitor(), pCfa);
    }

    public Set<CVariableDeclaration> getDeclarations(LoopStructure.Loop pLoop) {
        String function = ((CFANode)pLoop.getLoopHeads().iterator().next()).getFunctionName();
        ImmutableSet relevantVariabels = ImmutableSet.builder().addAll(this.getGlobalDeclarations()).addAll((Iterable)this.getLocalDeclarations().get((Object)function)).build();
        return relevantVariabels;
    }

    public ImmutableSet<CVariableDeclaration> getGlobalDeclarations() {
        return this.visitor.globalDeclarations.build();
    }

    public ImmutableSetMultimap<String, CVariableDeclaration> getLocalDeclarations() {
        return this.visitor.localDeclarations.build();
    }

    private static final class DeclarationCollectionCFAVisitor
    extends CFATraversal.DefaultCFAVisitor {
        private final ImmutableSet.Builder<CVariableDeclaration> globalDeclarations = ImmutableSet.builder();
        private final ImmutableSetMultimap.Builder<String, CVariableDeclaration> localDeclarations = ImmutableSetMultimap.builder();

        private DeclarationCollectionCFAVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            if (pNode instanceof CFunctionEntryNode) {
                String functionName = pNode.getFunctionName();
                List<CParameterDeclaration> parameters = ((CFunctionEntryNode)pNode).getFunctionParameters();
                parameters.stream().map(CParameterDeclaration::asVariableDeclaration).forEach(decl -> this.localDeclarations.put((Object)functionName, decl));
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            CDeclaration declaration;
            if (pEdge instanceof CDeclarationEdge && (declaration = ((CDeclarationEdge)pEdge).getDeclaration()) instanceof CVariableDeclaration) {
                CVariableDeclaration variableDeclaration = (CVariableDeclaration)declaration;
                if (variableDeclaration.isGlobal()) {
                    this.globalDeclarations.add((Object)variableDeclaration);
                } else {
                    String functionName = pEdge.getPredecessor().getFunctionName();
                    this.localDeclarations.put((Object)functionName, (Object)variableDeclaration);
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

