/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationLoopInformation;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationStatistics;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.SimpleTargetInformation;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.waitlist.AlwaysEmptyWaitlist;
import org.sosy_lab.cpachecker.cpa.alwaystop.AlwaysTopCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.termination.TerminationCPA;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="termination")
public class TerminationAlgorithm
implements Algorithm,
AutoCloseable,
StatisticsProvider {
    private static final ImmutableSet<Targetable.TargetInformation> TERMINATION_PROPERTY = SimpleTargetInformation.singleton("termination");
    @Option(secure=true, description="Strategy used to prepare reched set and ARG for next iteration after successful refinement of the termination argument.")
    private ResetReachedSetStrategy resetReachedSetStrategy = ResetReachedSetStrategy.REMOVE_LOOP;
    @Option(secure=true, description="maximal number of repeated ranking functions per loop before stopping analysis")
    @IntegerOption(min=1L)
    private int maxRepeatedRankingFunctionsPerLoop = 10;
    @Option(secure=true, description="consider counterexamples for loops for which only pointer variables are relevant or which check that pointer is unequal to null pointer to be imprecise")
    private boolean useCexImpreciseHeuristic = false;
    @Option(secure=true, description="enable to also analyze whether recursive calls terminate")
    private boolean considerRecursion = false;
    private final TerminationStatistics statistics;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final ReachedSetFactory reachedSetFactory;
    private final Algorithm safetyAlgorithm;
    private final ConfigurableProgramAnalysis safetyCPA;
    private final LassoAnalysis lassoAnalysis;
    private final TerminationLoopInformation terminationInformation;
    private final Set<CVariableDeclaration> globalDeclaration;
    private final SetMultimap<String, CVariableDeclaration> localDeclarations;
    private final AggregatedReachedSets.AggregatedReachedSetManager aggregatedReachedSetManager;

    public TerminationAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, ReachedSetFactory pReachedSetFactory, AggregatedReachedSets.AggregatedReachedSetManager pAggregatedReachedSetManager, Algorithm pSafetyAlgorithm, ConfigurableProgramAnalysis pSafetyCPA) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.reachedSetFactory = (ReachedSetFactory)Preconditions.checkNotNull((Object)pReachedSetFactory);
        this.aggregatedReachedSetManager = (AggregatedReachedSets.AggregatedReachedSetManager)Preconditions.checkNotNull((Object)pAggregatedReachedSetManager);
        this.safetyAlgorithm = (Algorithm)Preconditions.checkNotNull((Object)pSafetyAlgorithm);
        this.safetyCPA = (ConfigurableProgramAnalysis)Preconditions.checkNotNull((Object)pSafetyCPA);
        TerminationCPA terminationCpa = CPAs.retrieveCPAOrFail(pSafetyCPA, TerminationCPA.class, TerminationAlgorithm.class);
        this.terminationInformation = terminationCpa.getTerminationInformation();
        DeclarationCollectionCFAVisitor visitor = new DeclarationCollectionCFAVisitor();
        for (CFANode cFANode : this.cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverseOnce(cFANode, visitor);
        }
        this.localDeclarations = ImmutableSetMultimap.copyOf(visitor.localDeclarations);
        this.globalDeclaration = ImmutableSet.copyOf(visitor.globalDeclarations);
        LoopStructure loopStructure = this.cfa.getLoopStructure().orElseThrow(() -> new InvalidConfigurationException("Loop structure is not present, but required for termination analysis."));
        this.statistics = new TerminationStatistics(pConfig, this.logger, loopStructure.getAllLoops().size(), pCfa);
        this.lassoAnalysis = LassoAnalysis.create(pLogger, pConfig, pShutdownNotifier, pCfa, this.statistics);
    }

    @Override
    public void close() {
        this.lassoAnalysis.close();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.statistics.algorithmStarted();
        try {
            Algorithm.AlgorithmStatus algorithmStatus = this.run0(pReachedSet);
            return algorithmStatus;
        }
        finally {
            this.statistics.algorithmFinished();
        }
    }

    private Algorithm.AlgorithmStatus run0(ReachedSet pReachedSet) throws InterruptedException, CPAException {
        this.logger.log(Level.INFO, new Object[]{"Starting termination algorithm."});
        if (this.cfa.getLanguage() != Language.C) {
            this.logger.log(Level.WARNING, new Object[]{"Termination analysis supports only C."});
            return Algorithm.AlgorithmStatus.UNSOUND_AND_IMPRECISE;
        }
        CFANode initialLocation = AbstractStates.extractLocation(pReachedSet.getFirstState());
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_IMPRECISE;
        ArrayList<LoopStructure.Loop> allLoops = new ArrayList<LoopStructure.Loop>((Collection<LoopStructure.Loop>)this.cfa.getLoopStructure().orElseThrow().getAllLoops());
        Collections.sort(allLoops, Comparator.comparingInt(l -> l.getInnerLoopEdges().size()));
        if (this.considerRecursion) {
            ArrayList<LoopStructure.Loop> allRecursions = new ArrayList<LoopStructure.Loop>(LoopStructure.getRecursions(this.cfa));
            Collections.sort(allRecursions, Comparator.comparingInt(l -> l.getInnerLoopEdges().size()));
            allLoops.addAll(allRecursions);
        }
        for (LoopStructure.Loop loop : allLoops) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.statistics.analysisOfLoopStarted(loop);
            if (this.considerRecursion) {
                this.setExplicitAbstractionNodes((ImmutableSet<CFANode>)ImmutableSet.of());
            }
            this.resetReachedSet(pReachedSet, initialLocation);
            CPAcheckerResult.Result loopTermination = this.proveLoopTermination(pReachedSet, loop, initialLocation);
            if (loopTermination == CPAcheckerResult.Result.FALSE) {
                this.logger.logf(Level.FINE, "Proved non-termination of %s.", new Object[]{loop});
                return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
            }
            if (loopTermination != CPAcheckerResult.Result.TRUE) {
                this.logger.logf(Level.FINE, "Could not prove (non-)termination of %s.", new Object[]{loop});
                status = status.withSound(false);
            }
            this.statistics.analysisOfLoopFinished(loop);
        }
        if (status.isSound() && !this.considerRecursion) {
            status = status.update(this.checkRecursion(initialLocation));
        }
        this.logger.log(Level.INFO, new Object[]{"Termination algorithm did not find a non-terminating loop."});
        while (status.isSound() && pReachedSet.hasWaitingState()) {
            pReachedSet.popFromWaitlist();
        }
        return status;
    }

    private CPAcheckerResult.Result proveLoopTermination(ReachedSet pReachedSet, LoopStructure.Loop pLoop, CFANode initialLocation) throws CPAException, InterruptedException {
        this.logger.logf(Level.FINE, "Prooving (non)-termination of %s", new Object[]{pLoop});
        HashSet<RankingRelation> rankingRelations = new HashSet<RankingRelation>();
        int totalRepeatedRankingFunctions = 0;
        int repeatedRankingFunctionsSinceSuccessfulIteration = 0;
        Set<CVariableDeclaration> relevantVariables = this.getRelevantVariables(pLoop);
        this.terminationInformation.setProcessedLoop(pLoop, relevantVariables);
        if (this.considerRecursion) {
            this.setExplicitAbstractionNodes(pLoop);
        }
        CPAcheckerResult.Result result = CPAcheckerResult.Result.TRUE;
        Optional<CounterexampleInfo> foundCounterexample = Optional.empty();
        while (pReachedSet.hasWaitingState() && result != CPAcheckerResult.Result.FALSE) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.statistics.safetyAnalysisStarted(pLoop);
            Algorithm.AlgorithmStatus status = this.safetyAlgorithm.run(pReachedSet);
            this.terminationInformation.resetCfa();
            this.statistics.safetyAnalysisFinished(pLoop);
            this.shutdownNotifier.shutdownIfNecessary();
            boolean targetReached = pReachedSet.asCollection().stream().anyMatch(AbstractStates::isTargetState);
            Optional<ARGState> targetStateWithCounterExample = pReachedSet.stream().filter(AbstractStates::isTargetState).map(s -> AbstractStates.extractStateByType(s, ARGState.class)).filter(s -> s.getCounterexampleInformation().isPresent()).findAny();
            if (status.isPrecise() && targetStateWithCounterExample.isPresent()) {
                ARGState loopHeadState;
                ARGState nonTerminationLoopHead;
                ARGState targetState = targetStateWithCounterExample.orElseThrow();
                CounterexampleInfo originalCounterexample = targetState.getCounterexampleInformation().orElseThrow();
                CounterexampleInfo counterexample = this.removeDummyLocationsFromCounterExample(originalCounterexample, nonTerminationLoopHead = this.createNonTerminationState(loopHeadState = (ARGState)Iterables.getOnlyElement(targetState.getParents())));
                LassoAnalysisResult lassoAnalysisResult = this.lassoAnalysis.checkTermination(pLoop, counterexample, relevantVariables);
                if (lassoAnalysisResult.hasNonTerminationArgument()) {
                    this.removeIntermediateStates(pReachedSet, targetState);
                    result = CPAcheckerResult.Result.FALSE;
                    foundCounterexample = Optional.of(counterexample);
                    this.statistics.setNonterminatingLoop(pLoop);
                    continue;
                }
                if (lassoAnalysisResult.hasTerminationArgument()) {
                    RankingRelation rankingRelation = lassoAnalysisResult.getTerminationArgument();
                    if (rankingRelations.add(rankingRelation)) {
                        this.terminationInformation.addRankingRelation(rankingRelation);
                        this.prepareForNextIteration(pReachedSet, targetState, initialLocation);
                        this.addInvariantsToAggregatedReachedSet(loopHeadState, rankingRelation);
                        result = CPAcheckerResult.Result.TRUE;
                        repeatedRankingFunctionsSinceSuccessfulIteration = 0;
                        continue;
                    }
                    ++totalRepeatedRankingFunctions;
                    this.logger.logf(Level.WARNING, "Repeated ranking relation %s for %s", new Object[]{rankingRelation, pLoop});
                    if (++repeatedRankingFunctionsSinceSuccessfulIteration > this.maxRepeatedRankingFunctionsPerLoop / 5) {
                        this.removeTargetState(pReachedSet, targetState);
                        result = CPAcheckerResult.Result.UNKNOWN;
                        continue;
                    }
                    if (totalRepeatedRankingFunctions >= this.maxRepeatedRankingFunctionsPerLoop) {
                        this.removeTargetState(pReachedSet, targetState);
                        return CPAcheckerResult.Result.UNKNOWN;
                    }
                    this.prepareForNextIteration(pReachedSet, targetState, initialLocation);
                    result = CPAcheckerResult.Result.TRUE;
                    continue;
                }
                this.logger.logf(Level.WARNING, "Could not synthesize a termination or non-termination argument.", new Object[0]);
                this.removeTargetState(pReachedSet, targetState);
                result = CPAcheckerResult.Result.UNKNOWN;
                continue;
            }
            if (status.isSound() && !targetReached && !pReachedSet.hasWaitingState()) continue;
            result = CPAcheckerResult.Result.UNKNOWN;
        }
        if (this.useCexImpreciseHeuristic && result == CPAcheckerResult.Result.FALSE) {
            if (this.allRelevantVarsArePointers(relevantVariables) || this.doesImpreciseOperationOccur(foundCounterexample)) {
                this.logger.logf(Level.INFO, "Counterexample to termination found, but deemed imprecise", new Object[0]);
                return CPAcheckerResult.Result.UNKNOWN;
            }
            for (CFAEdge edge : pLoop.getOutgoingEdges()) {
                if (!(edge instanceof CAssumeEdge) || !this.possiblyNotEqualsNullPointer(((CAssumeEdge)edge).getExpression())) continue;
                return CPAcheckerResult.Result.UNKNOWN;
            }
        }
        return result;
    }

    private boolean doesImpreciseOperationOccur(Optional<CounterexampleInfo> pCounterexampleInfo) {
        if (pCounterexampleInfo.isEmpty()) {
            return false;
        }
        CounterexampleInfo cex = pCounterexampleInfo.orElseThrow();
        List<CFAEdge> edgesOnCex = cex.getTargetPath().getFullPath();
        for (CFAEdge edge : edgesOnCex) {
            CRightHandSide expression = CFAEdgeUtils.getRightHandSide(edge);
            if (expression != null && this.containsBinaryOperation(expression)) {
                return true;
            }
            if (!edge.getEdgeType().equals((Object)CFAEdgeType.AssumeEdge) || !this.containsBinaryOperation(((CAssumeEdge)edge).getExpression())) continue;
            return true;
        }
        return false;
    }

    private boolean containsBinaryOperation(CRightHandSide expression) {
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExp = (CBinaryExpression)expression;
            CBinaryExpression.BinaryOperator operator = binaryExp.getOperator();
            if (this.isBitwiseBinaryOperation(operator) || this.isMultiplicationWithEqualFactors(operator, binaryExp)) {
                return true;
            }
            return this.containsBinaryOperation(binaryExp.getOperand1()) || this.containsBinaryOperation(binaryExp.getOperand2());
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExp = (CUnaryExpression)expression;
            CUnaryExpression.UnaryOperator operator = unaryExp.getOperator();
            if (operator.equals(CUnaryExpression.UnaryOperator.TILDE)) {
                return true;
            }
            return this.containsBinaryOperation(unaryExp.getOperand());
        }
        return false;
    }

    private boolean isBitwiseBinaryOperation(CBinaryExpression.BinaryOperator pOperator) {
        switch (pOperator) {
            case BINARY_AND: 
            case BINARY_XOR: 
            case BINARY_OR: {
                return true;
            }
        }
        return false;
    }

    private boolean isMultiplicationWithEqualFactors(CBinaryExpression.BinaryOperator pOperator, CBinaryExpression pExpression) {
        if (pOperator == CBinaryExpression.BinaryOperator.MULTIPLY) {
            HashSet<CIdExpression> factors = new HashSet<CIdExpression>();
            return this.containsEqualFactors(pExpression, factors);
        }
        return false;
    }

    private boolean containsEqualFactors(CRightHandSide pExpression, Set<CIdExpression> pFactors) {
        CBinaryExpression binaryExpression;
        if (pExpression instanceof CIdExpression && !pFactors.add((CIdExpression)pExpression)) {
            return true;
        }
        boolean equalFactorsFound = false;
        if (pExpression instanceof CBinaryExpression && (binaryExpression = (CBinaryExpression)pExpression).getOperator() == CBinaryExpression.BinaryOperator.MULTIPLY) {
            equalFactorsFound |= this.containsEqualFactors(binaryExpression.getOperand1(), pFactors);
            equalFactorsFound |= this.containsEqualFactors(binaryExpression.getOperand2(), pFactors);
        }
        return equalFactorsFound;
    }

    private boolean allRelevantVarsArePointers(Set<CVariableDeclaration> pRelevantVariables) {
        if (pRelevantVariables.isEmpty()) {
            return false;
        }
        boolean allPointers = true;
        for (CVariableDeclaration var : pRelevantVariables) {
            if (var.getType() instanceof CPointerType) continue;
            allPointers = false;
            break;
        }
        return allPointers;
    }

    private boolean possiblyNotEqualsNullPointer(CExpression expr) {
        CBinaryExpression binExpr;
        return expr instanceof CBinaryExpression && (binExpr = (CBinaryExpression)expr).getOperator() == CBinaryExpression.BinaryOperator.NOT_EQUALS && binExpr.getOperand2() instanceof CCastExpression && binExpr.getOperand2().getExpressionType() instanceof CPointerType && ((CCastExpression)binExpr.getOperand2()).getOperand() instanceof CLiteralExpression;
    }

    private void addInvariantsToAggregatedReachedSet(ARGState loopHeadState, RankingRelation rankingRelation) {
        LocationMappedReachedSet dummy = new LocationMappedReachedSet(AlwaysTopCPA.INSTANCE, AlwaysEmptyWaitlist.factory());
        CFANode location = AbstractStates.extractLocation(loopHeadState);
        FormulaManagerView fmgr = rankingRelation.getFormulaManager();
        rankingRelation.getSupportingInvariants().stream().map(invariant -> new TerminationInvariantSupplierState(location, (BooleanFormula)invariant, fmgr)).forEach(s -> dummy.addNoWaitlist((AbstractState)s, SingletonPrecision.getInstance()));
        this.aggregatedReachedSetManager.addReachedSet(dummy);
    }

    private Set<CVariableDeclaration> getRelevantVariables(LoopStructure.Loop pLoop) {
        CFANode firstLoopHead = (CFANode)pLoop.getLoopHeads().iterator().next();
        if (firstLoopHead instanceof FunctionEntryNode) {
            ImmutableSet.Builder relVarBuilder = ImmutableSet.builder();
            relVarBuilder.addAll(this.globalDeclaration);
            for (CFANode entryNode : FluentIterable.from(pLoop.getLoopNodes()).filter(FunctionEntryNode.class)) {
                relVarBuilder.addAll((Iterable)this.localDeclarations.get((Object)entryNode.getFunctionName()));
            }
            return relVarBuilder.build();
        }
        String function = firstLoopHead.getFunctionName();
        ImmutableSet relevantVariabels = ImmutableSet.builder().addAll(this.globalDeclaration).addAll((Iterable)this.localDeclarations.get((Object)function)).build();
        return relevantVariabels;
    }

    private void removeIntermediateStates(ReachedSet pReachedSet, AbstractState pTargetState) {
        Preconditions.checkArgument((boolean)AbstractStates.isTargetState(pTargetState));
        Preconditions.checkArgument((!this.cfa.getAllNodes().contains(AbstractStates.extractLocation(pTargetState)) ? 1 : 0) != 0);
        ARGState targetState = AbstractStates.extractStateByType(pTargetState, ARGState.class);
        Preconditions.checkArgument((boolean)targetState.getCounterexampleInformation().isPresent());
        CounterexampleInfo counterexample = targetState.getCounterexampleInformation().orElseThrow();
        ARGState loopHead = (ARGState)Iterables.getOnlyElement(targetState.getParents());
        ARGState newTargetState = this.createNonTerminationState(loopHead);
        targetState.removeFromARG();
        loopHead.replaceInARGWith(newTargetState);
        pReachedSet.addNoWaitlist(newTargetState, pReachedSet.getPrecision(loopHead));
        pReachedSet.remove(pTargetState);
        pReachedSet.remove(loopHead);
        CounterexampleInfo newCounterexample = this.removeDummyLocationsFromCounterExample(counterexample, newTargetState);
        newTargetState.addCounterexampleInformation(newCounterexample);
    }

    private ARGState createNonTerminationState(AbstractState loopHead) {
        TerminationState terminationState = AbstractStates.extractStateByType(loopHead, TerminationState.class);
        TerminationState newTerminationState = terminationState.withTargetInformation((Set<Targetable.TargetInformation>)TERMINATION_PROPERTY);
        ARGState newTargetState = new ARGState(newTerminationState, null);
        return newTargetState;
    }

    private CounterexampleInfo removeDummyLocationsFromCounterExample(CounterexampleInfo counterexample, ARGState newTargetState) {
        ARGPath targetPath = counterexample.getTargetPath();
        PathIterator targetPathIt = targetPath.fullPathIterator();
        ARGPathBuilder builder = ARGPath.builder();
        Optional<ARGState> lastStateInCfa = Optional.empty();
        do {
            CFANode location;
            block5: {
                block7: {
                    CFANode nextLocation;
                    block6: {
                        if (!targetPathIt.hasNext()) continue;
                        CFAEdge outgoingEdge = targetPathIt.getOutgoingEdge();
                        location = outgoingEdge.getPredecessor();
                        nextLocation = outgoingEdge.getSuccessor();
                        if (!this.cfa.getAllNodes().contains(location) || !this.cfa.getAllNodes().contains(nextLocation)) break block5;
                        if (targetPathIt.isPositionWithState()) break block6;
                        if (!lastStateInCfa.isPresent()) break block7;
                    }
                    ARGState state = lastStateInCfa.orElseGet(targetPathIt::getAbstractState);
                    ARGState nextAbstractState = targetPathIt.getNextAbstractState();
                    CFAEdge edgeToNextState = null;
                    if (AbstractStates.extractLocation(nextAbstractState).equals(nextLocation)) {
                        edgeToNextState = state.getEdgeToChild(nextAbstractState);
                    }
                    builder.add(state, edgeToNextState);
                }
                lastStateInCfa = Optional.empty();
                continue;
            }
            if (!this.cfa.getAllNodes().contains(location) || !targetPathIt.isPositionWithState()) continue;
            lastStateInCfa = Optional.of(targetPathIt.getAbstractState());
        } while (targetPathIt.advanceIfPossible());
        ARGPath newTargetPath = builder.build(newTargetState);
        CounterexampleInfo newCounterexample = CounterexampleInfo.feasibleImprecise(newTargetPath);
        return newCounterexample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm.AlgorithmStatus checkRecursion(CFANode initialLocation) throws CPAException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        this.statistics.analysisOfRecursionStarted();
        try {
            this.terminationInformation.reset();
            ReachedSet reachedSet = this.reachedSetFactory.create(this.safetyCPA);
            this.resetReachedSet(reachedSet, initialLocation);
            Algorithm.AlgorithmStatus algorithmStatus = this.safetyAlgorithm.run(reachedSet);
            return algorithmStatus;
        }
        finally {
            this.statistics.analysisOfRecursionFinished();
        }
    }

    private void prepareForNextIteration(ReachedSet pReachedSet, ARGState pTargetState, CFANode pInitialLocation) throws InterruptedException {
        switch (this.resetReachedSetStrategy) {
            case REMOVE_TARGET_STATE: {
                pTargetState.getParents().forEach(pReachedSet::reAddToWaitlist);
                this.removeTargetState(pReachedSet, pTargetState);
                break;
            }
            case REMOVE_LOOP: {
                this.removeLoop(pReachedSet, pTargetState);
                break;
            }
            case RESET: {
                this.resetReachedSet(pReachedSet, pInitialLocation);
                break;
            }
            default: {
                throw new AssertionError((Object)this.resetReachedSetStrategy);
            }
        }
    }

    private void removeTargetState(ReachedSet pReachedSet, ARGState pTargetState) {
        assert (pTargetState.isTarget());
        pReachedSet.remove(pTargetState);
        pTargetState.removeFromARG();
    }

    private void removeLoop(ReachedSet pReachedSet, ARGState pTargetState) throws InterruptedException {
        ArrayDeque<ARGState> workList = new ArrayDeque<ARGState>();
        workList.add(pTargetState);
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayList<ARGState> firstLoopStates = new ArrayList<ARGState>();
        while (!workList.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState next = (ARGState)workList.poll();
            if (!seen.add(next)) continue;
            Collection parentLoopStates = (Collection)next.getParents().stream().filter(p -> AbstractStates.extractStateByType(p, TerminationState.class).isPartOfLoop()).collect(ImmutableList.toImmutableList());
            if (parentLoopStates.isEmpty()) {
                firstLoopStates.add(next);
                continue;
            }
            workList.addAll(parentLoopStates);
        }
        ARGReachedSet argReachedSet = new ARGReachedSet(pReachedSet);
        for (ARGState state : firstLoopStates) {
            argReachedSet.removeSubtree(state);
        }
    }

    private void resetReachedSet(ReachedSet pReachedSet, CFANode pInitialLocation) throws InterruptedException {
        AbstractState initialState = this.safetyCPA.getInitialState(pInitialLocation, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = this.safetyCPA.getInitialPrecision(pInitialLocation, StateSpacePartition.getDefaultPartition());
        pReachedSet.clear();
        pReachedSet.add(initialState, initialPrecision);
    }

    private void setExplicitAbstractionNodes(LoopStructure.Loop pLoop) {
        CFANode firstLoopHead = (CFANode)pLoop.getLoopHeads().iterator().next();
        if (firstLoopHead instanceof FunctionEntryNode) {
            this.setExplicitAbstractionNodes((ImmutableSet<CFANode>)ImmutableSet.of((Object)firstLoopHead));
        }
    }

    private void setExplicitAbstractionNodes(ImmutableSet<CFANode> newAbsLocs) {
        PredicateCPA predCPA = CPAs.retrieveCPA(this.safetyCPA, PredicateCPA.class);
        if (predCPA != null) {
            predCPA.changeExplicitAbstractionNodes(newAbsLocs);
        }
    }

    private static class DeclarationCollectionCFAVisitor
    extends CFATraversal.DefaultCFAVisitor {
        private final Set<CVariableDeclaration> globalDeclarations = new LinkedHashSet<CVariableDeclaration>();
        private final Multimap<String, CVariableDeclaration> localDeclarations = MultimapBuilder.hashKeys().linkedHashSetValues().build();

        private DeclarationCollectionCFAVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            if (pNode instanceof CFunctionEntryNode) {
                String functionName = pNode.getFunctionName();
                List<CParameterDeclaration> parameters = ((CFunctionEntryNode)pNode).getFunctionParameters();
                parameters.stream().map(CParameterDeclaration::asVariableDeclaration).forEach(this.localDeclarations.get((Object)functionName)::add);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            CDeclaration declaration;
            if (pEdge instanceof CDeclarationEdge && (declaration = ((CDeclarationEdge)pEdge).getDeclaration()) instanceof CVariableDeclaration) {
                CVariableDeclaration variableDeclaration = (CVariableDeclaration)declaration;
                if (variableDeclaration.isGlobal()) {
                    this.globalDeclarations.add(variableDeclaration);
                } else {
                    String functionName = pEdge.getPredecessor().getFunctionName();
                    this.localDeclarations.put((Object)functionName, (Object)variableDeclaration);
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }

    private static class TerminationInvariantSupplierState
    implements AbstractStateWithLocation,
    FormulaReportingState {
        private final CFANode location;
        private final FormulaManagerView fmgr;
        private final BooleanFormula invariant;

        public TerminationInvariantSupplierState(CFANode pLocation, BooleanFormula pInvariant, FormulaManagerView pFmgr) {
            this.location = (CFANode)Preconditions.checkNotNull((Object)pLocation);
            this.invariant = (BooleanFormula)Preconditions.checkNotNull((Object)pInvariant);
            this.fmgr = (FormulaManagerView)Preconditions.checkNotNull((Object)pFmgr);
        }

        @Override
        public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
            return pManager.translateFrom(this.invariant, this.fmgr);
        }

        @Override
        public CFANode getLocationNode() {
            return this.location;
        }

        @Override
        public String toString() {
            return TerminationInvariantSupplierState.class.getSimpleName() + "[" + this.invariant + "]";
        }
    }

    private static enum ResetReachedSetStrategy {
        REMOVE_TARGET_STATE,
        REMOVE_LOOP,
        RESET;

    }
}

