/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AbstractSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationUtils;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;

@NotThreadSafe
public class TerminationLoopInformation {
    private static final String NON_TERMINATION_LABEL = "__CPACHECKER_NON_TERMINATION";
    private Optional<LoopStructure.Loop> loop = Optional.empty();
    private Set<CFANode> loopLeavingLocations = ImmutableSet.of();
    private Set<CFAEdge> loopLeavingEdges = ImmutableSet.of();
    private Optional<RankingRelation> rankingRelation = Optional.empty();
    private Map<CExpression, CVariableDeclaration> relevantVariables = ImmutableMap.of();
    private List<CFANode> relevantVariablesInitializationIntermediateLocations = ImmutableList.of();
    private Set<CFAEdge> createdCfaEdges = new LinkedHashSet<CFAEdge>();
    private Optional<CFANode> targetNode = Optional.empty();
    private final CBinaryExpressionBuilder binaryExpressionBuilder;
    private final LogManager logger;

    public TerminationLoopInformation(MachineModel pMachineModel, LogManager pLogger) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.binaryExpressionBuilder = new CBinaryExpressionBuilder(pMachineModel, pLogger);
        this.resetRankingRelation();
    }

    private void resetRankingRelation() {
        this.rankingRelation = Optional.empty();
    }

    public boolean isLoopHead(CFANode pLocation) {
        return this.loop.map(LoopStructure.Loop::getLoopHeads).map(lh -> lh.contains((Object)pLocation)).orElse(false);
    }

    public boolean isPredecessorOfIncomingEdge(CFANode pLocation) {
        return this.loop.isPresent() && CFAUtils.leavingEdges(pLocation).anyMatch(edge -> this.loop.orElseThrow().getIncomingEdges().contains(edge));
    }

    public CExpression getRankingRelationAsCExpression() {
        return this.rankingRelation.map(RankingRelation::asCExpression).orElseGet(() -> this.binaryExpressionBuilder.buildBinaryExpressionUnchecked(CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.EQUALS));
    }

    public Optional<RankingRelation> getRankingRelation() {
        return this.rankingRelation;
    }

    public boolean isloopLeavingEdge(CFAEdge pEdge) {
        return this.loopLeavingEdges.contains(pEdge);
    }

    public boolean isloopLeavingLocation(CFANode pLocation) {
        return this.loopLeavingLocations.contains(pLocation);
    }

    void addRankingRelation(RankingRelation pRankingRelation) {
        this.rankingRelation = Optional.of(this.rankingRelation.map(r -> r.merge(pRankingRelation)).orElse(pRankingRelation));
    }

    void setProcessedLoop(LoopStructure.Loop pLoop, Set<CVariableDeclaration> pRelevantVariables) {
        this.loop = Optional.of(pLoop);
        this.loopLeavingLocations = Collections3.transformedImmutableSetCopy(pLoop.getOutgoingEdges(), CFAEdge::getSuccessor);
        this.loopLeavingEdges = ImmutableSet.copyOf(pLoop.getOutgoingEdges());
        this.resetRankingRelation();
        AFunctionDeclaration functionName = ((CFANode)pLoop.getLoopHeads().iterator().next()).getFunction();
        ImmutableList.Builder intermediateStates = ImmutableList.builder();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CVariableDeclaration relevantVariable : pRelevantVariables) {
            AbstractLeftHandSide unprimedVariable = new CIdExpression(FileLocation.DUMMY, relevantVariable);
            CVariableDeclaration primedVariable = TerminationUtils.createPrimedVariable(relevantVariable);
            builder.put((Object)unprimedVariable, (Object)primedVariable);
            intermediateStates.add((Object)new CFANode(functionName));
            CType type = relevantVariable.getType();
            while (type instanceof CPointerType && !((type = ((CPointerType)type).getType()) instanceof CVoidType) && !(type instanceof CFunctionType)) {
                unprimedVariable = new CPointerExpression(FileLocation.DUMMY, type, (CExpression)((Object)unprimedVariable));
                primedVariable = TerminationUtils.createDereferencedVariable(primedVariable);
                builder.put((Object)unprimedVariable, (Object)primedVariable);
                intermediateStates.add((Object)new CFANode(functionName));
            }
        }
        this.targetNode = Optional.of(new CFALabelNode(functionName, NON_TERMINATION_LABEL));
        this.relevantVariablesInitializationIntermediateLocations = intermediateStates.build();
        this.relevantVariables = builder.buildOrThrow();
    }

    void reset() {
        this.loop = Optional.empty();
        this.loopLeavingLocations = ImmutableSet.of();
        this.loopLeavingEdges = ImmutableSet.of();
        this.relevantVariables = ImmutableMap.of();
        this.relevantVariablesInitializationIntermediateLocations = ImmutableList.of();
        this.targetNode = Optional.empty();
        this.resetCfa();
    }

    public CFAEdge createRankingRelationAssumeEdge(CFANode startNode, CFANode endNode, boolean postive) {
        return this.createAssumeEdge(this.getRankingRelationAsCExpression(), startNode, endNode, postive);
    }

    public List<CFAEdge> createStemToLoopTransition(CFANode startNode, CFANode endNode) {
        CFANode currentNode = startNode;
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<CFANode> intermediateLocations = this.relevantVariablesInitializationIntermediateLocations.iterator();
        for (CStatement assignment : this.createPrimedVariableAssignments()) {
            CFANode nextNode = intermediateLocations.next();
            CStatementEdge edge = this.crateCStatementEdge(assignment, currentNode, nextNode);
            builder.add((Object)edge);
            currentNode = nextNode;
        }
        BlankEdge edge = this.createBlankEdge(currentNode, endNode, "");
        builder.add((Object)edge);
        return builder.build();
    }

    private List<CStatement> createPrimedVariableAssignments() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<CExpression, CVariableDeclaration> relevantVariable : this.relevantVariables.entrySet()) {
            CExpression unprimedVariable = relevantVariable.getKey();
            CVariableDeclaration primedVariable = relevantVariable.getValue();
            CExpressionAssignmentStatement assignment = this.createAssignmentStatement(primedVariable, unprimedVariable);
            builder.add((Object)assignment);
        }
        return builder.build();
    }

    public List<CFAEdge> createPrimedVariableDeclarations(CFANode startLocation) {
        AFunctionDeclaration function = startLocation.getFunction();
        this.logger.logf(Level.FINEST, "Adding declarations of primed variables %s after %s in function %s.", new Object[]{MoreStrings.lazyString(() -> this.relevantVariables.values().stream().map(AbstractSimpleDeclaration::getName).collect(Collectors.joining(" ,"))), startLocation, function});
        ImmutableList.Builder builder = ImmutableList.builder();
        CFANode currentNode = startLocation;
        for (CVariableDeclaration primedVariable : this.relevantVariables.values()) {
            CFANode nextNode = this.createCfaNode(function);
            CDeclarationEdge edge = this.createDeclarationEdge(primedVariable, currentNode, nextNode);
            builder.add((Object)edge);
            currentNode = nextNode;
        }
        BlankEdge edge = this.createBlankEdge(currentNode, startLocation, "");
        builder.add((Object)edge);
        return builder.build();
    }

    public CFAEdge createEdgeToNonTerminationLabel(CFANode pLocation) {
        Preconditions.checkState((boolean)this.targetNode.isPresent());
        return this.createBlankEdge(pLocation, this.targetNode.orElseThrow(), "Label: __CPACHECKER_NON_TERMINATION");
    }

    public CFAEdge createNegatedRankingRelationAssumeEdgeToTargetNode(CFANode pLoopHead) {
        Preconditions.checkState((boolean)this.targetNode.isPresent());
        return this.createRankingRelationAssumeEdge(pLoopHead, this.targetNode.orElseThrow(), false);
    }

    private CFANode createCfaNode(AFunctionDeclaration pFunction) {
        return new CFANode(pFunction);
    }

    private CExpressionAssignmentStatement createAssignmentStatement(CSimpleDeclaration pLeftHandSide, CExpression pRightHandSide) {
        return new CExpressionAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, pLeftHandSide), pRightHandSide);
    }

    public BlankEdge createBlankEdge(CFANode pPredecessor, CFANode pSuccessor, String pDescription) {
        BlankEdge edge = new BlankEdge(pDescription + ";", FileLocation.DUMMY, pPredecessor, pSuccessor, pDescription);
        this.addToCfa(edge);
        return edge;
    }

    private CStatementEdge crateCStatementEdge(CStatement pStatement, CFANode pPredecessor, CFANode pSuccessor) {
        CStatementEdge edge = new CStatementEdge(pStatement.toASTString(), pStatement, FileLocation.DUMMY, pPredecessor, pSuccessor);
        this.addToCfa(edge);
        return edge;
    }

    private CAssumeEdge createAssumeEdge(CExpression condition, CFANode predecessor, CFANode successor, boolean postive) {
        CAssumeEdge edge = new CAssumeEdge(condition.toASTString(), FileLocation.DUMMY, predecessor, successor, condition, postive);
        this.addToCfa(edge);
        return edge;
    }

    private CDeclarationEdge createDeclarationEdge(CDeclaration declaration, CFANode predecessor, CFANode successor) {
        CDeclarationEdge edge = new CDeclarationEdge(declaration.toASTString(), FileLocation.DUMMY, predecessor, successor, declaration);
        this.addToCfa(edge);
        return edge;
    }

    private void addToCfa(CFAEdge edge) {
        CFACreationUtils.addEdgeUnconditionallyToCFA(edge);
        this.createdCfaEdges.add(edge);
    }

    public void resetCfa() {
        this.createdCfaEdges.forEach(CFACreationUtils::removeEdgeFromNodes);
        this.createdCfaEdges.clear();
    }
}

