/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisStatistics;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankVar;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessToOutputFormatsUtils;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.location.LocationStateFactory;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="termination")
public class TerminationStatistics
extends LassoAnalysisStatistics {
    @Option(secure=true, description="A human readable representation of the synthesized (non-)termination arguments is exported to this file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path resultFile = Path.of("terminationAnalysisResult.txt", new String[0]);
    @Option(secure=true, name="violation.witness", description="Export termination counterexample to file as GraphML automaton ")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path violationWitness = Path.of("nontermination_witness.graphml", new String[0]);
    @Option(secure=true, name="violation.witness.dot", description="Export termination counterexample to file as dot/graphviz automaton ")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path violationWitnessDot = Path.of("nontermination_witness.dot", new String[0]);
    @Option(secure=true, name="compressWitness", description="compress the produced violation-witness automata using GZIP compression.")
    private boolean compressWitness = true;
    private final int totalLoops;
    private final Set<LoopStructure.Loop> analysedLoops = Sets.newConcurrentHashSet();
    private final Timer totalTime = new Timer();
    private final Timer loopTime = new Timer();
    private final Timer recursionTime = new Timer();
    private final Timer safetyAnalysisTime = new Timer();
    private final Multiset<LoopStructure.Loop> safetyAnalysisRunsPerLoop = ConcurrentHashMultiset.create();
    private final LogManager logger;
    private final WitnessExporter witnessExporter;
    private final LocationStateFactory locFac;
    private  @Nullable LoopStructure.Loop nonterminatingLoop = null;

    public TerminationStatistics(Configuration pConfig, LogManager pLogger, int pTotalNumberOfLoops, CFA pCFA) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.totalLoops = pTotalNumberOfLoops;
        this.witnessExporter = new WitnessExporter(pConfig, pLogger, Specification.alwaysSatisfied().withAdditionalProperties((Set<Property>)ImmutableSet.of((Object)Property.CommonVerificationProperty.TERMINATION)), pCFA);
        this.locFac = new LocationStateFactory(pCFA, AnalysisDirection.FORWARD, pConfig);
    }

    void algorithmStarted() {
        this.totalTime.start();
    }

    void algorithmFinished() {
        this.totalTime.stop();
        this.safetyAnalysisTime.stopIfRunning();
        this.lassoTime.stopIfRunning();
        this.loopTime.stopIfRunning();
    }

    void analysisOfLoopStarted(LoopStructure.Loop pLoop) {
        boolean newLoop = this.analysedLoops.add(pLoop);
        Preconditions.checkState((boolean)newLoop);
        this.loopTime.start();
    }

    void analysisOfLoopFinished(LoopStructure.Loop pLoop) {
        Preconditions.checkState((boolean)this.analysedLoops.contains(pLoop));
        this.loopTime.stop();
        this.recursionTime.stopIfRunning();
        this.safetyAnalysisTime.stopIfRunning();
        this.lassoTime.stopIfRunning();
        this.lassoConstructionTime.stopIfRunning();
        this.lassoNonTerminationTime.stopIfRunning();
        this.lassoTerminationTime.stopIfRunning();
    }

    void analysisOfRecursionStarted() {
        this.recursionTime.start();
    }

    void analysisOfRecursionFinished() {
        this.recursionTime.stop();
    }

    void safetyAnalysisStarted(LoopStructure.Loop pLoop) {
        Preconditions.checkState((boolean)this.analysedLoops.contains(pLoop));
        this.safetyAnalysisRunsPerLoop.add((Object)pLoop);
        this.safetyAnalysisTime.start();
    }

    void safetyAnalysisFinished(LoopStructure.Loop pLoop) {
        Preconditions.checkState((boolean)this.analysedLoops.contains(pLoop));
        Preconditions.checkState((boolean)this.safetyAnalysisRunsPerLoop.contains((Object)pLoop));
        this.safetyAnalysisTime.stop();
    }

    void setNonterminatingLoop(LoopStructure.Loop pLoop) {
        Preconditions.checkState((this.nonterminatingLoop == null ? 1 : 0) != 0);
        Preconditions.checkState((pLoop != null ? 1 : 0) != 0);
        this.nonterminatingLoop = pLoop;
    }

    @Override
    public void synthesizedTerminationArgument(LoopStructure.Loop pLoop, TerminationArgument pTerminationArgument) {
        Preconditions.checkState((boolean)this.analysedLoops.contains(pLoop));
        super.synthesizedTerminationArgument(pLoop, pTerminationArgument);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        String name;
        pOut.println("Total time :                                        " + this.totalTime);
        pOut.println("Time for recursion analysis:                        " + this.recursionTime);
        pOut.println();
        int loops = this.analysedLoops.size();
        pOut.println("Number of analysed loops:                               " + StatisticsUtils.valueWithPercentage(loops, this.totalLoops));
        pOut.println("Total time for loop analysis:                       " + this.loopTime);
        pOut.println("  Avg time per loop analysis:                       " + TerminationStatistics.format(this.loopTime.getAvgTime()));
        pOut.println("  Max time per loop analysis:                       " + TerminationStatistics.format(this.loopTime.getMaxTime()));
        pOut.println();
        int safetyAnalysisRuns = this.safetyAnalysisRunsPerLoop.size();
        assert (safetyAnalysisRuns == this.safetyAnalysisTime.getNumberOfIntervals());
        int maxSafetyAnalysisRuns = this.safetyAnalysisRunsPerLoop.entrySet().stream().mapToInt(Multiset.Entry::getCount).max().orElse(0);
        String loopsWithMaxSafetyAnalysisRuns = this.safetyAnalysisRunsPerLoop.entrySet().stream().filter(e -> e.getCount() == maxSafetyAnalysisRuns).map(Multiset.Entry::getElement).map(l -> l.getLoopHeads().toString()).collect(Collectors.joining(", "));
        pOut.println("Number of safety analysis runs:                     " + TerminationStatistics.format(safetyAnalysisRuns));
        if (loops > 0) {
            pOut.println("  Avg safety analysis run per loop:                 " + TerminationStatistics.div(safetyAnalysisRuns, loops));
        }
        pOut.println("  Max safety analysis run per loop:                 " + TerminationStatistics.format(maxSafetyAnalysisRuns) + " \t for loops " + loopsWithMaxSafetyAnalysisRuns);
        pOut.println("Total time for safety analysis:                     " + this.safetyAnalysisTime);
        pOut.println("  Avg time per safety analysis run:                 " + TerminationStatistics.format(this.safetyAnalysisTime.getAvgTime()));
        pOut.println("  Max time per safety analysis run:                 " + TerminationStatistics.format(this.safetyAnalysisTime.getMaxTime()));
        pOut.println();
        int iterations = this.lassoTime.getNumberOfIntervals();
        int lassos = this.lassosPerLoop.size();
        int maxLassosPerLoop = this.lassosPerLoop.entrySet().stream().mapToInt(Multiset.Entry::getCount).max().orElse(0);
        String loopsWithMaxLassos = this.lassosPerLoop.entrySet().stream().filter(e -> e.getCount() == maxLassosPerLoop).map(Multiset.Entry::getElement).map(l -> l.getLoopHeads().toString()).collect(Collectors.joining(", "));
        pOut.println("Number of analysed lassos:                          " + TerminationStatistics.format(lassos));
        if (loops > 0) {
            pOut.println("  Avg number of lassos per loop:                    " + TerminationStatistics.div(lassos, loops));
        }
        pOut.println("  Max number of lassos per loop:                    " + TerminationStatistics.format(maxLassosPerLoop) + " \t for loops " + loopsWithMaxLassos);
        if (loops > 0) {
            pOut.println("  Avg number of lassos per iteration:               " + TerminationStatistics.div(lassos, iterations));
        }
        pOut.println("  Max number of lassos per iteration:               " + TerminationStatistics.format(this.maxLassosPerIteration.get()));
        pOut.println();
        pOut.println("Total time for lassos analysis:                     " + this.lassoTime);
        pOut.println("  Avg time per iteration:                           " + TerminationStatistics.format(this.lassoTime.getAvgTime()));
        pOut.println("  Max time per iteration:                           " + TerminationStatistics.format(this.lassoTime.getMaxTime()));
        pOut.println("  Time for lassos construction:                     " + this.lassoConstructionTime);
        pOut.println("    Avg time for lasso construction per iteration:  " + TerminationStatistics.format(this.lassoConstructionTime.getAvgTime()));
        pOut.println("    Max time for lasso construction per iteration:  " + TerminationStatistics.format(this.lassoConstructionTime.getMaxTime()));
        pOut.println("      Time for stem and loop construction:                     " + this.lassoStemLoopConstructionTime);
        pOut.println("        Avg time for stem and loop construction per iteration:  " + TerminationStatistics.format(this.lassoStemLoopConstructionTime.getAvgTime()));
        pOut.println("        Max time for stem and loop construction per iteration:  " + TerminationStatistics.format(this.lassoStemLoopConstructionTime.getMaxTime()));
        pOut.println("      Time for lassos creation:                     " + this.lassosCreationTime);
        pOut.println("        Avg time for lassos creation per iteration:  " + TerminationStatistics.format(this.lassosCreationTime.getAvgTime()));
        pOut.println("        Max time for lassos creation per iteration:  " + TerminationStatistics.format(this.lassosCreationTime.getMaxTime()));
        pOut.println("  Total time for non-termination analysis:          " + this.lassoNonTerminationTime);
        pOut.println("    Avg time for non-termination analysis per lasso:" + TerminationStatistics.format(this.lassoNonTerminationTime.getAvgTime()));
        pOut.println("    Max time for non-termination analysis per lasso:" + TerminationStatistics.format(this.lassoNonTerminationTime.getMaxTime()));
        pOut.println("  Total time for termination analysis:              " + this.lassoTerminationTime);
        pOut.println("    Avg time for termination analysis per lasso:    " + TerminationStatistics.format(this.lassoTerminationTime.getAvgTime()));
        pOut.println("    Max time for termination analysis per lasso:    " + TerminationStatistics.format(this.lassoTerminationTime.getMaxTime()));
        pOut.println();
        int totoalTerminationArguments = this.terminationArguments.size();
        int maxTerminationArgumentsPerLoop = this.terminationArguments.asMap().values().stream().mapToInt(Collection::size).max().orElse(0);
        String loopsWithMaxTerminationArguments = this.terminationArguments.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() == maxTerminationArgumentsPerLoop).map(Map.Entry::getKey).map(l -> l.getLoopHeads().toString()).collect(Collectors.joining(", "));
        pOut.println("Total number of termination arguments:              " + TerminationStatistics.format(totoalTerminationArguments));
        if (loops > 0) {
            pOut.println("  Avg termination arguments per loop:               " + TerminationStatistics.div(totoalTerminationArguments, loops));
        }
        pOut.println("  Max termination arguments per loop:               " + TerminationStatistics.format(maxTerminationArgumentsPerLoop) + " \t for loops " + loopsWithMaxTerminationArguments);
        pOut.println();
        HashMap<String, Integer> terminationArguementTypes = new HashMap<String, Integer>();
        for (TerminationArgument terminationArgument : this.terminationArguments.values()) {
            name = terminationArgument.getRankingFunction().getName();
            terminationArguementTypes.merge(name, 1, Integer::sum);
        }
        for (Map.Entry entry : terminationArguementTypes.entrySet()) {
            name = (String)entry.getKey();
            String whiteSpaces = " ".repeat(49 - name.length());
            pOut.println("  " + name + ":" + whiteSpaces + TerminationStatistics.format((Integer)entry.getValue()));
        }
        this.exportSynthesizedArguments();
        if (pResult == CPAcheckerResult.Result.FALSE && (this.violationWitness != null || this.violationWitnessDot != null)) {
            Iterator violations = pReached.stream().filter(AbstractStates::isTargetState).map(s -> AbstractStates.extractStateByType(s, ARGState.class)).filter(s -> s.getCounterexampleInformation().isPresent()).iterator();
            Preconditions.checkState((this.nonterminatingLoop != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)violations.hasNext());
            this.exportViolationWitness((ARGState)pReached.getFirstState(), (ARGState)violations.next());
            Preconditions.checkState((!violations.hasNext() ? 1 : 0) != 0);
        }
    }

    private void exportSynthesizedArguments() {
        if (this.resultFile != null) {
            this.logger.logf(Level.FINER, "Writing result of termination analysis into %s.", new Object[]{this.resultFile});
            try (Writer writer = IO.openOutputFile((Path)this.resultFile, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);){
                writer.append("Non-termination arguments:\n");
                for (Map.Entry nonTerminationArgument : this.nonTerminationArguments.entrySet()) {
                    writer.append(((LoopStructure.Loop)nonTerminationArgument.getKey()).toString());
                    writer.append(":\n");
                    writer.append(((NonTerminationArgument)nonTerminationArgument.getValue()).toString());
                    writer.append('\n');
                }
                writer.append("\n\nTermination arguments:\n");
                for (LoopStructure.Loop loop : this.terminationArguments.keySet()) {
                    for (TerminationArgument terminationArgument : this.terminationArguments.get((Object)loop)) {
                        writer.append(loop.toString());
                        writer.append(":\n");
                        writer.append(terminationArgument.toString());
                        writer.append('\n');
                    }
                    writer.append('\n');
                }
            }
            catch (IOException e) {
                this.logger.logException(Level.WARNING, (Throwable)e, "Could not export (non-)termination arguments.");
            }
        }
    }

    private void exportViolationWitness(ARGState root, ARGState loopStart) {
        CounterexampleInfo cexInfo = loopStart.getCounterexampleInformation().orElseThrow();
        ARGState loopStartInCEX = new ARGState(AbstractStates.extractStateByType(loopStart, LocationState.class), null);
        ARGState newRoot = new ARGState(root.getWrappedState(), null);
        Collection<ARGState> cexStates = this.copyStem(cexInfo.getTargetPath(), newRoot, loopStart, loopStartInCEX);
        NonTerminationArgument arg = (NonTerminationArgument)this.nonTerminationArguments.get(this.nonterminatingLoop);
        ExpressionTree<Object> quasiInvariant = this.buildInvariantFrom(arg);
        Function provideQuasiInvariant = argState -> {
            if (Objects.equals(argState, loopStartInCEX)) {
                return quasiInvariant;
            }
            return ExpressionTrees.getTrue();
        };
        cexStates.addAll(this.addCEXLoopingPartToARG(loopStartInCEX));
        Predicate relevantStates = Predicates.in(cexStates);
        try {
            Witness witness = this.witnessExporter.generateTerminationErrorWitness(newRoot, (Predicate<? super ARGState>)relevantStates, BiPredicates.bothSatisfy(relevantStates), (Predicate<? super ARGState>)((Predicate)state -> Objects.equals(state, loopStartInCEX)), (Function<? super ARGState, ExpressionTree<Object>>)provideQuasiInvariant);
            if (this.violationWitness != null) {
                WitnessToOutputFormatsUtils.writeWitness(this.violationWitness, this.compressWitness, pAppendable -> WitnessToOutputFormatsUtils.writeToGraphMl(witness, pAppendable), this.logger);
            }
            if (this.violationWitnessDot != null) {
                WitnessToOutputFormatsUtils.writeWitness(this.violationWitnessDot, this.compressWitness, pAppendable -> WitnessToOutputFormatsUtils.writeToDot(witness, pAppendable), this.logger);
            }
        }
        catch (InterruptedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not export termination witness due to interruption");
        }
    }

    private Collection<ARGState> copyStem(ARGPath pStem, ARGState newRoot, ARGState loopStart, ARGState newLoopStart) {
        HashSet<ARGState> newStates = new HashSet<ARGState>();
        boolean first = true;
        ARGState parent = newRoot;
        newStates.add(newRoot);
        for (ARGState state : pStem.asStatesList()) {
            ARGState child;
            if (first) {
                first = false;
                continue;
            }
            if (Objects.equals(state, loopStart)) {
                newLoopStart.addParent(parent);
                newStates.add(newLoopStart);
                break;
            }
            parent = child = new ARGState(state.getWrappedState(), parent);
            newStates.add(parent);
        }
        return newStates;
    }

    private Collection<ARGState> addCEXLoopingPartToARG(ARGState pLoopEntry) {
        CFANode loc = AbstractStates.extractLocation(pLoopEntry);
        Preconditions.checkState((boolean)this.nonterminatingLoop.getLoopHeads().contains((Object)loc));
        HashSet<ARGState> relevantARGStates = new HashSet<ARGState>();
        HashMap nodeToARGState = Maps.newHashMapWithExpectedSize((int)this.nonterminatingLoop.getLoopNodes().size());
        nodeToARGState.put(loc, pLoopEntry);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.push(loc);
        while (!waitlist.isEmpty()) {
            loc = (CFANode)waitlist.pop();
            ARGState pred = (ARGState)nodeToARGState.get(loc);
            assert (pred != null);
            for (CFAEdge leave : CFAUtils.leavingEdges(loc)) {
                if (this.nonterminatingLoop.getLoopNodes().contains((Object)leave.getSuccessor())) {
                    ARGState succ = (ARGState)nodeToARGState.get(leave.getSuccessor());
                    if (succ == null) {
                        succ = new ARGState(this.locFac.getState(leave.getSuccessor()), null);
                        nodeToARGState.put(leave.getSuccessor(), succ);
                        waitlist.push(leave.getSuccessor());
                    }
                    succ.addParent(pred);
                    continue;
                }
                if (!(leave instanceof FunctionCallEdge) || !pred.getChildren().isEmpty()) continue;
                CFANode locContinueLoop = ((FunctionCallEdge)leave).getSummaryEdge().getSuccessor();
                HashMap<Pair<CFANode, CallstackState>, ARGState> contextToARGState = new HashMap<Pair<CFANode, CallstackState>, ARGState>();
                Pair context = Pair.of(leave.getSuccessor(), new CallstackState(null, leave.getSuccessor().getFunctionName(), leave.getPredecessor()));
                ArrayDeque<Pair<CFANode, CallstackState>> waitlistFun = new ArrayDeque<Pair<CFANode, CallstackState>>();
                waitlistFun.push(context);
                ARGState succFun = new ARGState(this.locFac.getState(leave.getSuccessor()), null);
                contextToARGState.put(context, succFun);
                succFun.addParent(pred);
                while (!waitlistFun.isEmpty()) {
                    context = (Pair)waitlistFun.pop();
                    ARGState predFun = (ARGState)contextToARGState.get(context);
                    assert (predFun != null);
                    for (CFAEdge leaveFun : CFAUtils.leavingEdges((CFANode)context.getFirst())) {
                        Pair<CFANode, CallstackState> newContext = Pair.of(leaveFun.getSuccessor(), (CallstackState)context.getSecond());
                        if (leaveFun instanceof FunctionReturnEdge) {
                            if (!((CallstackState)context.getSecond()).getCallNode().equals(((FunctionReturnEdge)leaveFun).getSummaryEdge().getPredecessor())) continue;
                            newContext = Pair.of(leaveFun.getSuccessor(), ((CallstackState)context.getSecond()).getPreviousState());
                        }
                        if (leaveFun instanceof FunctionCallEdge) {
                            newContext = Pair.of(leaveFun.getSuccessor(), new CallstackState((CallstackState)context.getSecond(), leaveFun.getSuccessor().getFunctionName(), leaveFun.getPredecessor()));
                        }
                        if (!Objects.equals(leaveFun.getSuccessor(), locContinueLoop)) {
                            succFun = (ARGState)contextToARGState.get(newContext);
                        } else {
                            succFun = (ARGState)nodeToARGState.get(locContinueLoop);
                            assert (newContext.getSecond() == null);
                        }
                        if (succFun == null) {
                            succFun = new ARGState(this.locFac.getState(leaveFun.getSuccessor()), null);
                            if (!Objects.equals(leaveFun.getSuccessor(), locContinueLoop)) {
                                contextToARGState.put(newContext, succFun);
                                waitlistFun.push(newContext);
                            } else {
                                nodeToARGState.put(leaveFun.getSuccessor(), succFun);
                                waitlist.push(leaveFun.getSuccessor());
                            }
                        }
                        succFun.addParent(predFun);
                    }
                }
                assert (nodeToARGState.containsKey(locContinueLoop));
                relevantARGStates.addAll(contextToARGState.values());
            }
        }
        relevantARGStates.addAll(nodeToARGState.values());
        return relevantARGStates;
    }

    private ExpressionTree<Object> buildInvariantFrom(NonTerminationArgument pArg) {
        ExpressionTree<Object> computedQuasiInvariant = ExpressionTrees.getTrue();
        if (pArg instanceof GeometricNonTerminationArgument) {
            computedQuasiInvariant = this.buildInvariantFrom((GeometricNonTerminationArgument)pArg);
        } else if (pArg instanceof InfiniteFixpointRepetition) {
            computedQuasiInvariant = this.buildInvaraintFrom((InfiniteFixpointRepetition)pArg);
        }
        return computedQuasiInvariant;
    }

    private ExpressionTree<Object> buildInvariantFrom(GeometricNonTerminationArgument arg) {
        ExpressionTree<Object> result = ExpressionTrees.getTrue();
        if (this.likelyIsFixpoint(arg)) {
            for (Map.Entry entry : arg.getStateHonda().entrySet()) {
                RankVar rankVar = (RankVar)entry.getKey();
                if (rankVar.getTerm() instanceof ApplicationTerm && ((ApplicationTerm)rankVar.getTerm()).getParameters().length != 0) continue;
                String varName = this.toOrigName(((IProgramVar)entry.getKey()).getTermVariable());
                CLiteralExpression litexpr = this.literalExpressionFrom((Rational)entry.getValue());
                result = And.of(result, LeafExpression.of(this.buildEquals(varName, litexpr)));
            }
        }
        return result;
    }

    private boolean likelyIsFixpoint(GeometricNonTerminationArgument arg) {
        HashMap<IProgramVar, Rational> secondElem = new HashMap<IProgramVar, Rational>(arg.getStateHonda());
        for (Map map : arg.getGEVs()) {
            for (Map.Entry entry : map.entrySet()) {
                secondElem.put((IProgramVar)entry.getKey(), ((Rational)entry.getValue()).add((Rational)secondElem.get(entry.getKey())));
            }
        }
        for (Map.Entry entry : secondElem.entrySet()) {
            if (((Rational)entry.getValue()).equals(arg.getStateHonda().get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private ExpressionTree<Object> buildInvaraintFrom(InfiniteFixpointRepetition arg) {
        ExpressionTree<Object> result = ExpressionTrees.getTrue();
        for (Map.Entry entry : arg.getValuesAtHonda().entrySet()) {
            CLiteralExpression litexpr;
            if (!(entry.getKey() instanceof TermVariable) || !(entry.getValue() instanceof ConstantTerm)) continue;
            String varName = this.toOrigName((TermVariable)entry.getKey());
            Object termVal = ((ConstantTerm)entry.getValue()).getValue();
            if (termVal instanceof BigDecimal) {
                litexpr = new CFloatLiteralExpression(FileLocation.DUMMY, CNumericTypes.FLOAT, (BigDecimal)termVal);
            } else if (termVal instanceof BigInteger) {
                litexpr = CIntegerLiteralExpression.createDummyLiteral(((BigInteger)termVal).longValue(), CNumericTypes.INT);
            } else {
                if (!(termVal instanceof Rational)) continue;
                litexpr = this.literalExpressionFrom((Rational)termVal);
            }
            result = And.of(result, LeafExpression.of(this.buildEquals(varName, litexpr)));
        }
        return result;
    }

    private CLiteralExpression literalExpressionFrom(Rational rat) {
        if (rat.numerator().mod(rat.denominator()).intValue() == 0) {
            return CIntegerLiteralExpression.createDummyLiteral(rat.numerator().divide(rat.denominator()).longValue(), CNumericTypes.INT);
        }
        return new CFloatLiteralExpression(FileLocation.DUMMY, CNumericTypes.FLOAT, new BigDecimal(rat.numerator()).divide(new BigDecimal(rat.denominator())));
    }

    private CBinaryExpression buildEquals(String varName, CLiteralExpression litExpr) {
        CSimpleType type = litExpr instanceof CIntegerLiteralExpression ? CNumericTypes.INT : CNumericTypes.FLOAT;
        CIdExpression idexpr = new CIdExpression(FileLocation.DUMMY, type, varName, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, type, varName, varName, varName, null));
        return new CBinaryExpression(FileLocation.DUMMY, type, type, idexpr, litExpr, CBinaryExpression.BinaryOperator.EQUALS);
    }

    private String toOrigName(TermVariable pTermVariable) {
        String varName = pTermVariable.getName();
        if (varName.startsWith("(")) {
            return this.expressionVarName(varName);
        }
        MemoryLocation memLoc = MemoryLocation.parseExtendedQualifiedName(varName);
        return memLoc.getIdentifier();
    }

    private String expressionVarName(String varName) {
        String result = varName;
        if (result.startsWith("(")) {
            List<String> t = this.extractArgs(result = result.substring(1, result.length() - 1));
            if (t.get(0).startsWith("*")) {
                if (t.size() == 2) {
                    return "*(" + this.expressionVarName(t.get(1)) + ")";
                }
                if (t.size() == 3) {
                    return "(" + this.expressionVarName(t.get(1)) + ")*(" + this.expressionVarName(t.get(2)) + ")";
                }
            }
            if (t.get(0).startsWith("+") && t.size() == 3) {
                return "(" + this.expressionVarName(t.get(1)) + ")+(" + this.expressionVarName(t.get(2)) + ")";
            }
            if (t.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (String s : t) {
                    sb.append(this.expressionVarName(s));
                }
                return sb.toString();
            }
        }
        if (result.startsWith("|") && result.endsWith("|")) {
            result = result.substring(1, result.length() - 1);
        }
        MemoryLocation memLoc = MemoryLocation.parseExtendedQualifiedName(result);
        return memLoc.getIdentifier();
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> extractArgs(String input) {
        ArrayList<String> args = new ArrayList<String>(2);
        String extendedInput = input + " ";
        int openBrackets = 0;
        StringBuilder bd = new StringBuilder();
        int i = 0;
        while (true) {
            block8: {
                if (i >= extendedInput.length()) {
                    return args;
                }
                char c = extendedInput.charAt(i);
                switch (c) {
                    case '(': {
                        ++openBrackets;
                        break;
                    }
                    case ')': {
                        --openBrackets;
                        break;
                    }
                    case ' ': {
                        if (openBrackets != 0) break;
                        if (bd.length() != 0) {
                            args.add(bd.toString());
                            bd = new StringBuilder();
                        }
                        break block8;
                    }
                }
                bd.append(c);
            }
            ++i;
        }
    }

    @Override
    public @Nullable String getName() {
        return "Termination Algorithm";
    }

    private static String format(TimeSpan pTimeSpan) {
        return pTimeSpan.formatAs(TimeUnit.SECONDS);
    }

    private static String format(int value) {
        return String.format("%5d", value);
    }

    private static String div(double val, double full) {
        return String.format("%8.2f", val / full);
    }
}

