/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public class TerminationUtils {
    private static final String PRIMED_VARIABLE_POSTFIX = "__TERMINATION_PRIMED";
    private static final String DEREFERENCE_POSTFIX = "__TERMINATION_DEREFERENCED";

    private TerminationUtils() {
    }

    public static CVariableDeclaration createPrimedVariable(CVariableDeclaration pVariableDecl) {
        return new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, pVariableDecl.getType(), pVariableDecl.getName() + PRIMED_VARIABLE_POSTFIX, pVariableDecl.getOrigName() + PRIMED_VARIABLE_POSTFIX, pVariableDecl.getQualifiedName() + PRIMED_VARIABLE_POSTFIX, null);
    }

    public static CVariableDeclaration createDereferencedVariable(CSimpleDeclaration pVariableDecl) {
        CType type = pVariableDecl.getType();
        if (type instanceof CPointerType) {
            CType innerType = ((CPointerType)type).getType();
            Preconditions.checkArgument((!(innerType instanceof CVoidType) ? 1 : 0) != 0);
            Preconditions.checkArgument((!(innerType instanceof CFunctionType) ? 1 : 0) != 0);
            return new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, innerType, pVariableDecl.getName() + DEREFERENCE_POSTFIX, pVariableDecl.getOrigName() + DEREFERENCE_POSTFIX, pVariableDecl.getQualifiedName() + DEREFERENCE_POSTFIX, null);
        }
        throw new IllegalArgumentException(type + " is not a pointer type");
    }
}

