/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.DefaultLassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.DefaultNonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.DefaultTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.AffineTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.NestedTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisStatistics;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelationBuilder;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.LassoBuilder;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.toolchain.LassoRankerToolchainStorage;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;

@Options(prefix="termination.lassoAnalysis")
public class LassoAnalysis {
    @Option(secure=true, description="Number of non-strict supporting invariants for each Motzkin transformation during synthesis of termination arguments.")
    @IntegerOption(min=1L)
    private int nonStrictInvariants = 3;
    @Option(secure=true, description="Number of generalized eigenvectors in the geometric nontermination argument.")
    @IntegerOption(min=0L)
    private int eigenvectors = 3;
    @Option(secure=true, description="Number of strict supporting invariants for each Motzkin transformation during synthesis of termination arguments.")
    @IntegerOption(min=0L)
    private int strictInvariants = 2;
    @Option(name="linear.analysisType", secure=true, description="Analysis type used for synthesis of linear termination arguments.")
    private LassoAnalysisType linearAnalysisType = LassoAnalysisType.LINEAR_WITH_GUESSES;
    @Option(name="linear.externalSolver", secure=true, description="If true, an external tool is used as SMT solver instead of SMTInterpol. This affects only synthesis of linear termination arguments.")
    private boolean linearExternalSolver = false;
    @Option(secure=true, name="nonlinear.analysisType", description="Analysis type used for synthesis of non-linear termination arguments.")
    private LassoAnalysisType nonlinearAnalysisType = LassoAnalysisType.LINEAR_WITH_GUESSES;
    @Option(name="nonlinear.externalSolver", secure=true, description="If true, an external tool is used as SMT solver instead of SMTInterpol. This affects only synthesis of non-linear termination arguments and non-termination arguments.")
    private boolean nonlinearExternalSolver = false;
    @Option(description="Shell command used to call the external SMT solver.")
    private String externalSolverCommand = NativeLibraries.getNativeLibraryPath().resolve("z3") + " -smt2 -in SMTLIB2_COMPLIANT=true ";
    @Option(secure=true, description="Maximal number of functions used in a ranking function template.")
    @IntegerOption(min=1L)
    private int maxTemplateFunctions = 3;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final LassoAnalysisStatistics statistics;
    private final SolverContext solverContext;
    private final LassoBuilder lassoBuilder;
    private final RankingRelationBuilder rankingRelationBuilder;
    private final LassoRankerPreferences linearLassoRankerPreferences;
    private final LassoRankerPreferences nonlinearLassoRankerPreferences;
    private final NonTerminationAnalysisSettings nonTerminationAnalysisSettings;
    private final TerminationAnalysisSettings linearTerminationAnalysisSettings;
    private final TerminationAnalysisSettings nonlinearTerminationAnalysisSettings;
    private final LassoRankerToolchainStorage toolchainStorage;
    private final ImmutableList<RankingTemplate> rankingTemplates;

    public static LassoAnalysis create(LassoBuilder pLassoBuilder, RankingRelationBuilder pRankingRelationBuilder, SolverContext pSolverContext, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier, LassoAnalysisStatistics pStatistics) throws InvalidConfigurationException {
        return new LassoAnalysis(pLassoBuilder, pRankingRelationBuilder, pSolverContext, pLogger, pConfig, pShutdownNotifier, pStatistics);
    }

    public static LassoAnalysis create(LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier, CFA pCfa, LassoAnalysisStatistics pStatistics) throws InvalidConfigurationException {
        pConfig = Solver.adjustConfigForSolver(pConfig);
        SolverContext solverContext = SolverContextFactory.createSolverContext((Configuration)pConfig, (LogManager)pLogger, (ShutdownNotifier)pShutdownNotifier, (SolverContextFactory.Solvers)SolverContextFactory.Solvers.SMTINTERPOL);
        AbstractFormulaManager formulaManager = (AbstractFormulaManager)solverContext.getFormulaManager();
        FormulaManagerView formulaManagerView = new FormulaManagerView((FormulaManager)formulaManager, pConfig, pLogger);
        PathFormulaManagerImpl pathFormulaManager = new PathFormulaManagerImpl(formulaManagerView, pConfig, pLogger, pShutdownNotifier, pCfa, AnalysisDirection.FORWARD);
        LassoBuilder lassoBuilder = new LassoBuilder(pConfig, pLogger, pShutdownNotifier, formulaManager, formulaManagerView, () -> solverContext.newProverEnvironment(new SolverContext.ProverOptions[0]), pathFormulaManager, pStatistics);
        RankingRelationBuilder rankingRelationBuilder = new RankingRelationBuilder(pCfa.getMachineModel(), pLogger, formulaManagerView, formulaManager.getFormulaCreator());
        return new LassoAnalysis(lassoBuilder, rankingRelationBuilder, solverContext, pLogger, pConfig, pShutdownNotifier, pStatistics);
    }

    private LassoAnalysis(LassoBuilder pLassoBuilder, RankingRelationBuilder pRankingRelationBuilder, SolverContext pSolverContext, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier, LassoAnalysisStatistics pStatistics) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.statistics = (LassoAnalysisStatistics)Preconditions.checkNotNull((Object)pStatistics);
        this.lassoBuilder = (LassoBuilder)Preconditions.checkNotNull((Object)pLassoBuilder);
        this.rankingRelationBuilder = (RankingRelationBuilder)Preconditions.checkNotNull((Object)pRankingRelationBuilder);
        this.solverContext = (SolverContext)Preconditions.checkNotNull((Object)pSolverContext);
        this.linearLassoRankerPreferences = new LassoRankerPreferences((ILassoRankerPreferences)new DefaultLassoRankerPreferences(){

            public String getExternalSolverCommand() {
                return LassoAnalysis.this.externalSolverCommand;
            }

            public boolean isExternalSolver() {
                return LassoAnalysis.this.linearExternalSolver;
            }
        });
        this.nonlinearLassoRankerPreferences = new LassoRankerPreferences((ILassoRankerPreferences)new DefaultLassoRankerPreferences(){

            public String getExternalSolverCommand() {
                return LassoAnalysis.this.externalSolverCommand;
            }

            public boolean isExternalSolver() {
                return LassoAnalysis.this.nonlinearExternalSolver;
            }
        });
        this.nonTerminationAnalysisSettings = new NonTerminationAnalysisSettings((INonTerminationAnalysisSettings)new DefaultNonTerminationAnalysisSettings(){

            public int getNumberOfGevs() {
                return LassoAnalysis.this.eigenvectors;
            }
        });
        this.linearTerminationAnalysisSettings = new TerminationAnalysisSettings((ITerminationAnalysisSettings)new DefaultTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return LassoAnalysis.this.linearAnalysisType.toAnalysisType();
            }

            public int getNumNonStrictInvariants() {
                return LassoAnalysis.this.nonStrictInvariants;
            }

            public int getNumStrictInvariants() {
                return LassoAnalysis.this.strictInvariants;
            }

            public boolean isNonDecreasingInvariants() {
                return false;
            }
        });
        this.nonlinearTerminationAnalysisSettings = new TerminationAnalysisSettings((ITerminationAnalysisSettings)new DefaultTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return LassoAnalysis.this.nonlinearAnalysisType.toAnalysisType();
            }

            public int getNumNonStrictInvariants() {
                return LassoAnalysis.this.nonStrictInvariants;
            }

            public int getNumStrictInvariants() {
                return LassoAnalysis.this.strictInvariants;
            }

            public boolean isNonDecreasingInvariants() {
                return false;
            }
        });
        this.toolchainStorage = new LassoRankerToolchainStorage(pLogger, pShutdownNotifier);
        this.rankingTemplates = LassoAnalysis.createTemplates(this.maxTemplateFunctions);
    }

    private static ImmutableList<RankingTemplate> createTemplates(int pMaxTemplateFunctions) {
        ImmutableList.Builder rankingTemplates = ImmutableList.builder();
        rankingTemplates.add((Object)new AffineTemplate());
        for (int i = 2; i <= pMaxTemplateFunctions; ++i) {
            rankingTemplates.add((Object)new NestedTemplate(i));
        }
        return rankingTemplates.build();
    }

    public void close() {
        this.toolchainStorage.clear();
        this.solverContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LassoAnalysisResult checkTermination(LoopStructure.Loop pLoop, CounterexampleInfo pCounterexample, Set<CVariableDeclaration> pRelevantVariables) throws CPATransferException, InterruptedException {
        this.statistics.analysisOfLassosStarted();
        try {
            LassoAnalysisResult lassoAnalysisResult = this.checkTermination0(pLoop, pCounterexample, pRelevantVariables);
            return lassoAnalysisResult;
        }
        finally {
            this.statistics.analysisOfLassosFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LassoAnalysisResult checkTermination0(LoopStructure.Loop pLoop, CounterexampleInfo pCounterexample, Set<CVariableDeclaration> pRelevantVariables) throws CPATransferException, InterruptedException {
        Collection<Lasso> lassos;
        this.statistics.lassoConstructionStarted();
        try {
            lassos = this.lassoBuilder.buildLasso(pCounterexample, pRelevantVariables);
            this.statistics.lassosConstructed(pLoop, lassos.size());
        }
        catch (TermException | SolverException e) {
            this.logger.logUserException(Level.WARNING, e, "Could not extract lasso (" + pLoop + ").");
            LassoAnalysisResult lassoAnalysisResult = LassoAnalysisResult.unknown();
            return lassoAnalysisResult;
        }
        finally {
            this.statistics.lassoConstructionFinished();
        }
        try {
            return this.checkTermination(pLoop, lassos, pRelevantVariables);
        }
        catch (TermException | SMTLIBException | IOException | SolverException e) {
            this.logger.logUserException(Level.WARNING, e, "Could not check (non)-termination of lasso (" + pLoop + ").");
            return LassoAnalysisResult.unknown();
        }
        catch (ToolchainCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public LassoAnalysisResult checkTermination(LoopStructure.Loop pLoop, Collection<Lasso> lassos, Set<CVariableDeclaration> pRelevantVariables) throws IOException, SMTLIBException, TermException, InterruptedException, SolverException {
        LassoAnalysisResult resultFromLasso;
        LassoAnalysisResult result = LassoAnalysisResult.unknown();
        for (Lasso lasso : lassos) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.logger.logf(Level.FINER, "Synthesizing non-termination argument for lasso:\n%s.", new Object[]{lasso});
            resultFromLasso = this.synthesizeNonTerminationArgument(pLoop, lasso);
            if (!(result = result.update(resultFromLasso)).hasNonTerminationArgument()) continue;
            return result;
        }
        for (Lasso lasso : lassos) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.logger.logf(Level.FINER, "Synthesizing termination argument for lasso:\n%s.", new Object[]{lasso});
            resultFromLasso = this.synthesizeTerminationArgument(pLoop, lasso, pRelevantVariables);
            result = result.update(resultFromLasso);
        }
        return result;
    }

    private LassoAnalysisResult synthesizeNonTerminationArgument(LoopStructure.Loop pLoop, Lasso lasso) throws IOException, SMTLIBException, TermException {
        this.statistics.nonTerminationAnalysisOfLassoStarted();
        GeometricNonTerminationArgument nonTerminationArgument = null;
        try {
            LassoAnalysisResult lassoAnalysisResult;
            block13: {
                NonTerminationArgumentSynthesizer nonTerminationArgumentSynthesizer;
                block11: {
                    LassoAnalysisResult lassoAnalysisResult2;
                    block12: {
                        nonTerminationArgumentSynthesizer = this.createNonTerminationArgumentSynthesizer(lasso);
                        try {
                            Script.LBool result = nonTerminationArgumentSynthesizer.synthesize();
                            if (!result.equals((Object)Script.LBool.SAT) || !nonTerminationArgumentSynthesizer.synthesisSuccessful()) break block11;
                            nonTerminationArgument = nonTerminationArgumentSynthesizer.getArgument();
                            this.logger.logf(Level.FINE, "Proved non-termination: %s", new Object[]{nonTerminationArgument});
                            this.statistics.synthesizedNonTerminationArgument(pLoop, (NonTerminationArgument)nonTerminationArgument);
                            lassoAnalysisResult2 = LassoAnalysisResult.fromNonTerminationArgument((NonTerminationArgument)nonTerminationArgument);
                            if (nonTerminationArgumentSynthesizer == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (nonTerminationArgumentSynthesizer != null) {
                                try {
                                    nonTerminationArgumentSynthesizer.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        nonTerminationArgumentSynthesizer.close();
                    }
                    return lassoAnalysisResult2;
                }
                lassoAnalysisResult = LassoAnalysisResult.unknown();
                if (nonTerminationArgumentSynthesizer == null) break block13;
                nonTerminationArgumentSynthesizer.close();
            }
            return lassoAnalysisResult;
        }
        finally {
            this.statistics.nonTerminationAnalysisOfLassoFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LassoAnalysisResult synthesizeTerminationArgument(LoopStructure.Loop pLoop, Lasso lasso, Set<CVariableDeclaration> pRelevantVariables) throws IOException, SMTLIBException, TermException, InterruptedException, SolverException {
        this.statistics.terminationAnalysisOfLassoStarted();
        try {
            UnmodifiableIterator unmodifiableIterator = this.rankingTemplates.iterator();
            while (unmodifiableIterator.hasNext()) {
                RankingTemplate rankingTemplate = (RankingTemplate)unmodifiableIterator.next();
                this.shutdownNotifier.shutdownIfNecessary();
                TerminationArgumentSynthesizer terminationArgumentSynthesizer = this.createTerminationArgumentSynthesizer(lasso, rankingTemplate);
                try {
                    ProverEnvironment proverEnv;
                    block22: {
                        Script.LBool result = null;
                        try {
                            result = terminationArgumentSynthesizer.synthesize();
                        }
                        catch (AssertionError e) {
                            if (!"not yet implemented".equals(((Throwable)((Object)e)).getMessage())) throw e;
                            this.shutdownNotifier.shutdownIfNecessary();
                            throw e;
                        }
                        if (!result.equals((Object)Script.LBool.SAT) || !terminationArgumentSynthesizer.synthesisSuccessful()) continue;
                        TerminationArgument terminationArgument = terminationArgumentSynthesizer.getArgument();
                        this.logger.logf(Level.FINE, "Found termination argument: %s", new Object[]{terminationArgument});
                        try {
                            LassoAnalysisResult lassoAnalysisResult;
                            proverEnv = this.solverContext.newProverEnvironment(new SolverContext.ProverOptions[0]);
                            try {
                                RankingRelation rankingRelation = this.rankingRelationBuilder.fromTerminationArgument(terminationArgument, pRelevantVariables);
                                proverEnv.push(rankingRelation.asFormula());
                                if (proverEnv.isUnsat()) break block22;
                                this.statistics.synthesizedTerminationArgument(pLoop, terminationArgument);
                                lassoAnalysisResult = LassoAnalysisResult.fromTerminationArgument(rankingRelation);
                                if (proverEnv == null) return lassoAnalysisResult;
                            }
                            catch (Throwable throwable) {
                                if (proverEnv == null) throw throwable;
                                try {
                                    proverEnv.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            proverEnv.close();
                            return lassoAnalysisResult;
                        }
                        catch (RankingRelationBuilder.RankingRelationException e) {
                            this.logger.logUserException(Level.INFO, (Throwable)e, "Could not create ranking relation from " + terminationArgument);
                            LassoAnalysisResult lassoAnalysisResult = LassoAnalysisResult.unknown();
                            if (terminationArgumentSynthesizer != null) {
                                terminationArgumentSynthesizer.close();
                            }
                            this.statistics.terminationAnalysisOfLassoFinished();
                            return lassoAnalysisResult;
                        }
                    }
                    if (proverEnv == null) continue;
                    proverEnv.close();
                }
                finally {
                    if (terminationArgumentSynthesizer == null) continue;
                    terminationArgumentSynthesizer.close();
                }
            }
            return LassoAnalysisResult.unknown();
        }
        finally {
            this.statistics.terminationAnalysisOfLassoFinished();
        }
    }

    private TerminationArgumentSynthesizer createTerminationArgumentSynthesizer(Lasso lasso, RankingTemplate template) throws IOException {
        TerminationAnalysisSettings terminationAnalysisSettings;
        LassoRankerPreferences lassoRankerPreferences;
        if (template.getDegree() == 0) {
            lassoRankerPreferences = this.linearLassoRankerPreferences;
            terminationAnalysisSettings = this.linearTerminationAnalysisSettings;
        } else {
            lassoRankerPreferences = this.nonlinearLassoRankerPreferences;
            terminationAnalysisSettings = this.nonlinearTerminationAnalysisSettings;
        }
        return new TerminationArgumentSynthesizer(lasso, template, (ILassoRankerPreferences)lassoRankerPreferences, terminationAnalysisSettings, (Set)ImmutableSet.of(), (IUltimateServiceProvider)this.toolchainStorage);
    }

    private NonTerminationArgumentSynthesizer createNonTerminationArgumentSynthesizer(Lasso lasso) throws IOException {
        return new NonTerminationArgumentSynthesizer(lasso, (ILassoRankerPreferences)this.nonlinearLassoRankerPreferences, this.nonTerminationAnalysisSettings, (IUltimateServiceProvider)this.toolchainStorage);
    }

    public static enum LassoAnalysisType {
        DISABLED(AnalysisType.DISABLED),
        LINEAR(AnalysisType.LINEAR),
        LINEAR_WITH_GUESSES(AnalysisType.LINEAR_WITH_GUESSES),
        NONLINEAR(AnalysisType.NONLINEAR);

        private final AnalysisType analysisType;

        private LassoAnalysisType(AnalysisType pAnalysisType) {
            this.analysisType = pAnalysisType;
        }

        private AnalysisType toAnalysisType() {
            return this.analysisType;
        }
    }
}

