/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;

public class LassoAnalysisResult {
    private final Optional<NonTerminationArgument> nonTerminationArgument;
    private final Optional<RankingRelation> terminationArgument;

    public static LassoAnalysisResult unknown() {
        return new LassoAnalysisResult(Optional.empty(), Optional.empty());
    }

    public static LassoAnalysisResult fromNonTerminationArgument(NonTerminationArgument nonTerminationArgument) {
        return new LassoAnalysisResult(Optional.of(nonTerminationArgument), Optional.empty());
    }

    public static LassoAnalysisResult fromTerminationArgument(RankingRelation terminationArgument) {
        return new LassoAnalysisResult(Optional.empty(), Optional.of(terminationArgument));
    }

    private LassoAnalysisResult(Optional<NonTerminationArgument> pNonTerminationArgument, Optional<RankingRelation> pTerminationArgument) {
        Preconditions.checkArgument((!pNonTerminationArgument.isPresent() || !pTerminationArgument.isPresent() ? 1 : 0) != 0);
        this.nonTerminationArgument = (Optional)Preconditions.checkNotNull(pNonTerminationArgument);
        this.terminationArgument = (Optional)Preconditions.checkNotNull(pTerminationArgument);
    }

    public NonTerminationArgument getNonTerminationArgument() {
        return this.nonTerminationArgument.orElseThrow();
    }

    public RankingRelation getTerminationArgument() {
        return this.terminationArgument.orElseThrow();
    }

    public boolean isUnknown() {
        return !this.hasNonTerminationArgument() && !this.hasTerminationArgument();
    }

    public boolean hasNonTerminationArgument() {
        return this.nonTerminationArgument.isPresent();
    }

    public boolean hasTerminationArgument() {
        return this.terminationArgument.isPresent();
    }

    @CheckReturnValue
    public LassoAnalysisResult update(LassoAnalysisResult pOther) {
        if (this.isUnknown()) {
            return pOther;
        }
        if (pOther.isUnknown()) {
            return this;
        }
        if (this.hasNonTerminationArgument()) {
            return this;
        }
        if (pOther.hasNonTerminationArgument()) {
            return pOther;
        }
        assert (this.hasTerminationArgument() && pOther.hasTerminationArgument());
        RankingRelation newRankingRelation = this.getTerminationArgument().merge(pOther.getTerminationArgument());
        return new LassoAnalysisResult(Optional.empty(), Optional.of(newRankingRelation));
    }
}

