/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.util.LoopStructure;

public abstract class LassoAnalysisStatistics
implements Statistics {
    protected final Timer lassoTime = new Timer();
    protected final Timer lassoConstructionTime = new Timer();
    protected final Timer lassoNonTerminationTime = new Timer();
    protected final Timer lassoTerminationTime = new Timer();
    protected final Timer lassoStemLoopConstructionTime = new Timer();
    protected final Timer lassosCreationTime = new Timer();
    protected final Multiset<LoopStructure.Loop> lassosPerLoop = ConcurrentHashMultiset.create();
    protected final AtomicInteger maxLassosPerIteration = new AtomicInteger();
    protected final AtomicInteger lassosCurrentIteration = new AtomicInteger();
    protected final Multimap<LoopStructure.Loop, TerminationArgument> terminationArguments = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    protected final Map<LoopStructure.Loop, NonTerminationArgument> nonTerminationArguments = new ConcurrentHashMap<LoopStructure.Loop, NonTerminationArgument>();

    protected LassoAnalysisStatistics() {
    }

    public void analysisOfLassosStarted() {
        this.lassoTime.start();
    }

    public void analysisOfLassosFinished() {
        this.lassoTime.stop();
        this.lassoConstructionTime.stopIfRunning();
        this.lassoNonTerminationTime.stopIfRunning();
        this.lassoTerminationTime.stopIfRunning();
        this.maxLassosPerIteration.accumulateAndGet(this.lassosCurrentIteration.getAndSet(0), Math::max);
    }

    public void lassoConstructionStarted() {
        this.lassoConstructionTime.start();
    }

    public void lassoConstructionFinished() {
        this.lassoConstructionTime.stop();
    }

    public void lassosConstructed(LoopStructure.Loop pLoop, int numberOfLassos) {
        this.lassosPerLoop.add((Object)pLoop, numberOfLassos);
        this.lassosCurrentIteration.addAndGet(numberOfLassos);
    }

    public void nonTerminationAnalysisOfLassoStarted() {
        this.lassoNonTerminationTime.start();
    }

    public void nonTerminationAnalysisOfLassoFinished() {
        this.lassoNonTerminationTime.stop();
    }

    public void terminationAnalysisOfLassoStarted() {
        this.lassoTerminationTime.start();
    }

    public void terminationAnalysisOfLassoFinished() {
        this.lassoTerminationTime.stop();
    }

    public void synthesizedNonTerminationArgument(LoopStructure.Loop pLoop, NonTerminationArgument pNonTerminationArgument) {
        this.nonTerminationArguments.put(pLoop, pNonTerminationArgument);
    }

    protected void synthesizedTerminationArgument(LoopStructure.Loop pLoop, TerminationArgument pTerminationArgument) {
        this.terminationArguments.put((Object)pLoop, (Object)pTerminationArgument);
    }

    public void stemAndLoopConstructionStarted() {
        this.lassoStemLoopConstructionTime.start();
    }

    public void stemAndLoopConstructionFinished() {
        this.lassoStemLoopConstructionTime.stop();
    }

    public void lassosCreationStarted() {
        this.lassosCreationTime.start();
    }

    public void lassosCreationFinished() {
        this.lassosCreationTime.stop();
    }
}

