/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class RankingRelation {
    private final ImmutableSet<CExpression> rankingRelations;
    private final ImmutableSet<BooleanFormula> rankingRelationFormulas;
    private final ImmutableSet<BooleanFormula> supportingInvariants;
    private final FormulaManagerView formulaManagerView;
    private final CBinaryExpressionBuilder binaryExpressionBuilder;

    public RankingRelation(Optional<CExpression> pRankingRelation, BooleanFormula pFormula, CBinaryExpressionBuilder pBinaryExpressionBuilder, FormulaManagerView pFormulaManagerView) {
        this.rankingRelations = pRankingRelation.map(ImmutableSet::of).orElse(ImmutableSet.of());
        this.rankingRelationFormulas = ImmutableSet.of((Object)pFormula);
        this.supportingInvariants = ImmutableSet.of();
        this.formulaManagerView = (FormulaManagerView)Preconditions.checkNotNull((Object)pFormulaManagerView);
        this.binaryExpressionBuilder = (CBinaryExpressionBuilder)Preconditions.checkNotNull((Object)pBinaryExpressionBuilder);
    }

    public RankingRelation(CExpression pRankingRelation, BooleanFormula pFormula, CBinaryExpressionBuilder pBinaryExpressionBuilder, FormulaManagerView pFormulaManagerView) {
        this(Optional.of(pRankingRelation), pFormula, pBinaryExpressionBuilder, pFormulaManagerView);
    }

    private RankingRelation(Set<CExpression> pRankingRelations, Set<BooleanFormula> pRankingRelationFormulas, Set<BooleanFormula> pSupportingInvariants, CBinaryExpressionBuilder pBinaryExpressionBuilder, FormulaManagerView pFormulaManagerView) {
        this.rankingRelations = ImmutableSet.copyOf(pRankingRelations);
        this.rankingRelationFormulas = ImmutableSet.copyOf(pRankingRelationFormulas);
        this.supportingInvariants = ImmutableSet.copyOf(pSupportingInvariants);
        this.formulaManagerView = (FormulaManagerView)Preconditions.checkNotNull((Object)pFormulaManagerView);
        this.binaryExpressionBuilder = (CBinaryExpressionBuilder)Preconditions.checkNotNull((Object)pBinaryExpressionBuilder);
    }

    public CExpression asCExpression() {
        assert (!this.rankingRelationFormulas.isEmpty());
        return this.rankingRelations.stream().reduce((a, b) -> this.binaryExpressionBuilder.buildBinaryExpressionUnchecked((CExpression)a, (CExpression)b, CBinaryExpression.BinaryOperator.BINARY_OR)).orElseGet(() -> this.binaryExpressionBuilder.buildBinaryExpressionUnchecked(CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.EQUALS));
    }

    public BooleanFormula asFormula() {
        assert (!this.rankingRelationFormulas.isEmpty());
        return this.formulaManagerView.getBooleanFormulaManager().or((Collection<BooleanFormula>)this.rankingRelationFormulas);
    }

    public BooleanFormula asFormulaFromOtherSolver(FormulaManagerView pFormulaManagerView) {
        return pFormulaManagerView.translateFrom(this.asFormula(), this.formulaManagerView);
    }

    public ImmutableSet<BooleanFormula> getSupportingInvariants() {
        return this.supportingInvariants;
    }

    public FormulaManagerView getFormulaManager() {
        return this.formulaManagerView;
    }

    @CheckReturnValue
    public RankingRelation merge(RankingRelation other) {
        ImmutableSet.Builder newRankingRelations = ImmutableSet.builder();
        newRankingRelations.addAll(this.rankingRelations);
        newRankingRelations.addAll(other.rankingRelations);
        ImmutableSet.Builder newRankingRelationFormulas = ImmutableSet.builder();
        newRankingRelationFormulas.addAll(this.rankingRelationFormulas);
        newRankingRelationFormulas.addAll(other.rankingRelationFormulas);
        ImmutableSet.Builder newSupportingInvariants = ImmutableSet.builder();
        newSupportingInvariants.addAll(this.supportingInvariants);
        newSupportingInvariants.addAll(other.supportingInvariants);
        return new RankingRelation((Set<CExpression>)newRankingRelations.build(), (Set<BooleanFormula>)newRankingRelationFormulas.build(), (Set<BooleanFormula>)newSupportingInvariants.build(), this.binaryExpressionBuilder, this.formulaManagerView);
    }

    @CheckReturnValue
    public RankingRelation withSupportingInvariants(Collection<BooleanFormula> pSupportingInvariants) {
        ImmutableSet newSupportingInvariants = ImmutableSet.builder().addAll(this.supportingInvariants).addAll(pSupportingInvariants).build();
        return new RankingRelation((Set<CExpression>)this.rankingRelations, (Set<BooleanFormula>)this.rankingRelationFormulas, (Set<BooleanFormula>)newSupportingInvariants, this.binaryExpressionBuilder, this.formulaManagerView);
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (!(pObj instanceof RankingRelation)) {
            return false;
        }
        RankingRelation that = (RankingRelation)pObj;
        return this.rankingRelationFormulas.equals(that.rankingRelationFormulas);
    }

    public int hashCode() {
        return this.rankingRelationFormulas.hashCode();
    }

    public String toString() {
        return this.asFormula().toString();
    }
}

