/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LexicographicRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LinearRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.NestedRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationUtils;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankVar;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public class RankingRelationBuilder {
    private final LogManager logger;
    private final CBinaryExpressionBuilder cExpressionBuilder;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final IntegerFormulaManagerView ifmgr;
    private final NumeralFormula zero;
    private final FormulaCreator<Term, ?, ?, ?> formulaCreator;

    public RankingRelationBuilder(MachineModel pMachineModel, LogManager pLogger, FormulaManagerView pFormulaManagerView, FormulaCreator<Term, ?, ?, ?> pFormulaCreator) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.cExpressionBuilder = new CBinaryExpressionBuilder(pMachineModel, pLogger);
        this.fmgr = (FormulaManagerView)Preconditions.checkNotNull((Object)pFormulaManagerView);
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.ifmgr = this.fmgr.getIntegerFormulaManager();
        this.zero = this.ifmgr.makeNumber(0L);
        this.formulaCreator = (FormulaCreator)Preconditions.checkNotNull(pFormulaCreator);
    }

    public RankingRelation fromTerminationArgument(TerminationArgument pTerminationArgument, Set<CVariableDeclaration> pRelevantVariables) throws RankingRelationException {
        RankingRelation rankingRelation;
        try {
            rankingRelation = this.fromRankingFunction(pRelevantVariables, pTerminationArgument.getRankingFunction());
        }
        catch (UnrecognizedCodeException e) {
            throw new RankingRelationException(e);
        }
        Collection<BooleanFormula> supportingInvariants = this.extractSupportingInvariants(pTerminationArgument, pRelevantVariables);
        return rankingRelation.withSupportingInvariants(supportingInvariants);
    }

    private Collection<BooleanFormula> extractSupportingInvariants(TerminationArgument pTerminationArgument, Set<CVariableDeclaration> pRelevantVariables) {
        ArrayList<BooleanFormula> supportingInvariants = new ArrayList<BooleanFormula>();
        for (SupportingInvariant supportingInvariant : pTerminationArgument.getSupportingInvariants()) {
            RankingRelationComponents components;
            try {
                components = this.createRankingRelationComponents((AffineFunction)supportingInvariant, pRelevantVariables);
            }
            catch (RankingRelationException e) {
                this.logger.logDebugException((Throwable)e, "Could not process " + supportingInvariant);
                continue;
            }
            BooleanFormula invariantFormula = supportingInvariant.strict ? this.fmgr.makeGreaterThan(components.getUnprimedFormula(), this.zero, true) : this.fmgr.makeGreaterOrEqual(components.getUnprimedFormula(), this.zero, true);
            supportingInvariants.add(this.fmgr.uninstantiate(invariantFormula));
        }
        return supportingInvariants;
    }

    private RankingRelation fromRankingFunction(Set<CVariableDeclaration> pRelevantVariables, RankingFunction rankingFunction) throws UnrecognizedCodeException, RankingRelationException {
        if (rankingFunction instanceof LinearRankingFunction) {
            AffineFunction function = ((LinearRankingFunction)rankingFunction).getComponent();
            return this.fromAffineFunction(pRelevantVariables, function);
        }
        if (rankingFunction instanceof LexicographicRankingFunction) {
            return this.fromLexicographicRankingFunction((LexicographicRankingFunction)rankingFunction, pRelevantVariables);
        }
        if (rankingFunction instanceof NestedRankingFunction) {
            return this.fromNestedRankingFunction((NestedRankingFunction)rankingFunction, pRelevantVariables);
        }
        throw new UnsupportedOperationException(rankingFunction.getName());
    }

    private RankingRelation fromLexicographicRankingFunction(LexicographicRankingFunction rankingFunction, Set<CVariableDeclaration> pRelevantVariables) throws UnrecognizedCodeException, RankingRelationException {
        AbstractExpression cExpression = CIntegerLiteralExpression.ZERO;
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>();
        for (RankingFunction component : rankingFunction.getComponents()) {
            RankingRelation rankingRelation = this.fromRankingFunction(pRelevantVariables, component);
            CExpression cExpressionComponent = rankingRelation.asCExpression();
            cExpression = this.cExpressionBuilder.buildBinaryExpression((CExpression)((Object)cExpression), cExpressionComponent, CBinaryExpression.BinaryOperator.BINARY_OR);
            formulas.add(rankingRelation.asFormula());
        }
        BooleanFormula formula = this.bfmgr.or(formulas);
        return new RankingRelation((CExpression)((Object)cExpression), formula, this.cExpressionBuilder, this.fmgr);
    }

    private RankingRelation fromNestedRankingFunction(NestedRankingFunction pRankingFunction, Set<CVariableDeclaration> pRelevantVariables) throws UnrecognizedCodeException, RankingRelationException {
        Preconditions.checkArgument((pRankingFunction.getComponents().length > 0 ? 1 : 0) != 0);
        BooleanFormula phaseConditionFormula = this.bfmgr.makeTrue();
        AbstractExpression phaseConditionExpression = CIntegerLiteralExpression.ONE;
        ArrayList<CBinaryExpression> componentExpressions = new ArrayList<CBinaryExpression>();
        ArrayList<BooleanFormula> componentFormulas = new ArrayList<BooleanFormula>();
        for (AffineFunction component : pRankingFunction.getComponents()) {
            RankingRelation componentRelation = this.fromAffineFunction(pRelevantVariables, component);
            CBinaryExpression componentExpression = this.cExpressionBuilder.buildBinaryExpression((CExpression)((Object)phaseConditionExpression), componentRelation.asCExpression(), CBinaryExpression.BinaryOperator.BINARY_AND);
            componentExpressions.add(componentExpression);
            BooleanFormula componentFormula = this.fmgr.makeAnd(phaseConditionFormula, componentRelation.asFormula());
            componentFormulas.add(componentFormula);
            RankingRelationComponents rankingRelationComponents = this.createRankingRelationComponents(component, pRelevantVariables);
            BooleanFormula unprimedLessThanZeroFormula = this.fmgr.makeLessThan(rankingRelationComponents.getUnprimedFormula(), this.zero, true);
            phaseConditionFormula = this.fmgr.makeAnd(phaseConditionFormula, unprimedLessThanZeroFormula);
            CBinaryExpression unprimedLessThanZeroExpression = this.cExpressionBuilder.buildBinaryExpression(rankingRelationComponents.getUnprimedExpression().orElse(CIntegerLiteralExpression.ZERO), CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.LESS_THAN);
            phaseConditionExpression = this.cExpressionBuilder.buildBinaryExpression((CExpression)((Object)phaseConditionExpression), unprimedLessThanZeroExpression, CBinaryExpression.BinaryOperator.BINARY_AND);
        }
        BooleanFormula formula = this.fmgr.getBooleanFormulaManager().or(componentFormulas);
        CExpression expression = (CExpression)componentExpressions.stream().reduce((op1, op2) -> this.cExpressionBuilder.buildBinaryExpressionUnchecked((CExpression)op1, (CExpression)op2, CBinaryExpression.BinaryOperator.BINARY_OR)).orElseThrow();
        return new RankingRelation(expression, formula, this.cExpressionBuilder, this.fmgr);
    }

    private RankingRelation fromAffineFunction(Set<CVariableDeclaration> pRelevantVariables, AffineFunction function) throws UnrecognizedCodeException, RankingRelationException {
        RankingRelationComponents components = this.createRankingRelationComponents(function, pRelevantVariables);
        Optional<CExpression> rankingRelation = this.createRankingRelationExpression(components);
        BooleanFormula rankingRelationFormula = this.createRankingRelationFormula(components);
        return new RankingRelation(rankingRelation, rankingRelationFormula, this.cExpressionBuilder, this.fmgr);
    }

    private Optional<CExpression> createRankingRelationExpression(RankingRelationComponents components) throws UnrecognizedCodeException {
        Optional<CExpression> unprimedFunction = components.getUnprimedExpression();
        Optional<CExpression> primedFunction = components.getPrimedExpression();
        if (unprimedFunction.isPresent() && primedFunction.isPresent()) {
            CBinaryExpression unprimedGreatorThanZero = this.cExpressionBuilder.buildBinaryExpression(primedFunction.orElseThrow(), CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.GREATER_EQUAL);
            CBinaryExpression primedLessThanUnprimed = this.cExpressionBuilder.buildBinaryExpression(unprimedFunction.orElseThrow(), primedFunction.orElseThrow(), CBinaryExpression.BinaryOperator.LESS_THAN);
            CBinaryExpression rankingRelation = this.cExpressionBuilder.buildBinaryExpression(unprimedGreatorThanZero, primedLessThanUnprimed, CBinaryExpression.BinaryOperator.BINARY_AND);
            return Optional.of(rankingRelation);
        }
        return Optional.empty();
    }

    private RankingRelationComponents createRankingRelationComponents(AffineFunction function, Set<CVariableDeclaration> pRelevantVariables) throws RankingRelationException {
        Optional<CExpression> primedFunction = RankingRelationBuilder.createLiteral(function.getConstant());
        ArrayList<NumeralFormula> primedFormulaSummands = new ArrayList<NumeralFormula>();
        primedFormulaSummands.add((NumeralFormula)this.ifmgr.makeNumber(function.getConstant()));
        Optional<CExpression> unprimedFunction = RankingRelationBuilder.createLiteral(function.getConstant());
        ArrayList<NumeralFormula> unprimedFormulaSummands = new ArrayList<NumeralFormula>();
        unprimedFormulaSummands.add((NumeralFormula)this.ifmgr.makeNumber(function.getConstant()));
        for (IProgramVar programVar : function.getVariables()) {
            RankVar rankVar = (RankVar)programVar;
            BigInteger coefficient = function.get((IProgramVar)rankVar);
            Optional<CExpression> cCoefficient = RankingRelationBuilder.createLiteral(coefficient);
            Pair<CIdExpression, CExpression> variables = this.getVariable(rankVar, pRelevantVariables);
            CIdExpression primedVariable = variables.getFirstNotNull();
            CExpression variable = variables.getSecondNotNull();
            if (primedFunction.isPresent() && unprimedFunction.isPresent() && cCoefficient.isPresent()) {
                try {
                    primedFunction = Optional.of(this.addSummand(primedFunction.orElseThrow(), cCoefficient.orElseThrow(), primedVariable));
                    unprimedFunction = Optional.of(this.addSummand(unprimedFunction.orElseThrow(), cCoefficient.orElseThrow(), variable));
                }
                catch (UnrecognizedCodeException e) {
                    primedFunction = Optional.empty();
                    unprimedFunction = Optional.empty();
                }
            } else {
                primedFunction = Optional.empty();
                unprimedFunction = Optional.empty();
            }
            NumeralFormula unprimedVariableFormula = this.encapsulate(rankVar.getTerm());
            String primedVariableName = primedVariable.getDeclaration().getQualifiedName();
            FormulaType<NumeralFormula> formulaType = this.fmgr.getFormulaType(unprimedVariableFormula);
            NumeralFormula primedVariableFormula = this.fmgr.makeVariable(formulaType, primedVariableName);
            primedFormulaSummands.add(this.createSummand(coefficient, primedVariableFormula));
            unprimedFormulaSummands.add(this.createSummand(coefficient, unprimedVariableFormula));
        }
        return new RankingRelationComponents(unprimedFunction, primedFunction, unprimedFormulaSummands, primedFormulaSummands);
    }

    private CExpression addSummand(CExpression pSum, CExpression pCoefficient, CExpression pVariable) throws UnrecognizedCodeException {
        CExpression summand = pCoefficient.equals(CIntegerLiteralExpression.ONE) ? pVariable : this.cExpressionBuilder.buildBinaryExpression(pCoefficient, pVariable, CBinaryExpression.BinaryOperator.MULTIPLY);
        return this.cExpressionBuilder.buildBinaryExpression(pSum, summand, CBinaryExpression.BinaryOperator.PLUS);
    }

    private NumeralFormula encapsulate(Term pTerm) {
        FormulaType type;
        Sort sort = pTerm.getSort();
        assert (sort.isNumericSort());
        if (sort.getName().equalsIgnoreCase("int")) {
            type = FormulaType.IntegerType;
        } else if (sort.getName().equalsIgnoreCase("real")) {
            type = FormulaType.RationalType;
        } else {
            throw new AssertionError(sort);
        }
        return (NumeralFormula)this.formulaCreator.encapsulate(type, (Object)pTerm);
    }

    private Pair<CIdExpression, CExpression> getVariable(RankVar pRankVar, Set<CVariableDeclaration> pRelevantVariables) throws RankingRelationException {
        String variableName = pRankVar.getGloballyUniqueId();
        Optional<CVariableDeclaration> variableDecl = pRelevantVariables.stream().filter(v -> v.getQualifiedName().equals(variableName)).findAny();
        if (variableDecl.isPresent()) {
            CVariableDeclaration primedVariableDecl = TerminationUtils.createPrimedVariable(variableDecl.orElseThrow());
            CIdExpression primedVariable = new CIdExpression(FileLocation.DUMMY, primedVariableDecl);
            CIdExpression variable = new CIdExpression(FileLocation.DUMMY, variableDecl.orElseThrow());
            return Pair.of(primedVariable, variable);
        }
        Term term = pRankVar.getTerm();
        if (term instanceof ApplicationTerm && !((ApplicationTerm)term).getFunction().isInterpreted()) {
            ApplicationTerm uf = (ApplicationTerm)term;
            assert (uf.getFunction().getParameterSorts().length == 1) : uf;
            assert (uf.getFunction().getName().startsWith("*"));
            Term innerVariableTerm = uf.getParameters()[0];
            String innerVariableName = CharMatcher.is((char)'|').trimFrom((CharSequence)innerVariableTerm.toStringDirect());
            RankVar innerDummyRankVar = new RankVar(innerVariableName, pRankVar.isGlobal(), innerVariableTerm);
            Pair<CIdExpression, CExpression> innerVariables = this.getVariable(innerDummyRankVar, pRelevantVariables);
            CSimpleDeclaration innerPrimedVariable = innerVariables.getFirstNotNull().getDeclaration();
            CExpression innerVariable = innerVariables.getSecondNotNull();
            CVariableDeclaration primedVariableDecl = TerminationUtils.createDereferencedVariable(innerPrimedVariable);
            CPointerExpression variable = new CPointerExpression(FileLocation.DUMMY, primedVariableDecl.getType(), innerVariable);
            CIdExpression primedVariable = new CIdExpression(FileLocation.DUMMY, primedVariableDecl);
            return Pair.of(primedVariable, variable);
        }
        throw new RankingRelationException("Cannot create CExpression from " + variableName);
    }

    private static Optional<CExpression> createLiteral(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0) {
            return Optional.of(CIntegerLiteralExpression.createDummyLiteral(value.longValueExact(), CNumericTypes.LONG_LONG_INT));
        }
        return Optional.empty();
    }

    private BooleanFormula createRankingRelationFormula(RankingRelationComponents components) {
        NumeralFormula primedFormula = components.getPrimedFormula();
        NumeralFormula unprimedFormula = components.getUnprimedFormula();
        BooleanFormula unprimedGreatorThanZeroFormula = this.fmgr.makeGreaterOrEqual(primedFormula, this.zero, true);
        BooleanFormula primedLessThanUnprimedFormula = this.fmgr.makeLessThan(unprimedFormula, primedFormula, true);
        BooleanFormula rankingRelationFormula = this.fmgr.makeAnd(unprimedGreatorThanZeroFormula, primedLessThanUnprimedFormula);
        return rankingRelationFormula;
    }

    private NumeralFormula createSummand(BigInteger pCoefficient, NumeralFormula pVariable) {
        if (pCoefficient.equals(BigInteger.ONE)) {
            return pVariable;
        }
        NumeralFormula.IntegerFormula coefficient = (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(pCoefficient);
        return this.fmgr.makeMultiply(coefficient, pVariable);
    }

    public static class RankingRelationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RankingRelationException(String message) {
            super(message);
        }

        public RankingRelationException(Exception e) {
            super(e);
        }
    }

    private final class RankingRelationComponents {
        private final Optional<CExpression> unprimedExpression;
        private final Optional<CExpression> primedExpression;
        private final List<NumeralFormula> unprimedFormulaSummands;
        private final List<NumeralFormula> primedFormulaSummands;

        RankingRelationComponents(Optional<CExpression> pUnprimedFunction, Optional<CExpression> pPrimedFunction, List<NumeralFormula> pUnprimedFormulaSummands, List<NumeralFormula> pPrimedFormulaSummands) {
            this.unprimedExpression = pUnprimedFunction;
            this.primedExpression = pPrimedFunction;
            this.unprimedFormulaSummands = pUnprimedFormulaSummands;
            this.primedFormulaSummands = pPrimedFormulaSummands;
        }

        public Optional<CExpression> getPrimedExpression() {
            return this.primedExpression;
        }

        public Optional<CExpression> getUnprimedExpression() {
            return this.unprimedExpression;
        }

        public NumeralFormula getPrimedFormula() {
            return this.sum(this.primedFormulaSummands);
        }

        public NumeralFormula getUnprimedFormula() {
            return this.sum(this.unprimedFormulaSummands);
        }

        private NumeralFormula sum(Collection<NumeralFormula> operands) {
            return operands.stream().reduce(RankingRelationBuilder.this.zero, RankingRelationBuilder.this.fmgr::makePlus);
        }
    }
}

