/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;

class DivAndModElimination
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private final FormulaManagerView fmgrView;
    private final FormulaManager fmgr;

    DivAndModElimination(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
        super(pFmgrView);
        this.fmgrView = pFmgrView;
        this.fmgr = pFmgr;
    }

    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
        DivAndModTransformation divAndModTransformation = new DivAndModTransformation(this.fmgrView, this.fmgr);
        BooleanFormula result = (BooleanFormula)this.fmgrView.visit((Formula)pAtom, divAndModTransformation);
        BooleanFormulaManagerView booleanFormulaManager = this.fmgrView.getBooleanFormulaManager();
        BooleanFormula additionalAxioms = booleanFormulaManager.and(divAndModTransformation.getAdditionalAxioms());
        return this.fmgrView.makeAnd(result, additionalAxioms);
    }

    private static class DivAndModTransformation
    extends DefaultFormulaVisitor<Formula> {
        private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
        private final FormulaManagerView fmgrView;
        private final FormulaManager fmgr;
        private final Collection<BooleanFormula> additionalAxioms;

        private DivAndModTransformation(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
            this.fmgrView = pFmgrView;
            this.fmgr = pFmgr;
            this.additionalAxioms = new ArrayList<BooleanFormula>();
        }

        public Collection<BooleanFormula> getAdditionalAxioms() {
            return ImmutableList.copyOf(this.additionalAxioms);
        }

        protected Formula visitDefault(Formula pF) {
            return pF;
        }

        public Formula visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            List newArgs = Lists.transform(pArgs, f -> (Formula)this.fmgrView.visit((Formula)f, this));
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.DIV) || pFunctionDeclaration.getName().equalsIgnoreCase("div") || pFunctionDeclaration.getName().equalsIgnoreCase("Integer__/_")) {
                assert (newArgs.size() == 2);
                return this.transformDivision((Formula)newArgs.get(0), (Formula)newArgs.get(1), pFunctionDeclaration.getType());
            }
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.MODULO) || pFunctionDeclaration.getName().equalsIgnoreCase("mod")) {
                assert (newArgs.size() == 2);
                return this.transformModulo((Formula)newArgs.get(0), (Formula)newArgs.get(1), pFunctionDeclaration.getType());
            }
            return this.fmgr.makeApplication(pFunctionDeclaration, newArgs);
        }

        private Formula transformModulo(Formula dividend, Formula divisor, FormulaType<?> formulaType) {
            BooleanFormulaManagerView booleanFormulaManager = this.fmgrView.getBooleanFormulaManager();
            Formula quotientAuxVar = this.fmgr.makeVariable(formulaType, "__TERMINATION-QUOTIENT_AUX_VAR_" + ID_GENERATOR.getFreshId());
            Formula remainderAuxVar = this.fmgr.makeVariable(formulaType, "__TERMINATION-REMAINDER_AUX_VAR_" + ID_GENERATOR.getFreshId());
            Object one = this.fmgrView.makeNumber(formulaType, 1L);
            Object zero = this.fmgrView.makeNumber(formulaType, 0L);
            BooleanFormula divisorIsNegative = this.fmgrView.makeLessThan(divisor, zero, true);
            BooleanFormula divisorIsPositive = this.fmgrView.makeGreaterThan(divisor, zero, true);
            BooleanFormula isLowerBound = this.fmgrView.makeLessOrEqual(zero, remainderAuxVar, true);
            Formula upperBoundPosDivisor = this.fmgrView.makeMinus(divisor, one);
            BooleanFormula isUpperBoundPosDivisor = this.fmgrView.makeLessOrEqual(remainderAuxVar, upperBoundPosDivisor, true);
            Formula upperBoundNegDivisor = this.fmgrView.makeMinus(one, divisor);
            BooleanFormula isUpperBoundNegDivisor = this.fmgrView.makeLessOrEqual(remainderAuxVar, upperBoundNegDivisor, true);
            BooleanFormula equality = this.fmgrView.makeEqual(dividend, this.fmgrView.makePlus(this.fmgrView.makeMultiply(quotientAuxVar, divisor), remainderAuxVar));
            BooleanFormula divisorIsPositiveFormula = booleanFormulaManager.and(divisorIsPositive, isLowerBound, isUpperBoundPosDivisor, equality);
            BooleanFormula divisorIsNegativeFormula = booleanFormulaManager.and(divisorIsNegative, isLowerBound, isUpperBoundNegDivisor, equality);
            this.additionalAxioms.add(this.fmgrView.makeOr(divisorIsPositiveFormula, divisorIsNegativeFormula));
            return remainderAuxVar;
        }

        private Formula transformDivision(Formula dividend, Formula divisor, FormulaType<?> formulaType) {
            BooleanFormulaManagerView booleanFormulaManager = this.fmgrView.getBooleanFormulaManager();
            Formula quotientAuxVar = this.fmgr.makeVariable(formulaType, "__TERMINATION-QUOTIENT_AUX_VAR_" + ID_GENERATOR.getFreshId());
            Object one = this.fmgrView.makeNumber(formulaType, 1L);
            Object zero = this.fmgrView.makeNumber(formulaType, 0L);
            BooleanFormula divisorIsNegative = this.fmgrView.makeLessThan(divisor, zero, true);
            BooleanFormula divisorIsPositive = this.fmgrView.makeGreaterThan(divisor, zero, true);
            BooleanFormula dividendIsNegative = this.fmgrView.makeLessThan(dividend, zero, true);
            BooleanFormula dividendIsPositive = this.fmgrView.makeGreaterOrEqual(dividend, zero, true);
            Formula quotientMulDivisor = this.fmgrView.makeMultiply(quotientAuxVar, divisor);
            BooleanFormula isLowerBoundPosDivident = this.fmgrView.makeLessOrEqual(quotientMulDivisor, dividend, true);
            BooleanFormula isUpperBoundNegDivident = this.fmgrView.makeGreaterOrEqual(quotientMulDivisor, dividend, true);
            Formula stictBoundPosResult = this.fmgrView.makeMultiply(this.fmgrView.makePlus(quotientAuxVar, one), divisor);
            Formula strictBoundNegResult = this.fmgrView.makeMultiply(this.fmgrView.makeMinus(quotientAuxVar, one), divisor);
            BooleanFormula isUpperBoundPosDivisorPosDivident = this.fmgrView.makeLessThan(dividend, stictBoundPosResult, true);
            BooleanFormula isUpperBoundNegDivisorPosDivident = this.fmgrView.makeLessThan(dividend, strictBoundNegResult, true);
            BooleanFormula isLowerBoundPosDivisorNegDivident = this.fmgrView.makeGreaterThan(dividend, strictBoundNegResult, true);
            BooleanFormula isLowerBoundNegDivisorNegDivident = this.fmgrView.makeGreaterThan(dividend, stictBoundPosResult, true);
            BooleanFormula posDivisorPosDividentFormula = booleanFormulaManager.and(divisorIsPositive, dividendIsPositive, isLowerBoundPosDivident, isUpperBoundPosDivisorPosDivident);
            BooleanFormula negDivisorPosDividentFormula = booleanFormulaManager.and(divisorIsNegative, dividendIsPositive, isLowerBoundPosDivident, isUpperBoundNegDivisorPosDivident);
            BooleanFormula posDivisorNegDividentFormula = booleanFormulaManager.and(divisorIsPositive, dividendIsNegative, isUpperBoundNegDivident, isLowerBoundPosDivisorNegDivident);
            BooleanFormula negDivisorNegDividentFormula = booleanFormulaManager.and(divisorIsNegative, dividendIsNegative, isUpperBoundNegDivident, isLowerBoundNegDivisorNegDivident);
            this.additionalAxioms.add(booleanFormulaManager.or(posDivisorPosDividentFormula, negDivisorPosDividentFormula, posDivisorNegDividentFormula, negDivisorNegDividentFormula));
            return quotientAuxVar;
        }
    }
}

