/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

class DnfTransformation
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private static final int MAX_CLAUSES = 1000000;
    private final ShutdownNotifier shutdownNotifier;
    private final BooleanFormulaManager fmgr;
    private final Supplier<ProverEnvironment> proverEnvironmentSupplier;

    private DnfTransformation(ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr, Supplier<ProverEnvironment> pProverEnvironmentSupplier) {
        super(pFmgr);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.fmgr = pFmgr.getBooleanFormulaManager();
        this.proverEnvironmentSupplier = (Supplier)Preconditions.checkNotNull(pProverEnvironmentSupplier);
    }

    static BooleanFormula transformToDnf(BooleanFormula formula, FormulaManagerView fmgr, ShutdownNotifier shutdownNotifier, Supplier<ProverEnvironment> proverEnvironmentSupplier) throws InterruptedException, SolverException {
        shutdownNotifier.shutdownIfNecessary();
        DnfTransformation visitor = new DnfTransformation(shutdownNotifier, fmgr, proverEnvironmentSupplier);
        try {
            return fmgr.getBooleanFormulaManager().transformRecursively(formula, visitor);
        }
        catch (DnfTransformationException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), InterruptedException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), SolverException.class);
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BooleanFormula visitAnd(List<BooleanFormula> pProcessedOperands) {
        ImmutableList clauses = ImmutableList.of((Object)this.fmgr.makeTrue());
        ImmutableList operands = (ImmutableList)pProcessedOperands.stream().map(f -> this.fmgr.toDisjunctionArgs(f, false)).sorted(Comparator.comparingInt(Set::size)).collect(ImmutableList.toImmutableList());
        try (ProverEnvironment proverEnvironment = this.proverEnvironmentSupplier.get();){
            ArrayList<BooleanFormula> tempList;
            UnmodifiableIterator unmodifiableIterator = operands.iterator();
            do {
                if (!unmodifiableIterator.hasNext()) return this.fmgr.or((Collection)clauses);
                Set childOperands = (Set)unmodifiableIterator.next();
                this.shutdownNotifier.shutdownIfNecessary();
                tempList = new ArrayList<BooleanFormula>();
                for (BooleanFormula clause : clauses) {
                    List list = childOperands.stream().map(co -> this.fmgr.and(clause, co)).collect(Collectors.toCollection(ArrayList::new));
                    for (BooleanFormula bf : list) {
                        if (!this.isSat(proverEnvironment, bf)) continue;
                        tempList.add(bf);
                    }
                }
            } while ((clauses = ImmutableList.copyOf(tempList)).size() <= 1000000);
            this.shutdownNotifier.shutdownIfNecessary();
            UnmodifiableIterator unmodifiableIterator2 = this.fmgr.and(pProcessedOperands);
            return unmodifiableIterator2;
        }
        catch (InterruptedException | SolverException e) {
            throw new DnfTransformationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSat(ProverEnvironment pProverEnvironment, BooleanFormula pFormula) throws InterruptedException, SolverException {
        this.shutdownNotifier.shutdownIfNecessary();
        try {
            pProverEnvironment.push(pFormula);
            boolean bl = !pProverEnvironment.isUnsat();
            return bl;
        }
        finally {
            pProverEnvironment.pop();
        }
    }

    private static class DnfTransformationException
    extends RuntimeException {
        private static final long serialVersionUID = 8329172743374361993L;

        DnfTransformationException(String pMsg, Throwable pCause) {
            super((String)Preconditions.checkNotNull((Object)pMsg), (Throwable)Preconditions.checkNotNull((Object)pCause));
        }
    }
}

