/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;

class EqualElimination
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private final FormulaManagerView fmgr;

    EqualElimination(FormulaManagerView pFmgr) {
        super(pFmgr);
        this.fmgr = pFmgr;
    }

    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
        if (pDecl.getKind().equals((Object)FunctionDeclarationKind.EQ)) {
            List<BooleanFormula> split = this.fmgr.splitNumeralEqualityIfPossible(pAtom);
            if (split.size() == 1) {
                return split.get(0);
            }
            if (split.size() == 2) {
                return this.fmgr.makeAnd(split.get(0), split.get(1));
            }
            throw new AssertionError();
        }
        return super.visitAtom(pAtom, pDecl);
    }
}

