/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;

class IfThenElseElimination
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private final FormulaManagerView fmgrView;
    private final FormulaManager fmgr;

    IfThenElseElimination(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
        super(pFmgrView);
        this.fmgrView = pFmgrView;
        this.fmgr = pFmgr;
    }

    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
        IfThenElseTransformation ifThenElseTransformation = new IfThenElseTransformation(this.fmgrView, this.fmgr);
        BooleanFormula result = (BooleanFormula)this.fmgrView.visit((Formula)pAtom, ifThenElseTransformation);
        BooleanFormulaManagerView booleanFormulaManager = this.fmgrView.getBooleanFormulaManager();
        BooleanFormula additionalAxioms = booleanFormulaManager.and(ifThenElseTransformation.getAdditionalAxioms());
        return this.fmgrView.makeAnd(result, additionalAxioms);
    }

    private static class IfThenElseTransformation
    extends DefaultFormulaVisitor<Formula> {
        private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
        private final FormulaManagerView fmgrView;
        private final FormulaManager fmgr;
        private final Collection<BooleanFormula> additionalAxioms;

        private IfThenElseTransformation(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
            this.fmgrView = pFmgrView;
            this.fmgr = pFmgr;
            this.additionalAxioms = new ArrayList<BooleanFormula>();
        }

        public Collection<BooleanFormula> getAdditionalAxioms() {
            return this.additionalAxioms;
        }

        protected Formula visitDefault(Formula pF) {
            return pF;
        }

        public Formula visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            List newArgs = Lists.transform(pArgs, f -> (Formula)this.fmgrView.visit((Formula)f, this));
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.ITE) || pFunctionDeclaration.getName().equalsIgnoreCase("ite")) {
                return this.transformIfThenElse((Formula)newArgs.get(0), (Formula)newArgs.get(1), (Formula)newArgs.get(2), pFunctionDeclaration.getType());
            }
            return this.fmgr.makeApplication(pFunctionDeclaration, newArgs);
        }

        private Formula transformIfThenElse(Formula pCondition, Formula pThen, Formula pElse, FormulaType<?> pFormulaType) {
            BooleanFormula condition = (BooleanFormula)pCondition;
            Formula auxVar = this.fmgr.makeVariable(pFormulaType, "__TERMINATION-IF_THEN_ELSE_AUX_VAR_" + ID_GENERATOR.getFreshId());
            this.additionalAxioms.add(this.fmgrView.makeOr(this.fmgrView.makeAnd(this.fmgrView.makeEqual(auxVar, pThen), condition), this.fmgrView.makeAnd(this.fmgrView.makeEqual(auxVar, pElse), this.fmgrView.makeNot(condition))));
            return auxVar;
        }
    }
}

