/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

class InOutVariablesCollector
extends DefaultFormulaVisitor<TraversalProcess> {
    private final FormulaManagerView formulaManagerView;
    private final Set<Formula> inVariables = new LinkedHashSet<Formula>();
    private final Set<Formula> outVariables = new LinkedHashSet<Formula>();
    private final Map<Pair<String, List<Formula>>, NavigableMap<Integer, Formula>> ufs;
    private final SSAMap outVariablesSsa;
    private final SSAMap inVariablesSsa;
    private final Set<String> relevantVariables;
    private final Map<Formula, Formula> substitution;

    public InOutVariablesCollector(FormulaManagerView pFormulaManagerView, SSAMap pInVariablesSsa, SSAMap pOutVariablesSsa, ImmutableSet<String> pRelevantVariables, ImmutableMap<Formula, Formula> pSubstitution) {
        this.formulaManagerView = pFormulaManagerView;
        this.outVariablesSsa = pOutVariablesSsa;
        this.inVariablesSsa = pInVariablesSsa;
        this.relevantVariables = pRelevantVariables;
        this.substitution = pSubstitution;
        this.ufs = new LinkedHashMap<Pair<String, List<Formula>>, NavigableMap<Integer, Formula>>();
    }

    protected TraversalProcess visitDefault(Formula pF) {
        return TraversalProcess.CONTINUE;
    }

    public TraversalProcess visitFreeVariable(Formula pF, String pName) {
        if (this.inVariables.contains(pF) && this.outVariables.contains(pF)) {
            return TraversalProcess.CONTINUE;
        }
        if (this.substitution.containsValue(pF)) {
            Formula originalFormula = this.substitution.entrySet().stream().filter(e -> ((Formula)e.getValue()).equals((Object)pF)).map(Map.Entry::getKey).findAny().orElseThrow();
            this.formulaManagerView.visit(originalFormula, new SubstitutionVisitor());
        } else {
            if (!this.formulaManagerView.isIntermediate(pName, this.outVariablesSsa)) {
                this.outVariables.add(pF);
            }
            if (!this.formulaManagerView.isIntermediate(pName, this.inVariablesSsa)) {
                this.inVariables.add(pF);
            }
        }
        return TraversalProcess.CONTINUE;
    }

    public Set<Formula> getInVariables() {
        ImmutableSet.Builder allInVariables = ImmutableSet.builder();
        allInVariables.addAll(this.inVariables);
        this.ufs.values().stream().map(m -> (Formula)m.firstEntry().getValue()).forEach(arg_0 -> ((ImmutableSet.Builder)allInVariables).add(arg_0));
        return allInVariables.build();
    }

    public Set<Formula> getOutVariables() {
        ImmutableSet.Builder allOutVariables = ImmutableSet.builder();
        allOutVariables.addAll(this.outVariables);
        this.ufs.values().stream().map(m -> (Formula)m.lastEntry().getValue()).forEach(arg_0 -> ((ImmutableSet.Builder)allOutVariables).add(arg_0));
        return allOutVariables.build();
    }

    private class SubstitutionVisitor
    extends DefaultFormulaVisitor<TraversalProcess> {
        private SubstitutionVisitor() {
        }

        protected TraversalProcess visitDefault(Formula pF) {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitFreeVariable(Formula pF, String pName) {
            Formula variable = InOutVariablesCollector.this.substitution.get(pF);
            if (variable != null) {
                if (!InOutVariablesCollector.this.formulaManagerView.isIntermediate(pName, InOutVariablesCollector.this.outVariablesSsa)) {
                    InOutVariablesCollector.this.outVariables.add(variable);
                }
                if (!InOutVariablesCollector.this.formulaManagerView.isIntermediate(pName, InOutVariablesCollector.this.inVariablesSsa)) {
                    InOutVariablesCollector.this.inVariables.add(variable);
                }
            }
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            if (!pArgs.stream().map(InOutVariablesCollector.this.formulaManagerView::uninstantiate).flatMap(f -> InOutVariablesCollector.this.formulaManagerView.extractVariableNames((Formula)f).stream()).allMatch(InOutVariablesCollector.this.relevantVariables::contains)) {
                return TraversalProcess.CONTINUE;
            }
            int argIndexes = pArgs.stream().flatMap(f -> InOutVariablesCollector.this.formulaManagerView.extractFunctionNames((Formula)f).stream()).map(FormulaManagerView::parseName).map(Pair::getSecondNotNull).filter(OptionalInt::isPresent).mapToInt(OptionalInt::getAsInt).sum();
            String name = pFunctionDeclaration.getName();
            Pair<String, OptionalInt> tokens = FormulaManagerView.parseName(name);
            ImmutableList uninstatiatedArgs = Collections3.transformedImmutableListCopy(pArgs, InOutVariablesCollector.this.formulaManagerView::uninstantiate);
            Pair<String, ImmutableList> key = Pair.of(tokens.getFirstNotNull(), uninstatiatedArgs);
            InOutVariablesCollector.this.ufs.putIfAbsent(key, new TreeMap());
            Map ufApplications = InOutVariablesCollector.this.ufs.get(key);
            int functionIndex = tokens.getSecondNotNull().orElse(0);
            ufApplications.put(functionIndex + argIndexes, InOutVariablesCollector.this.substitution.get(pF));
            return TraversalProcess.CONTINUE;
        }
    }
}

