/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;

class InvertInequalityTransformation
extends DefaultFormulaVisitor<BooleanFormula> {
    private final FormulaManagerView fmgr;

    InvertInequalityTransformation(FormulaManagerView pFmgr) {
        this.fmgr = pFmgr;
    }

    protected BooleanFormula visitDefault(Formula pF) {
        return (BooleanFormula)pF;
    }

    public BooleanFormula visitFunction(Formula pF, List<Formula> pNewArgs, FunctionDeclaration<?> pFunctionDeclaration) {
        if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.GTE) || pFunctionDeclaration.getName().equals(">=")) {
            assert (pNewArgs.size() == 2);
            return this.fmgr.makeLessThan(pNewArgs.get(0), pNewArgs.get(1), true);
        }
        if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.LTE) || pFunctionDeclaration.getName().equals("<=")) {
            assert (pNewArgs.size() == 2);
            return this.fmgr.makeGreaterThan(pNewArgs.get(0), pNewArgs.get(1), true);
        }
        if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.GT) || pFunctionDeclaration.getName().equals(">")) {
            assert (pNewArgs.size() == 2);
            return this.fmgr.makeLessOrEqual(pNewArgs.get(0), pNewArgs.get(1), true);
        }
        if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.LT) || pFunctionDeclaration.getName().equals("<")) {
            assert (pNewArgs.size() == 2);
            return this.fmgr.makeGreaterOrEqual(pNewArgs.get(0), pNewArgs.get(1), true);
        }
        return (BooleanFormula)super.visitFunction(pF, pNewArgs, pFunctionDeclaration);
    }
}

