/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisStatistics;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankVar;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.DivAndModElimination;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.DnfTransformation;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.EqualElimination;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.IfThenElseElimination;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.InOutVariablesCollector;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.NonLinearMultiplicationElimination;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.NotEqualAndNotInequalityElimination;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.utils.SolverUtils;
import org.sosy_lab.java_smt.utils.UfElimination;

@Options(prefix="termination.lassoBuilder")
public class LassoBuilder {
    protected static final ImmutableSet<String> META_VARIABLES_PREFIX = ImmutableSet.of((Object)"__VERIFIER_nondet_", (Object)"__ADDRESS_OF_");
    static final String TERMINATION_AUX_VARS_PREFIX = "__TERMINATION-";
    static final String TERMINATION_REPLACE_VARS_PREFIX = "__TERMINATION_REPLACE-";
    @Option(secure=true, description="Simplifies loop and stem formulas.")
    private boolean simplify = false;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final AbstractFormulaManager<Term, ?, ?, ?> fmgr;
    private final Supplier<ProverEnvironment> proverEnvironmentSupplier;
    private final FormulaManagerView fmgrView;
    private final BooleanFormulaManagerView bfmrView;
    private final PathFormulaManager pathFormulaManager;
    private final Script env;
    private final DivAndModElimination divAndModElimination;
    private final NonLinearMultiplicationElimination nonLinearMultiplicationElimination;
    private final UfElimination ufElimination;
    private final IfThenElseElimination ifThenElseElimination;
    private final EqualElimination equalElimination;
    private final NotEqualAndNotInequalityElimination notEqualAndNotInequalityElimination;
    private final FormulaTransformationVisitor formulaVisitor;
    private final LassoAnalysisStatistics stats;

    public LassoBuilder(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, AbstractFormulaManager<Term, ?, ?, ?> pFormulaManager, FormulaManagerView pFormulaManagerView, Supplier<ProverEnvironment> pProverEnvironmentSupplier, PathFormulaManager pPathFormulaManager, LassoAnalysisStatistics pLassoAnalysisStats) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.fmgr = (AbstractFormulaManager)Preconditions.checkNotNull(pFormulaManager);
        this.env = (Script)this.fmgr.getEnvironment();
        this.proverEnvironmentSupplier = (Supplier)Preconditions.checkNotNull(pProverEnvironmentSupplier);
        this.fmgrView = (FormulaManagerView)Preconditions.checkNotNull((Object)pFormulaManagerView);
        this.bfmrView = this.fmgrView.getBooleanFormulaManager();
        this.pathFormulaManager = (PathFormulaManager)Preconditions.checkNotNull((Object)pPathFormulaManager);
        this.divAndModElimination = new DivAndModElimination(this.fmgrView, (FormulaManager)this.fmgr);
        this.nonLinearMultiplicationElimination = new NonLinearMultiplicationElimination(this.fmgrView, (FormulaManager)this.fmgr);
        this.ufElimination = SolverUtils.ufElimination(pFormulaManager);
        this.ifThenElseElimination = new IfThenElseElimination(this.fmgrView, (FormulaManager)this.fmgr);
        this.equalElimination = new EqualElimination(this.fmgrView);
        this.notEqualAndNotInequalityElimination = new NotEqualAndNotInequalityElimination(this.fmgrView);
        this.formulaVisitor = new FormulaTransformationVisitor((FormulaManager)this.fmgr){

            public Formula visitFreeVariable(Formula pF, String pName) {
                ApplicationTerm appTerm = (ApplicationTerm)LassoBuilder.this.fmgr.extractInfo(pF);
                TermVariable result = LassoBuilder.this.env.variable(appTerm.getFunction().getName(), appTerm.getSort());
                return LassoBuilder.this.fmgr.getFormulaCreator().encapsulateWithTypeOf((Object)result);
            }
        };
        this.stats = pLassoAnalysisStats;
    }

    protected static boolean isMetaVariable(String variableName) {
        return META_VARIABLES_PREFIX.stream().anyMatch(variableName::startsWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Lasso> buildLasso(CounterexampleInfo pCounterexampleInfo, Set<CVariableDeclaration> pRelevantVariables) throws CPATransferException, InterruptedException, TermException, SolverException {
        this.stats.stemAndLoopConstructionStarted();
        StemAndLoop stemAndLoop = this.createStemAndLoop(pCounterexampleInfo);
        this.shutdownNotifier.shutdownIfNecessary();
        this.stats.stemAndLoopConstructionFinished();
        ImmutableMap relevantVariables = Maps.uniqueIndex(pRelevantVariables, AVariableDeclaration::getQualifiedName);
        try {
            this.stats.lassosCreationStarted();
            Collection<Lasso> collection = this.createLassos(stemAndLoop, (ImmutableMap<String, CVariableDeclaration>)relevantVariables);
            return collection;
        }
        finally {
            this.stats.lassosCreationFinished();
        }
    }

    private StemAndLoop createStemAndLoop(CounterexampleInfo pCounterexampleInfo) throws CPATransferException, InterruptedException {
        PathIterator path = pCounterexampleInfo.getTargetPath().fullPathIterator();
        ArrayList<CFAEdge> stemEdges = new ArrayList<CFAEdge>();
        ArrayList<CFAEdge> loopEdges = new ArrayList<CFAEdge>();
        boolean loopStarted = false;
        path.advance();
        while (path.advanceIfPossible()) {
            if (!loopStarted) {
                if (path.hasNext()) {
                    ARGState nextState = path.getNextAbstractState();
                    TerminationState nextTerminationState = AbstractStates.extractStateByType(nextState, TerminationState.class);
                    if (path.isPositionWithState()) {
                        ARGState state = path.getAbstractState();
                        TerminationState terminationState = AbstractStates.extractStateByType(state, TerminationState.class);
                        loopStarted = nextTerminationState.isPartOfLoop() && !terminationState.isPartOfStem();
                    } else {
                        loopStarted = nextTerminationState.isPartOfLoop();
                    }
                } else {
                    TerminationState state = AbstractStates.extractStateByType(path.getAbstractState(), TerminationState.class);
                    Verify.verify((boolean)state.isPartOfLoop());
                    loopStarted = true;
                }
            }
            if (loopStarted) {
                loopEdges.add(path.getIncomingEdge());
                continue;
            }
            stemEdges.add(path.getIncomingEdge());
        }
        return this.createStemAndLoop(stemEdges, loopEdges);
    }

    public StemAndLoop createStemAndLoop(List<CFAEdge> stemEdges, List<CFAEdge> loopEdges) throws CPATransferException, InterruptedException {
        PathFormula stemPathFormula = this.pathFormulaManager.makeFormulaForPath(stemEdges);
        PathFormula loopPathFormula = this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(stemPathFormula);
        SSAMap.SSAMapBuilder loopInVars = stemPathFormula.getSsa().builder();
        for (CFAEdge edge : loopEdges) {
            loopPathFormula = this.pathFormulaManager.makeAnd(loopPathFormula, edge);
            SSAMap currentSsa = loopPathFormula.getSsa();
            currentSsa.allVariables().stream().filter(v -> !loopInVars.allVariables().contains(v)).forEach(v -> loopInVars.setIndex((String)v, currentSsa.getType((String)v), currentSsa.getIndex((String)v)));
        }
        this.logger.logf(Level.FINE, "Stem formula %s", new Object[]{stemPathFormula.getFormula()});
        this.logger.logf(Level.FINE, "Loop formula %s", new Object[]{loopPathFormula.getFormula()});
        return new StemAndLoop(stemPathFormula, loopPathFormula, loopInVars.build());
    }

    private Collection<Lasso> createLassos(StemAndLoop pStemAndLoop, ImmutableMap<String, CVariableDeclaration> pRelevantVariables) throws InterruptedException, TermException, SolverException {
        Dnf stemDnf = this.toDnf(pStemAndLoop.getStem(), UfElimination.Result.empty(this.fmgr));
        Dnf loopDnf = this.toDnf(pStemAndLoop.getLoop(), stemDnf.getUfEliminationResult());
        return this.createLassos(pStemAndLoop, stemDnf, loopDnf, pRelevantVariables, true);
    }

    public Collection<Lasso> createLassos(StemAndLoop pStemAndLoop, Dnf stemDnf, Dnf loopDnf, ImmutableMap<String, CVariableDeclaration> pRelevantVariables, boolean checkSat) throws InterruptedException, TermException, SolverException {
        InOutVariables stemRankVars = this.extractRankVars(stemDnf, pStemAndLoop.getStemInVars(), pStemAndLoop.getStemOutVars(), pRelevantVariables);
        InOutVariables loopRankVars = this.extractRankVars(loopDnf, pStemAndLoop.getLoopInVars(), pStemAndLoop.getLoopOutVars(), pRelevantVariables);
        ImmutableList.Builder lassos = ImmutableList.builder();
        for (BooleanFormula stem : stemDnf.getClauses()) {
            for (BooleanFormula loop : loopDnf.getClauses()) {
                this.shutdownNotifier.shutdownIfNecessary();
                if (checkSat && this.isUnsat(this.bfmrView.and(stem, loop))) continue;
                LinearTransition stemTransition = this.createLinearTransition(stem, stemRankVars);
                LinearTransition loopTransition = this.createLinearTransition(loop, loopRankVars);
                Lasso lasso = new Lasso(stemTransition, loopTransition);
                lassos.add((Object)lasso);
            }
        }
        return lassos.build();
    }

    private boolean isUnsat(BooleanFormula formula) throws SolverException, InterruptedException {
        try (ProverEnvironment proverEnvironment = this.proverEnvironmentSupplier.get();){
            proverEnvironment.push(formula);
            boolean bl = proverEnvironment.isUnsat();
            return bl;
        }
    }

    private LinearTransition createLinearTransition(BooleanFormula path, InOutVariables rankVars) throws TermException {
        List<List<LinearInequality>> polyhedra = this.extractPolyhedra(path);
        return new LinearTransition(polyhedra, rankVars.getInVars(), rankVars.getOutVars());
    }

    private List<List<LinearInequality>> extractPolyhedra(BooleanFormula pathInDnf) throws TermException {
        Set<BooleanFormula> clauses = this.bfmrView.toDisjunctionArgs(pathInDnf, true);
        ArrayList<List<LinearInequality>> polyhedra = new ArrayList<List<LinearInequality>>(clauses.size());
        for (BooleanFormula clause : clauses) {
            Formula converted = this.fmgr.transformRecursively((Formula)clause, this.formulaVisitor);
            Term term = (Term)this.fmgr.extractInfo(converted);
            polyhedra.add(InequalityConverter.convert((Term)term, (InequalityConverter.NlaHandling)InequalityConverter.NlaHandling.EXCEPTION));
        }
        return polyhedra;
    }

    public Dnf toDnf(BooleanFormula pFormula) throws InterruptedException, SolverException {
        return this.toDnf(pFormula, UfElimination.Result.empty(this.fmgr));
    }

    public Dnf toDnf(BooleanFormula pFormula, UfElimination.Result eliminatedUfs) throws InterruptedException, SolverException {
        BooleanFormula simplified = this.simplify ? this.fmgrView.simplify(pFormula) : pFormula;
        BooleanFormula withoutDivAndMod = this.transformRecursively(this.divAndModElimination, simplified);
        BooleanFormula withoutNonLinearMult = this.transformRecursively(this.nonLinearMultiplicationElimination, withoutDivAndMod);
        UfElimination.Result ufEliminationResult = this.ufElimination.eliminateUfs(withoutNonLinearMult, eliminatedUfs);
        BooleanFormula withoutUfs = this.bfmrView.and(ufEliminationResult.getFormula(), ufEliminationResult.getConstraints());
        Map ufSubstitution = ufEliminationResult.getSubstitution();
        this.logger.logf(Level.FINER, "Substitution of Ufs in lasso formula: %s", new Object[]{ufSubstitution});
        BooleanFormula withoutIfThenElse = this.transformRecursively(this.ifThenElseElimination, withoutUfs);
        BooleanFormula nnf = this.fmgrView.applyTactic(withoutIfThenElse, Tactic.NNF);
        BooleanFormula notEqualEliminated = this.transformRecursively(this.notEqualAndNotInequalityElimination, nnf);
        BooleanFormula equalEliminated = this.transformRecursively(this.equalElimination, notEqualEliminated);
        BooleanFormula dnf = DnfTransformation.transformToDnf(equalEliminated, this.fmgrView, this.shutdownNotifier, this.proverEnvironmentSupplier);
        ImmutableSet clauses = ImmutableSet.copyOf(this.bfmrView.toDisjunctionArgs(dnf, true));
        return new Dnf((ImmutableSet<BooleanFormula>)clauses, ufEliminationResult);
    }

    private BooleanFormula transformRecursively(BooleanFormulaManagerView.BooleanFormulaTransformationVisitor visitor, BooleanFormula formula) throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        return this.fmgrView.getBooleanFormulaManager().transformRecursively(formula, visitor);
    }

    private InOutVariables extractRankVars(Dnf pDnf, SSAMap inSsa, SSAMap outSsa, ImmutableMap<String, CVariableDeclaration> pRelevantVariables) {
        ImmutableMap substitution = ImmutableMap.copyOf((Map)pDnf.getUfEliminationResult().getSubstitution());
        InOutVariablesCollector variablesCollector = new InOutVariablesCollector(this.fmgrView, inSsa, outSsa, (ImmutableSet<String>)pRelevantVariables.keySet(), (ImmutableMap<Formula, Formula>)substitution);
        this.fmgrView.visitRecursively((Formula)pDnf.getUfEliminationResult().getFormula(), (FormulaVisitor<TraversalProcess>)variablesCollector);
        ImmutableMap<RankVar, TermVariable> inRankVars = this.createRankVars(variablesCollector.getInVariables(), (Map<String, CVariableDeclaration>)pRelevantVariables, (Map<Formula, Formula>)substitution);
        ImmutableMap<RankVar, TermVariable> outRankVars = this.createRankVars(variablesCollector.getOutVariables(), (Map<String, CVariableDeclaration>)pRelevantVariables, (Map<Formula, Formula>)substitution);
        return new InOutVariables(inRankVars, outRankVars);
    }

    private ImmutableMap<RankVar, TermVariable> createRankVars(Set<Formula> variables, Map<String, CVariableDeclaration> pRelevantVariables, Map<Formula, Formula> substitution) {
        ImmutableMap.Builder rankVars = ImmutableMap.builder();
        for (Formula variable : variables) {
            Term term = (Term)this.fmgr.extractInfo(variable);
            Verify.verify((boolean)(term instanceof ApplicationTerm), (String)"Variable 'term' is expected to be an instance of ApplicationTerm", (Object[])new Object[0]);
            TermVariable termVar = this.env.variable(((ApplicationTerm)term).getFunction().getName(), term.getSort());
            Formula uninstantiatedVariable = this.fmgrView.uninstantiate(variable);
            Set<String> variableNames = this.fmgrView.extractVariableNames(uninstantiatedVariable);
            String variableName = (String)Iterables.getOnlyElement(variableNames);
            if (pRelevantVariables.get(variableName) != null) {
                rankVars.put((Object)new RankVar(variableName, pRelevantVariables.get(variableName).isGlobal(), (Term)this.fmgr.extractInfo(uninstantiatedVariable)), (Object)termVar);
                continue;
            }
            if (substitution.containsValue(variable)) {
                Formula originalFormula = substitution.entrySet().stream().filter(e -> ((Formula)e.getValue()).equals((Object)variable)).map(Map.Entry::getKey).findAny().orElseThrow();
                Formula uninstantiatedOriginalFormula = this.fmgrView.uninstantiate(originalFormula);
                Term originalTerm = (Term)this.fmgr.extractInfo(uninstantiatedOriginalFormula);
                rankVars.put((Object)new RankVar(originalTerm.toString(), true, originalTerm), (Object)termVar);
                continue;
            }
            if (LassoBuilder.isMetaVariable(variableName) || variableName.startsWith(TERMINATION_AUX_VARS_PREFIX)) continue;
            this.logger.logf(Level.FINE, "Ignoring variable %s during construction of lasso.", new Object[]{variableName});
        }
        return rankVars.buildOrThrow();
    }

    public static class Dnf {
        private final ImmutableSet<BooleanFormula> clauses;
        private final UfElimination.Result ufEliminationResult;

        Dnf(ImmutableSet<BooleanFormula> pClauses, UfElimination.Result p) {
            this.clauses = (ImmutableSet)Preconditions.checkNotNull(pClauses);
            this.ufEliminationResult = (UfElimination.Result)Preconditions.checkNotNull((Object)p);
        }

        public ImmutableSet<BooleanFormula> getClauses() {
            return this.clauses;
        }

        public UfElimination.Result getUfEliminationResult() {
            return this.ufEliminationResult;
        }
    }

    public static class StemAndLoop {
        private final PathFormula stem;
        private final PathFormula loop;
        private final SSAMap loopInVars;

        public StemAndLoop(PathFormula pStem, PathFormula pLoop, SSAMap pLoopInVars) {
            this.stem = (PathFormula)Preconditions.checkNotNull((Object)pStem);
            this.loop = (PathFormula)Preconditions.checkNotNull((Object)pLoop);
            this.loopInVars = (SSAMap)Preconditions.checkNotNull((Object)pLoopInVars);
        }

        public BooleanFormula getStem() {
            return this.stem.getFormula();
        }

        public SSAMap getStemInVars() {
            return SSAMap.emptySSAMap();
        }

        public SSAMap getStemOutVars() {
            return this.stem.getSsa();
        }

        public BooleanFormula getLoop() {
            return this.loop.getFormula();
        }

        public SSAMap getLoopInVars() {
            return this.loopInVars;
        }

        public SSAMap getLoopOutVars() {
            return this.loop.getSsa();
        }
    }

    private static class InOutVariables {
        private final ImmutableMap<RankVar, TermVariable> inVars;
        private final ImmutableMap<RankVar, TermVariable> outVars;

        public InOutVariables(ImmutableMap<RankVar, TermVariable> pInVars, ImmutableMap<RankVar, TermVariable> pOutVars) {
            this.inVars = (ImmutableMap)Preconditions.checkNotNull(pInVars);
            this.outVars = (ImmutableMap)Preconditions.checkNotNull(pOutVars);
        }

        public ImmutableMap<IProgramVar, TermVariable> getInVars() {
            return ImmutableMap.copyOf(this.inVars);
        }

        public ImmutableMap<IProgramVar, TermVariable> getOutVars() {
            return ImmutableMap.copyOf(this.outVars);
        }
    }
}

