/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

class NonLinearMultiplicationElimination
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private final FormulaManagerView fmgrView;
    private final FormulaManager fmgr;

    NonLinearMultiplicationElimination(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
        super(pFmgrView);
        this.fmgrView = pFmgrView;
        this.fmgr = pFmgr;
    }

    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
        NonLinearMultiplicationTransformation multiplicationTransformation = new NonLinearMultiplicationTransformation(this.fmgrView, this.fmgr);
        BooleanFormula result = (BooleanFormula)this.fmgrView.visit((Formula)pAtom, multiplicationTransformation);
        BooleanFormulaManagerView booleanFormulaManager = this.fmgrView.getBooleanFormulaManager();
        BooleanFormula additionalAxioms = booleanFormulaManager.and(multiplicationTransformation.getAdditionalAxioms());
        return this.fmgrView.makeAnd(result, additionalAxioms);
    }

    private static class NonLinearMultiplicationTransformation
    extends DefaultFormulaVisitor<Formula> {
        private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
        private final FormulaManagerView fmgrView;
        private final FormulaManager fmgr;
        private final List<BooleanFormula> additionalAxioms;

        private NonLinearMultiplicationTransformation(FormulaManagerView pFmgrView, FormulaManager pFmgr) {
            this.fmgrView = pFmgrView;
            this.fmgr = pFmgr;
            this.additionalAxioms = new ArrayList<BooleanFormula>();
        }

        public Collection<BooleanFormula> getAdditionalAxioms() {
            return ImmutableList.copyOf(this.additionalAxioms);
        }

        protected Formula visitDefault(Formula pF) {
            return pF;
        }

        public Formula visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            List newArgs = Lists.transform(pArgs, f -> (Formula)this.fmgrView.visit((Formula)f, this));
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.UF) && pFunctionDeclaration.getName().equalsIgnoreCase("Integer__*_") || pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.MUL) && !this.isConstant((Formula)newArgs.get(0)) && !this.isConstant((Formula)newArgs.get(1))) {
                assert (newArgs.size() == 2);
                return this.transformNonLinearMultiplication((Formula)newArgs.get(0), (Formula)newArgs.get(1), pFunctionDeclaration.getType());
            }
            return this.fmgr.makeApplication(pFunctionDeclaration, newArgs);
        }

        private boolean isConstant(Formula pF) {
            final AtomicBoolean constant = new AtomicBoolean(true);
            this.fmgrView.visitRecursively(pF, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

                protected TraversalProcess visitDefault(Formula pFormula) {
                    constant.set(false);
                    return TraversalProcess.ABORT;
                }

                public TraversalProcess visitFunction(Formula pFormula, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
                    if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.UMINUS)) {
                        return TraversalProcess.CONTINUE;
                    }
                    return TraversalProcess.ABORT;
                }

                public TraversalProcess visitConstant(Formula pFormula, Object pValue) {
                    return TraversalProcess.CONTINUE;
                }
            });
            return constant.get();
        }

        private Formula transformNonLinearMultiplication(Formula a, Formula b, FormulaType<?> formulaType) {
            BooleanFormulaManagerView bfmgr = this.fmgrView.getBooleanFormulaManager();
            Formula multAux = this.fmgr.makeVariable(formulaType, "__TERMINATION-MULT_AUX_VAR_" + ID_GENERATOR.getFreshId());
            ArrayList<BooleanFormula> cases = new ArrayList<BooleanFormula>();
            Object one = this.fmgrView.makeNumber(formulaType, 1L);
            Object minusOne = this.fmgrView.makeNumber(formulaType, -1L);
            Object zero = this.fmgrView.makeNumber(formulaType, 0L);
            BooleanFormula aIsZero = this.fmgrView.makeEqual(a, zero);
            BooleanFormula bIsZero = this.fmgrView.makeEqual(b, zero);
            BooleanFormula factorIsZero = this.fmgrView.makeOr(aIsZero, bIsZero);
            cases.add(this.fmgrView.makeAnd(factorIsZero, this.fmgrView.makeEqual(multAux, zero)));
            BooleanFormula aIsOne = this.fmgrView.makeEqual(a, minusOne);
            BooleanFormula bIsOne = this.fmgrView.makeEqual(b, minusOne);
            cases.add(this.fmgrView.makeAnd(bIsOne, this.fmgrView.makeEqual(multAux, a)));
            cases.add(this.fmgrView.makeAnd(aIsOne, this.fmgrView.makeEqual(multAux, b)));
            BooleanFormula aIsminusOne = this.fmgrView.makeEqual(a, one);
            BooleanFormula bIsminusOne = this.fmgrView.makeEqual(b, one);
            Formula minusA = this.fmgrView.makeNegate(a);
            Formula minusB = this.fmgrView.makeNegate(b);
            cases.add(this.fmgrView.makeAnd(aIsminusOne, this.fmgrView.makeEqual(multAux, minusA)));
            cases.add(this.fmgrView.makeAnd(bIsminusOne, this.fmgrView.makeEqual(multAux, minusB)));
            BooleanFormula zeroLessALessOne = bfmgr.and(this.fmgrView.makeLessThan(zero, a, true), this.fmgrView.makeLessThan(a, one, true));
            BooleanFormula zeroLessBLessOne = bfmgr.and(this.fmgrView.makeLessThan(zero, b, true), this.fmgrView.makeLessThan(b, one, true));
            BooleanFormula minusOneLessALessZero = bfmgr.and(this.fmgrView.makeLessThan(minusOne, a, true), this.fmgrView.makeLessThan(a, zero, true));
            BooleanFormula minusOneLessBLessZero = bfmgr.and(this.fmgrView.makeLessThan(minusOne, b, true), this.fmgrView.makeLessThan(b, zero, true));
            BooleanFormula aGreaterOne = bfmgr.and(this.fmgrView.makeGreaterThan(a, one, true));
            BooleanFormula bGreaterOne = bfmgr.and(this.fmgrView.makeGreaterThan(b, one, true));
            BooleanFormula aLessMinuseOne = bfmgr.and(this.fmgrView.makeLessThan(a, one, true));
            BooleanFormula bLessMinuseOne = bfmgr.and(this.fmgrView.makeLessThan(b, one, true));
            BooleanFormula zeroLessResultLessOne = bfmgr.and(this.fmgrView.makeLessThan(zero, multAux, true), this.fmgrView.makeLessThan(multAux, one, true));
            BooleanFormula minusOneLessResultLessZero = bfmgr.and(this.fmgrView.makeLessThan(minusOne, multAux, true), this.fmgrView.makeLessThan(multAux, zero, true));
            BooleanFormula resultGreaterOne = bfmgr.and(this.fmgrView.makeGreaterThan(multAux, one, true));
            BooleanFormula resultLessMinuseOne = bfmgr.and(this.fmgrView.makeLessThan(multAux, one, true));
            BooleanFormula positiveResult = this.fmgrView.makeGreaterThan(multAux, zero, true);
            BooleanFormula negativeResult = this.fmgrView.makeLessThan(multAux, zero, true);
            cases.add(bfmgr.and(zeroLessALessOne, zeroLessBLessOne, zeroLessResultLessOne));
            cases.add(bfmgr.and(zeroLessALessOne, minusOneLessBLessZero, minusOneLessResultLessZero));
            cases.add(bfmgr.and(zeroLessALessOne, bGreaterOne, positiveResult));
            cases.add(bfmgr.and(zeroLessALessOne, bLessMinuseOne, negativeResult));
            cases.add(bfmgr.and(minusOneLessALessZero, zeroLessBLessOne, minusOneLessResultLessZero));
            cases.add(bfmgr.and(minusOneLessALessZero, minusOneLessBLessZero, zeroLessResultLessOne));
            cases.add(bfmgr.and(minusOneLessALessZero, bGreaterOne, negativeResult));
            cases.add(bfmgr.and(minusOneLessALessZero, bLessMinuseOne, positiveResult));
            cases.add(bfmgr.and(aGreaterOne, zeroLessBLessOne, positiveResult));
            cases.add(bfmgr.and(aGreaterOne, minusOneLessBLessZero, negativeResult));
            cases.add(bfmgr.and(aGreaterOne, bGreaterOne, resultGreaterOne));
            cases.add(bfmgr.and(aGreaterOne, bLessMinuseOne, resultLessMinuseOne));
            cases.add(bfmgr.and(aLessMinuseOne, zeroLessBLessOne, negativeResult));
            cases.add(bfmgr.and(aLessMinuseOne, minusOneLessBLessZero, positiveResult));
            cases.add(bfmgr.and(aLessMinuseOne, bGreaterOne, resultLessMinuseOne));
            cases.add(bfmgr.and(aLessMinuseOne, bLessMinuseOne, resultGreaterOne));
            this.additionalAxioms.add(bfmgr.or(cases));
            return multAux;
        }
    }
}

