/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction;

import java.util.List;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.InvertInequalityTransformation;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;

class NotEqualAndNotInequalityElimination
extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
    private final FormulaManagerView fmgr;
    private final StrictInequalityTransformation strictInequalityTransformation;
    private final InvertInequalityTransformation invertInequalityTransformation;

    NotEqualAndNotInequalityElimination(FormulaManagerView pFmgr) {
        super(pFmgr);
        this.fmgr = pFmgr;
        this.strictInequalityTransformation = new StrictInequalityTransformation(pFmgr);
        this.invertInequalityTransformation = new InvertInequalityTransformation(pFmgr);
    }

    public BooleanFormula visitNot(BooleanFormula pOperand) {
        List<BooleanFormula> split = this.fmgr.splitNumeralEqualityIfPossible(pOperand);
        if (split.size() == 2) {
            return this.fmgr.makeOr((BooleanFormula)this.fmgr.visit((Formula)split.get(0), this.strictInequalityTransformation), (BooleanFormula)this.fmgr.visit((Formula)split.get(1), this.strictInequalityTransformation));
        }
        return (BooleanFormula)this.fmgr.visit((Formula)pOperand, this.invertInequalityTransformation);
    }

    private static class StrictInequalityTransformation
    extends DefaultFormulaVisitor<BooleanFormula> {
        private final FormulaManagerView fmgr;

        private StrictInequalityTransformation(FormulaManagerView pFmgr) {
            this.fmgr = pFmgr;
        }

        protected BooleanFormula visitDefault(Formula pF) {
            return (BooleanFormula)pF;
        }

        public BooleanFormula visitFunction(Formula pF, List<Formula> pNewArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.GTE) || pFunctionDeclaration.getName().equals(">=")) {
                assert (pNewArgs.size() == 2);
                return this.fmgr.makeGreaterThan(pNewArgs.get(0), pNewArgs.get(1), true);
            }
            if (pFunctionDeclaration.getKind().equals((Object)FunctionDeclarationKind.LTE) || pFunctionDeclaration.getName().equals("<=")) {
                assert (pNewArgs.size() == 2);
                return this.fmgr.makeLessThan(pNewArgs.get(0), pNewArgs.get(1), true);
            }
            return (BooleanFormula)super.visitFunction(pF, pNewArgs, pFunctionDeclaration);
        }
    }
}

