/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.toolchain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;

public class LassoRankerLogger
implements ILogger {
    private final LogManager logger;

    public LassoRankerLogger(LogManager pLogger) {
        this.logger = pLogger;
    }

    public LassoRankerLogger(LogManager pLogger, String name) {
        this.logger = pLogger.withComponentName(name);
    }

    public boolean isFatalEnabled() {
        return this.logger.wouldBeLogged(Level.SEVERE);
    }

    public void fatal(Object pMessage, Throwable pThrowable) {
        this.logException(Level.SEVERE, pMessage, pThrowable);
    }

    public void fatal(Object pMessage) {
        this.logger.log(Level.SEVERE, new Object[]{pMessage});
    }

    public boolean isErrorEnabled() {
        return this.logger.wouldBeLogged(Level.WARNING);
    }

    public void error(Object pMessage, Throwable pThrowable) {
        this.logException(Level.WARNING, pMessage, pThrowable);
    }

    public void error(Object pMessage) {
        this.logger.log(Level.WARNING, new Object[]{pMessage});
    }

    public boolean isWarnEnabled() {
        return this.logger.wouldBeLogged(Level.INFO);
    }

    public void warn(Object pMessage) {
        this.logger.log(Level.INFO, new Object[]{pMessage});
    }

    public boolean isInfoEnabled() {
        return this.logger.wouldBeLogged(Level.FINEST);
    }

    public void info(Object pMessage) {
        this.logger.log(Level.FINEST, new Object[]{pMessage});
    }

    public boolean isDebugEnabled() {
        return this.logger.wouldBeLogged(Level.ALL);
    }

    public void debug(Object pMessage) {
        this.logger.log(Level.ALL, new Object[]{pMessage});
    }

    public boolean isLogLevelEnabled(ILogger.LogLevel pLevel) {
        switch (pLevel) {
            case DEBUG: {
                return this.logger.wouldBeLogged(Level.ALL);
            }
            case ERROR: {
                return this.logger.wouldBeLogged(Level.WARNING);
            }
            case FATAL: {
                return this.logger.wouldBeLogged(Level.SEVERE);
            }
            case INFO: {
                return this.logger.wouldBeLogged(Level.FINEST);
            }
            case OFF: {
                return this.logger.wouldBeLogged(Level.OFF);
            }
            case WARN: {
                return this.logger.wouldBeLogged(Level.INFO);
            }
        }
        throw new IllegalArgumentException(this.getClass() + "Unhandled loglevel");
    }

    public void log(ILogger.LogLevel pLevel, String pMessage) {
        switch (pLevel) {
            case DEBUG: {
                this.debug(pMessage);
                break;
            }
            case ERROR: {
                this.error(pMessage);
                break;
            }
            case FATAL: {
                this.fatal(pMessage);
                break;
            }
            case INFO: {
                this.info(pMessage);
                break;
            }
            case WARN: {
                this.warn(pMessage);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled loglevel: " + pLevel));
            }
        }
    }

    public void setLevel(ILogger.LogLevel pLevel) {
        throw new UnsupportedOperationException(this.getClass() + "::setLevel is not implemented");
    }

    private void logException(Level level, Object pMessage, Throwable pThrowable) {
        if (pThrowable != null) {
            this.logger.logException(level, pThrowable, pMessage.toString());
        } else {
            this.logger.log(level, new Object[]{pMessage});
        }
    }
}

