/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.toolchain;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.toolchain.LassoRankerLoggingService;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.toolchain.LassoRankerProgressMonitorService;

public class LassoRankerToolchainStorage
implements IToolchainStorage,
IUltimateServiceProvider {
    private final ShutdownNotifier shutdownNotifier;
    private final ILoggingService lassoRankerLoggingService;
    private final Map<String, IStorable> toolchainStorage;

    public LassoRankerToolchainStorage(LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.lassoRankerLoggingService = new LassoRankerLoggingService(pLogger);
        this.toolchainStorage = new ConcurrentHashMap<String, IStorable>();
    }

    public boolean destroyStorable(String pKey) {
        IStorable storable = this.removeStorable(pKey);
        if (storable != null) {
            storable.destroy();
            return true;
        }
        return false;
    }

    public IStorable removeStorable(String pKey) {
        return this.toolchainStorage.remove(pKey);
    }

    public IStorable getStorable(String pKey) {
        return this.toolchainStorage.get(pKey);
    }

    public IStorable putStorable(String pKey, IStorable pValue) {
        return this.toolchainStorage.put(pKey, pValue);
    }

    public void clear() {
        for (IStorable storable : this.toolchainStorage.values()) {
            storable.destroy();
        }
        this.toolchainStorage.clear();
    }

    public ILoggingService getLoggingService() {
        return this.lassoRankerLoggingService;
    }

    public IProgressMonitorService getProgressMonitorService() {
        return new LassoRankerProgressMonitorService(this.shutdownNotifier);
    }

    public IToolchainStorage getStorage() {
        return this;
    }

    public Set<String> keys() {
        return this.toolchainStorage.keySet();
    }

    public IBacktranslationService getBacktranslationService() {
        throw new UnsupportedOperationException(this.getClass() + "::getBacktranslationService is not implemented");
    }

    public IResultService getResultService() {
        throw new UnsupportedOperationException(this.getClass() + "::getResultService is not implemented");
    }

    public <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(Class<K> pServiceType) {
        throw new UnsupportedOperationException(this.getClass() + "::getServiceInstance is not implemented");
    }

    public IPreferenceProvider getPreferenceProvider(String pPluginId) {
        throw new UnsupportedOperationException(this.getClass() + "::getPreferenceProvider is not implemented");
    }

    public IUltimateServiceProvider registerPreferenceLayer(Class<?> pCreator, String ... pPluginIds) {
        throw new UnsupportedOperationException(this.getClass() + "::registerPreferenceLayer is not implemented");
    }

    public IUltimateServiceProvider registerDefaultPreferenceLayer(Class<?> pCreator, String ... pPluginIds) {
        throw new UnsupportedOperationException(this.getClass() + "::registerDefaultPreferenceLayer is not implemented");
    }

    public void pushMarker(Object pMarker) throws IllegalArgumentException {
        throw new UnsupportedOperationException(this.getClass() + "::pushMarker is not implemented");
    }

    public Set<String> destroyMarker(Object pMarker) {
        throw new UnsupportedOperationException(this.getClass() + "::destroyMarker is not implemented");
    }
}

