/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.termination.validation;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.DummyTargetState;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;
import org.sosy_lab.cpachecker.util.expressions.ToFormulaVisitor;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="witness.validation.termination")
public class NonTerminationWitnessValidator
implements Algorithm,
StatisticsProvider {
    private static final DummyTargetState DUMMY_TARGET_STATE = DummyTargetState.withSimpleTargetInformation("termination");
    private static final String REACHABILITY_SPEC_NAME = "ReachabilityObserver";
    private static final String STEM_SPEC_NAME = "StemEndController";
    private static final String WITNESS_BREAK_CONTROLLER_SPEC_NAME = "WitnessBreakController";
    private static final String WITNESS_BREAK_OBSERVER_SPEC_NAME = "WitnessBreakObserver";
    private static final String TERMINATION_OBSERVER_SPEC_NAME = "TerminationObserver";
    private static final String ITERATION_OBSERVER_SPEC_NAME = "RecurrentSetObserver";
    private static final String AUTOMATANAMEPREFIX = "AutomatonAnalysis_";
    private static final String BREAKSTATENAME = "_predefinedState_BREAK";
    @Option(secure=true, name="reachCycle.config", required=true, description="Use this configuration when checking that recurrent set (at cycle head) is reachable. Configuration must be precise, i.e., may only report real counterexamples")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path reachabilityConfig;
    @Option(secure=true, required=true, name="inspectCycle.config", description="Use this configuration when checking that when reach recurrent set, execution can be extended to an infinite one")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path recurrentConfig;
    @Option(secure=true, required=true, name="terminatingStatements", description="Path to automaton specification describing which statements let the program terminate.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path terminatingStatementsAutomaton = Classes.getCodeLocation(NonTerminationWitnessValidator.class).resolveSibling("config/specification/TerminatingStatements.spc");
    @Option(secure=true, name="successAsViolation", description="Report a successful validation of the witness, i.e., a confirmation of the nontermination, as termination violation.")
    private boolean reportSuccessfulCheckAsViolation = true;
    private static final String RECURSIONDEPTH = "2";
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdown;
    private final CFA cfa;
    private final Automaton witness;
    private final String witnessAutomatonName;
    private final Automaton terminationAutomaton;
    private final String terminationAutomatonName;
    private final NonTerminationValidationStatistics statistics;

    public NonTerminationWitnessValidator(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ImmutableList<Automaton> pSpecificationAutomata) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdown = pShutdownNotifier;
        if (pSpecificationAutomata.size() < 1) {
            throw new InvalidConfigurationException("Witness file is missing in specification.");
        }
        if (pSpecificationAutomata.size() != 1) {
            throw new InvalidConfigurationException("Expect that only violation witness is part of the specification.");
        }
        this.witness = (Automaton)pSpecificationAutomata.get(0);
        this.witnessAutomatonName = AUTOMATANAMEPREFIX + this.witness.getName();
        Scope scope = this.cfa.getLanguage() == Language.C ? new CProgramScope(this.cfa, this.logger) : DummyScope.getInstance();
        this.terminationAutomaton = AutomatonParser.parseAutomatonFile(this.terminatingStatementsAutomaton, this.config, this.logger, this.cfa.getMachineModel(), scope, this.cfa.getLanguage(), pShutdownNotifier).get(0);
        this.terminationAutomatonName = AUTOMATANAMEPREFIX + this.terminationAutomaton.getName();
        this.statistics = new NonTerminationValidationStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.statistics.totalVal.start();
        FluentIterable cycleHeadCandidates = FluentIterable.from(this.witness.getStates()).filter(automState -> automState.isNontrivialCycleStart());
        if (cycleHeadCandidates.isEmpty()) {
            throw new CPAException("Invalid witness. Witness is missing cycle start state.");
        }
        try {
            for (AutomatonInternalState stemEndRepeatStart : cycleHeadCandidates) {
                this.shutdown.shutdownIfNecessary();
                Optional<AbstractState> stemSynState = this.findStemEndLocation(stemEndRepeatStart);
                this.shutdown.shutdownIfNecessary();
                if (!stemSynState.isPresent()) continue;
                CFANode stemEndLoc = AbstractStates.extractLocation(stemSynState.orElseThrow());
                CFANode afterInvCheck = new CFANode(stemEndLoc.getFunction());
                ExpressionTree<AExpression> quasiInvariant = ExpressionTrees.getTrue();
                for (AbstractState state : AbstractStates.asIterable(stemSynState.orElseThrow())) {
                    AutomatonState automatonState;
                    if (!(state instanceof AutomatonState) || (automatonState = (AutomatonState)state).getOwningAutomaton() != this.witness) continue;
                    quasiInvariant = automatonState.getCandidateInvariants();
                    break;
                }
                this.shutdown.shutdownIfNecessary();
                CExpression expr = quasiInvariant.accept(new ToCExpressionVisitor(this.cfa.getMachineModel(), this.logger));
                this.shutdown.shutdownIfNecessary();
                CAssumeEdge invCheck = new CAssumeEdge(expr.toASTString(), FileLocation.DUMMY, stemEndLoc, afterInvCheck, expr, true);
                stemEndLoc.addLeavingEdge(invCheck);
                invCheck.getSuccessor().addEnteringEdge(invCheck);
                CAssumeEdge negInvCheck = new CAssumeEdge("!( " + invCheck.getRawStatement() + " )", FileLocation.DUMMY, stemEndLoc, new CFANode(stemEndLoc.getFunction()), invCheck.getExpression(), false);
                this.logger.log(Level.INFO, new Object[]{"Check that recurrent set is reachable"});
                if (!this.checkReachabilityOfRecurrentSet(invCheck)) continue;
                this.shutdown.shutdownIfNecessary();
                stemEndLoc.removeLeavingEdge(invCheck);
                this.logger.log(Level.INFO, new Object[]{"Check that recurrent set is valid"});
                if (!this.confirmThatRecurrentSetIsProper(stemEndRepeatStart, stemEndLoc, negInvCheck)) continue;
                pReachedSet.popFromWaitlist();
                this.logger.log(Level.INFO, new Object[]{"Non-termination witness confirmed."});
                if (this.reportSuccessfulCheckAsViolation) {
                    pReachedSet.add(new ARGState(DUMMY_TARGET_STATE, null), SingletonPrecision.getInstance());
                }
                Algorithm.AlgorithmStatus algorithmStatus = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                return algorithmStatus;
            }
            this.logger.log(Level.INFO, new Object[]{"Could not confirm witness."});
            pReachedSet.add(new DummyErrorState(pReachedSet.getFirstState()), SingletonPrecision.getInstance());
            pReachedSet.popFromWaitlist();
            Algorithm.AlgorithmStatus algorithmStatus = Algorithm.AlgorithmStatus.SOUND_AND_IMPRECISE;
            return algorithmStatus;
        }
        finally {
            this.statistics.totalVal.stop();
        }
    }

    private Optional<AbstractState> findStemEndLocation(AutomatonInternalState cycleStart) throws InterruptedException {
        try {
            ArrayList<Automaton> automata = new ArrayList<Automaton>(2);
            automata.add(this.witness);
            automata.add(this.getSpecForErrorAt(this.witnessAutomatonName, cycleStart, STEM_SPEC_NAME));
            automata.add(this.terminationAutomaton);
            automata.add(this.getSpecForStopAtWitnessTerminationBreak(WITNESS_BREAK_CONTROLLER_SPEC_NAME));
            Specification spec = Specification.fromAutomata(automata);
            ConfigurationBuilder singleConfigBuilder = Configuration.builder();
            singleConfigBuilder.setOption("cpa", "cpa.composite.CompositeCPA");
            singleConfigBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA");
            singleConfigBuilder.setOption("cpa.callstack.depth", RECURSIONDEPTH);
            singleConfigBuilder.setOption("analysis.traversal.order", "BFS");
            singleConfigBuilder.setOption("output.disable", "true");
            Configuration singleConfig = singleConfigBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, this.logger, this.shutdown, AggregatedReachedSets.empty());
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, spec);
            GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
            Algorithm algorithm = coreComponents.createAlgorithm(cpa, this.cfa, spec);
            AbstractState initialState = cpa.getInitialState(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
            Precision initialPrecision = cpa.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(initialState, initialPrecision);
            this.shutdown.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Search for program location at which infinite path(s) split into stem and looping part"});
            algorithm.run(reached);
            Optional<AbstractState> stemState = reached.stream().filter(AbstractStates::isTargetState).findFirst();
            return stemState;
        }
        catch (IOException | InvalidConfigurationException | CPAException e) {
            this.logger.logException(Level.FINE, e, "Exception occurred while trying to find location which is visited infinitely in a nonterminating execution");
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkReachabilityOfRecurrentSet(CAssumeEdge quasiInvariantAsAssumeEdge) throws InterruptedException {
        this.statistics.cycleReachTime.start();
        try {
            this.logger.log(Level.INFO, new Object[]{"Prepare check for reachability of recurrent set."});
            ArrayList<Automaton> automata = new ArrayList<Automaton>(2);
            automata.add(this.witness);
            automata.add(this.getSpecForErrorAt(quasiInvariantAsAssumeEdge.getSuccessor()));
            automata.add(this.terminationAutomaton);
            automata.add(this.getSpecForStopAtWitnessTerminationBreak(WITNESS_BREAK_CONTROLLER_SPEC_NAME));
            Specification spec = Specification.fromAutomata(automata);
            ConfigurationBuilder singleConfigBuilder = Configuration.builder();
            singleConfigBuilder.loadFromFile(this.reachabilityConfig);
            singleConfigBuilder.setOption("cpa.callstack.depth", RECURSIONDEPTH);
            singleConfigBuilder.setOption("output.disable", "true");
            Configuration singleConfig = singleConfigBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, this.logger, this.shutdown, AggregatedReachedSets.empty());
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, spec);
            GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
            Algorithm algorithm = coreComponents.createAlgorithm(cpa, this.cfa, spec);
            AbstractState initialState = cpa.getInitialState(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
            Precision initialPrecision = cpa.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(initialState, initialPrecision);
            this.shutdown.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Start checking whether recurrent set is reachable."});
            Algorithm.AlgorithmStatus result = algorithm.run(reached);
            if (result.isPrecise() && reached.wasTargetReached()) {
                this.logger.log(Level.INFO, new Object[]{"Recurrent set is reachable."});
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException | InvalidConfigurationException | CPAException e) {
            this.logger.logException(Level.FINE, e, "Exception occurred while proving that recurrent set is reachable.");
        }
        finally {
            this.statistics.cycleReachTime.stop();
        }
        this.logger.log(Level.INFO, new Object[]{"Could not establish that recurrent set is reachable."});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean confirmThatRecurrentSetIsProper(AutomatonInternalState pStemEndCycleStart, CFANode pStemEndLoc, CAssumeEdge pNegInvCheck) throws InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Check that assumptions in witnesses only restrict nondeterministic choices"});
        if (!this.areWitnessAssumptionsInLoopOnlyNondeterminismRestricting(pStemEndLoc, pStemEndCycleStart)) {
            return false;
        }
        this.statistics.cycleCheckTime.start();
        try {
            ArrayList<Automaton> automataSecondCheck = new ArrayList<Automaton>(4);
            ArrayList<Automaton> automata = new ArrayList<Automaton>(5);
            try {
                automataSecondCheck.add(new Automaton(this.witness.getName(), (Map<String, AutomatonVariable>)this.witness.getInitialVariables(), this.witness.getStates(), pStemEndCycleStart.getName()));
            }
            catch (InvalidAutomatonException e) {
                this.logger.logException(Level.INFO, (Throwable)e, "Failed to set up specification to check recurrent set");
                boolean bl = false;
                this.statistics.cycleCheckTime.stop();
                return bl;
            }
            automataSecondCheck.add(this.getSpecForErrorAt(this.witnessAutomatonName, BREAKSTATENAME, WITNESS_BREAK_OBSERVER_SPEC_NAME));
            automataSecondCheck.add(this.terminationAutomaton);
            automataSecondCheck.add(this.getSpecForErrorAt(this.terminationAutomatonName, BREAKSTATENAME, TERMINATION_OBSERVER_SPEC_NAME));
            automata.addAll(automataSecondCheck);
            Automaton automatonRedetectRecurrentSet = this.getSpecForDetectingCycleIterationEnd(pStemEndLoc, this.witnessAutomatonName, pStemEndCycleStart, pNegInvCheck.getSuccessor(), ITERATION_OBSERVER_SPEC_NAME);
            automata.add(automatonRedetectRecurrentSet);
            Specification spec = Specification.fromAutomata(automata);
            Specification spec2 = Specification.fromAutomata(automataSecondCheck);
            this.shutdown.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Checking infinite part of non-termination witness, often the loop part"});
            this.logger.log(Level.INFO, new Object[]{"Try using complete witness information"});
            boolean confirmedRecurrentSet = this.setUpAndRunAnalysisForRecurrentSetCheck(spec, pStemEndLoc, pNegInvCheck, pStemEndCycleStart, automatonRedetectRecurrentSet);
            if (!confirmedRecurrentSet) {
                this.logger.log(Level.INFO, new Object[]{"First check of recurrent set check failed. Continue with check only relying on recurrent set information, but do not stop exploration at cyclehead."});
                confirmedRecurrentSet = this.setUpAndRunAnalysisForRecurrentSetCheck(spec2, pStemEndLoc, pNegInvCheck, pStemEndCycleStart, null);
            }
            boolean bl = confirmedRecurrentSet;
            return bl;
        }
        catch (IOException | InvalidConfigurationException e) {
            this.logger.logException(Level.FINE, e, "Exception occurred while checking validity (closedness) of given recurrent set.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.statistics.cycleCheckTime.stop();
        }
    }

    private boolean setUpAndRunAnalysisForRecurrentSetCheck(Specification spec, CFANode pStemEndLoc, CAssumeEdge pNegInvCheck, AutomatonInternalState pStemEndCycleStart, @Nullable Automaton pAutomatonRedetectRecurrentSet) throws InterruptedException {
        try {
            ConfigurationBuilder singleConfigBuilder = Configuration.builder();
            singleConfigBuilder.loadFromFile(this.recurrentConfig);
            singleConfigBuilder.setOption("cpa.callstack.depth", RECURSIONDEPTH);
            singleConfigBuilder.setOption("output.disable", "true");
            Configuration singleConfig = singleConfigBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, this.logger, this.shutdown, AggregatedReachedSets.empty());
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, spec);
            Preconditions.checkArgument((boolean)(cpa instanceof ARGCPA), (Object)"Require ARGCPA to check validity of recurrent set:");
            ConfigurableProgramAnalysis wrappedCPA = (ConfigurableProgramAnalysis)((ARGCPA)cpa).getWrappedCPAs().get(0);
            GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
            Algorithm algorithm = coreComponents.createAlgorithm(cpa, this.cfa, spec);
            this.shutdown.shutdownIfNecessary();
            Precision initialPrecision = cpa.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
            PredicateCPA predCPA = CPAs.retrieveCPA(cpa, PredicateCPA.class);
            if (predCPA != null) {
                PredicatePrecision predPrec = this.getPredicatePrecisionFromCandidateInvariants(predCPA);
                initialPrecision = Precisions.replaceByType(initialPrecision, predPrec, (Predicate<? super Precision>)((Predicate)precision -> precision instanceof PredicatePrecision));
            }
            CAssumeEdge invCheckLoop = new CAssumeEdge("!(" + pNegInvCheck.getRawStatement() + ")", FileLocation.DUMMY, pStemEndLoc, pStemEndLoc, pNegInvCheck.getExpression(), true);
            pStemEndLoc.addLeavingEdge(invCheckLoop);
            AbstractState initialState = this.setUpInitialAbstractStateForRecurrentSet(pStemEndLoc, wrappedCPA, initialPrecision, invCheckLoop, pStemEndCycleStart);
            pStemEndLoc.removeLeavingEdge(invCheckLoop);
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(initialState, initialPrecision);
            this.shutdown.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Start checking recurrent set"});
            Algorithm.AlgorithmStatus result = algorithm.run(reached);
            if (!result.isSound()) {
                this.logger.log(Level.INFO, new Object[]{"Current check became unsound. Do not use its result for witness valiation."});
                return false;
            }
            if (reached.wasTargetReached()) {
                this.logger.log(Level.INFO, new Object[]{"May leave recurrent set in current check."});
                return false;
            }
            for (AbstractState stateWithoutSucc : FluentIterable.from((Iterable)reached).filter(state -> {
                ARGState argState = (ARGState)state;
                return !argState.isCovered() && argState.getChildren().isEmpty();
            })) {
                this.shutdown.shutdownIfNecessary();
                for (AbstractState compState : AbstractStates.asIterable(stateWithoutSucc)) {
                    AutomatonState amState;
                    if (compState instanceof LocationState) {
                        if (((LocationState)compState).getLocationNode().getNumLeavingEdges() != 0) continue;
                        this.logger.log(Level.INFO, new Object[]{"May reach a terminating state from the recurrent set in current check."});
                        return false;
                    }
                    if (compState instanceof CallstackState) {
                        if (((CallstackState)compState).getDepth() != 0 || !(AbstractStates.extractLocation(stateWithoutSucc) instanceof FunctionExitNode)) continue;
                        this.logger.log(Level.INFO, new Object[]{"Function return without known caller found. May be unsound to continue. Abort current check."});
                        return false;
                    }
                    if (!(compState instanceof AutomatonState) || (amState = (AutomatonState)compState).getOwningAutomaton() != pAutomatonRedetectRecurrentSet || !amState.getInternalStateName().equals(SuccessorState.FINISHED.toString())) continue;
                    pNegInvCheck.getPredecessor().addLeavingEdge(pNegInvCheck);
                    for (AbstractState succ : wrappedCPA.getTransferRelation().getAbstractSuccessorsForEdge(((ARGState)stateWithoutSucc).getWrappedState(), reached.getPrecision(stateWithoutSucc), pNegInvCheck)) {
                        Optional<PrecisionAdjustmentResult> precResult = wrappedCPA.getPrecisionAdjustment().prec(succ, reached.getPrecision(stateWithoutSucc), reached, (Function<AbstractState, AbstractState>)Functions.identity(), succ);
                        pNegInvCheck.getPredecessor().removeLeavingEdge(pNegInvCheck);
                        if (!precResult.isPresent()) continue;
                        this.logger.log(Level.INFO, new Object[]{"May leave the recurrent set in current check."});
                        return false;
                    }
                }
            }
        }
        catch (IOException | InvalidConfigurationException | CPAException e) {
            return false;
        }
        return true;
    }

    private PredicatePrecision getPredicatePrecisionFromCandidateInvariants(PredicateCPA pPredCPA) {
        PredicateAbstractionManager pAMgr = pPredCPA.getPredicateManager();
        PathFormulaManager pfmgr = pPredCPA.getPathFormulaManager();
        if (pfmgr instanceof CachingPathFormulaManager) {
            pfmgr = ((CachingPathFormulaManager)pfmgr).delegate;
        }
        ToFormulaVisitor toFormula = new ToFormulaVisitor(pPredCPA.getSolver().getFormulaManager(), pfmgr, null);
        ArrayList<AbstractionPredicate> predicates = new ArrayList<AbstractionPredicate>();
        predicates.add(pAMgr.makeFalsePredicate());
        for (ExpressionTree<AExpression> candidate : this.witness.getAllCandidateInvariants()) {
            try {
                BooleanFormula invariant = candidate.accept(toFormula);
                predicates.addAll((Collection<AbstractionPredicate>)pAMgr.getPredicatesForAtomsOf(invariant));
            }
            catch (ToFormulaVisitor.ToFormulaException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Ignoring candidate invariant in precision generation.");
            }
        }
        return new PredicatePrecision((Multimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)ArrayListMultimap.create(), (Multimap<CFANode, AbstractionPredicate>)ArrayListMultimap.create(), (Multimap<String, AbstractionPredicate>)ArrayListMultimap.create(), predicates);
    }

    private AbstractState setUpInitialAbstractStateForRecurrentSet(CFANode pRecurrentSetLoc, ConfigurableProgramAnalysis cpaWrappedInARGCPA, Precision pInitialPrecision, CAssumeEdge pAssumeRecurrentSetInvariant, AutomatonInternalState pStemEndCycleStart) throws InterruptedException {
        Preconditions.checkArgument((boolean)Objects.equals(pAssumeRecurrentSetInvariant.getPredecessor(), pAssumeRecurrentSetInvariant.getSuccessor()));
        AbstractState initialDefault = cpaWrappedInARGCPA.getInitialState(pRecurrentSetLoc, StateSpacePartition.getDefaultPartition());
        try {
            Collection<? extends AbstractState> succ = cpaWrappedInARGCPA.getTransferRelation().getAbstractSuccessorsForEdge(initialDefault, pInitialPrecision, pAssumeRecurrentSetInvariant);
            ArrayList<AbstractState> initialCandidate = new ArrayList<AbstractState>(succ.size());
            for (AbstractState abstractState : succ) {
                for (AbstractState innerState : AbstractStates.asIterable(abstractState)) {
                    if (!(innerState instanceof AutomatonState) || !((AutomatonState)innerState).getInternalStateName().equals(pStemEndCycleStart.getName())) continue;
                    initialCandidate.add(abstractState);
                }
                if (initialCandidate.size() != 1) continue;
                return new ARGState((AbstractState)initialCandidate.get(0), null);
            }
        }
        catch (CPATransferException e) {
            this.logger.logException(Level.FINE, (Throwable)e, "Failed to properly set up initial state for recurrent checking.");
        }
        this.logger.log(Level.WARNING, new Object[]{"Failed to add the information of the recurrent set. Try to check witness with recurrent set TRUE"});
        return new ARGState(initialDefault, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areWitnessAssumptionsInLoopOnlyNondeterminismRestricting(CFANode pRecurrentStart, AutomatonInternalState pRecurrentStartInWitness) throws InterruptedException {
        this.statistics.cycleCheckTime.start();
        try {
            ArrayList<Automaton> automata = new ArrayList<Automaton>(1);
            try {
                automata.add(new Automaton(this.witness.getName(), (Map<String, AutomatonVariable>)this.witness.getInitialVariables(), this.witness.getStates(), pRecurrentStartInWitness.getName()));
                automata.add(this.getSpecForStopAtWitnessTerminationBreak(WITNESS_BREAK_CONTROLLER_SPEC_NAME));
            }
            catch (IOException | InvalidConfigurationException | InvalidAutomatonException e) {
                this.logger.logUserException(Level.INFO, e, "Failed to set up specification to check assumptions.");
                boolean bl = false;
                this.statistics.cycleCheckTime.stop();
                return bl;
            }
            automata.add(this.terminationAutomaton);
            Specification spec = Specification.fromAutomata(automata);
            ConfigurationBuilder singleConfigBuilder = Configuration.builder();
            singleConfigBuilder.setOption("cpa", "cpa.arg.ARGCPA");
            singleConfigBuilder.setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA");
            singleConfigBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPA");
            singleConfigBuilder.setOption("analysis.traversal.order", "BFS");
            singleConfigBuilder.setOption("output.disable", "true");
            Configuration singleConfig = singleConfigBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, this.logger, this.shutdown, AggregatedReachedSets.empty());
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, spec);
            GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
            Algorithm algorithm = coreComponents.createAlgorithm(cpa, this.cfa, spec);
            AbstractState initialState = cpa.getInitialState(pRecurrentStart, StateSpacePartition.getDefaultPartition());
            Precision initialPrecision = cpa.getInitialPrecision(pRecurrentStart, StateSpacePartition.getDefaultPartition());
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(initialState, initialPrecision);
            this.shutdown.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Explore assumptions in witness automaton. Focus on looping part."});
            algorithm.run(reached);
            for (AbstractState state : reached) {
                for (AutomatonState amState : AbstractStates.asIterable(state).filter(AutomatonState.class)) {
                    if (amState.getAssumptions().isEmpty()) continue;
                    ARGState argState = (ARGState)state;
                    if (amState.getAssumptions().size() > 1) {
                        this.logger.log(Level.INFO, new Object[]{"Support at most one assumption per edge in witness, but this witness has more."});
                        boolean bl = false;
                        return bl;
                    }
                    if (!(amState.getAssumptions().get(0) instanceof CBinaryExpression)) {
                        this.logger.log(Level.INFO, new Object[]{"Found a disallowed assumption. Only support binary assumptions."});
                        boolean bl = false;
                        return bl;
                    }
                    CBinaryExpression assumption = (CBinaryExpression)amState.getAssumptions().get(0);
                    if (assumption.getOperator() != CBinaryExpression.BinaryOperator.EQUALS) {
                        this.logger.log(Level.INFO, new Object[]{"Found a disallowed operator in assumption. Only equality is supported."});
                        boolean bl = false;
                        return bl;
                    }
                    for (ARGState parent : argState.getParents()) {
                        CFAEdge edge = parent.getEdgeToChild(argState);
                        switch (edge.getEdgeType()) {
                            case StatementEdge: {
                                CStatement stmt = ((CStatementEdge)edge).getStatement();
                                if (stmt instanceof CFunctionCallAssignmentStatement) {
                                    CLeftHandSide assigned = ((CFunctionCallAssignmentStatement)stmt).getLeftHandSide();
                                    if (assumption.getOperand1().equals(assigned) || assumption.getOperand2().equals(assigned)) break;
                                    this.logger.log(Level.INFO, new Object[]{"Cannot detect that assumption only restricts assigned variable. Assumption might be too strong."});
                                    boolean bl = false;
                                    return bl;
                                }
                                this.logger.log(Level.INFO, new Object[]{"Found an assumption for a deterministic edge."});
                                boolean bl = false;
                                return bl;
                            }
                            case DeclarationEdge: {
                                CDeclaration decl = ((CDeclarationEdge)edge).getDeclaration();
                                if (decl instanceof CVariableDeclaration && ((CVariableDeclaration)decl).getInitializer() == null) {
                                    if (decl.getName().equals(assumption.getOperand1().toASTString()) || decl.getName().equals(assumption.getOperand2().toASTString())) break;
                                    this.logger.log(Level.INFO, new Object[]{"Cannot detect that declared variables refers to declared variable. Assumption might be too strong."});
                                    boolean bl = false;
                                    return bl;
                                }
                                this.logger.log(Level.INFO, new Object[]{"Found an unallowed assumption for a declaration with initializer."});
                                boolean bl = false;
                                return bl;
                            }
                            default: {
                                this.logger.log(Level.INFO, new Object[]{"Found an assumption for a deterministic statement"});
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (InvalidConfigurationException | CPAException e) {
            this.logger.logException(Level.FINE, e, "Failed to check proper use of assumptions in witness.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.statistics.cycleCheckTime.stop();
        }
    }

    private Automaton getSpecForErrorAt(String automatonCPAName, AutomatonInternalState automatonState, String fileName) throws IOException, InvalidConfigurationException {
        return this.getSpecForErrorAt(automatonCPAName, automatonState.getName(), fileName);
    }

    private Automaton getSpecForErrorAt(String automatonCPAName, String internalStateName, String fileName) throws IOException, InvalidConfigurationException {
        return this.writeObserver(fileName, "CHECK(" + automatonCPAName + " , \"state==" + internalStateName + "\")", SuccessorState.ERROR);
    }

    private Automaton getSpecForErrorAt(CFANode loc) throws IOException, InvalidConfigurationException {
        return this.writeObserver(REACHABILITY_SPEC_NAME, "CHECK(location , \"nodenumber==" + loc.getNodeNumber() + "\")", SuccessorState.ERROR);
    }

    private Automaton writeObserver(String automatonFileName, String checkStatement, SuccessorState succState) throws InvalidConfigurationException, IOException {
        Path tmpSpec = Files.createTempFile(automatonFileName, "spc", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(tmpSpec, Charset.defaultCharset(), new OpenOption[0]);){
            writer.append("OBSERVER AUTOMATON ");
            writer.append(automatonFileName);
            writer.append("\nINITIAL STATE Init;\n");
            writer.append("STATE USEFIRST Init :\n");
            writer.append(checkStatement);
            writer.append(" -> " + succState + ";\n\n");
            writer.append("END AUTOMATON");
        }
        return this.getAutomaton(tmpSpec);
    }

    private Automaton getSpecForStopAtWitnessTerminationBreak(String fileName) throws IOException, InvalidConfigurationException {
        Path tmpSpec = Files.createTempFile(fileName, "spc", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(tmpSpec, Charset.defaultCharset(), new OpenOption[0]);){
            writer.append("CONTROL AUTOMATON ");
            writer.append(fileName);
            writer.append("\nINITIAL STATE Init;\n");
            writer.append("STATE USEFIRST Init :\n");
            writer.append("CHECK(");
            writer.append(this.witnessAutomatonName);
            writer.append(" , \"state==");
            writer.append(BREAKSTATENAME);
            writer.append("\") -> STOP;\n");
            writer.append("CHECK(");
            writer.append(this.terminationAutomatonName);
            writer.append(" , \"state==");
            writer.append(BREAKSTATENAME);
            writer.append("\") -> STOP;\n\n");
            writer.append("END AUTOMATON");
        }
        return this.getAutomaton(tmpSpec);
    }

    private Automaton getSpecForDetectingCycleIterationEnd(CFANode loc, String automatonCPAName, AutomatonInternalState automatonState, CFANode nodeToContinue, String fileName) throws IOException, InvalidConfigurationException {
        Path tmpSpec = Files.createTempFile(fileName, "spc", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(tmpSpec, Charset.defaultCharset(), new OpenOption[0]);){
            writer.append("CONTROL AUTOMATON ");
            writer.append(fileName);
            writer.append("\nINITIAL STATE Init;\n");
            writer.append("STATE USEFIRST Init :\n");
            writer.append(" TRUE -> GOTO Checking;\n\n");
            writer.append("STATE USEFIRST Checking :\n");
            writer.append("CHECK(location, \"nodenumber==");
            writer.append(Integer.toString(loc.getNodeNumber()));
            writer.append("\") && CHECK(");
            writer.append(automatonCPAName);
            writer.append(" , \"state==");
            writer.append(automatonState.getName());
            writer.append("\")");
            writer.append(" -> GOTO " + SuccessorState.FINISHED + ";\n\n");
            writer.append("STATE USEFIRST " + SuccessorState.FINISHED + ":\n");
            writer.append("CHECK(location, \"nodenumber==");
            writer.append(Integer.toString(nodeToContinue.getNodeNumber()));
            writer.append("\") -> GOTO " + SuccessorState.FINISHED + ";\n");
            writer.append(" TRUE -> " + SuccessorState.STOP + ";\n\n");
            writer.append("END AUTOMATON");
        }
        return this.getAutomaton(tmpSpec);
    }

    private Automaton getAutomaton(Path automatonSpec) throws InvalidConfigurationException {
        Scope scope = this.cfa.getLanguage() == Language.C ? new CProgramScope(this.cfa, this.logger) : DummyScope.getInstance();
        return AutomatonParser.parseAutomatonFile(automatonSpec, this.config, this.logger, this.cfa.getMachineModel(), scope, this.cfa.getLanguage(), this.shutdown).get(0);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    private static class NonTerminationValidationStatistics
    implements Statistics {
        private final StatTimer totalVal = new StatTimer("Total time for validation");
        private final StatTimer cycleReachTime = new StatTimer("Time to check reachability of cycle start");
        private final StatTimer cycleCheckTime = new StatTimer("Time for checking infinite execution from cycle start");

        private NonTerminationValidationStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
            writer.put(this.totalVal);
            writer = writer.beginLevel();
            writer.put(this.cycleReachTime);
            writer.put(this.cycleCheckTime);
        }

        @Override
        public @Nullable String getName() {
            return "Nontermination Witness Validation";
        }
    }

    private static enum SuccessorState {
        BREAK,
        ERROR,
        STOP,
        FINISHED;

    }
}

