/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.math.DoubleMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.common.rationals.ExtendedRational;
import org.sosy_lab.common.rationals.Rational;

public abstract class Address {
    private Address() {
    }

    public abstract Address addOffset(BigInteger var1);

    public abstract Address addOffset(BigDecimal var1);

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract boolean isUnknown();

    public abstract boolean isSymbolic();

    public abstract boolean isConcrete();

    public abstract BigInteger getAddressValue();

    public abstract String getCommentRepresentation();

    public static Address valueOf(Object pAddress) {
        if (pAddress instanceof Address) {
            return (Address)pAddress;
        }
        if (pAddress instanceof BigInteger) {
            return new ConcreteAddress((BigInteger)pAddress);
        }
        if (pAddress instanceof Rational) {
            Rational rational = (Rational)pAddress;
            if (rational.isIntegral()) {
                return new ConcreteAddress(rational.getNum());
            }
        } else if (pAddress instanceof ExtendedRational) {
            Rational rat;
            ExtendedRational eRat = (ExtendedRational)pAddress;
            if (eRat.isRational() && (rat = eRat.getRational()).isIntegral()) {
                return new ConcreteAddress(rat.getNum());
            }
        } else {
            if (pAddress instanceof Byte) {
                long value = ((Byte)pAddress).longValue();
                return new ConcreteAddress(BigInteger.valueOf(value));
            }
            if (pAddress instanceof Integer) {
                long value = ((Integer)pAddress).longValue();
                return new ConcreteAddress(BigInteger.valueOf(value));
            }
            if (pAddress instanceof Long) {
                long value = (Long)pAddress;
                return new ConcreteAddress(BigInteger.valueOf(value));
            }
            if (pAddress instanceof Short) {
                long value = ((Short)pAddress).longValue();
                return new ConcreteAddress(BigInteger.valueOf(value));
            }
            if (pAddress instanceof Double) {
                Double value = (Double)pAddress;
                if (DoubleMath.isMathematicalInteger((double)value)) {
                    long dValue = value.longValue();
                    return new ConcreteAddress(BigInteger.valueOf(dValue));
                }
            } else if (pAddress instanceof Float) {
                Float value = (Float)pAddress;
                if (DoubleMath.isMathematicalInteger((double)value.floatValue())) {
                    long dValue = value.longValue();
                    return new ConcreteAddress(BigInteger.valueOf(dValue));
                }
            } else if (pAddress instanceof BigDecimal) {
                BigDecimal bdVal = (BigDecimal)pAddress;
                try {
                    BigInteger bigIntValue = bdVal.toBigIntegerExact();
                    return new ConcreteAddress(bigIntValue);
                }
                catch (ArithmeticException e) {
                    return new SymbolicAddress(pAddress);
                }
            }
        }
        return new SymbolicAddress(pAddress);
    }

    public static Address getUnknownAddress() {
        return UnknownAddress.getInstance();
    }

    private static class SymbolicAddress
    extends Address {
        private final Object symbolicAddress;

        private SymbolicAddress(Object pSymbolicAddress) {
            this.symbolicAddress = pSymbolicAddress;
        }

        @Override
        public Address addOffset(BigInteger pOffset) {
            throw new UnsupportedOperationException("Can't use pointer arithmetic on symbolic address.");
        }

        @Override
        public Address addOffset(BigDecimal pOffset) {
            throw new UnsupportedOperationException("Can't use pointer arithmetic on symbolic address.");
        }

        @Override
        public String toString() {
            return "<Symbolic address :" + this.symbolicAddress + ">";
        }

        @Override
        public int hashCode() {
            return this.symbolicAddress.hashCode();
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj instanceof SymbolicAddress) {
                return this.symbolicAddress.equals(((SymbolicAddress)pObj).symbolicAddress);
            }
            return false;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public boolean isSymbolic() {
            return true;
        }

        @Override
        public boolean isConcrete() {
            return false;
        }

        @Override
        public BigInteger getAddressValue() {
            throw new UnsupportedOperationException("Value of this symbolic address is not known.");
        }

        @Override
        public String getCommentRepresentation() {
            return this.symbolicAddress.toString();
        }
    }

    private static class UnknownAddress
    extends Address {
        private static final UnknownAddress instance = new UnknownAddress();

        private UnknownAddress() {
        }

        private static UnknownAddress getInstance() {
            return instance;
        }

        @Override
        public Address addOffset(BigInteger pOffset) {
            throw new UnsupportedOperationException("Can't use pointer arithmetic on unkown address.");
        }

        @Override
        public Address addOffset(BigDecimal pOffset) {
            throw new UnsupportedOperationException("Can't use pointer arithmetic on unkown address.");
        }

        @Override
        public String toString() {
            return "Unknown address";
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException("Can't compare unknown addresses.");
        }

        @Override
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(Object pObj) {
            throw new UnsupportedOperationException("Can't compare unknown addresses.");
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public boolean isConcrete() {
            return false;
        }

        @Override
        public BigInteger getAddressValue() {
            throw new UnsupportedOperationException("Value of this unknown address is not known.");
        }

        @Override
        public String getCommentRepresentation() {
            return "unknown";
        }
    }

    private static class ConcreteAddress
    extends Address {
        private final BigInteger addressValue;

        private ConcreteAddress(BigInteger pAddressValue) {
            this.addressValue = pAddressValue;
        }

        @Override
        public Address addOffset(BigInteger pOffset) {
            BigInteger newAddressValue = this.addressValue.add(pOffset);
            return Address.valueOf(newAddressValue);
        }

        @Override
        public Address addOffset(BigDecimal pOffset) {
            BigInteger offset;
            try {
                offset = pOffset.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                return ConcreteAddress.getUnknownAddress();
            }
            BigInteger newAddressValue = this.addressValue.add(offset);
            return Address.valueOf(newAddressValue);
        }

        @Override
        public String toString() {
            return "<Concrete address : value " + this.addressValue + ">";
        }

        @Override
        public int hashCode() {
            return this.addressValue.hashCode();
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj instanceof ConcreteAddress) {
                return this.addressValue.equals(((ConcreteAddress)pObj).addressValue);
            }
            return false;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public boolean isConcrete() {
            return true;
        }

        @Override
        public BigInteger getAddressValue() {
            return this.addressValue;
        }

        @Override
        public String getCommentRepresentation() {
            return this.addressValue.toString();
        }
    }
}

