/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.FieldReference;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

@Options(prefix="counterexample.export.assumptions")
public class AssumptionToEdgeAllocator {
    private final LogManager logger;
    private final MachineModel machineModel;
    private static final int FIRST = 0;
    @Option(secure=true, description="Try to avoid using operations that exceed the capabilities of linear arithmetics when extracting assumptions from the model. This option aims to prevent witnesses that are inconsistent with  models that are, due to an analysis limited to linear arithmetics, actually incorrect.\n This option does not magically produce a correct witness from an incorrect model, and since the difference between an incorrect witness consistent with the model and an incorrect witness that is inconsistent with the model is academic, you usually want this option to be off.")
    private boolean assumeLinearArithmetics = false;
    @Option(secure=true, description="If the option assumeLinearArithmetics is set, this option can be used to allow multiplication between operands with at least one constant.")
    private boolean allowMultiplicationWithConstants = false;
    @Option(secure=true, description="If the option assumeLinearArithmetics is set, this option can be used to allow division and modulo by constants.")
    private boolean allowDivisionAndModuloByConstants = false;

    public static AssumptionToEdgeAllocator create(Configuration pConfig, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        return new AssumptionToEdgeAllocator(pConfig, pLogger, pMachineModel);
    }

    private AssumptionToEdgeAllocator(Configuration pConfig, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkNotNull((Object)((Object)pMachineModel));
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.machineModel = pMachineModel;
    }

    public CFAEdgeWithAssumptions allocateAssumptionsToEdge(CFAEdge pCFAEdge, ConcreteState pConcreteState) {
        ImmutableSet<AExpressionStatement> assignmentsAtEdge = this.createAssignmentsAtEdge(pCFAEdge, pConcreteState);
        String comment = this.createComment(pCFAEdge, pConcreteState);
        return new CFAEdgeWithAssumptions(pCFAEdge, (ImmutableCollection<AExpressionStatement>)assignmentsAtEdge, comment);
    }

    private String createComment(CFAEdge pCfaEdge, ConcreteState pConcreteState) {
        switch (pCfaEdge.getEdgeType()) {
            case AssumeEdge: {
                return this.handleAssumeComment((AssumeEdge)pCfaEdge, pConcreteState);
            }
            case DeclarationEdge: {
                return this.handleDclComment((ADeclarationEdge)pCfaEdge, pConcreteState);
            }
            case ReturnStatementEdge: {
                return this.handleReturnStatementComment((AReturnStatementEdge)pCfaEdge, pConcreteState);
            }
        }
        return "";
    }

    private String handleReturnStatementComment(AReturnStatementEdge pCfaEdge, ConcreteState pConcreteState) {
        Optional<? extends AExpression> returnExpression = pCfaEdge.getExpression();
        if (returnExpression.isPresent() && returnExpression.get() instanceof CExpression) {
            CExpression returnExp = (CExpression)returnExpression.get();
            if (returnExp instanceof CLiteralExpression) {
                return "";
            }
            String functionname = pCfaEdge.getPredecessor().getFunctionName();
            LModelValueVisitor v = new LModelValueVisitor(functionname, pConcreteState);
            Number value = v.evaluateNumericalValue(returnExp);
            if (value == null) {
                return "";
            }
            return returnExp.toASTString() + " = " + value;
        }
        return "";
    }

    private String handleDclComment(ADeclarationEdge pCfaEdge, ConcreteState pConcreteState) {
        if (pCfaEdge instanceof CDeclarationEdge) {
            return this.getCommentOfDclAddress((CSimpleDeclaration)((Object)pCfaEdge.getDeclaration()), pCfaEdge, pConcreteState);
        }
        return "";
    }

    private String getCommentOfDclAddress(CSimpleDeclaration dcl, CFAEdge edge, ConcreteState pConcreteState) {
        String functionName = edge.getPredecessor().getFunctionName();
        LModelValueVisitor v = new LModelValueVisitor(functionName, pConcreteState);
        Address address = v.getAddress(dcl);
        if (address.isUnknown() || address.isConcrete()) {
            return "";
        }
        return "&" + dcl.getName() + " == " + address.getCommentRepresentation();
    }

    private ImmutableSet<AExpressionStatement> createAssignmentsAtEdge(CFAEdge pCFAEdge, ConcreteState pConcreteState) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        switch (pCFAEdge.getEdgeType()) {
            case DeclarationEdge: {
                result.addAll(this.handleDeclaration(((ADeclarationEdge)pCFAEdge).getDeclaration(), pCFAEdge.getPredecessor().getFunctionName(), pConcreteState));
                break;
            }
            case StatementEdge: {
                result.addAll(this.handleStatement(pCFAEdge, ((AStatementEdge)pCFAEdge).getStatement(), pConcreteState));
                break;
            }
            case AssumeEdge: {
                result.addAll(this.handleAssumeStatement((AssumeEdge)pCFAEdge, pConcreteState));
                break;
            }
        }
        if (pCFAEdge.getEdgeType() == CFAEdgeType.BlankEdge || !AutomatonGraphmlCommon.handleAsEpsilonEdge(pCFAEdge)) {
            List<AExpressionStatement> parameterAssumptions = this.handleFunctionEntry(pCFAEdge, pConcreteState);
            result.addAll(parameterAssumptions);
        }
        return result.build();
    }

    private String handleAssumeComment(AssumeEdge pCfaEdge, ConcreteState pConcreteState) {
        if (pCfaEdge instanceof CAssumeEdge) {
            return this.handleAssumeComment((CAssumeEdge)pCfaEdge, pConcreteState);
        }
        return "";
    }

    private String handleAssumeComment(CAssumeEdge pCFAEdge, ConcreteState pConcreteState) {
        CExpression pCExpression = pCFAEdge.getExpression();
        String functionName = pCFAEdge.getPredecessor().getFunctionName();
        if (pCExpression instanceof CBinaryExpression) {
            CBinaryExpression binExp = (CBinaryExpression)pCExpression;
            String result1 = this.handleAssumeOp(pCFAEdge, binExp.getOperand1(), functionName, pConcreteState);
            String result2 = this.handleAssumeOp(pCFAEdge, binExp.getOperand2(), functionName, pConcreteState);
            if (!result1.isEmpty() && !result2.isEmpty()) {
                return result1 + System.lineSeparator() + result2;
            }
            if (!result1.isEmpty()) {
                return result1;
            }
            if (!result2.isEmpty()) {
                return result2;
            }
        }
        return "";
    }

    private String handleAssumeOp(CFAEdge pCFAEdge, CExpression op, String pFunctionName, ConcreteState pConcreteState) {
        if (op instanceof CLiteralExpression) {
            return "";
        }
        if (op instanceof CLeftHandSide) {
            List<AExpressionStatement> assignments = this.handleAssignment(pCFAEdge, (CLeftHandSide)op, pConcreteState);
            if (assignments.isEmpty()) {
                return "";
            }
            return Joiner.on((String)System.lineSeparator()).join(Iterables.transform(assignments, a -> a.toASTString()));
        }
        Object value = this.getValueObject(op, pFunctionName, pConcreteState);
        if (value != null) {
            return op.toASTString() + " == " + value;
        }
        return "";
    }

    private List<AExpressionStatement> handleAssumeStatement(AssumeEdge pCFAEdge, ConcreteState pConcreteState) {
        if (!(pCFAEdge instanceof CAssumeEdge)) {
            return ImmutableList.of();
        }
        CExpression pCExpression = ((CAssumeEdge)pCFAEdge).getExpression();
        if (!(pCExpression instanceof CBinaryExpression)) {
            return ImmutableList.of();
        }
        CBinaryExpression binExp = (CBinaryExpression)pCExpression;
        CExpression op1 = binExp.getOperand1();
        CExpression op2 = binExp.getOperand2();
        ImmutableList.Builder result = ImmutableList.builder();
        if (op1 instanceof CLeftHandSide) {
            result.addAll(this.handleAssignment((CFAEdge)pCFAEdge, (CLeftHandSide)op1, pConcreteState));
        }
        if (op2 instanceof CLeftHandSide) {
            result.addAll(this.handleAssignment((CFAEdge)pCFAEdge, (CLeftHandSide)op2, pConcreteState));
        }
        return result.build();
    }

    private Object getValueObject(CExpression pOp1, String pFunctionName, ConcreteState pConcreteState) {
        LModelValueVisitor v = new LModelValueVisitor(pFunctionName, pConcreteState);
        return v.evaluateNumericalValue(pOp1);
    }

    private List<AExpressionStatement> handleFunctionEntry(CFAEdge pEdge, ConcreteState pConcreteState) {
        CFANode predecessor = pEdge.getPredecessor();
        if (predecessor.getNumEnteringEdges() <= 0) {
            return ImmutableList.of();
        }
        String function = predecessor.getFunctionName();
        while (!(predecessor instanceof FunctionEntryNode)) {
            if (predecessor.getNumEnteringEdges() != 1 || !predecessor.getFunctionName().equals(function)) {
                return ImmutableList.of();
            }
            CFAEdge enteringEdge = predecessor.getEnteringEdge(0);
            if (!AutomatonGraphmlCommon.handleAsEpsilonEdge(enteringEdge) && !AutomatonGraphmlCommon.isMainFunctionEntry(enteringEdge)) {
                return ImmutableList.of();
            }
            predecessor = enteringEdge.getPredecessor();
        }
        FunctionEntryNode entryNode = (FunctionEntryNode)predecessor;
        String functionName = entryNode.getFunctionDefinition().getName();
        List<? extends AParameterDeclaration> parameterDeclarations = entryNode.getFunctionParameters();
        if (parameterDeclarations.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (AParameterDeclaration aParameterDeclaration : parameterDeclarations) {
            result.addAll(this.handleDeclaration(aParameterDeclaration, functionName, pConcreteState));
        }
        return result.build();
    }

    private List<AExpressionStatement> handleAssignment(CFAEdge pCFAEdge, CLeftHandSide pLeftHandSide, ConcreteState pConcreteState) {
        String functionName = pCFAEdge.getPredecessor().getFunctionName();
        Object value = this.getValueObject(pLeftHandSide, functionName, pConcreteState);
        if (value == null) {
            return ImmutableList.of();
        }
        CType expectedType = pLeftHandSide.getExpressionType();
        ValueLiterals valueAsCode = this.getValueAsCode(value, expectedType, pLeftHandSide, functionName, pConcreteState);
        return this.handleSimpleValueLiteralsAssumptions(valueAsCode, pLeftHandSide);
    }

    private List<AExpressionStatement> handleAssignment(CFAEdge pCFAEdge, CAssignment pAssignment, ConcreteState pConcreteState) {
        CLeftHandSide leftHandSide = pAssignment.getLeftHandSide();
        return this.handleAssignment(pCFAEdge, leftHandSide, pConcreteState);
    }

    private Object getValueObject(CLeftHandSide pLeftHandSide, String pFunctionName, ConcreteState pConcreteState) {
        LModelValueVisitor v = new LModelValueVisitor(pFunctionName, pConcreteState);
        return pLeftHandSide.accept(v);
    }

    private ValueLiterals getValueAsCode(Object pValue, Type pExpectedType, CLeftHandSide leftHandSide, String functionName, ConcreteState pConcreteState) {
        if (pExpectedType instanceof CType) {
            CType cType = ((CType)pExpectedType).getCanonicalType();
            ValueLiteralsVisitor v = new ValueLiteralsVisitor(pValue, leftHandSide, pConcreteState);
            ValueLiterals valueLiterals = cType.accept(v);
            if (this.isStructOrUnionType(cType) && leftHandSide instanceof CIdExpression) {
                v.resolveStruct(cType, valueLiterals, (CIdExpression)leftHandSide, functionName);
            }
            return valueLiterals;
        }
        return new ValueLiterals();
    }

    private List<AExpressionStatement> handleStatement(CFAEdge pCFAEdge, AStatement pStatement, ConcreteState pConcreteState) {
        if (pStatement instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignmentStatement = (CFunctionCallAssignmentStatement)pStatement;
            return this.handleAssignment(pCFAEdge, assignmentStatement, pConcreteState);
        }
        if (pStatement instanceof CExpressionAssignmentStatement) {
            CExpressionAssignmentStatement assignmentStatement = (CExpressionAssignmentStatement)pStatement;
            return this.handleAssignment(pCFAEdge, assignmentStatement, pConcreteState);
        }
        return ImmutableList.of();
    }

    private List<AExpressionStatement> handleDeclaration(ASimpleDeclaration dcl, String pFunctionName, ConcreteState pConcreteState) {
        if (dcl instanceof CSimpleDeclaration) {
            CSimpleDeclaration cDcl = (CSimpleDeclaration)dcl;
            CType dclType = cDcl.getType();
            @Nullable Object value = this.getValueObject(cDcl, pFunctionName, pConcreteState);
            if (value == null) {
                return ImmutableList.of();
            }
            CIdExpression idExpression = new CIdExpression(dcl.getFileLocation(), cDcl);
            ValueLiterals valueAsCode = this.getValueAsCode(value, dclType, idExpression, pFunctionName, pConcreteState);
            CIdExpression leftHandSide = new CIdExpression(FileLocation.DUMMY, cDcl);
            return this.handleSimpleValueLiteralsAssumptions(valueAsCode, leftHandSide);
        }
        return ImmutableList.of();
    }

    private List<AExpressionStatement> handleSimpleValueLiteralsAssumptions(ValueLiterals pValueLiterals, CLeftHandSide pLValue) {
        Set<SubExpressionValueLiteral> subValues = pValueLiterals.getSubExpressionValueLiteral();
        LinkedHashSet<AExpressionStatement> statements = new LinkedHashSet<AExpressionStatement>();
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(this.machineModel, this.logger);
        if (!pValueLiterals.hasUnknownValueLiteral()) {
            CExpression leftSide = this.getLeftAssumptionFromLhs(pLValue);
            CExpression rightSide = pValueLiterals.getExpressionValueLiteralAsCExpression();
            AExpressionStatement statement = this.buildEquationExpressionStatement(expressionBuilder, leftSide, rightSide);
            statements.add(statement);
        }
        for (SubExpressionValueLiteral subValueLiteral : subValues) {
            CExpression leftSide = this.getLeftAssumptionFromLhs(subValueLiteral.getSubExpression());
            CExpression rightSide = subValueLiteral.getValueLiteralAsCExpression();
            AExpressionStatement statement = this.buildEquationExpressionStatement(expressionBuilder, leftSide, rightSide);
            statements.add(statement);
        }
        return FluentIterable.from(statements).filter(Predicates.notNull()).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable AExpressionStatement buildEquationExpressionStatement(CBinaryExpressionBuilder pBuilder, CExpression pLeftSide, CExpression pRightSide) {
        boolean rightIsAccepted;
        CExpression leftSide = pLeftSide;
        CExpression rightSide = pRightSide;
        CType leftType = leftSide.getExpressionType().getCanonicalType();
        CType rightType = rightSide.getExpressionType().getCanonicalType();
        if (leftType instanceof CVoidType && rightType instanceof CVoidType) {
            return null;
        }
        boolean equalTypes = leftType.equals(rightType);
        FluentIterable acceptedTypes = FluentIterable.from(Collections.singleton(CSimpleType.class));
        acceptedTypes = acceptedTypes.append(Arrays.asList(CArrayType.class, CPointerType.class));
        boolean leftIsAccepted = equalTypes || acceptedTypes.anyMatch(acceptedTypeClass -> acceptedTypeClass.isAssignableFrom(leftType.getClass()));
        boolean bl = rightIsAccepted = equalTypes || acceptedTypes.anyMatch(acceptedTypeClass -> acceptedTypeClass.isAssignableFrom(rightType.getClass()));
        if (leftType instanceof CSimpleType && !rightIsAccepted) {
            if (rightType instanceof CVoidType) {
                if (!(rightSide instanceof CPointerExpression)) return null;
                rightSide = this.castDereferencedPointerType((CPointerExpression)rightSide, leftType);
            } else {
                rightSide = new CCastExpression(rightSide.getFileLocation(), leftType, rightSide);
            }
        } else if (!leftIsAccepted && rightType instanceof CSimpleType) {
            if (leftType instanceof CVoidType) {
                if (!(leftSide instanceof CPointerExpression)) return null;
                leftSide = this.castDereferencedPointerType((CPointerExpression)leftSide, rightType);
            } else {
                leftSide = new CCastExpression(leftSide.getFileLocation(), rightType, leftSide);
            }
        }
        CBinaryExpression assumption = pBuilder.buildBinaryExpressionUnchecked(leftSide, rightSide, CBinaryExpression.BinaryOperator.EQUALS);
        return new CExpressionStatement(assumption.getFileLocation(), assumption);
    }

    private CExpression castDereferencedPointerType(CPointerExpression pDereference, CType pTargetType) {
        CExpression inner = pDereference.getOperand();
        if (inner.getExpressionType().equals(pTargetType)) {
            return pDereference;
        }
        inner = new CCastExpression(pDereference.getFileLocation(), new CPointerType(false, false, pTargetType), inner);
        return new CPointerExpression(pDereference.getFileLocation(), pTargetType, inner);
    }

    private CExpression getLeftAssumptionFromLhs(CLeftHandSide pLValue) {
        CType type = pLValue.getExpressionType().getCanonicalType();
        if (this.isStructOrUnionType(type) || type instanceof CArrayType) {
            if (pLValue instanceof CPointerExpression) {
                return ((CPointerExpression)pLValue).getOperand();
            }
            CUnaryExpression unaryExpression = new CUnaryExpression(pLValue.getFileLocation(), new CPointerType(false, false, type), pLValue, CUnaryExpression.UnaryOperator.AMPER);
            return unaryExpression;
        }
        return pLValue;
    }

    private @Nullable Object getValueObject(CSimpleDeclaration pDcl, String pFunctionName, ConcreteState pConcreteState) {
        return new LModelValueVisitor(pFunctionName, pConcreteState).handleVariableDeclaration(pDcl);
    }

    private boolean isStructOrUnionType(CType rValueType) {
        if ((rValueType = rValueType.getCanonicalType()) instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    private @Nullable FieldReference getFieldReference(CFieldReference pIastFieldReference, String pFunctionName) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        CFieldReference reference = pIastFieldReference;
        fieldNameList.add(0, reference.getFieldName());
        while (reference.getFieldOwner() instanceof CFieldReference && !reference.isPointerDereference()) {
            reference = (CFieldReference)reference.getFieldOwner();
            fieldNameList.add(0, reference.getFieldName());
        }
        if (reference.getFieldOwner() instanceof CIdExpression) {
            CIdExpression idExpression = (CIdExpression)reference.getFieldOwner();
            if (ForwardingTransferRelation.isGlobal((AExpression)idExpression)) {
                return new FieldReference(idExpression.getName(), fieldNameList);
            }
            return new FieldReference(idExpression.getName(), pFunctionName, fieldNameList);
        }
        return null;
    }

    private static Optional<BigInteger> getFieldOffset(CType ownerType, String fieldName, MachineModel pMachineModel) {
        if (ownerType instanceof CElaboratedType) {
            CComplexType realType = ((CElaboratedType)ownerType).getRealType();
            if (realType == null) {
                return Optional.empty();
            }
            return AssumptionToEdgeAllocator.getFieldOffset(realType.getCanonicalType(), fieldName, pMachineModel);
        }
        if (ownerType instanceof CCompositeType) {
            BigInteger fieldOffsetInBits = pMachineModel.getFieldOffsetInBits((CCompositeType)ownerType, fieldName);
            return AssumptionToEdgeAllocator.bitsToByte(fieldOffsetInBits, pMachineModel);
        }
        if (ownerType instanceof CPointerType) {
            CType type = ((CPointerType)ownerType).getType().getCanonicalType();
            return AssumptionToEdgeAllocator.getFieldOffset(type, fieldName, pMachineModel);
        }
        throw new AssertionError();
    }

    private static Optional<BigInteger> bitsToByte(BigInteger bits, MachineModel pMachineModel) {
        BigInteger charSizeInBits = BigInteger.valueOf(pMachineModel.getSizeofCharInBits());
        BigInteger[] divAndRemainder = bits.divideAndRemainder(charSizeInBits);
        if (divAndRemainder[1].equals(BigInteger.ZERO)) {
            return Optional.of(divAndRemainder[0]);
        }
        return Optional.empty();
    }

    private static final class SubExpressionValueLiteral {
        private final ValueLiteral valueLiteral;
        private final CLeftHandSide subExpression;

        private SubExpressionValueLiteral(ValueLiteral pValueLiteral, CLeftHandSide pSubExpression) {
            this.valueLiteral = pValueLiteral;
            this.subExpression = pSubExpression;
        }

        public CExpression getValueLiteralAsCExpression() {
            return this.valueLiteral.getValueLiteral();
        }

        public CLeftHandSide getSubExpression() {
            return this.subExpression;
        }
    }

    private static final class CastedExplicitValueLiteral
    extends ExplicitValueLiteral {
        private final CCastExpression castExpression;

        CastedExplicitValueLiteral(CLiteralExpression pValueLiteral, CCastExpression exp) {
            super(pValueLiteral);
            this.castExpression = exp;
        }

        @Override
        public CExpression getValueLiteral() {
            return this.castExpression;
        }
    }

    private static class ExplicitValueLiteral
    implements ValueLiteral {
        private final CLiteralExpression explicitValueLiteral;

        protected ExplicitValueLiteral(CLiteralExpression pValueLiteral) {
            this.explicitValueLiteral = pValueLiteral;
        }

        public static ValueLiteral valueOf(Address address, MachineModel pMachineModel) {
            if (address.isUnknown() || address.isSymbolic()) {
                return UnknownValueLiteral.getInstance();
            }
            BigInteger value = address.getAddressValue();
            CSimpleType type = CNumericTypes.LONG_LONG_INT;
            BigInteger upperInclusiveBound = pMachineModel.getMaximalIntegerValue(type);
            if (upperInclusiveBound.compareTo(value) < 0) {
                type = CNumericTypes.UNSIGNED_LONG_LONG_INT;
            }
            CIntegerLiteralExpression lit = new CIntegerLiteralExpression(FileLocation.DUMMY, type, value);
            return new ExplicitValueLiteral(lit);
        }

        @Override
        public ValueLiteral addCast(CSimpleType pType) {
            CExpression castedValue = this.getValueLiteral();
            CCastExpression castExpression = new CCastExpression(castedValue.getFileLocation(), pType, castedValue);
            return new CastedExplicitValueLiteral(this.explicitValueLiteral, castExpression);
        }

        public static ValueLiteral valueOf(BigInteger value, CSimpleType pType) {
            CIntegerLiteralExpression literal = new CIntegerLiteralExpression(FileLocation.DUMMY, pType, value);
            return new ExplicitValueLiteral(literal);
        }

        public static ValueLiteral valueOf(BigDecimal value, CSimpleType pType) {
            CFloatLiteralExpression literal = new CFloatLiteralExpression(FileLocation.DUMMY, pType, value);
            return new ExplicitValueLiteral(literal);
        }

        @Override
        public CExpression getValueLiteral() {
            return this.explicitValueLiteral;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        public String toString() {
            return this.explicitValueLiteral.toASTString();
        }
    }

    private static class UnknownValueLiteral
    implements ValueLiteral {
        private static final UnknownValueLiteral instance = new UnknownValueLiteral();

        private UnknownValueLiteral() {
        }

        public static UnknownValueLiteral getInstance() {
            return instance;
        }

        @Override
        public CLiteralExpression getValueLiteral() {
            throw new UnsupportedOperationException("Can't get the value code of an unknown value");
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public ValueLiteral addCast(CSimpleType pType) {
            throw new UnsupportedOperationException("Can't get the value code of an unknown value");
        }

        public String toString() {
            return "UNKNOWN";
        }
    }

    private static interface ValueLiteral {
        public CExpression getValueLiteral();

        public boolean isUnknown();

        public ValueLiteral addCast(CSimpleType var1);
    }

    private static final class ValueLiterals {
        private final List<SubExpressionValueLiteral> subExpressionValueLiterals = new ArrayList<SubExpressionValueLiteral>();
        private final ValueLiteral expressionValueLiteral;

        public ValueLiterals() {
            this.expressionValueLiteral = UnknownValueLiteral.getInstance();
        }

        public ValueLiterals(ValueLiteral valueLiteral) {
            this.expressionValueLiteral = valueLiteral;
        }

        public CExpression getExpressionValueLiteralAsCExpression() {
            return this.expressionValueLiteral.getValueLiteral();
        }

        public void addSubExpressionValueLiteral(SubExpressionValueLiteral code) {
            this.subExpressionValueLiterals.add(code);
        }

        public boolean hasUnknownValueLiteral() {
            return this.expressionValueLiteral.isUnknown();
        }

        public Set<SubExpressionValueLiteral> getSubExpressionValueLiteral() {
            return ImmutableSet.copyOf(this.subExpressionValueLiterals);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ValueLiteral : ");
            result.append(this.expressionValueLiteral.toString());
            result.append(", SubValueLiterals : ");
            result.append(Joiner.on((String)", ").join(this.subExpressionValueLiterals));
            return result.toString();
        }
    }

    private class ValueLiteralsVisitor
    extends DefaultCTypeVisitor<ValueLiterals, NoException> {
        private final Object value;
        private final CExpression exp;
        private final ConcreteState concreteState;

        public ValueLiteralsVisitor(Object pValue, CExpression pExp, ConcreteState pConcreteState) {
            this.value = pValue;
            this.exp = pExp;
            this.concreteState = pConcreteState;
        }

        @Override
        public ValueLiterals visitDefault(CType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CPointerType pointerType) {
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address, AssumptionToEdgeAllocator.this.machineModel);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            pointerType.accept(new ValueLiteralVisitor(address, valueLiterals, this.exp));
            return valueLiterals;
        }

        @Override
        public ValueLiterals visit(CArrayType arrayType) {
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address, AssumptionToEdgeAllocator.this.machineModel);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            arrayType.accept(new ValueLiteralVisitor(address, valueLiterals, this.exp));
            return valueLiterals;
        }

        @Override
        public ValueLiterals visit(CElaboratedType pT) {
            CComplexType realType = pT.getRealType();
            if (realType != null) {
                return realType.accept(this);
            }
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CEnumType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CFunctionType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CSimpleType simpleType) {
            return new ValueLiterals(this.getValueLiteral(simpleType, this.value));
        }

        @Override
        public ValueLiterals visit(CBitFieldType pCBitFieldType) {
            return pCBitFieldType.getType().accept(this);
        }

        @Override
        public ValueLiterals visit(CProblemType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CTypedefType pT) {
            return pT.getRealType().accept(this);
        }

        @Override
        public ValueLiterals visit(CCompositeType compType) {
            if (compType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return this.createUnknownValueLiterals();
            }
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address, AssumptionToEdgeAllocator.this.machineModel);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            compType.accept(new ValueLiteralVisitor(address, valueLiterals, this.exp));
            return valueLiterals;
        }

        protected ValueLiteral getValueLiteral(CSimpleType pSimpleType, Object pValue) {
            CSimpleType simpleType = pSimpleType.getCanonicalType();
            CBasicType basicType = simpleType.getType();
            switch (basicType) {
                case BOOL: 
                case CHAR: 
                case INT: {
                    return this.handleIntegerNumbers(pValue, simpleType);
                }
                case FLOAT: 
                case DOUBLE: {
                    if (AssumptionToEdgeAllocator.this.assumeLinearArithmetics) break;
                    return this.handleFloatingPointNumbers(pValue, simpleType);
                }
            }
            return UnknownValueLiteral.getInstance();
        }

        private ValueLiterals createUnknownValueLiterals() {
            return new ValueLiterals();
        }

        private ValueLiteral handleFloatingPointNumbers(Object pValue, CSimpleType pType) {
            BigDecimal val;
            if (pValue instanceof Rational) {
                double val2 = ((Rational)pValue).doubleValue();
                if (Double.isInfinite(val2) || Double.isNaN(val2)) {
                    return UnknownValueLiteral.getInstance();
                }
                return ExplicitValueLiteral.valueOf(new BigDecimal(val2), pType);
            }
            if (pValue instanceof Double) {
                double doubleValue = (Double)pValue;
                if (Double.isInfinite(doubleValue) || Double.isNaN(doubleValue)) {
                    return UnknownValueLiteral.getInstance();
                }
                return ExplicitValueLiteral.valueOf(BigDecimal.valueOf(doubleValue), pType);
            }
            if (pValue instanceof Float) {
                float floatValue = ((Float)pValue).floatValue();
                if (Float.isInfinite(floatValue) || Double.isNaN(floatValue)) {
                    return UnknownValueLiteral.getInstance();
                }
                return ExplicitValueLiteral.valueOf(BigDecimal.valueOf(floatValue), pType);
            }
            try {
                val = new BigDecimal(pValue.toString());
            }
            catch (NumberFormatException e) {
                AssumptionToEdgeAllocator.this.logger.log(Level.INFO, new Object[]{"Can't parse " + this.value + " as value for the counter-example path."});
                return UnknownValueLiteral.getInstance();
            }
            return ExplicitValueLiteral.valueOf(val, pType);
        }

        public void resolveStruct(CType type, ValueLiterals pValueLiterals, CIdExpression pOwner, String pFunctionName) {
            ValueLiteralStructResolver v = new ValueLiteralStructResolver(pValueLiterals, pFunctionName, pOwner);
            type.accept(v);
        }

        private ValueLiteral handleIntegerNumbers(Object pValue, CSimpleType pType) {
            String valueStr = pValue.toString();
            if (valueStr.matches("((-)?)\\d*")) {
                BigInteger integerValue = new BigInteger(valueStr);
                return this.handlePotentialIntegerOverflow(integerValue, pType);
            }
            List numberParts = Splitter.on((char)'.').splitToList((CharSequence)valueStr);
            if (numberParts.size() == 2 && ((String)numberParts.get(1)).matches("0*") && ((String)numberParts.get(0)).matches("((-)?)\\d*")) {
                BigInteger integerValue = new BigInteger((String)numberParts.get(0));
                return this.handlePotentialIntegerOverflow(integerValue, pType);
            }
            ValueLiteral valueLiteral = this.handleFloatingPointNumbers(pValue, pType);
            return valueLiteral.isUnknown() ? valueLiteral : valueLiteral.addCast(pType);
        }

        private ValueLiteral handlePotentialIntegerOverflow(BigInteger pIntegerValue, CSimpleType pType) {
            BigInteger lowerInclusiveBound = AssumptionToEdgeAllocator.this.machineModel.getMinimalIntegerValue(pType);
            BigInteger upperInclusiveBound = AssumptionToEdgeAllocator.this.machineModel.getMaximalIntegerValue(pType);
            assert (lowerInclusiveBound.compareTo(upperInclusiveBound) < 0);
            if (pIntegerValue.compareTo(lowerInclusiveBound) < 0 || pIntegerValue.compareTo(upperInclusiveBound) > 0) {
                if (AssumptionToEdgeAllocator.this.assumeLinearArithmetics) {
                    return UnknownValueLiteral.getInstance();
                }
                LogManagerWithoutDuplicates logManager = AssumptionToEdgeAllocator.this.logger instanceof LogManagerWithoutDuplicates ? (LogManagerWithoutDuplicates)AssumptionToEdgeAllocator.this.logger : new LogManagerWithoutDuplicates(AssumptionToEdgeAllocator.this.logger);
                Value castValue = AbstractExpressionValueVisitor.castCValue(new NumericValue(pIntegerValue), pType, AssumptionToEdgeAllocator.this.machineModel, logManager, FileLocation.DUMMY);
                if (castValue.isUnknown()) {
                    return UnknownValueLiteral.getInstance();
                }
                Number number = castValue.asNumericValue().getNumber();
                BigInteger valueAsBigInt = number instanceof BigInteger ? (BigInteger)number : BigInteger.valueOf(number.longValue());
                return ExplicitValueLiteral.valueOf(valueAsBigInt, pType);
            }
            return ExplicitValueLiteral.valueOf(pIntegerValue, pType);
        }

        private class ValueLiteralStructResolver
        extends DefaultCTypeVisitor<Void, NoException> {
            private final ValueLiterals valueLiterals;
            private final String functionName;
            private final CExpression prevSub;

            public ValueLiteralStructResolver(ValueLiterals pValueLiterals, String pFunctionName, CFieldReference pPrevSub) {
                this.valueLiterals = pValueLiterals;
                this.functionName = pFunctionName;
                this.prevSub = pPrevSub;
            }

            public ValueLiteralStructResolver(ValueLiterals pValueLiterals, String pFunctionName, CIdExpression pOwner) {
                this.valueLiterals = pValueLiterals;
                this.functionName = pFunctionName;
                this.prevSub = pOwner;
            }

            @Override
            public @Nullable Void visitDefault(CType pT) {
                return null;
            }

            @Override
            public @Nullable Void visit(CElaboratedType type) {
                CComplexType realType = type.getRealType();
                return realType == null ? null : realType.getCanonicalType().accept(this);
            }

            @Override
            public @Nullable Void visit(CTypedefType pType) {
                return pType.getRealType().accept(this);
            }

            @Override
            public @Nullable Void visit(CBitFieldType pCBitFieldType) {
                return pCBitFieldType.getType().accept(this);
            }

            @Override
            public @Nullable Void visit(CCompositeType compType) {
                if (compType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                    return null;
                }
                for (CCompositeType.CCompositeTypeMemberDeclaration memberType : compType.getMembers()) {
                    this.handleField(memberType.getName(), memberType.getType());
                }
                return null;
            }

            private void handleField(String pFieldName, CType pMemberType) {
                CFieldReference reference = new CFieldReference(this.prevSub.getFileLocation(), pMemberType, pFieldName, this.prevSub, false);
                FieldReference fieldReferenceName = AssumptionToEdgeAllocator.this.getFieldReference(reference, this.functionName);
                if (ValueLiteralsVisitor.this.concreteState.hasValueForLeftHandSide(fieldReferenceName)) {
                    Object referenceValue = ValueLiteralsVisitor.this.concreteState.getVariableValue(fieldReferenceName);
                    this.addStructSubexpression(referenceValue, reference);
                }
                ValueLiteralStructResolver resolver = new ValueLiteralStructResolver(this.valueLiterals, this.functionName, reference);
                pMemberType.accept(resolver);
            }

            private void addStructSubexpression(Object pFieldValue, CFieldReference reference) {
                ValueLiteral valueLiteral;
                CType realType = reference.getExpressionType();
                if (realType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)realType, pFieldValue);
                } else {
                    Address valueAddress = Address.valueOf(pFieldValue);
                    if (valueAddress.isUnknown()) {
                        return;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress, AssumptionToEdgeAllocator.this.machineModel);
                }
                if (valueLiteral.isUnknown()) {
                    return;
                }
                SubExpressionValueLiteral subExpression = new SubExpressionValueLiteral(valueLiteral, reference);
                this.valueLiterals.addSubExpressionValueLiteral(subExpression);
            }
        }

        private class ValueLiteralVisitor
        extends DefaultCTypeVisitor<Void, NoException> {
            private final Set<Pair<CType, Address>> visited;
            private final Address address;
            private final ValueLiterals valueLiterals;
            private final CExpression subExpression;

            public ValueLiteralVisitor(Address pAddress, ValueLiterals pValueLiterals, CExpression pSubExp) {
                this.address = pAddress;
                this.valueLiterals = pValueLiterals;
                this.visited = new HashSet<Pair<CType, Address>>();
                this.subExpression = pSubExp;
            }

            private ValueLiteralVisitor(Address pAddress, ValueLiterals pValueLiterals, CExpression pSubExp, Set<Pair<CType, Address>> pVisited) {
                this.address = pAddress;
                this.valueLiterals = pValueLiterals;
                this.visited = pVisited;
                this.subExpression = pSubExp;
            }

            @Override
            public @Nullable Void visitDefault(CType pT) {
                return null;
            }

            @Override
            public @Nullable Void visit(CTypedefType pT) {
                return pT.getRealType().accept(this);
            }

            @Override
            public @Nullable Void visit(CElaboratedType pT) {
                CComplexType realType = pT.getRealType();
                return realType == null ? null : realType.getCanonicalType().accept(this);
            }

            @Override
            public @Nullable Void visit(CEnumType pT) {
                return null;
            }

            @Override
            public @Nullable Void visit(CBitFieldType pCBitFieldType) {
                return pCBitFieldType.getType().accept(this);
            }

            @Override
            public @Nullable Void visit(CCompositeType compType) {
                if (compType.getKind() == CComplexType.ComplexTypeKind.STRUCT) {
                    this.handleStruct(compType);
                }
                return null;
            }

            private void handleStruct(CCompositeType pCompType) {
                Address fieldAddress = this.address;
                if (!fieldAddress.isConcrete()) {
                    return;
                }
                Map<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> bitOffsets = AssumptionToEdgeAllocator.this.machineModel.getAllFieldOffsetsInBits(pCompType);
                for (Map.Entry<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> memberBitOffset : bitOffsets.entrySet()) {
                    CCompositeType.CCompositeTypeMemberDeclaration memberType = memberBitOffset.getKey();
                    Optional<BigInteger> memberOffset = AssumptionToEdgeAllocator.bitsToByte(memberBitOffset.getValue(), AssumptionToEdgeAllocator.this.machineModel);
                    if (!memberOffset.isPresent()) continue;
                    this.handleMemberField(memberType, this.address.addOffset(memberOffset.orElseThrow()));
                }
            }

            private void handleMemberField(CCompositeType.CCompositeTypeMemberDeclaration pType, Address fieldAddress) {
                ValueLiteral valueLiteral;
                boolean isPointerDeref;
                CExpression subExp;
                CType expectedType = pType.getType().getCanonicalType();
                assert (AssumptionToEdgeAllocator.this.isStructOrUnionType(this.subExpression.getExpressionType().getCanonicalType()));
                if (this.subExpression instanceof CPointerExpression) {
                    subExp = ((CPointerExpression)this.subExpression).getOperand();
                    isPointerDeref = true;
                } else {
                    subExp = this.subExpression;
                    isPointerDeref = false;
                }
                CFieldReference fieldReference = new CFieldReference(subExp.getFileLocation(), expectedType, pType.getName(), subExp, isPointerDeref);
                Object fieldValue = expectedType instanceof CArrayType || AssumptionToEdgeAllocator.this.isStructOrUnionType(expectedType) ? fieldAddress : ValueLiteralsVisitor.this.concreteState.getValueFromMemory(fieldReference, fieldAddress);
                if (fieldValue == null) {
                    return;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (expectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)expectedType, fieldValue);
                } else {
                    valueAddress = Address.valueOf(fieldValue);
                    if (valueAddress.isUnknown()) {
                        return;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress, AssumptionToEdgeAllocator.this.machineModel);
                }
                Pair<CType, Address> visits = Pair.of(expectedType, fieldAddress);
                if (this.visited.contains(visits)) {
                    return;
                }
                if (!valueLiteral.isUnknown()) {
                    this.visited.add(visits);
                    this.valueLiterals.addSubExpressionValueLiteral(new SubExpressionValueLiteral(valueLiteral, fieldReference));
                }
                if (valueAddress != null) {
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, fieldReference, this.visited);
                    expectedType.accept(v);
                }
            }

            @Override
            public @Nullable Void visit(CArrayType arrayType) {
                CType expectedType = arrayType.getType().getCanonicalType();
                int subscript = 0;
                boolean memoryHasValue = true;
                while (memoryHasValue) {
                    memoryHasValue = this.handleArraySubscript(this.address, subscript, expectedType, arrayType);
                    ++subscript;
                }
                return null;
            }

            private boolean handleArraySubscript(Address pArrayAddress, int pSubscript, CType pExpectedType, CArrayType pArrayType) {
                ValueLiteral valueLiteral;
                if (!pArrayAddress.isConcrete()) {
                    return false;
                }
                BigInteger typeSize = AssumptionToEdgeAllocator.this.machineModel.getSizeof(pExpectedType);
                BigInteger subscriptOffset = BigInteger.valueOf(pSubscript).multiply(typeSize);
                if (!pArrayType.isIncomplete() && AssumptionToEdgeAllocator.this.machineModel.getSizeof(pArrayType).compareTo(subscriptOffset) <= 0) {
                    return false;
                }
                if (pArrayType.getLength() == null) {
                    return false;
                }
                Address arrayAddressWithOffset = pArrayAddress.addOffset(subscriptOffset);
                BigInteger subscript = BigInteger.valueOf(pSubscript);
                CIntegerLiteralExpression litExp = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, subscript);
                CArraySubscriptExpression arraySubscript = new CArraySubscriptExpression(this.subExpression.getFileLocation(), pExpectedType, this.subExpression, litExp);
                Object concreteValue = AssumptionToEdgeAllocator.this.isStructOrUnionType(pExpectedType) || pExpectedType instanceof CArrayType ? arrayAddressWithOffset : ValueLiteralsVisitor.this.concreteState.getValueFromMemory(arraySubscript, arrayAddressWithOffset);
                if (concreteValue == null) {
                    return false;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (pExpectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)pExpectedType, concreteValue);
                } else {
                    valueAddress = Address.valueOf(concreteValue);
                    if (valueAddress.isUnknown()) {
                        return false;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress, AssumptionToEdgeAllocator.this.machineModel);
                }
                if (!valueLiteral.isUnknown()) {
                    SubExpressionValueLiteral subExpressionValueLiteral = new SubExpressionValueLiteral(valueLiteral, arraySubscript);
                    this.valueLiterals.addSubExpressionValueLiteral(subExpressionValueLiteral);
                }
                if (!valueAddress.isUnknown()) {
                    Pair<CType, Address> visits = Pair.of(pExpectedType, valueAddress);
                    if (this.visited.contains(visits)) {
                        return false;
                    }
                    this.visited.add(visits);
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, arraySubscript, this.visited);
                    pExpectedType.accept(v);
                }
                return true;
            }

            @Override
            public @Nullable Void visit(CPointerType pointerType) {
                ValueLiteral valueLiteral;
                CType expectedType = pointerType.getType().getCanonicalType();
                CPointerExpression pointerExp = new CPointerExpression(this.subExpression.getFileLocation(), expectedType, this.subExpression);
                Object concreteValue = AssumptionToEdgeAllocator.this.isStructOrUnionType(expectedType) || expectedType instanceof CArrayType ? this.address : ValueLiteralsVisitor.this.concreteState.getValueFromMemory(pointerExp, this.address);
                if (concreteValue == null) {
                    return null;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (expectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)expectedType, concreteValue);
                } else {
                    valueAddress = Address.valueOf(concreteValue);
                    if (valueAddress.isUnknown()) {
                        return null;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress, AssumptionToEdgeAllocator.this.machineModel);
                }
                if (!valueLiteral.isUnknown()) {
                    SubExpressionValueLiteral subExpressionValueLiteral = new SubExpressionValueLiteral(valueLiteral, pointerExp);
                    this.valueLiterals.addSubExpressionValueLiteral(subExpressionValueLiteral);
                }
                if (!valueAddress.isUnknown()) {
                    Pair<CType, Address> visits = Pair.of(expectedType, valueAddress);
                    if (this.visited.contains(visits)) {
                        return null;
                    }
                    this.visited.add(visits);
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, pointerExp, this.visited);
                    expectedType.accept(v);
                }
                return null;
            }
        }
    }

    private class LModelValueVisitor
    implements CLeftHandSideVisitor<Object, NoException> {
        private final String functionName;
        private final AddressValueVisitor addressVisitor;
        private final ConcreteState concreteState;

        public LModelValueVisitor(String pFunctionName, ConcreteState pConcreteState) {
            this.functionName = pFunctionName;
            this.addressVisitor = new AddressValueVisitor(this);
            this.concreteState = pConcreteState;
        }

        private Address getAddress(CSimpleDeclaration dcl) {
            return this.addressVisitor.getAddress(dcl);
        }

        private @Nullable Number evaluateNumericalValue(CExpression exp) {
            Value addressV;
            try {
                ModelExpressionValueVisitor v = new ModelExpressionValueVisitor(this.functionName, AssumptionToEdgeAllocator.this.machineModel, new LogManagerWithoutDuplicates(AssumptionToEdgeAllocator.this.logger));
                addressV = exp.accept(v);
            }
            catch (ArithmeticException e) {
                AssumptionToEdgeAllocator.this.logger.logDebugException((Throwable)e);
                AssumptionToEdgeAllocator.this.logger.log(Level.WARNING, new Object[]{"The expression " + exp.toASTString() + "could not be correctly evaluated while calculating the concrete values in the counterexample path."});
                return null;
            }
            catch (UnrecognizedCodeException e1) {
                throw new IllegalArgumentException(e1);
            }
            if (addressV.isUnknown() && !addressV.isNumericValue()) {
                return null;
            }
            return addressV.asNumericValue().getNumber();
        }

        private Address evaluateNumericalValueAsAddress(CExpression exp) {
            Number result = this.evaluateNumericalValue(exp);
            return result == null ? Address.getUnknownAddress() : Address.valueOf(result);
        }

        private Address evaluateAddress(CLeftHandSide pExp) {
            return pExp.accept(this.addressVisitor);
        }

        @Override
        public @Nullable Object visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            Address valueAddress = this.evaluateAddress(pIastArraySubscriptExpression);
            if (valueAddress.isUnknown()) {
                return null;
            }
            CType type = pIastArraySubscriptExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (valueAddress.isSymbolic()) {
                    return null;
                }
                return valueAddress.getAddressValue();
            }
            return this.concreteState.getValueFromMemory(pIastArraySubscriptExpression, valueAddress);
        }

        @Override
        public @Nullable Object visit(CFieldReference pIastFieldReference) {
            Address address = this.evaluateAddress(pIastFieldReference);
            if (address.isUnknown()) {
                return this.lookupReference(pIastFieldReference);
            }
            CType type = pIastFieldReference.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return null;
                }
                return address.getAddressValue();
            }
            @Nullable Object value = this.concreteState.getValueFromMemory(pIastFieldReference, address);
            if (value == null) {
                return this.lookupReference(pIastFieldReference);
            }
            return value;
        }

        private @Nullable Object lookupReference(CFieldReference pIastFieldReference) {
            FieldReference fieldReference = AssumptionToEdgeAllocator.this.getFieldReference(pIastFieldReference, this.functionName);
            if (fieldReference != null && this.concreteState.hasValueForLeftHandSide(fieldReference)) {
                return this.concreteState.getVariableValue(fieldReference);
            }
            return null;
        }

        private @Nullable Optional<BigInteger> getFieldOffset(CFieldReference fieldReference) {
            CType fieldOwnerType = fieldReference.getFieldOwner().getExpressionType().getCanonicalType();
            return AssumptionToEdgeAllocator.getFieldOffset(fieldOwnerType, fieldReference.getFieldName(), AssumptionToEdgeAllocator.this.machineModel);
        }

        @Override
        public Object visit(CIdExpression pCIdExpression) {
            CSimpleDeclaration dcl = pCIdExpression.getDeclaration();
            Address address = this.evaluateAddress(pCIdExpression);
            if (address.isUnknown()) {
                return this.lookupVariable(dcl);
            }
            CType type = pCIdExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return this.lookupVariable(dcl);
                }
                return address.getAddressValue();
            }
            @Nullable Object value = this.concreteState.getValueFromMemory(pCIdExpression, address);
            if (value == null) {
                return this.lookupVariable(dcl);
            }
            return value;
        }

        private @Nullable Object handleVariableDeclaration(CSimpleDeclaration pDcl) {
            if (pDcl instanceof CFunctionDeclaration || pDcl instanceof CTypeDeclaration) {
                return null;
            }
            CIdExpression representingIdExpression = new CIdExpression(pDcl.getFileLocation(), pDcl);
            return this.visit(representingIdExpression);
        }

        private @Nullable Object lookupVariable(CSimpleDeclaration pVarDcl) {
            IDExpression varName = this.getIDExpression(pVarDcl);
            if (this.concreteState.hasValueForLeftHandSide(varName)) {
                return this.concreteState.getVariableValue(varName);
            }
            return null;
        }

        private IDExpression getIDExpression(CSimpleDeclaration pDcl) {
            String name = pDcl.getName();
            if (pDcl instanceof CDeclaration && ((CDeclaration)pDcl).isGlobal()) {
                return new IDExpression(name);
            }
            return new IDExpression(name, this.functionName);
        }

        @Override
        public @Nullable Object visit(CPointerExpression pPointerExpression) {
            Address address = this.evaluateAddress(pPointerExpression);
            if (address.isUnknown()) {
                return null;
            }
            CType type = pPointerExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return null;
                }
                return address.getAddressValue();
            }
            return this.concreteState.getValueFromMemory(pPointerExpression, address);
        }

        boolean isStructOrUnionType(CType rValueType) {
            if ((rValueType = rValueType.getCanonicalType()) instanceof CElaboratedType) {
                CElaboratedType type = (CElaboratedType)rValueType;
                return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
            }
            if (rValueType instanceof CCompositeType) {
                CCompositeType type = (CCompositeType)rValueType;
                return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
            }
            return false;
        }

        @Override
        public Object visit(CComplexCastExpression pComplexCastExpression) {
            return null;
        }

        private class ModelExpressionValueVisitor
        extends AbstractExpressionValueVisitor {
            public ModelExpressionValueVisitor(String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
                super(pFunctionName, pMachineModel, pLogger);
            }

            @Override
            public Value visit(CCastExpression cast) throws UnrecognizedCodeException {
                if (LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().shouldEvaluateExpressionWithThisEvaluator(cast)) {
                    Value op = cast.getOperand().accept(this);
                    if (op.isUnknown()) {
                        return op;
                    }
                    return LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().evaluate(cast, op);
                }
                return super.visit(cast);
            }

            @Override
            public Value visit(CBinaryExpression binaryExp) throws UnrecognizedCodeException {
                if (LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().shouldEvaluateExpressionWithThisEvaluator(binaryExp)) {
                    Value op1 = binaryExp.getOperand1().accept(this);
                    if (op1.isUnknown()) {
                        return op1;
                    }
                    Value op2 = binaryExp.getOperand2().accept(this);
                    if (op2.isUnknown()) {
                        return op2;
                    }
                    return LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().evaluate(binaryExp, op1, op2);
                }
                CExpression lVarInBinaryExp = binaryExp.getOperand1();
                CExpression rVarInBinaryExp = binaryExp.getOperand2();
                CType lVarInBinaryExpType = lVarInBinaryExp.getExpressionType().getCanonicalType();
                CType rVarInBinaryExpType = rVarInBinaryExp.getExpressionType().getCanonicalType();
                boolean lVarIsAddress = lVarInBinaryExpType instanceof CPointerType || lVarInBinaryExpType instanceof CArrayType;
                boolean rVarIsAddress = rVarInBinaryExpType instanceof CPointerType || rVarInBinaryExpType instanceof CArrayType;
                CExpression address = null;
                CExpression pointerOffset = null;
                CType addressType = null;
                if (lVarIsAddress && rVarIsAddress) {
                    return Value.UnknownValue.getInstance();
                }
                if (lVarIsAddress) {
                    address = lVarInBinaryExp;
                    pointerOffset = rVarInBinaryExp;
                    addressType = lVarInBinaryExpType;
                } else if (rVarIsAddress) {
                    address = rVarInBinaryExp;
                    pointerOffset = lVarInBinaryExp;
                    addressType = rVarInBinaryExpType;
                } else {
                    if (AssumptionToEdgeAllocator.this.assumeLinearArithmetics) {
                        switch (binaryExp.getOperator()) {
                            case MULTIPLY: {
                                if (AssumptionToEdgeAllocator.this.allowMultiplicationWithConstants && (lVarInBinaryExp instanceof ALiteralExpression || rVarInBinaryExp instanceof ALiteralExpression)) {
                                    return super.visit(binaryExp);
                                }
                                return Value.UnknownValue.getInstance();
                            }
                            case DIVIDE: 
                            case MODULO: {
                                if (AssumptionToEdgeAllocator.this.allowDivisionAndModuloByConstants && rVarInBinaryExp instanceof ALiteralExpression) break;
                            }
                            case BINARY_AND: 
                            case BINARY_OR: 
                            case BINARY_XOR: 
                            case SHIFT_LEFT: 
                            case SHIFT_RIGHT: {
                                return Value.UnknownValue.getInstance();
                            }
                        }
                    }
                    return super.visit(binaryExp);
                }
                CBinaryExpression.BinaryOperator binaryOperator = binaryExp.getOperator();
                CType elementType = addressType instanceof CPointerType ? ((CPointerType)addressType).getType().getCanonicalType() : ((CArrayType)addressType).getType().getCanonicalType();
                switch (binaryOperator) {
                    case PLUS: 
                    case MINUS: {
                        Value addressValueV = address.accept(this);
                        Value offsetValueV = pointerOffset.accept(this);
                        if (addressValueV.isUnknown() || offsetValueV.isUnknown() || !addressValueV.isNumericValue() || !offsetValueV.isNumericValue()) {
                            return Value.UnknownValue.getInstance();
                        }
                        Number addressValueNumber = addressValueV.asNumericValue().getNumber();
                        BigDecimal addressValue = new BigDecimal(addressValueNumber.toString());
                        Number offsetValueNumber = offsetValueV.asNumericValue().getNumber();
                        BigDecimal offsetValue = new BigDecimal(offsetValueNumber.toString());
                        BigDecimal typeSize = new BigDecimal(AssumptionToEdgeAllocator.this.machineModel.getSizeof(elementType));
                        BigDecimal pointerOffsetValue = offsetValue.multiply(typeSize);
                        switch (binaryOperator) {
                            case PLUS: {
                                return new NumericValue(addressValue.add(pointerOffsetValue));
                            }
                            case MINUS: {
                                if (lVarIsAddress) {
                                    return new NumericValue(addressValue.subtract(pointerOffsetValue));
                                }
                                throw new UnrecognizedCodeException("Expected pointer arithmetic  with + or - but found " + binaryExp.toASTString(), binaryExp);
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return Value.UnknownValue.getInstance();
            }

            @Override
            public Value visit(CUnaryExpression pUnaryExpression) throws UnrecognizedCodeException {
                if (LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().shouldEvaluateExpressionWithThisEvaluator(pUnaryExpression)) {
                    Value operand = pUnaryExpression.getOperand().accept(this);
                    if (operand.isUnknown() && (pUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.MINUS || pUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.TILDE)) {
                        return operand;
                    }
                    return LModelValueVisitor.this.concreteState.getAnalysisConcreteExpressionEvaluation().evaluate(pUnaryExpression, operand);
                }
                if (pUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                    return this.handleAmper(pUnaryExpression.getOperand());
                }
                return super.visit(pUnaryExpression);
            }

            private Value handleAmper(CExpression pOperand) {
                if (pOperand instanceof CLeftHandSide) {
                    Address address = LModelValueVisitor.this.evaluateAddress((CLeftHandSide)pOperand);
                    if (address.isConcrete()) {
                        return new NumericValue(address.getAddressValue());
                    }
                } else if (pOperand instanceof CCastExpression) {
                    return this.handleAmper(((CCastExpression)pOperand).getOperand());
                }
                return Value.UnknownValue.getInstance();
            }

            @Override
            protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCodeException {
                Object value = LModelValueVisitor.this.visit(pCPointerExpression);
                if (!(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCodeException {
                Object value = LModelValueVisitor.this.visit(pCIdExpression);
                if (!(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateJIdExpression(JIdExpression pVarName) {
                return Value.UnknownValue.getInstance();
            }

            @Override
            protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCodeException {
                Object value = LModelValueVisitor.this.visit(pLValue);
                if (!(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCodeException {
                Object value = LModelValueVisitor.this.visit(pLValue);
                if (!(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            public Value visit(JClassLiteralExpression pJClassLiteralExpression) throws NoException {
                return Value.UnknownValue.getInstance();
            }
        }

        private class AddressValueVisitor
        implements CLeftHandSideVisitor<Address, NoException> {
            private final LModelValueVisitor valueVisitor;

            public AddressValueVisitor(LModelValueVisitor pValueVisitor) {
                this.valueVisitor = pValueVisitor;
            }

            public Address getAddress(CSimpleDeclaration dcl) {
                IDExpression name = LModelValueVisitor.this.getIDExpression(dcl);
                if (LModelValueVisitor.this.concreteState.hasAddressOfVariable(name)) {
                    return LModelValueVisitor.this.concreteState.getVariableAddress(name);
                }
                return Address.getUnknownAddress();
            }

            @Override
            public Address visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
                BigDecimal subscriptValue;
                CExpression arrayExpression = pIastArraySubscriptExpression.getArrayExpression();
                Address address = LModelValueVisitor.this.evaluateNumericalValueAsAddress(arrayExpression);
                if (address.isUnknown() || address.isSymbolic()) {
                    return Address.getUnknownAddress();
                }
                CExpression subscriptCExpression = pIastArraySubscriptExpression.getSubscriptExpression();
                Number subscriptValueNumber = LModelValueVisitor.this.evaluateNumericalValue(subscriptCExpression);
                if (subscriptValueNumber == null) {
                    return Address.getUnknownAddress();
                }
                if (subscriptValueNumber instanceof Rational) {
                    Rational rational = (Rational)subscriptValueNumber;
                    subscriptValue = new BigDecimal(rational.getNum()).divide(new BigDecimal(rational.getDen()));
                } else {
                    subscriptValue = new BigDecimal(subscriptValueNumber.toString());
                }
                BigDecimal typeSize = new BigDecimal(AssumptionToEdgeAllocator.this.machineModel.getSizeof(pIastArraySubscriptExpression.getExpressionType().getCanonicalType()));
                BigDecimal subscriptOffset = subscriptValue.multiply(typeSize);
                return address.addOffset(subscriptOffset);
            }

            @Override
            public Address visit(CFieldReference pIastFieldReference) {
                CExpression fieldOwner = pIastFieldReference.getFieldOwner();
                Address fieldOwnerAddress = LModelValueVisitor.this.evaluateNumericalValueAsAddress(fieldOwner);
                if (fieldOwnerAddress.isUnknown() || fieldOwnerAddress.isSymbolic()) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                Optional<BigInteger> fieldOffset = LModelValueVisitor.this.getFieldOffset(pIastFieldReference);
                if (!fieldOffset.isPresent()) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                Address address = fieldOwnerAddress.addOffset(fieldOffset.orElseThrow());
                if (address.isUnknown()) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                return address;
            }

            private Address lookupReferenceAddress(CFieldReference pIastFieldReference) {
                FieldReference fieldReferenceName = AssumptionToEdgeAllocator.this.getFieldReference(pIastFieldReference, LModelValueVisitor.this.functionName);
                if (fieldReferenceName != null && LModelValueVisitor.this.concreteState.hasAddressOfVariable(fieldReferenceName)) {
                    return LModelValueVisitor.this.concreteState.getVariableAddress(fieldReferenceName);
                }
                return Address.getUnknownAddress();
            }

            @Override
            public Address visit(CIdExpression pIastIdExpression) {
                return this.getAddress(pIastIdExpression.getDeclaration());
            }

            @Override
            public Address visit(CPointerExpression pPointerExpression) {
                return this.valueVisitor.evaluateNumericalValueAsAddress(pPointerExpression.getOperand());
            }

            @Override
            public Address visit(CComplexCastExpression pComplexCastExpression) {
                return Address.getUnknownAddress();
            }
        }
    }
}

