/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class AssumptionToEdgeAllocatorTest {
    private MachineModel machineModel;
    private LogManager logger;
    private CFA cfa;
    private ConcreteState empty;
    private ConcreteState symbolic;
    private ConcreteState full;
    private static final String MEMORYNAME = "Test_Heap";
    private MemoryName memoryName = pExp -> "Test_Heap";

    @Before
    public void setUp() throws Exception {
        this.cfa = TestDataTools.makeCFA("typedef struct dataNode {", "  int h;", "  int h2[3];", "  int *h3;", "} data;", "", "typedef struct node {", "  int h;", "  struct node *n;", "  data d;", "} List;", "", "typedef List *ListP;", "", "int x;", "", "int main() {", "  int a;", "  int* b;", "  int** c;", "  int  d[6];", "  int  e[2][3];", "  List list;", "  a = a;", "  *b = *b;", "  **c = **c;", "  d[1] = d[1];", "  *(d + 1) = *(d + 1);", "  e[1][2] = e[1][2];", "  list.h = list.h;", "  list.n = list.n;", "  list.d.h = list.d.h;", "  list.n->d.h2[0] = list.n->d.h2[0];", "  list.n->d.h3 = list.n->d.h3;", "}");
        this.machineModel = this.cfa.getMachineModel();
        this.logger = LogManager.createTestLogManager();
        this.empty = this.createEmptyState();
        this.full = this.createFullState();
        this.symbolic = this.createSymbolicState();
    }

    private ConcreteState createFullState() {
        HashMap<LeftHandSide, Object> variables = new HashMap<LeftHandSide, Object>();
        variables.put(this.makeVariable("x", ""), 0);
        HashMap<LeftHandSide, Address> variableAddressMap = new HashMap<LeftHandSide, Address>();
        variableAddressMap.put(this.makeVariable("a", "main"), this.makeConcreteAddress(20));
        variableAddressMap.put(this.makeVariable("b", "main"), this.makeConcreteAddress(24));
        variableAddressMap.put(this.makeVariable("c", "main"), this.makeConcreteAddress(28));
        variableAddressMap.put(this.makeVariable("d", "main"), this.makeConcreteAddress(32));
        variableAddressMap.put(this.makeVariable("e", "main"), this.makeConcreteAddress(56));
        variableAddressMap.put(this.makeVariable("list", "main"), this.makeConcreteAddress(80));
        HashMap<String, Memory> allocatedMemory = new HashMap<String, Memory>();
        HashMap<Address, Object> values = new HashMap<Address, Object>();
        values.put(this.makeConcreteAddress(20), 1);
        values.put(this.makeConcreteAddress(24), 20);
        values.put(this.makeConcreteAddress(28), 24);
        values.put(this.makeConcreteAddress(32), 21);
        values.put(this.makeConcreteAddress(36), 22);
        values.put(this.makeConcreteAddress(40), 23);
        values.put(this.makeConcreteAddress(44), 24);
        values.put(this.makeConcreteAddress(48), 25);
        values.put(this.makeConcreteAddress(52), 26);
        values.put(this.makeConcreteAddress(56), 21);
        values.put(this.makeConcreteAddress(60), 22);
        values.put(this.makeConcreteAddress(64), 23);
        values.put(this.makeConcreteAddress(68), 24);
        values.put(this.makeConcreteAddress(72), 25);
        values.put(this.makeConcreteAddress(76), 26);
        values.put(this.makeConcreteAddress(80), 31);
        values.put(this.makeConcreteAddress(84), 108);
        values.put(this.makeConcreteAddress(88), 32);
        values.put(this.makeConcreteAddress(92), 33);
        values.put(this.makeConcreteAddress(96), 34);
        values.put(this.makeConcreteAddress(100), 35);
        values.put(this.makeConcreteAddress(104), 32);
        values.put(this.makeConcreteAddress(108), 41);
        values.put(this.makeConcreteAddress(112), 80);
        values.put(this.makeConcreteAddress(116), 42);
        values.put(this.makeConcreteAddress(120), 43);
        values.put(this.makeConcreteAddress(124), 44);
        values.put(this.makeConcreteAddress(128), 45);
        values.put(this.makeConcreteAddress(132), 36);
        Memory memory = new Memory(MEMORYNAME, values);
        allocatedMemory.put(MEMORYNAME, memory);
        return new ConcreteState(variables, allocatedMemory, variableAddressMap, this.memoryName, this.machineModel);
    }

    private Address makeConcreteAddress(int pValue) {
        return Address.valueOf(pValue);
    }

    private Address makeSymbolicAddress(int pValue) {
        return Address.valueOf(Integer.toString(pValue));
    }

    private LeftHandSide makeVariable(String pName, String pFunction) {
        if (pFunction.isEmpty()) {
            return new IDExpression(pName);
        }
        return new IDExpression(pName, pFunction);
    }

    private ConcreteState createSymbolicState() {
        HashMap<LeftHandSide, Object> variables = new HashMap<LeftHandSide, Object>();
        variables.put(this.makeVariable("x", ""), 0);
        HashMap<LeftHandSide, Address> variableAddressMap = new HashMap<LeftHandSide, Address>();
        variableAddressMap.put(this.makeVariable("a", "main"), this.makeSymbolicAddress(20));
        variableAddressMap.put(this.makeVariable("b", "main"), this.makeSymbolicAddress(24));
        variableAddressMap.put(this.makeVariable("c", "main"), this.makeSymbolicAddress(28));
        variableAddressMap.put(this.makeVariable("d", "main"), this.makeSymbolicAddress(32));
        variableAddressMap.put(this.makeVariable("e", "main"), this.makeSymbolicAddress(56));
        variableAddressMap.put(this.makeVariable("list", "main"), this.makeSymbolicAddress(80));
        HashMap<String, Memory> allocatedMemory = new HashMap<String, Memory>();
        HashMap<Address, Object> values = new HashMap<Address, Object>();
        values.put(this.makeSymbolicAddress(20), 1);
        values.put(this.makeSymbolicAddress(24), "20");
        values.put(this.makeSymbolicAddress(28), "24");
        values.put(this.makeSymbolicAddress(32), 21);
        values.put(this.makeSymbolicAddress(36), 22);
        values.put(this.makeSymbolicAddress(40), 23);
        values.put(this.makeSymbolicAddress(44), 24);
        values.put(this.makeSymbolicAddress(48), 25);
        values.put(this.makeSymbolicAddress(52), 26);
        values.put(this.makeSymbolicAddress(56), 21);
        values.put(this.makeSymbolicAddress(60), 22);
        values.put(this.makeSymbolicAddress(64), 23);
        values.put(this.makeSymbolicAddress(68), 24);
        values.put(this.makeSymbolicAddress(72), 25);
        values.put(this.makeSymbolicAddress(76), 26);
        values.put(this.makeSymbolicAddress(80), 31);
        values.put(this.makeSymbolicAddress(84), "108");
        values.put(this.makeSymbolicAddress(88), 32);
        values.put(this.makeSymbolicAddress(92), 33);
        values.put(this.makeSymbolicAddress(96), 34);
        values.put(this.makeSymbolicAddress(100), 35);
        values.put(this.makeSymbolicAddress(104), "32");
        values.put(this.makeSymbolicAddress(108), 41);
        values.put(this.makeSymbolicAddress(112), "80");
        values.put(this.makeSymbolicAddress(116), 42);
        values.put(this.makeSymbolicAddress(120), 43);
        values.put(this.makeSymbolicAddress(124), 44);
        values.put(this.makeSymbolicAddress(128), 45);
        values.put(this.makeSymbolicAddress(132), "36");
        Memory memory = new Memory(MEMORYNAME, values);
        allocatedMemory.put(MEMORYNAME, memory);
        return new ConcreteState(variables, allocatedMemory, variableAddressMap, this.memoryName, this.machineModel);
    }

    private ConcreteState createEmptyState() {
        ImmutableMap pVariables = ImmutableMap.of();
        ImmutableMap pAllocatedMemory = ImmutableMap.of();
        ImmutableMap pVariableAddressMap = ImmutableMap.of();
        return new ConcreteState((Map<LeftHandSide, Object>)pVariables, (Map<String, Memory>)pAllocatedMemory, (Map<LeftHandSide, Address>)pVariableAddressMap, this.memoryName, this.machineModel);
    }

    @Test
    public void testAllocateAssignmentsToEdge() throws InvalidConfigurationException {
        for (CFANode node : this.cfa.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                this.testWithEdge(edge);
            }
        }
    }

    private void testWithEdge(CFAEdge pEdge) throws InvalidConfigurationException {
        Configuration testConfig = TestDataTools.configurationForTest().build();
        AssumptionToEdgeAllocator allocator = AssumptionToEdgeAllocator.create(testConfig, this.logger, this.machineModel);
        CFAEdgeWithAssumptions assignmentEdgeFull = allocator.allocateAssumptionsToEdge(pEdge, this.full);
        CFAEdgeWithAssumptions assignmentEdgeSymbolic = allocator.allocateAssumptionsToEdge(pEdge, this.symbolic);
        CFAEdgeWithAssumptions assignmentEdgeEmpty = allocator.allocateAssumptionsToEdge(pEdge, this.empty);
        Truth.assertThat(assignmentEdgeEmpty.getExpStmts()).isEmpty();
        switch (pEdge.getRawStatement()) {
            case "int x;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"x == (0);");
                Truth.assertThat((String)assignmentEdgeSymbolic.getAsCode()).contains((CharSequence)"x == (0);");
                break;
            }
            case "int a;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"a == (1);");
                Truth.assertThat((String)assignmentEdgeSymbolic.getAsCode()).contains((CharSequence)"a == (1);");
                break;
            }
            case "int* b;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(b)) == (1);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"b == (20LL);");
                Truth.assertThat((String)assignmentEdgeSymbolic.getAsCode()).contains((CharSequence)"(*(b)) == (1);");
                break;
            }
            case "int** c;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(*(c))) == (1);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(c)) == (20LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"c == (24LL);");
                Truth.assertThat((String)assignmentEdgeSymbolic.getAsCode()).contains((CharSequence)"(*(*(c))) == (1);");
                break;
            }
            case "int  d[6];": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(&d) == (32LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[0]) == (21);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[1]) == (22);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[2]) == (23);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[3]) == (24);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[4]) == (25);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[5]) == (26);");
                break;
            }
            case "int  e[2][3];": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(&e) == (56LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[0][0]) == (21);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[0][1]) == (22);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[0][2]) == (23);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[1][0]) == (24);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[1][1]) == (25);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[1][2]) == (26);");
                break;
            }
            case "List list;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(&list) == (80LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.h) == (31);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n) == (108LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->h) == (41);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->n) == (80LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->n->d.h) == (32);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->n->d.h2)[0]) == (33);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->n->d.h2)[1]) == (34);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->n->d.h2)[2]) == (35);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->n->d.h3) == (32LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(list.n->n->d.h3)) == (21);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->d.h) == (42);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->d.h2)[0]) == (43);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->d.h2)[1]) == (44);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->d.h2)[2]) == (45);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->d.h3) == (36LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(list.n->d.h3)) == (22);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(list.n->d.h3)) == (22);");
                break;
            }
            case "a = a;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"a == (1);");
                break;
            }
            case "*b = *b;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(b)) == (1);");
                break;
            }
            case "**c = **c;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(*(c))) == (1);");
                break;
            }
            case "d[1] = d[1];": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(d[1]) == (22);");
                break;
            }
            case "*(d + 1) = *(d + 1);": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(d + (1))) == (22);");
                break;
            }
            case "e[1][2] = e[1][2];": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(e[1][2]) == (26);");
                break;
            }
            case "list.h = list.h;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.h) == (31);");
                break;
            }
            case "list.n = list.n;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n) == (108LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->h) == (41);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->n->h) == (31);");
                break;
            }
            case "list.d.h = list.d.h;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.d.h) == (32);");
                break;
            }
            case "list.n->d.h2[0] = list.n->d.h2[0];": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"((list.n->d.h2)[0]) == (43);");
                break;
            }
            case "list.n->d.h3 = list.n->d.h3;": {
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(list.n->d.h3) == (36LL);");
                Truth.assertThat((String)assignmentEdgeFull.getAsCode()).contains((CharSequence)"(*(list.n->d.h3)) == (22);");
                break;
            }
            default: {
                Truth.assertThat((String)pEdge.getRawStatement()).doesNotContain((CharSequence)" = ");
            }
        }
    }
}

