/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.NoException;

public class CExpressionToOrinalCodeVisitor
implements CExpressionVisitor<String, NoException> {
    public static final CExpressionToOrinalCodeVisitor BASIC_TRANSFORMER = new CExpressionToOrinalCodeVisitor();
    private final Map<CExpression, String> subsitution;

    private CExpressionToOrinalCodeVisitor() {
        this((Map<CExpression, String>)ImmutableMap.of());
    }

    private CExpressionToOrinalCodeVisitor(Map<CExpression, String> pSubsitution) {
        this.subsitution = ImmutableMap.copyOf(pSubsitution);
    }

    public CExpressionToOrinalCodeVisitor substitute(CExpression pExpression, String pSubsitute) {
        if (pSubsitute.equals(this.subsitution.get(Objects.requireNonNull(pExpression)))) {
            return this;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<CExpression, String> entry : this.subsitution.entrySet()) {
            if (entry.getKey().equals(pExpression)) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        builder.put((Object)pExpression, (Object)pSubsitute);
        return new CExpressionToOrinalCodeVisitor((Map<CExpression, String>)builder.buildOrThrow());
    }

    @Override
    public String visit(CArraySubscriptExpression pArraySubscriptExpression) {
        String substitute = this.subsitution.get(pArraySubscriptExpression);
        if (substitute != null) {
            return substitute;
        }
        CExpression arrayExpression = pArraySubscriptExpression.getArrayExpression();
        String left = arrayExpression instanceof AArraySubscriptExpression ? arrayExpression.accept(this) : this.parenthesize(arrayExpression);
        CExpression subscriptExpression = pArraySubscriptExpression.getSubscriptExpression();
        return left + "[" + subscriptExpression.accept(this) + "]";
    }

    @Override
    public String visit(CFieldReference pFieldReference) {
        String substitute = this.subsitution.get(pFieldReference);
        if (substitute != null) {
            return substitute;
        }
        String left = pFieldReference.getFieldOwner() instanceof CFieldReference ? pFieldReference.getFieldOwner().accept(this) : this.parenthesize(pFieldReference.getFieldOwner());
        String op = pFieldReference.isPointerDereference() ? "->" : ".";
        return left + op + pFieldReference.getFieldName();
    }

    @Override
    public String visit(CIdExpression pIdExpression) {
        String substitute = this.subsitution.get(pIdExpression);
        if (substitute != null) {
            return substitute;
        }
        if (pIdExpression.getDeclaration() == null) {
            return pIdExpression.getName();
        }
        return pIdExpression.getDeclaration().getOrigName();
    }

    @Override
    public String visit(CPointerExpression pPointerExpression) {
        String substitute = this.subsitution.get(pPointerExpression);
        if (substitute != null) {
            return substitute;
        }
        return "*" + this.parenthesize(pPointerExpression.getOperand().accept(this));
    }

    @Override
    public String visit(CComplexCastExpression pComplexCastExpression) {
        String substitute = this.subsitution.get(pComplexCastExpression);
        if (substitute != null) {
            return substitute;
        }
        String operand = pComplexCastExpression.getOperand().accept(this);
        if (pComplexCastExpression.isRealCast()) {
            return "__real__ " + operand;
        }
        return "__imag__ " + operand;
    }

    @Override
    public String visit(CBinaryExpression pIastBinaryExpression) {
        String substitute = this.subsitution.get(pIastBinaryExpression);
        if (substitute != null) {
            return substitute;
        }
        return this.parenthesize(pIastBinaryExpression.getOperand1()) + " " + pIastBinaryExpression.getOperator().getOperator() + " " + this.parenthesize(pIastBinaryExpression.getOperand2());
    }

    @Override
    public String visit(CCastExpression pCastExpression) {
        String substitute = this.subsitution.get(pCastExpression);
        if (substitute != null) {
            return substitute;
        }
        CType type = pCastExpression.getExpressionType();
        String typeCode = type.toASTString("");
        return this.parenthesize(typeCode) + this.parenthesize(pCastExpression.getOperand());
    }

    @Override
    public String visit(CCharLiteralExpression pCharLiteralExpression) {
        String substitute = this.subsitution.get(pCharLiteralExpression);
        if (substitute != null) {
            return substitute;
        }
        char c = pCharLiteralExpression.getCharacter();
        if (c >= ' ' && c < '\u0080') {
            return "'" + c + "'";
        }
        return "'\\x" + Integer.toHexString(c) + "'";
    }

    @Override
    public String visit(CFloatLiteralExpression pFloatLiteralExpression) {
        String substitute = this.subsitution.get(pFloatLiteralExpression);
        if (substitute != null) {
            return substitute;
        }
        return pFloatLiteralExpression.getValue().toString();
    }

    @Override
    public String visit(CIntegerLiteralExpression pIntegerLiteralExpression) {
        String substitute = this.subsitution.get(pIntegerLiteralExpression);
        if (substitute != null) {
            return substitute;
        }
        Object suffix = "";
        CType cType = pIntegerLiteralExpression.getExpressionType();
        if (cType instanceof CSimpleType) {
            CSimpleType type = (CSimpleType)cType;
            if (type.isUnsigned()) {
                suffix = (String)suffix + "U";
            }
            if (type.isLong()) {
                suffix = (String)suffix + "L";
            } else if (type.isLongLong()) {
                suffix = (String)suffix + "LL";
            }
        }
        return pIntegerLiteralExpression.getValue().toString() + (String)suffix;
    }

    @Override
    public String visit(CStringLiteralExpression pStringLiteralExpression) {
        String substitute = this.subsitution.get(pStringLiteralExpression);
        if (substitute != null) {
            return substitute;
        }
        return pStringLiteralExpression.getValue();
    }

    @Override
    public String visit(CTypeIdExpression pTypeIdExpression) {
        String substitute = this.subsitution.get(pTypeIdExpression);
        if (substitute != null) {
            return substitute;
        }
        return pTypeIdExpression.getOperator().getOperator() + this.parenthesize(pTypeIdExpression.getType().getCanonicalType().toASTString(""));
    }

    @Override
    public String visit(CUnaryExpression pUnaryExpression) {
        String substitute = this.subsitution.get(pUnaryExpression);
        if (substitute != null) {
            return substitute;
        }
        CUnaryExpression.UnaryOperator operator = pUnaryExpression.getOperator();
        if (operator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return operator.getOperator() + this.parenthesize(pUnaryExpression.getOperand().accept(this));
        }
        return operator.getOperator() + this.parenthesize(pUnaryExpression.getOperand());
    }

    @Override
    public String visit(CImaginaryLiteralExpression pLiteralExpression) {
        String substitute = this.subsitution.get(pLiteralExpression);
        if (substitute != null) {
            return substitute;
        }
        return pLiteralExpression.getValue() + "i";
    }

    @Override
    public String visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
        String substitute = this.subsitution.get(pAddressOfLabelExpression);
        if (substitute != null) {
            return substitute;
        }
        return pAddressOfLabelExpression.toASTString();
    }

    public String parenthesize(String pInput) {
        return "(" + pInput + ")";
    }

    public String parenthesize(CExpression pInput) {
        String result = pInput.accept(this);
        if (pInput instanceof CIdExpression) {
            return result;
        }
        return this.parenthesize(result);
    }
}

