/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CStatementToOriginalCodeVisitor;

public class CFAEdgeWithAssumptions {
    private final CFAEdge edge;
    private final ImmutableList<AExpressionStatement> expressionStmts;
    private final String comment;

    public CFAEdgeWithAssumptions(CFAEdge pEdge, ImmutableCollection<AExpressionStatement> pExpStmt, String pComment) {
        this.edge = Objects.requireNonNull(pEdge);
        this.expressionStmts = pExpStmt.asList();
        this.comment = Objects.requireNonNull(pComment);
    }

    private CFAEdgeWithAssumptions(CFAEdgeWithAssumptions pEdgeWA, CFAEdgeWithAssumptions pEdgeWA2) {
        assert (pEdgeWA.edge.equals(pEdgeWA2.edge));
        this.edge = pEdgeWA.edge;
        ImmutableSet expStmts1 = ImmutableSet.copyOf(pEdgeWA.getExpStmts());
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(pEdgeWA.getExpStmts());
        for (AExpressionStatement expStmt2 : pEdgeWA2.getExpStmts()) {
            if (expStmts1.contains(expStmt2)) continue;
            result.add((Object)expStmt2);
        }
        this.comment = pEdgeWA.comment;
        this.expressionStmts = result.build();
    }

    public ImmutableList<AExpressionStatement> getExpStmts() {
        return this.expressionStmts;
    }

    public CFAEdge getCFAEdge() {
        return this.edge;
    }

    public String getAsCode() {
        if (this.expressionStmts.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (AExpressionStatement expressionStmt : this.expressionStmts) {
            if (expressionStmt instanceof CExpressionStatement) {
                result.append(((CExpressionStatement)expressionStmt).accept(CStatementToOriginalCodeVisitor.INSTANCE));
                continue;
            }
            return "";
        }
        return result.toString();
    }

    public String prettyPrintCode(int numberOfTabsPerLine) {
        if (this.expressionStmts.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (AExpressionStatement expStmt : this.expressionStmts) {
            if (expStmt instanceof CExpressionStatement) {
                for (int c = 0; c < numberOfTabsPerLine; ++c) {
                    result.append("\t");
                }
                result.append(expStmt.toASTString());
                result.append(System.lineSeparator());
                continue;
            }
            return "";
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.edge.toString());
        for (AExpressionStatement assum : this.expressionStmts) {
            str.append("\n\t").append(assum);
        }
        return str.toString();
    }

    public @Nullable String getComment() {
        return this.comment;
    }

    public CFAEdgeWithAssumptions mergeEdge(CFAEdgeWithAssumptions pEdge) {
        return new CFAEdgeWithAssumptions(this, pEdge);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.edge, this.expressionStmts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CFAEdgeWithAssumptions) {
            CFAEdgeWithAssumptions other = (CFAEdgeWithAssumptions)obj;
            return this.comment.equals(other.comment) && this.edge.equals(other.edge) && this.expressionStmts.equals(other.expressionStmts);
        }
        return false;
    }
}

