/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithAdditionalInfo;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AdditionalInfoConverter;
import org.sosy_lab.cpachecker.util.CPAs;

public class CFAPathWithAdditionalInfo
extends ForwardingList<CFAEdgeWithAdditionalInfo> {
    private final ImmutableList<CFAEdgeWithAdditionalInfo> pathInfo;
    private final Set<AdditionalInfoConverter> additionalInfoConverters;

    private CFAPathWithAdditionalInfo(List<CFAEdgeWithAdditionalInfo> pPathInfo) {
        this.pathInfo = ImmutableList.copyOf(pPathInfo);
        this.additionalInfoConverters = new HashSet<AdditionalInfoConverter>();
    }

    public static CFAPathWithAdditionalInfo empty() {
        return new CFAPathWithAdditionalInfo((List<CFAEdgeWithAdditionalInfo>)ImmutableList.of());
    }

    public static CFAPathWithAdditionalInfo of(List<CFAEdgeWithAdditionalInfo> pPathInfo) {
        return new CFAPathWithAdditionalInfo(pPathInfo);
    }

    public static CFAPathWithAdditionalInfo of(ARGPath pPath, ConfigurableProgramAnalysis pCPA) {
        FluentIterable cpas = CPAs.asIterable(pCPA).filter(ConfigurableProgramAnalysisWithAdditionalInfo.class);
        Optional<Object> result = Optional.empty();
        for (ConfigurableProgramAnalysisWithAdditionalInfo wrappedCpa : cpas) {
            CFAPathWithAdditionalInfo path = wrappedCpa.createExtendedInfo(pPath);
            path.addConverter(wrappedCpa.exportAdditionalInfoConverter());
            if (result.isPresent()) {
                if ((result = ((CFAPathWithAdditionalInfo)((Object)result.orElseThrow())).mergePaths(path)).isPresent()) continue;
                break;
            }
            result = Optional.of(path);
        }
        if (!result.isPresent()) {
            return CFAPathWithAdditionalInfo.empty();
        }
        return (CFAPathWithAdditionalInfo)((Object)result.orElseThrow());
    }

    private void addConverter(AdditionalInfoConverter pAdditionalInfoConverter) {
        this.additionalInfoConverters.add(pAdditionalInfoConverter);
    }

    public Set<AdditionalInfoConverter> getAdditionalInfoConverters() {
        return this.additionalInfoConverters;
    }

    private Optional<CFAPathWithAdditionalInfo> mergePaths(CFAPathWithAdditionalInfo pOtherPath) {
        if (pOtherPath.size() != this.size()) {
            return Optional.empty();
        }
        ArrayList<CFAEdgeWithAdditionalInfo> result = new ArrayList<CFAEdgeWithAdditionalInfo>(this.size());
        Iterator path2Iterator = this.iterator();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CFAEdgeWithAdditionalInfo edge = (CFAEdgeWithAdditionalInfo)iterator.next();
            CFAEdgeWithAdditionalInfo other = (CFAEdgeWithAdditionalInfo)path2Iterator.next();
            if (!edge.getCFAEdge().equals(other.getCFAEdge())) {
                return Optional.empty();
            }
            CFAEdgeWithAdditionalInfo resultEdge = edge.mergeEdge(other);
            result.add(resultEdge);
        }
        return Optional.of(new CFAPathWithAdditionalInfo(result));
    }

    protected List<CFAEdgeWithAdditionalInfo> delegate() {
        return this.pathInfo;
    }

    public Map<ARGState, CFAEdgeWithAdditionalInfo> getAdditionalInfoMapping(ARGPath pPath) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        PathIterator pathIterator = pPath.fullPathIterator();
        int multiEdgeOffset = 0;
        while (pathIterator.hasNext()) {
            CFAEdgeWithAdditionalInfo edgeWithAdditionalInfo = (CFAEdgeWithAdditionalInfo)this.pathInfo.get(pathIterator.getIndex() + multiEdgeOffset);
            CFAEdge argPathEdge = pathIterator.getOutgoingEdge();
            if (!edgeWithAdditionalInfo.getCFAEdge().equals(argPathEdge)) {
                return ImmutableMap.of();
            }
            ARGState abstractState = pathIterator.isPositionWithState() ? pathIterator.getAbstractState() : pathIterator.getPreviousAbstractState();
            result.put((Object)abstractState, (Object)edgeWithAdditionalInfo);
            pathIterator.advance();
        }
        return result.buildOrThrow();
    }
}

