/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.util.CPAs;

public class CFAPathWithAssumptions
extends ForwardingList<CFAEdgeWithAssumptions> {
    private final ImmutableList<CFAEdgeWithAssumptions> pathWithAssignments;

    private CFAPathWithAssumptions(ImmutableList<CFAEdgeWithAssumptions> pPathWithAssignments) {
        this.pathWithAssignments = ImmutableList.copyOf(pPathWithAssignments);
    }

    public static CFAPathWithAssumptions empty() {
        return new CFAPathWithAssumptions((ImmutableList<CFAEdgeWithAssumptions>)ImmutableList.of());
    }

    protected List<CFAEdgeWithAssumptions> delegate() {
        return this.pathWithAssignments;
    }

    boolean fitsPath(List<CFAEdge> pPath) {
        int index = 0;
        for (CFAEdge edge : pPath) {
            CFAEdgeWithAssumptions cfaWithAssignment;
            if (!edge.equals((cfaWithAssignment = (CFAEdgeWithAssumptions)this.pathWithAssignments.get(index)).getCFAEdge())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public ImmutableSetMultimap<ARGState, CFAEdgeWithAssumptions> getExactVariableValues(ARGPath pPath) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        PathIterator pathIterator = pPath.fullPathIterator();
        int multiEdgeOffset = 0;
        while (pathIterator.hasNext()) {
            CFAEdgeWithAssumptions edgeWithAssignment = (CFAEdgeWithAssumptions)this.pathWithAssignments.get(pathIterator.getIndex() + multiEdgeOffset);
            CFAEdge argPathEdge = pathIterator.getOutgoingEdge();
            if (!edgeWithAssignment.getCFAEdge().equals(argPathEdge)) {
                return ImmutableSetMultimap.of();
            }
            ARGState abstractState = pathIterator.isPositionWithState() ? pathIterator.getAbstractState() : pathIterator.getPreviousAbstractState();
            result.put((Object)abstractState, (Object)edgeWithAssignment);
            pathIterator.advance();
        }
        return result.build();
    }

    public static CFAPathWithAssumptions of(ConcreteStatePath statePath, AssumptionToEdgeAllocator pAllocator) {
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)statePath.size());
        ArrayList<ConcreteStatePath.IntermediateConcreteState> currentIntermediateStates = new ArrayList<ConcreteStatePath.IntermediateConcreteState>();
        for (ConcreteStatePath.ConcreteStatePathNode node : statePath) {
            CFAEdgeWithAssumptions edge;
            if (node instanceof ConcreteStatePath.IntermediateConcreteState) {
                ConcreteStatePath.IntermediateConcreteState intermediateState = (ConcreteStatePath.IntermediateConcreteState)node;
                currentIntermediateStates.add(intermediateState);
                edge = pAllocator.allocateAssumptionsToEdge(intermediateState.getCfaEdge(), intermediateState.getConcreteState());
            } else {
                ConcreteStatePath.SingleConcreteState singleState = (ConcreteStatePath.SingleConcreteState)node;
                if (currentIntermediateStates.isEmpty()) {
                    edge = pAllocator.allocateAssumptionsToEdge(singleState.getCfaEdge(), singleState.getConcreteState());
                } else {
                    ImmutableSet.Builder assumptions = ImmutableSet.builder();
                    HashSet<String> assumptionCodes = new HashSet<String>();
                    ConcreteState lastState = singleState.getConcreteState();
                    StringBuilder comment = new StringBuilder("");
                    if (!CFAPathWithAssumptions.isEmptyDeclaration(singleState.getCfaEdge())) {
                        for (ConcreteStatePath.IntermediateConcreteState intermediates : currentIntermediateStates) {
                            CFAEdgeWithAssumptions assumptionForedge = pAllocator.allocateAssumptionsToEdge(intermediates.getCfaEdge(), lastState);
                            CFAPathWithAssumptions.addAssumptionsIfNecessary((ImmutableCollection.Builder<AExpressionStatement>)assumptions, assumptionCodes, comment, assumptionForedge);
                        }
                        CFAPathWithAssumptions.addAssumptionsIfNecessary((ImmutableCollection.Builder<AExpressionStatement>)assumptions, assumptionCodes, comment, pAllocator.allocateAssumptionsToEdge(singleState.getCfaEdge(), lastState));
                    }
                    edge = new CFAEdgeWithAssumptions(singleState.getCfaEdge(), (ImmutableCollection<AExpressionStatement>)assumptions.build(), comment.toString());
                    currentIntermediateStates.clear();
                }
            }
            result.add((Object)edge);
        }
        return new CFAPathWithAssumptions((ImmutableList<CFAEdgeWithAssumptions>)result.build());
    }

    private static boolean isEmptyDeclaration(CFAEdge pCfaEdge) {
        if (pCfaEdge instanceof ADeclarationEdge) {
            ADeclarationEdge declarationEdge = (ADeclarationEdge)pCfaEdge;
            ADeclaration declaration = declarationEdge.getDeclaration();
            if (declaration instanceof AVariableDeclaration) {
                AVariableDeclaration variableDeclaration = (AVariableDeclaration)declaration;
                return variableDeclaration.getInitializer() == null && !variableDeclaration.isGlobal();
            }
            return true;
        }
        return false;
    }

    private static void addAssumptionsIfNecessary(ImmutableCollection.Builder<AExpressionStatement> assumptions, Set<String> assumptionCodes, StringBuilder comment, CFAEdgeWithAssumptions lastIntermediate) {
        for (AExpressionStatement assumption : lastIntermediate.getExpStmts()) {
            if (assumptionCodes.contains(assumption.toASTString())) continue;
            assumptions.add((Object)assumption);
            assumptionCodes.add(assumption.toASTString());
        }
        String commentOfEdge = lastIntermediate.getComment();
        if (!Strings.isNullOrEmpty((String)commentOfEdge)) {
            comment.append(commentOfEdge);
            comment.append("\n");
        }
    }

    public Optional<CFAPathWithAssumptions> mergePaths(CFAPathWithAssumptions pOtherPath) {
        if (pOtherPath.size() != this.size()) {
            return Optional.empty();
        }
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.size());
        Iterator path2Iterator = this.iterator();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CFAEdgeWithAssumptions edge = (CFAEdgeWithAssumptions)iterator.next();
            CFAEdgeWithAssumptions other = (CFAEdgeWithAssumptions)path2Iterator.next();
            if (!edge.getCFAEdge().equals(other.getCFAEdge())) {
                return Optional.empty();
            }
            CFAEdgeWithAssumptions resultEdge = edge.mergeEdge(other);
            result.add((Object)resultEdge);
        }
        return Optional.of(new CFAPathWithAssumptions((ImmutableList<CFAEdgeWithAssumptions>)result.build()));
    }

    public static CFAPathWithAssumptions of(ARGPath pPath, ConfigurableProgramAnalysis pCPA, AssumptionToEdgeAllocator pAssumptionToEdgeAllocator) {
        FluentIterable cpas = CPAs.asIterable(pCPA).filter(ConfigurableProgramAnalysisWithConcreteCex.class);
        Optional<Object> result = Optional.empty();
        for (ConfigurableProgramAnalysisWithConcreteCex wrappedCpa : cpas) {
            ConcreteStatePath path = wrappedCpa.createConcreteStatePath(pPath);
            CFAPathWithAssumptions cexPath = CFAPathWithAssumptions.of(path, pAssumptionToEdgeAllocator);
            if (result.isPresent()) {
                if ((result = ((CFAPathWithAssumptions)((Object)result.orElseThrow())).mergePaths(cexPath)).isPresent()) continue;
                break;
            }
            result = Optional.of(cexPath);
        }
        if (!result.isPresent()) {
            return CFAPathWithAssumptions.empty();
        }
        return (CFAPathWithAssumptions)((Object)result.orElseThrow());
    }
}

