/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatementVisitor;
import org.sosy_lab.cpachecker.core.counterexample.CExpressionToOrinalCodeVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;

enum CStatementToOriginalCodeVisitor implements CStatementVisitor<String, NoException>
{
    INSTANCE;


    @Override
    public String visit(CExpressionStatement pIastExpressionStatement) {
        return pIastExpressionStatement.getExpression().accept(CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER) + ";";
    }

    @Override
    public String visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) {
        CExpressionToOrinalCodeVisitor expressionToOrinalCodeVisitor = CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER;
        String leftHandSide = pIastExpressionAssignmentStatement.getLeftHandSide().accept(expressionToOrinalCodeVisitor);
        String rightHandSide = pIastExpressionAssignmentStatement.getRightHandSide().accept(expressionToOrinalCodeVisitor);
        return leftHandSide + " == " + rightHandSide + "; ";
    }

    @Override
    public String visit(CFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) {
        CExpressionToOrinalCodeVisitor expressionToOrinalCodeVisitor = CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER;
        String leftHandSide = pIastFunctionCallAssignmentStatement.getLeftHandSide().accept(expressionToOrinalCodeVisitor);
        String rightHandSide = CStatementToOriginalCodeVisitor.handleFunctionCallExpression(pIastFunctionCallAssignmentStatement.getFunctionCallExpression());
        return leftHandSide + " == " + rightHandSide + "; ";
    }

    @Override
    public String visit(CFunctionCallStatement pIastFunctionCallStatement) {
        return CStatementToOriginalCodeVisitor.handleFunctionCallExpression(pIastFunctionCallStatement.getFunctionCallExpression()) + ";";
    }

    private static String handleFunctionCallExpression(CFunctionCallExpression pFunctionCallExpression) {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(CStatementToOriginalCodeVisitor.parenthesize(pFunctionCallExpression.getFunctionNameExpression()));
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, Iterables.transform(pFunctionCallExpression.getParameterExpressions(), pInput -> pInput.accept(CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER)));
        lASTString.append(")");
        return lASTString.toString();
    }

    private static String parenthesize(CExpression pInput) {
        return CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER.parenthesize(pInput);
    }
}

