/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ACastExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteExpressionEvaluator;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

public final class ConcreteState {
    private static final ConcreteState EMPTY_CONCRETE_STATE = new ConcreteState();
    private final Map<LeftHandSide, Object> variables;
    private final Map<String, Memory> allocatedMemory;
    private final Map<LeftHandSide, Address> variableAddressMap;
    private final ConcreteExpressionEvaluator analysisConcreteExpressionEvaluation;
    private final MemoryName memoryNameAllocator;
    private final @Nullable MachineModel machineModel;

    public ConcreteState(Map<LeftHandSide, Object> pVariables, Map<String, Memory> pAllocatedMemory, Map<LeftHandSide, Address> pVariableAddressMap, MemoryName pMemoryName, MachineModel pMachineModel) {
        this.variableAddressMap = ImmutableMap.copyOf(pVariableAddressMap);
        this.allocatedMemory = ImmutableMap.copyOf(pAllocatedMemory);
        this.variables = ImmutableMap.copyOf(pVariables);
        this.memoryNameAllocator = pMemoryName;
        this.machineModel = pMachineModel;
        this.analysisConcreteExpressionEvaluation = new DefaultConcreteExpressionEvaluator();
    }

    public ConcreteState(Map<LeftHandSide, Object> pVariables, Map<String, Memory> pAllocatedMemory, Map<LeftHandSide, Address> pVariableAddressMap, MemoryName pMemoryName, ConcreteExpressionEvaluator pAnalysisConcreteExpressionEvaluation, MachineModel pMachineModel) {
        this.variableAddressMap = ImmutableMap.copyOf(pVariableAddressMap);
        this.allocatedMemory = ImmutableMap.copyOf(pAllocatedMemory);
        this.variables = ImmutableMap.copyOf(pVariables);
        this.memoryNameAllocator = pMemoryName;
        this.analysisConcreteExpressionEvaluation = pAnalysisConcreteExpressionEvaluation;
        this.machineModel = pMachineModel;
    }

    private ConcreteState() {
        this.variableAddressMap = ImmutableMap.of();
        this.allocatedMemory = ImmutableMap.of();
        this.variables = ImmutableMap.of();
        this.memoryNameAllocator = pExp -> "";
        this.analysisConcreteExpressionEvaluation = new DefaultConcreteExpressionEvaluator();
        this.machineModel = null;
    }

    public ConcreteState(Map<LeftHandSide, Object> pVariables, Map<String, Memory> pAllocatedMemory, Map<LeftHandSide, Address> pVariableAddressMap, MemoryName pMemoryName) {
        this.variableAddressMap = ImmutableMap.copyOf(pVariableAddressMap);
        this.allocatedMemory = ImmutableMap.copyOf(pAllocatedMemory);
        this.variables = ImmutableMap.copyOf(pVariables);
        this.memoryNameAllocator = pMemoryName;
        this.analysisConcreteExpressionEvaluation = new DefaultConcreteExpressionEvaluator();
        this.machineModel = null;
    }

    public @Nullable Object getValueFromMemory(CRightHandSide exp, Address address) {
        String memoryName = this.memoryNameAllocator.getMemoryName(exp);
        if (!this.allocatedMemory.containsKey(memoryName)) {
            return null;
        }
        Memory memory = this.allocatedMemory.get(memoryName);
        if (TypeHandlerWithPointerAliasing.isByteArrayAccessName(memoryName)) {
            Preconditions.checkArgument((this.machineModel != null ? 1 : 0) != 0, (Object)"Sound computation of heap values with byte array encodings requires the machine model.");
            int typeSizeInByte = this.machineModel.getSizeof(exp.getExpressionType()).intValueExact();
            if (typeSizeInByte == 1) {
                if (memory.hasValue(address)) {
                    return memory.getValue(address);
                }
                return null;
            }
            int offset = 0;
            int ret = 0;
            boolean memoryHasValue = false;
            while (offset < typeSizeInByte) {
                BigInteger byteJunk;
                Address addressWithOffset = address.addOffset(BigInteger.valueOf(offset));
                if (memory.hasValue(addressWithOffset)) {
                    memoryHasValue = true;
                    byteJunk = (BigInteger)memory.getValue(addressWithOffset);
                } else {
                    byteJunk = BigInteger.ZERO;
                }
                int shiftBy = this.machineModel.getEndianness() == ByteOrder.BIG_ENDIAN ? 8 * (typeSizeInByte - 1 - offset++) : 8 * offset++;
                ret += byteJunk.intValueExact() << shiftBy;
            }
            return memoryHasValue ? BigInteger.valueOf(ret) : null;
        }
        if (memory.hasValue(address)) {
            return memory.getValue(address);
        }
        return null;
    }

    public boolean hasValueForLeftHandSide(LeftHandSide variable) {
        return this.variables.containsKey(variable);
    }

    public Object getVariableValue(LeftHandSide variable) {
        Preconditions.checkArgument((boolean)this.variables.containsKey(variable));
        return this.variables.get(variable);
    }

    public ConcreteExpressionEvaluator getAnalysisConcreteExpressionEvaluation() {
        return this.analysisConcreteExpressionEvaluation;
    }

    public boolean hasAddressOfVariable(LeftHandSide variable) {
        return this.variableAddressMap.containsKey(variable);
    }

    public Address getVariableAddress(LeftHandSide variable) {
        Preconditions.checkArgument((boolean)this.variableAddressMap.containsKey(variable));
        return this.variableAddressMap.get(variable);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "variables=" + this.variables + System.lineSeparator() + "allocatedMemory=" + this.allocatedMemory + System.lineSeparator() + " variableAddressMap=" + this.variableAddressMap;
    }

    public static ConcreteState empty() {
        return EMPTY_CONCRETE_STATE;
    }

    private static class DefaultConcreteExpressionEvaluator
    implements ConcreteExpressionEvaluator {
        private DefaultConcreteExpressionEvaluator() {
        }

        @Override
        public boolean shouldEvaluateExpressionWithThisEvaluator(AExpression pExp) {
            return false;
        }

        private Value throwUnsupportedOperationException(AExpression pExp) {
            throw new UnsupportedOperationException(pExp.toASTString() + "should not be evaluated with this class.");
        }

        @Override
        public Value evaluate(ABinaryExpression pBinExp, Value pOp1, Value pOp2) {
            return this.throwUnsupportedOperationException(pBinExp);
        }

        @Override
        public Value evaluate(AUnaryExpression pUnaryExpression, Value pOperand) {
            return this.throwUnsupportedOperationException(pUnaryExpression);
        }

        @Override
        public Value evaluate(ACastExpression pCastExpression, Value pOperand) {
            return this.throwUnsupportedOperationException(pCastExpression);
        }
    }
}

