/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ErrorPathShrinker;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AdditionalInfoConverter;
import org.sosy_lab.cpachecker.util.Pair;

public class CounterexampleInfo
extends Appenders.AbstractAppender {
    private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
    private final int uniqueId = ID_GENERATOR.getFreshId();
    private final boolean spurious;
    private final boolean isPreciseCounterExample;
    private final ARGPath targetPath;
    private final CFAPathWithAssumptions assignments;
    private final CFAPathWithAdditionalInfo additionalInfo;
    private final Collection<Pair<Object, PathTemplate>> furtherInfo;
    private static final CounterexampleInfo SPURIOUS = new CounterexampleInfo(true, null, null, false, CFAPathWithAdditionalInfo.empty());

    protected CounterexampleInfo(boolean pSpurious, ARGPath pTargetPath, CFAPathWithAssumptions pAssignments, boolean pIsPreciseCEX, CFAPathWithAdditionalInfo pAdditionalInfo) {
        this.spurious = pSpurious;
        this.targetPath = pTargetPath;
        this.assignments = pAssignments;
        this.additionalInfo = pAdditionalInfo;
        this.isPreciseCounterExample = pIsPreciseCEX;
        this.furtherInfo = !this.spurious ? new ArrayList<Pair<Object, PathTemplate>>(1) : null;
    }

    public static CounterexampleInfo spurious() {
        return SPURIOUS;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public boolean isPreciseCounterExample() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.isPreciseCounterExample;
    }

    public static CounterexampleInfo feasibleImprecise(ARGPath pTargetPath) {
        return CounterexampleInfo.feasibleImprecise((ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pTargetPath))), CFAPathWithAdditionalInfo.empty());
    }

    public static CounterexampleInfo feasibleImprecise(ARGPath pTargetPath, CFAPathWithAdditionalInfo pAdditionalInfo) {
        return new CounterexampleInfo(false, (ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pTargetPath))), null, false, (CFAPathWithAdditionalInfo)((Object)Preconditions.checkNotNull((Object)((Object)pAdditionalInfo))));
    }

    public static CounterexampleInfo feasiblePrecise(ARGPath pTargetPath, CFAPathWithAssumptions pAssignments) {
        return CounterexampleInfo.feasiblePrecise((ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pTargetPath))), pAssignments, CFAPathWithAdditionalInfo.empty());
    }

    public static CounterexampleInfo feasiblePrecise(ARGPath pTargetPath, CFAPathWithAssumptions pAssignments, CFAPathWithAdditionalInfo pAdditionalInfo) {
        Preconditions.checkArgument((!pAssignments.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)pAssignments.fitsPath(pTargetPath.getFullPath()));
        return new CounterexampleInfo(false, (ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pTargetPath))), pAssignments, true, (CFAPathWithAdditionalInfo)((Object)Preconditions.checkNotNull((Object)((Object)pAdditionalInfo))));
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public ARGPath getTargetPath() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        assert (this.targetPath != null);
        return this.targetPath;
    }

    public ARGState getTargetState() {
        return this.getTargetPath().getLastState();
    }

    public ARGState getRootState() {
        return this.getTargetPath().getFirstState();
    }

    public CFAPathWithAssumptions getCFAPathWithAssignments() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isPreciseCounterExample);
        return this.assignments;
    }

    public ImmutableSetMultimap<ARGState, CFAEdgeWithAssumptions> getExactVariableValues() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isPreciseCounterExample);
        return this.assignments.getExactVariableValues(this.targetPath);
    }

    public Map<ARGState, CFAEdgeWithAdditionalInfo> getAdditionalInfoMapping() {
        return this.additionalInfo.isEmpty() ? ImmutableMap.of() : this.additionalInfo.getAdditionalInfoMapping(this.targetPath);
    }

    public Set<AdditionalInfoConverter> getAdditionalInfoConverters() {
        return this.additionalInfo.isEmpty() ? ImmutableSet.of() : this.additionalInfo.getAdditionalInfoConverters();
    }

    public void toJSON(Appendable sb) throws IOException {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        int pathLength = this.targetPath.getFullPath().size();
        ArrayList<HashMap<String, Object>> path = new ArrayList<HashMap<String, Object>>(pathLength);
        ErrorPathShrinker pathShrinker = new ErrorPathShrinker();
        ImmutableList<Pair<CFAEdgeWithAssumptions, Boolean>> shrinkedErrorPath = pathShrinker.shrinkErrorPath(this.targetPath, this.assignments);
        Iterator shrinkedErrorPathIterator = null;
        if (shrinkedErrorPath != null) {
            shrinkedErrorPathIterator = shrinkedErrorPath.iterator();
        }
        PathIterator iterator = this.targetPath.fullPathIterator();
        while (iterator.hasNext()) {
            Pair shrinkedEdge;
            HashMap<String, Object> elem = new HashMap<String, Object>();
            CFAEdge edge = iterator.getOutgoingEdge();
            if (edge == null) continue;
            elem.put("importance", 0);
            if (shrinkedErrorPathIterator != null && shrinkedErrorPathIterator.hasNext() && edge.equals(((CFAEdgeWithAssumptions)(shrinkedEdge = (Pair)shrinkedErrorPathIterator.next()).getFirst()).getCFAEdge()) && ((Boolean)shrinkedEdge.getSecond()).booleanValue()) {
                elem.put("importance", 1);
            }
            if (iterator.isPositionWithState()) {
                elem.put("argelem", iterator.getAbstractState().getStateId());
            }
            elem.put("source", edge.getPredecessor().getNodeNumber());
            elem.put("target", edge.getSuccessor().getNodeNumber());
            elem.put("desc", edge.getDescription().replace('\n', ' '));
            elem.put("line", edge.getFileLocation().getStartingLineInOrigin());
            elem.put("file", edge.getFileLocation().getFileName());
            if (this.assignments == null) {
                elem.put("val", "");
            } else {
                CFAEdgeWithAssumptions edgeWithAssignment = (CFAEdgeWithAssumptions)this.assignments.get(iterator.getIndex());
                elem.put("val", edgeWithAssignment.prettyPrintCode(0).replace(System.lineSeparator(), "\n") + edgeWithAssignment.getComment().replace(System.lineSeparator(), "\n"));
            }
            this.addAdditionalInfo(elem, edge);
            path.add(elem);
            iterator.advance();
        }
        JSON.writeJSONString(path, (Appendable)sb);
    }

    protected void addAdditionalInfo(Map<String, Object> element, CFAEdge edge) {
    }

    public void appendTo(Appendable out) throws IOException {
        if (this.isSpurious()) {
            out.append("SPURIOUS COUNTEREXAMPLE");
        } else if (this.isPreciseCounterExample) {
            for (CFAEdgeWithAssumptions edgeWithAssignments : FluentIterable.from((Iterable)((Object)this.assignments)).filter(Predicates.notNull())) {
                this.printPreciseValues(out, edgeWithAssignments);
            }
        } else {
            this.targetPath.appendTo(out);
        }
    }

    private void printPreciseValues(Appendable out, CFAEdgeWithAssumptions edgeWithAssignments) throws IOException {
        String comment;
        out.append(edgeWithAssignments.getCFAEdge().toString());
        out.append(System.lineSeparator());
        String cCode = edgeWithAssignments.prettyPrintCode(1);
        if (!cCode.isEmpty()) {
            out.append(cCode);
        }
        if (!(comment = edgeWithAssignments.getComment()).isEmpty()) {
            out.append('\t');
            out.append(comment);
            out.append(System.lineSeparator());
        }
    }

    public void addFurtherInformation(Object info, PathTemplate dumpFile) {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        this.furtherInfo.add(Pair.of(Preconditions.checkNotNull((Object)info), dumpFile));
    }

    public Collection<Pair<Object, PathTemplate>> getAllFurtherInformation() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return Collections.unmodifiableCollection(this.furtherInfo);
    }
}

