/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.counterexample.Address;

public class Memory {
    private final String name;
    private final Map<Address, Object> values;

    public Memory(String pName, Map<Address, Object> pValues) {
        this.name = pName;
        this.values = ImmutableMap.copyOf(pValues);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue(Address address) {
        return this.values.containsKey(address);
    }

    public Object getValue(Address address) {
        Preconditions.checkArgument((boolean)this.hasValue(address));
        return this.values.get(address);
    }

    public String toString() {
        return "Memory name=" + this.name + " ,  values=" + this.values;
    }
}

