/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder2;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizationInfoWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.PreCondition;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessToOutputFormatsUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultLocalizationInfo;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaToCVisitor;
import org.sosy_lab.java_smt.api.Formula;

@Options
public class ReportGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private static final String HTML_TEMPLATE = "report.html";
    private static final String CSS_TEMPLATE = "build/main.css";
    private static final String JS_TEMPLATE = "build/main.js";
    private static final String WORKER_DATA_TEMPLATE = "build/workerData.js";
    private static final String VENDOR_CSS_TEMPLATE = "build/vendors.css";
    private static final String VENDOR_JS_TEMPLATE = "build/vendors.js";
    private final Configuration config;
    private final LogManager logger;
    @Option(secure=true, name="report.export", description="Generate HTML report with analysis result.")
    private boolean generateReport = true;
    @Option(secure=true, name="report.file", description="File name for analysis report in case no counterexample was found.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reportFile = Path.of("Report.html", new String[0]);
    @Option(secure=true, name="counterexample.export.report", description="File name for analysis report in case a counterexample was found.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate counterExampleFiles = PathTemplate.ofFormatString((String)"Counterexample.%d.html");
    private final @Nullable Path logFile;
    private final ImmutableList<String> sourceFiles;
    private final Map<Integer, Object> argNodes;
    private final Map<String, Object> argEdges;
    private final Map<String, Object> argRelevantEdges;
    private final Map<Integer, Object> argRelevantNodes;
    private final Map<String, Object> argReducedEdges;
    private final Map<String, Map<String, Object>> argReducedNodes;
    private Optional<Witness> witnessOptional;
    private final String producer;

    public ReportGenerator(Configuration pConfig, LogManager pLogger, @Nullable Path pLogFile, ImmutableList<String> pSourceFiles) throws InvalidConfigurationException {
        this.config = (Configuration)Preconditions.checkNotNull((Object)pConfig);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.logFile = pLogFile;
        this.config.inject((Object)this);
        this.sourceFiles = pSourceFiles;
        this.argNodes = new HashMap<Integer, Object>();
        this.argEdges = new HashMap<String, Object>();
        this.argRelevantEdges = new HashMap<String, Object>();
        this.argRelevantNodes = new HashMap<Integer, Object>();
        this.argReducedEdges = new HashMap<String, Object>();
        this.argReducedNodes = new HashMap<String, Map<String, Object>>();
        this.witnessOptional = Optional.empty();
        this.producer = HtmlEscapers.htmlEscaper().escape(CPAchecker.getVersion(pConfig));
    }

    @SuppressForbidden(value="System.out is correct here")
    public void generate(CPAcheckerResult.Result pResult, CFA pCfa, UnmodifiableReachedSet pReached, String pStatistics) {
        Preconditions.checkNotNull((Object)((Object)pResult));
        Preconditions.checkNotNull((Object)pCfa);
        Preconditions.checkNotNull((Object)pReached);
        Preconditions.checkNotNull((Object)pStatistics);
        if (!this.generateReport || this.reportFile == null && this.counterExampleFiles == null) {
            return;
        }
        FluentIterable counterExamples = Optionals.presentInstances((Iterable)FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState).filter(ARGState.class).transform(ARGState::getCounterexampleInformation));
        if (counterExamples.isEmpty() ? this.reportFile == null : this.counterExampleFiles == null) {
            return;
        }
        ImmutableSet<Path> allInputFiles = this.getAllInputFiles(pCfa);
        this.extractWitness(pResult, pCfa, pReached);
        if (!pReached.isEmpty() && pReached.getFirstState() instanceof ARGState) {
            this.buildArgGraphData(pReached);
            if (!this.argNodes.isEmpty() && !this.argEdges.isEmpty()) {
                this.buildRelevantArgGraphData(pReached);
                this.buildReducedArgGraphData();
            }
        }
        DOTBuilder2 dotBuilder = new DOTBuilder2(pCfa);
        PrintStream console = System.out;
        if (counterExamples.isEmpty()) {
            if (this.reportFile != null) {
                this.fillOutTemplate(null, this.reportFile, pCfa, (Set<Path>)allInputFiles, dotBuilder, pStatistics);
                console.println("Graphical representation included in the file \"" + this.reportFile + "\".");
            }
        } else {
            for (CounterexampleInfo counterExample : counterExamples) {
                this.fillOutTemplate(counterExample, this.counterExampleFiles.getPath(new Object[]{counterExample.getUniqueId()}), pCfa, (Set<Path>)allInputFiles, dotBuilder, pStatistics);
            }
            StringBuilder counterExFiles = new StringBuilder();
            counterExFiles.append("Graphical representation included in the file");
            if (counterExamples.size() > 1) {
                counterExFiles.append('s');
            }
            counterExFiles.append(" \"");
            Joiner.on((String)"\", \"").appendTo(counterExFiles, (Iterable)counterExamples.transform(cex -> this.counterExampleFiles.getPath(new Object[]{cex.getUniqueId()})));
            counterExFiles.append("\".");
            console.println(counterExFiles.toString());
        }
    }

    private void extractWitness(CPAcheckerResult.Result pResult, CFA pCfa, UnmodifiableReachedSet pReached) {
        if (EnumSet.of(CPAcheckerResult.Result.TRUE, CPAcheckerResult.Result.UNKNOWN).contains((Object)pResult)) {
            ImmutableSet<ARGState> rootStates = ARGUtils.getRootStates(pReached);
            if (rootStates.size() != 1) {
                this.logger.log(Level.FINER, new Object[]{"Could not determine ARG root for witness view"});
                return;
            }
            ARGState rootState = (ARGState)rootStates.iterator().next();
            try {
                WitnessExporter argWitnessExporter = new WitnessExporter(this.config, this.logger, Specification.alwaysSatisfied(), pCfa);
                this.witnessOptional = Optional.of(argWitnessExporter.generateProofWitness(rootState, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysTrue(), argWitnessExporter.getProofInvariantProvider()));
            }
            catch (InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not generate witness for witness view");
            }
            catch (InterruptedException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not generate witness for witness view due to interruption");
            }
        }
    }

    private void fillOutTemplate(@Nullable CounterexampleInfo counterExample, Path reportPath, CFA cfa, Set<Path> allInputFiles, DOTBuilder2 dotBuilder, String statistics) {
        try (BufferedReader reader = Resources.asCharSource((URL)Resources.getResource(this.getClass(), (String)HTML_TEMPLATE), (Charset)StandardCharsets.UTF_8).openBufferedStream();
             Writer writer = IO.openOutputFile((Path)reportPath, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);){
            String line;
            while (null != (line = reader.readLine())) {
                if (line.contains("CONFIGURATION")) {
                    this.insertConfiguration(writer);
                    continue;
                }
                if (line.contains("REPORT_CSS")) {
                    this.insertCss(writer);
                    continue;
                }
                if (line.contains("REPORT_JS")) {
                    this.insertJs(writer, cfa, allInputFiles, dotBuilder, counterExample);
                    continue;
                }
                if (line.contains("STATISTICS")) {
                    this.insertStatistics(writer, statistics);
                    continue;
                }
                if (line.contains("SOURCE_CONTENT")) {
                    this.insertSources(writer, allInputFiles);
                    continue;
                }
                if (line.contains("LOG")) {
                    this.insertLog(writer);
                    continue;
                }
                if (line.contains("REPORT_NAME")) {
                    this.insertReportName(counterExample, writer);
                    continue;
                }
                if (line.contains("METATAGS")) {
                    this.insertMetaTags(writer);
                    continue;
                }
                if (line.contains("GENERATED")) {
                    this.insertDateAndVersion(writer);
                    continue;
                }
                writer.write(line);
                writer.write(10);
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not create report: Processing of HTML template failed.");
        }
    }

    private void insertJsFile(Writer writer, String file) throws IOException {
        try (BufferedReader reader = Resources.asCharSource((URL)Resources.getResource(this.getClass(), (String)file), (Charset)StandardCharsets.UTF_8).openBufferedStream();){
            String line;
            while (null != (line = reader.readLine())) {
                writer.write(line);
                writer.write(10);
            }
        }
    }

    private void insertJs(Writer writer, CFA cfa, Set<Path> allInputFiles, DOTBuilder2 dotBuilder, @Nullable CounterexampleInfo counterExample) throws IOException {
        this.insertCfaJson(writer, cfa, dotBuilder, counterExample);
        this.insertArgJson(writer);
        this.insertSourceFileNames(writer, allInputFiles);
        this.insertJsFile(writer, WORKER_DATA_TEMPLATE);
        this.insertJsFile(writer, VENDOR_JS_TEMPLATE);
        this.insertJsFile(writer, JS_TEMPLATE);
    }

    private void insertCfaJson(Writer writer, CFA cfa, DOTBuilder2 dotBuilder, @Nullable CounterexampleInfo counterExample) throws IOException {
        writer.write("var cfaJson = {\n");
        writer.write("\"functionNames\":");
        ImmutableSet allFunctionsEntryFirst = ImmutableSet.builder().add((Object)cfa.getMainFunction().getFunctionName()).addAll(cfa.getAllFunctionNames()).build();
        JSON.writeJSONString((Object)allFunctionsEntryFirst, (Appendable)writer);
        writer.write(",\n\"functionCallEdges\":");
        dotBuilder.writeFunctionCallEdges(writer);
        writer.write(",\n\"combinedNodes\":");
        dotBuilder.writeCombinedNodes(writer);
        writer.write(",\n\"combinedNodesLabels\":");
        dotBuilder.writeCombinedNodesLabels(writer);
        writer.write(",\n\"mergedNodes\":");
        dotBuilder.writeMergedNodesList(writer);
        if (counterExample != null) {
            if (counterExample instanceof FaultLocalizationInfo) {
                FaultLocalizationInfo flInfo = (FaultLocalizationInfo)counterExample;
                flInfo.prepare();
                writer.write(",\n\"errorPath\":");
                counterExample.toJSON(writer);
                writer.write(",\n\"faults\":");
                flInfo.faultsToJSON(writer);
                writer.write(",\n\"precondition\":");
                JSON.writeJSONString((Object)ImmutableMap.of((Object)"fl-precondition", (Object)this.extractPreconditionFromFaultLocalizationInfo(flInfo)), (Appendable)writer);
            } else {
                writer.write(",\n\"errorPath\":");
                counterExample.toJSON(writer);
            }
        }
        writer.write(",\n");
        dotBuilder.writeCfaInfo(writer);
        writer.write("\n}\n");
        writer.write("window.cfaJson = cfaJson;\n");
    }

    private String extractPreconditionFromFaultLocalizationInfo(FaultLocalizationInfo fInfo) {
        if (!(fInfo instanceof FaultLocalizationInfoWithTraceFormula)) {
            return "";
        }
        TraceFormula traceFormula = ((FaultLocalizationInfoWithTraceFormula)fInfo).getTraceFormula();
        PreCondition preCondition = traceFormula.getPrecondition();
        FormulaContext context = traceFormula.getContext();
        FormulaToCVisitor visitor = new FormulaToCVisitor(context.getSolver().getFormulaManager());
        context.getSolver().getFormulaManager().visit((Formula)preCondition.getPrecondition(), visitor);
        return visitor.getString();
    }

    private void insertArgJson(Writer writer) throws IOException {
        writer.write("var argJson = {");
        if (!this.argNodes.isEmpty() && !this.argEdges.isEmpty()) {
            writer.write("\n\"nodes\":");
            JSON.writeJSONString(this.argNodes.values(), (Appendable)writer);
            writer.write(",\n\"edges\":");
            JSON.writeJSONString(this.argEdges.values(), (Appendable)writer);
            writer.write("\n");
        }
        if (!this.argRelevantEdges.isEmpty() && !this.argRelevantNodes.isEmpty()) {
            writer.write(",\n\"relevantnodes\":");
            JSON.writeJSONString(this.argRelevantNodes.values(), (Appendable)writer);
            writer.write(",\n\"relevantedges\":");
            JSON.writeJSONString(this.argRelevantEdges.values(), (Appendable)writer);
            writer.write("\n");
        }
        if (!this.argReducedEdges.isEmpty() || !this.argReducedNodes.isEmpty()) {
            writer.write(",\n\"reducednodes\":");
            JSON.writeJSONString(this.argReducedNodes.values(), (Appendable)writer);
            writer.write(",\n\"reducededges\":");
            JSON.writeJSONString(this.argReducedEdges.values(), (Appendable)writer);
            writer.write("\n");
        }
        writer.write("}\n");
        writer.write("window.argJson = argJson;\n");
    }

    private void insertCssFile(Writer writer, String file) throws IOException {
        writer.write("<style>\n");
        Resources.asCharSource((URL)Resources.getResource(this.getClass(), (String)file), (Charset)StandardCharsets.UTF_8).copyTo((Appendable)writer);
        writer.write("</style>");
    }

    private void insertCss(Writer writer) throws IOException {
        this.insertCssFile(writer, CSS_TEMPLATE);
        this.insertCssFile(writer, VENDOR_CSS_TEMPLATE);
    }

    private void insertMetaTags(Writer writer) throws IOException {
        writer.write(String.format("<meta name='generator' content='%s'>%n", this.producer));
    }

    private void insertDateAndVersion(Writer writer) throws IOException {
        writer.write(String.format("Generated on %s by %s", DATE_TIME_FORMAT.format(LocalDateTime.now(ZoneId.systemDefault())), this.producer));
    }

    private void insertReportName(@Nullable CounterexampleInfo counterExample, Writer writer) throws IOException {
        if (counterExample == null) {
            writer.write((String)this.sourceFiles.get(0));
        } else {
            String title = String.format("%s (Counterexample %s)", this.sourceFiles.get(0), counterExample.getUniqueId());
            writer.write(title);
        }
    }

    private void insertStatistics(Writer writer, String statistics) throws IOException {
        int counter = 0;
        String insertTableLine = "<table  id=\"statistics_table\" class=\"display\" style=\"width:100%;padding: 10px\" class=\"table table-bordered\"><thead class=\"thead-light\"><tr><th scope=\"col\">Statistics Name</th><th scope=\"col\">Statistics Value</th><th scope=\"col\">Additional Value</th></tr></thead><tbody>\n";
        writer.write(insertTableLine);
        for (Object line : LINE_SPLITTER.split((CharSequence)statistics)) {
            if (!(((String)line).contains(":") || ((String)line).trim().isEmpty() || ((String)line).contains("----------"))) {
                String insertTableHead = "<tr class=\"table_head\" id=\"statistics-" + counter + "\"><th>" + HtmlEscapers.htmlEscaper().escape((String)line) + "</th><th></th><th></th></tr>";
                writer.write(insertTableHead);
            } else {
                int count = ((String)line).indexOf(((String)line).trim());
                for (int i = 0; i < count / 2; ++i) {
                    line = "\t" + (String)line;
                }
                List splitLine = Splitter.on((String)":").limit(2).splitToList((CharSequence)line);
                if (splitLine.size() == 2) {
                    if (!((String)splitLine.get(1)).contains(";") && ((String)splitLine.get(1)).contains("(")) {
                        List splitLineAnotherValue = Splitter.on((String)"(").limit(2).splitToList((CharSequence)splitLine.get(1));
                        line = "<tr id=\"statistics-" + counter + "\"><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLine.get(0)) + "</td><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLineAnotherValue.get(0)) + "</td><td>" + HtmlEscapers.htmlEscaper().escape(CharMatcher.anyOf((CharSequence)"()").removeFrom((CharSequence)splitLineAnotherValue.get(1))) + "</td></tr>\n";
                        writer.write((String)line);
                    } else {
                        line = "<tr id=\"statistics-" + counter + "\"><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLine.get(0)) + "</td><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLine.get(1)) + "</td><td></td></tr>\n";
                        writer.write((String)line);
                    }
                    ++counter;
                }
            }
            ++counter;
        }
        String exitTableLine = "</tbody></table>\n";
        writer.write(exitTableLine);
    }

    private void insertSources(Writer report, Iterable<Path> allSources) throws IOException {
        int index = 0;
        for (Path sourceFile : allSources) {
            this.insertSource(sourceFile, report, index);
            ++index;
        }
    }

    private void insertSource(Path sourcePath, Writer writer, int sourceFileNumber) throws IOException {
        if (Files.isReadable(sourcePath) && !Files.isDirectory(sourcePath, new LinkOption[0])) {
            int lineNumber = 1;
            try (BufferedReader source = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourcePath.toFile()), Charset.defaultCharset()));){
                Object line;
                writer.write("<div id=\"source-file\" class=\"sourceContent\" ng-show = \"sourceFileIsSet(" + sourceFileNumber + ")\">\n<table>\n");
                while (null != (line = source.readLine())) {
                    line = "<td><pre class=\"prettyprint\">" + HtmlEscapers.htmlEscaper().escape((String)line) + "  </pre></td>";
                    writer.write("<tr id=\"source-" + lineNumber + "\"><td><pre>" + lineNumber + "</pre></td>" + (String)line + "</tr>\n");
                    ++lineNumber;
                }
                writer.write("</table></div>\n");
            }
        } else {
            writer.write("<p>No Source-File available</p>");
        }
    }

    private void insertConfiguration(Writer writer) throws IOException {
        Iterable lines = LINE_SPLITTER.split((CharSequence)this.config.asPropertiesString());
        int iterator = 0;
        String insertTableLine = "<table  id=\"config_table\" class=\"display\" style=\"width:100%;padding: 10px\" class=\"table table-bordered\"><thead class=\"thead-light\"><tr><th scope=\"col\">#</th><th scope=\"col\">Configuration Name</th><th scope=\"col\">Configuration Value</th></tr></thead><tbody>\n";
        writer.write(insertTableLine);
        for (Object line : lines) {
            List splitLine = Splitter.on((char)'=').limit(2).splitToList((CharSequence)line);
            if (splitLine.size() != 2) continue;
            int countLineNumber = iterator + 1;
            line = "<tr id=\"config-" + iterator + "\"><th scope=\"row\">" + countLineNumber + "</th><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLine.get(0)) + "</td><td>" + HtmlEscapers.htmlEscaper().escape((String)splitLine.get(1)) + "</td></tr>\n";
            writer.write((String)line);
            ++iterator;
        }
        String exitTableLine = "</tbody></table>\n";
        writer.write(exitTableLine);
    }

    private void insertLog(Writer writer) throws IOException {
        if (this.logFile != null && Files.isReadable(this.logFile)) {
            Pattern logLinePattern = Pattern.compile("[0-9-]* [0-9:]*\t[A-Z]*\t.*\t.*");
            Splitter logLineSplitter = Splitter.on((char)'\t').limit(4);
            Splitter logDateSplitter = Splitter.on((char)' ').limit(2);
            String insertTableLine = "<table  id=\"log_table\" class=\"display\" style=\"width:100%;padding: 10px\" class=\"table table-bordered\"><thead class=\"thead-light\"><tr><th scope=\"col\">Date</th><th scope=\"col\">Time</th><th scope=\"col\">Level</th><th scope=\"col\">Component</th><th scope=\"col\">Message</th></tr></thead><tbody>\n";
            writer.write(insertTableLine);
            try (BufferedReader log = Files.newBufferedReader(this.logFile, Charset.defaultCharset());){
                String line;
                int counter = 0;
                while ((line = log.readLine()) != null && !logLinePattern.matcher(line).matches()) {
                }
                while (line != null) {
                    List splitLine = logLineSplitter.splitToList((CharSequence)line);
                    List dateTime = logDateSplitter.splitToList((CharSequence)splitLine.get(0));
                    writer.write("<tr id=\"log-" + counter + "\">");
                    writer.write("<th scope=\"row\">");
                    writer.write(HtmlEscapers.htmlEscaper().escape((String)dateTime.get(0)));
                    writer.write("</th><td>");
                    writer.write(HtmlEscapers.htmlEscaper().escape((String)dateTime.get(1)));
                    writer.write("</td><td>");
                    writer.write(HtmlEscapers.htmlEscaper().escape((String)splitLine.get(1)));
                    writer.write("</td><td>");
                    writer.write(HtmlEscapers.htmlEscaper().escape((String)splitLine.get(2)).replace(":", "<br>"));
                    writer.write("</td><td>");
                    writer.write(HtmlEscapers.htmlEscaper().escape((String)splitLine.get(3)));
                    while ((line = log.readLine()) != null && !logLinePattern.matcher(line).matches()) {
                        if (line.isEmpty()) continue;
                        writer.write("<br>");
                        writer.write(HtmlEscapers.htmlEscaper().escape(line));
                    }
                    writer.write("</td></tr>\n");
                    ++counter;
                }
                String exitTableLine = "</tbody></table>\n";
                writer.write(exitTableLine);
            }
        } else {
            writer.write("<p>Log not available</p>");
        }
    }

    private void insertSourceFileNames(Writer writer, Iterable<Path> allSourceFiles) throws IOException {
        writer.write("var sourceFiles = ");
        JSON.writeJSONString(allSourceFiles, (Appendable)writer);
        writer.write(";\n");
        writer.write("window.sourceFiles = sourceFiles;\n");
    }

    private ImmutableSet<Path> getAllInputFiles(CFA cfa) {
        ImmutableSet allLocations = FluentIterable.of((Object)cfa.getMainFunction(), (Object[])new FunctionEntryNode[0]).append(cfa.getAllFunctionHeads()).transform(FunctionEntryNode::getFileLocation).filter(FileLocation::isRealLocation).toSet();
        return FluentIterable.concat((Iterable)Collections2.transform(this.sourceFiles, x$0 -> Path.of(x$0, new String[0])), (Iterable)Collections2.transform((Collection)allLocations, FileLocation::getFileName)).filter(path -> Files.isReadable(path)).filter(path -> !Files.isDirectory(path, new LinkOption[0])).toSet();
    }

    private void buildArgGraphData(UnmodifiableReachedSet reached) {
        for (AbstractState entry : reached) {
            int parentStateId = ((ARGState)entry).getStateId();
            for (CFANode node : AbstractStates.extractLocations(entry)) {
                if (!this.argNodes.containsKey(parentStateId)) {
                    this.argNodes.put(parentStateId, this.createArgNode(parentStateId, node, (ARGState)entry));
                }
                if (((ARGState)entry).getChildren().isEmpty()) continue;
                for (ARGState child : ((ARGState)entry).getChildren()) {
                    int childStateId = child.getStateId();
                    if (child.isCovered()) {
                        String label = child.toDOTLabel();
                        label = label.length() > 2 ? label.substring(0, label.length() - 2) : "";
                        this.createCoveredArgNode(childStateId, child, label);
                        this.createCoveredArgEdge(childStateId, child.getCoveringState().getStateId());
                    }
                    this.argEdges.put(parentStateId + "->" + childStateId, ReportGenerator.createArgEdge(parentStateId, childStateId, ((ARGState)entry).getEdgesToChild(child)));
                }
            }
        }
    }

    private void buildRelevantArgGraphData(UnmodifiableReachedSet reached) {
        SetMultimap<ARGState, ARGState> relevantSetMultimap = ARGUtils.projectARG((ARGState)reached.getFirstState(), ARGState::getChildren, (Predicate<? super ARGState>)((Predicate)ARGUtils::isRelevantState));
        for (Map.Entry entry : relevantSetMultimap.asMap().entrySet()) {
            ARGState parent = (ARGState)entry.getKey();
            Collection children = (Collection)entry.getValue();
            int parentStateId = parent.getStateId();
            for (CFANode node : AbstractStates.extractLocations(parent)) {
                if (this.argRelevantNodes.containsKey(parentStateId)) continue;
                this.argRelevantNodes.put(parentStateId, this.createArgNode(parentStateId, node, parent));
            }
            for (ARGState child : children) {
                int childStateId = child.getStateId();
                for (CFANode node : AbstractStates.extractLocations(child)) {
                    if (!this.argRelevantNodes.containsKey(childStateId)) {
                        this.argRelevantNodes.put(childStateId, this.createArgNode(childStateId, node, child));
                    }
                    this.argRelevantEdges.put(parentStateId + "->" + childStateId, ReportGenerator.createArgEdge(parentStateId, childStateId, parent.getEdgesToChild(child)));
                }
            }
        }
    }

    private void buildReducedArgGraphData() {
        if (!this.witnessOptional.isPresent()) {
            return;
        }
        Witness witness = this.witnessOptional.orElseThrow();
        WitnessToOutputFormatsUtils.witnessToMapsForHTMLReport(witness, this.argReducedNodes, this.argReducedEdges);
    }

    private Map<String, Object> createArgNode(int parentStateId, CFANode node, ARGState argState) {
        String dotLabel = argState.toDOTLabel().length() > 2 ? argState.toDOTLabel().substring(0, argState.toDOTLabel().length() - 2) : "";
        HashMap<String, Object> argNode = new HashMap<String, Object>();
        argNode.put("index", parentStateId);
        argNode.put("func", node.getFunctionName());
        argNode.put("label", parentStateId + " @ " + node + "\n" + node.getFunctionName() + this.nodeTypeInNodeLabel(node) + "\n" + dotLabel);
        argNode.put("type", this.determineNodeType(argState));
        return argNode;
    }

    private String determineNodeType(ARGState argState) {
        if (argState.isTarget()) {
            return "target";
        }
        if (!argState.wasExpanded()) {
            return "not-expanded";
        }
        if (argState.shouldBeHighlighted()) {
            return "highlighted";
        }
        return "";
    }

    private void createCoveredArgNode(int childStateId, ARGState child, String dotLabel) {
        HashMap<String, Object> nodeData = new HashMap<String, Object>();
        for (CFANode coveredNode : AbstractStates.extractLocations(child)) {
            if (this.argNodes.containsKey(childStateId)) continue;
            nodeData.put("index", childStateId);
            nodeData.put("func", coveredNode.getFunctionName());
            nodeData.put("label", childStateId + " @ " + coveredNode + "\n" + coveredNode.getFunctionName() + this.nodeTypeInNodeLabel(coveredNode) + dotLabel);
            nodeData.put("type", "covered");
            this.argNodes.put(childStateId, nodeData);
        }
    }

    private void createCoveredArgEdge(int parentStateId, int coveringStateId) {
        HashMap<String, Object> coveredEdge = new HashMap<String, Object>();
        coveredEdge.put("source", parentStateId);
        coveredEdge.put("target", coveringStateId);
        coveredEdge.put("label", "covered by");
        coveredEdge.put("type", "covered");
        this.argEdges.put(coveringStateId + "->" + parentStateId, coveredEdge);
    }

    public static Map<String, Object> createArgEdge(int parentStateId, int childStateId, List<CFAEdge> edges) {
        HashMap<String, Object> argEdge = new HashMap<String, Object>();
        argEdge.put("source", parentStateId);
        argEdge.put("target", childStateId);
        StringBuilder edgeLabel = new StringBuilder();
        if (edges.isEmpty()) {
            edgeLabel.append("dummy edge");
            argEdge.put("type", "dummy type");
        } else {
            argEdge.put("type", edges.get(0).getEdgeType().toString());
            if (edges.size() > 1) {
                edgeLabel.append("Lines ");
                edgeLabel.append(edges.get(0).getFileLocation().getStartingLineInOrigin());
                edgeLabel.append(" - ");
                edgeLabel.append(edges.get(edges.size() - 1).getFileLocation().getStartingLineInOrigin());
                edgeLabel.append(":");
                argEdge.put("lines", edgeLabel.substring(6));
            } else {
                edgeLabel.append("Line ");
                edgeLabel.append(edges.get(0).getFileLocation().getStartingLineInOrigin());
                argEdge.put("line", edgeLabel.substring(5));
            }
            for (CFAEdge edge : edges) {
                if (edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                    edgeLabel.append("\n");
                    List edgeText = Splitter.on((char)':').limit(2).splitToList((CharSequence)ReportGenerator.getEdgeText(edge));
                    edgeLabel.append((String)edgeText.get(0));
                    if (edgeText.size() <= 1) continue;
                    edgeLabel.append("\n");
                    edgeLabel.append((String)edgeText.get(1));
                    continue;
                }
                edgeLabel.append("\n");
                edgeLabel.append(ReportGenerator.getEdgeText(edge));
            }
            argEdge.put("file", edges.get(0).getFileLocation().getFileName());
        }
        argEdge.put("label", edgeLabel.toString());
        return argEdge;
    }

    private String nodeTypeInNodeLabel(CFANode node) {
        if (node instanceof FunctionEntryNode) {
            return " entry";
        }
        if (node instanceof FunctionExitNode) {
            return " exit";
        }
        return "";
    }

    private static String getEdgeText(CFAEdge edge) {
        return edge.getDescription().replace("\"", "\\\"").replace('\n', ' ').replaceAll("\\s+", " ").replace(" ;", ";");
    }
}

