/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopAlwaysOperator;
import org.sosy_lab.cpachecker.core.defaults.StopEqualsOperator;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;

public abstract class AbstractCPA
implements ConfigurableProgramAnalysis {
    private final AbstractDomain abstractDomain;
    private final @Nullable String mergeType;
    private final @Nullable String stopType;
    private final @Nullable TransferRelation transferRelation;

    protected AbstractCPA(String mergeType, String stopType, @Nullable TransferRelation transfer) {
        this(mergeType, stopType, new FlatLatticeDomain(), transfer);
    }

    protected AbstractCPA(AbstractDomain domain, TransferRelation transfer) {
        this.abstractDomain = domain;
        this.mergeType = null;
        this.stopType = null;
        this.transferRelation = transfer;
    }

    protected AbstractCPA(String mergeType, String stopType, AbstractDomain domain, @Nullable TransferRelation transfer) {
        this.abstractDomain = domain;
        this.mergeType = mergeType;
        this.stopType = stopType;
        this.transferRelation = transfer;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator((String)Preconditions.checkNotNull((Object)this.mergeType));
    }

    protected MergeOperator buildMergeOperator(String pMergeType) {
        switch (pMergeType.toUpperCase()) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"unknown merge operator");
    }

    @Override
    public StopOperator getStopOperator() {
        return this.buildStopOperator((String)Preconditions.checkNotNull((Object)this.stopType));
    }

    protected StopOperator buildStopOperator(String pStopType) throws AssertionError {
        switch (pStopType.toUpperCase()) {
            case "SEP": {
                return new StopSepOperator(this.getAbstractDomain());
            }
            case "JOIN": {
                return new StopJoinOperator(this.getAbstractDomain());
            }
            case "NEVER": {
                return new StopNeverOperator();
            }
            case "ALWAYS": {
                return new StopAlwaysOperator();
            }
            case "EQUALS": {
                return new StopEqualsOperator();
            }
        }
        throw new AssertionError((Object)"unknown stop operator");
    }

    @Override
    public TransferRelation getTransferRelation() {
        return (TransferRelation)Preconditions.checkNotNull((Object)this.transferRelation);
    }
}

