/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;

public abstract class AbstractCPAFactory
implements CPAFactory {
    private @Nullable LogManager logger = null;
    private @Nullable Configuration configuration = null;
    private @Nullable ShutdownNotifier shutdownNotifier = null;

    @Override
    public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot wrap CPA");
    }

    @Override
    public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot wrap CPAs");
    }

    @Override
    @CanIgnoreReturnValue
    public CPAFactory setConfiguration(Configuration pConfiguration) {
        Preconditions.checkNotNull((Object)pConfiguration);
        Preconditions.checkState((this.configuration == null ? 1 : 0) != 0, (Object)"setConfiguration called twice on CPAFactory");
        this.configuration = pConfiguration;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CPAFactory setLogger(LogManager pLogger) {
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkState((this.logger == null ? 1 : 0) != 0, (Object)"setLogger called twice on CPAFactory");
        this.logger = pLogger;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CPAFactory setShutdownNotifier(ShutdownNotifier pShutdownNotifier) {
        Preconditions.checkNotNull((Object)pShutdownNotifier);
        Preconditions.checkState((this.shutdownNotifier == null ? 1 : 0) != 0, (Object)"setShutdownNotifier called twice on CPAFactory");
        this.shutdownNotifier = pShutdownNotifier;
        return this;
    }

    protected LogManager getLogger() {
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (Object)"LogManager object needed to create CPA");
        return this.logger;
    }

    protected Configuration getConfiguration() {
        Preconditions.checkState((this.configuration != null ? 1 : 0) != 0, (Object)"Configuration object needed to create CPA");
        return this.configuration;
    }

    public ShutdownNotifier getShutdownNotifier() {
        Preconditions.checkState((this.shutdownNotifier != null ? 1 : 0) != 0, (Object)"ShutdownNotifier object needed to create CPA");
        return this.shutdownNotifier;
    }

    @Override
    public <T> CPAFactory set(T pObject, Class<T> pClass) throws UnsupportedOperationException {
        return this;
    }
}

