/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;

public abstract class AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysis,
WrapperCPA,
StatisticsProvider {
    private final ConfigurableProgramAnalysis wrappedCpa;

    protected AbstractSingleWrapperCPA(ConfigurableProgramAnalysis pCpa) {
        Preconditions.checkNotNull((Object)pCpa);
        this.wrappedCpa = pCpa;
    }

    protected ConfigurableProgramAnalysis getWrappedCpa() {
        return this.wrappedCpa;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.wrappedCpa.getAbstractDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.wrappedCpa.getTransferRelation();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.wrappedCpa.getMergeOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.wrappedCpa.getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.wrappedCpa.getPrecisionAdjustment();
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.wrappedCpa.getInitialState(node, partition);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return this.wrappedCpa.getInitialPrecision(pNode, pPartition);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.wrappedCpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.wrappedCpa)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        if (pType.isAssignableFrom(this.wrappedCpa.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this.wrappedCpa));
        }
        if (this.wrappedCpa instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)this.wrappedCpa)).retrieveWrappedCpa(pType);
        }
        return null;
    }

    public ImmutableList<ConfigurableProgramAnalysis> getWrappedCPAs() {
        return ImmutableList.of((Object)this.wrappedCpa);
    }
}

