/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodOrConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodCallEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.Pair;

public abstract class ForwardingTransferRelation<S, T extends AbstractState, P extends Precision>
extends SingleEdgeTransferRelation {
    protected @Nullable T state;
    protected @Nullable P precision;
    protected @Nullable String functionName;
    private static final ImmutableSet<ABinaryExpression.ABinaryOperator> BOOLEAN_BINARY_OPERATORS = ImmutableSet.of((Object)CBinaryExpression.BinaryOperator.EQUALS, (Object)CBinaryExpression.BinaryOperator.NOT_EQUALS, (Object)CBinaryExpression.BinaryOperator.GREATER_EQUAL, (Object)CBinaryExpression.BinaryOperator.GREATER_THAN, (Object)CBinaryExpression.BinaryOperator.LESS_EQUAL, (Object)CBinaryExpression.BinaryOperator.LESS_THAN, (Object[])new ABinaryExpression.ABinaryOperator[]{JBinaryExpression.BinaryOperator.EQUALS, JBinaryExpression.BinaryOperator.NOT_EQUALS, JBinaryExpression.BinaryOperator.GREATER_EQUAL, JBinaryExpression.BinaryOperator.GREATER_THAN, JBinaryExpression.BinaryOperator.LESS_EQUAL, JBinaryExpression.BinaryOperator.LESS_THAN});

    protected T getState() {
        return (T)((AbstractState)Preconditions.checkNotNull(this.state));
    }

    protected P getPrecision() {
        return (P)((Precision)Preconditions.checkNotNull(this.precision));
    }

    protected String getFunctionName() {
        return (String)Preconditions.checkNotNull((Object)this.functionName);
    }

    public Collection<T> getAbstractSuccessorsForEdge(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        S successor;
        this.setInfo(abstractState, abstractPrecision, cfaEdge);
        Collection<T> preCheck = this.preCheck(this.state, this.precision);
        if (preCheck != null) {
            return preCheck;
        }
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumption = (AssumeEdge)cfaEdge;
                successor = this.handleAssumption(assumption, assumption.getExpression(), assumption.getTruthAssumption());
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fnkCall = (FunctionCallEdge)cfaEdge;
                FunctionEntryNode succ = fnkCall.getSuccessor();
                String calledFunctionName = succ.getFunctionName();
                successor = this.handleFunctionCallEdge(fnkCall, fnkCall.getArguments(), succ.getFunctionParameters(), calledFunctionName);
                break;
            }
            case FunctionReturnEdge: {
                String callerFunctionName = cfaEdge.getSuccessor().getFunctionName();
                FunctionReturnEdge fnkReturnEdge = (FunctionReturnEdge)cfaEdge;
                FunctionSummaryEdge summaryEdge = fnkReturnEdge.getSummaryEdge();
                successor = this.handleFunctionReturnEdge(fnkReturnEdge, summaryEdge, summaryEdge.getExpression(), callerFunctionName);
                break;
            }
            case DeclarationEdge: {
                ADeclarationEdge declarationEdge = (ADeclarationEdge)cfaEdge;
                successor = this.handleDeclarationEdge(declarationEdge, declarationEdge.getDeclaration());
                break;
            }
            case StatementEdge: {
                AStatementEdge statementEdge = (AStatementEdge)cfaEdge;
                successor = this.handleStatementEdge(statementEdge, statementEdge.getStatement());
                break;
            }
            case ReturnStatementEdge: {
                AReturnStatementEdge returnEdge = (AReturnStatementEdge)cfaEdge;
                successor = this.handleReturnStatementEdge(returnEdge);
                break;
            }
            case BlankEdge: {
                successor = this.handleBlankEdge((BlankEdge)cfaEdge);
                break;
            }
            case CallToReturnEdge: {
                successor = this.handleFunctionSummaryEdge((FunctionSummaryEdge)cfaEdge);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        Collection<T> result = this.postProcessing(successor, cfaEdge);
        this.resetInfo();
        return result;
    }

    protected void setInfo(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) {
        this.state = abstractState;
        this.precision = abstractPrecision;
        this.functionName = cfaEdge.getPredecessor().getFunctionName();
    }

    protected void resetInfo() {
        this.state = null;
        this.precision = null;
        this.functionName = null;
    }

    protected @Nullable Collection<T> preCheck(T pState, P pPrecision) {
        return null;
    }

    protected Collection<T> postProcessing(@Nullable S successor, CFAEdge edge) {
        if (successor == null) {
            return ImmutableSet.of();
        }
        return Collections.singleton((AbstractState)successor);
    }

    protected @Nullable S handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthAssumption) throws CPATransferException, InterruptedException {
        Pair<AExpression, Boolean> simplifiedExpression = ForwardingTransferRelation.simplifyAssumption(expression, truthAssumption);
        expression = simplifiedExpression.getFirst();
        truthAssumption = simplifiedExpression.getSecond();
        if (cfaEdge instanceof CAssumeEdge) {
            return this.handleAssumption((CAssumeEdge)cfaEdge, (CExpression)expression, truthAssumption);
        }
        if (cfaEdge instanceof JAssumeEdge) {
            return this.handleAssumption((JAssumeEdge)cfaEdge, (JExpression)expression, truthAssumption);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected @Nullable S handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException, InterruptedException {
        return this.notImplemented();
    }

    protected @Nullable S handleAssumption(JAssumeEdge cfaEdge, JExpression expression, boolean truthAssumption) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleFunctionCallEdge(FunctionCallEdge cfaEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        if (cfaEdge instanceof CFunctionCallEdge) {
            return this.handleFunctionCallEdge((CFunctionCallEdge)cfaEdge, arguments, parameters, calledFunctionName);
        }
        if (cfaEdge instanceof JMethodCallEdge) {
            return this.handleFunctionCallEdge((JMethodCallEdge)cfaEdge, arguments, parameters, calledFunctionName);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected S handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> arguments, List<CParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleFunctionCallEdge(JMethodCallEdge cfaEdge, List<JExpression> arguments, List<JParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleFunctionReturnEdge(FunctionReturnEdge cfaEdge, FunctionSummaryEdge fnkCall, AFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        if (cfaEdge instanceof CFunctionReturnEdge) {
            return this.handleFunctionReturnEdge((CFunctionReturnEdge)cfaEdge, (CFunctionSummaryEdge)fnkCall, (CFunctionCall)summaryExpr, callerFunctionName);
        }
        if (cfaEdge instanceof JMethodReturnEdge) {
            return this.handleFunctionReturnEdge((JMethodReturnEdge)cfaEdge, (JMethodSummaryEdge)fnkCall, (JMethodOrConstructorInvocation)summaryExpr, callerFunctionName);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected S handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleFunctionReturnEdge(JMethodReturnEdge cfaEdge, JMethodSummaryEdge fnkCall, JMethodOrConstructorInvocation summaryExpr, String callerFunctionName) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleDeclarationEdge(ADeclarationEdge cfaEdge, ADeclaration decl) throws CPATransferException {
        if (cfaEdge instanceof CDeclarationEdge) {
            return this.handleDeclarationEdge((CDeclarationEdge)cfaEdge, (CDeclaration)decl);
        }
        if (cfaEdge instanceof JDeclarationEdge) {
            return this.handleDeclarationEdge((JDeclarationEdge)cfaEdge, (JDeclaration)decl);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected S handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleDeclarationEdge(JDeclarationEdge cfaEdge, JDeclaration decl) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleStatementEdge(AStatementEdge cfaEdge, AStatement statement) throws CPATransferException {
        if (cfaEdge instanceof CStatementEdge) {
            return this.handleStatementEdge((CStatementEdge)cfaEdge, (CStatement)statement);
        }
        if (cfaEdge instanceof JStatementEdge) {
            return this.handleStatementEdge((JStatementEdge)cfaEdge, (JStatement)statement);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected S handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleStatementEdge(JStatementEdge cfaEdge, JStatement statement) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleReturnStatementEdge(AReturnStatementEdge cfaEdge) throws CPATransferException {
        if (cfaEdge instanceof CReturnStatementEdge) {
            return this.handleReturnStatementEdge((CReturnStatementEdge)cfaEdge);
        }
        if (cfaEdge instanceof JReturnStatementEdge) {
            return this.handleReturnStatementEdge((JReturnStatementEdge)cfaEdge);
        }
        throw new AssertionError((Object)"unknown edge");
    }

    protected S handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleReturnStatementEdge(JReturnStatementEdge cfaEdge) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleBlankEdge(BlankEdge cfaEdge) throws CPATransferException {
        return (S)this.state;
    }

    protected S handleFunctionSummaryEdge(FunctionSummaryEdge cfaEdge) throws CPATransferException {
        if (cfaEdge instanceof CFunctionSummaryEdge) {
            return this.handleFunctionSummaryEdge((CFunctionSummaryEdge)cfaEdge);
        }
        if (cfaEdge instanceof JMethodSummaryEdge) {
            return this.handleFunctionSummaryEdge((JMethodSummaryEdge)cfaEdge);
        }
        throw new AssertionError((Object)"unkown error");
    }

    protected S handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        return this.notImplemented();
    }

    protected S handleFunctionSummaryEdge(JMethodSummaryEdge cfaEdge) throws CPATransferException {
        return this.notImplemented();
    }

    public static boolean isGlobal(AExpression exp) {
        if (exp instanceof CExpression) {
            return ForwardingTransferRelation.isGlobal((CExpression)exp);
        }
        if (exp instanceof JExpression) {
            return ForwardingTransferRelation.isGlobal((JExpression)exp);
        }
        throw new AssertionError((Object)("unknown expression: " + exp));
    }

    protected static boolean isGlobal(CExpression exp) {
        CSimpleDeclaration decl;
        if (exp instanceof CIdExpression && (decl = ((CIdExpression)exp).getDeclaration()) instanceof CDeclaration) {
            return ((CDeclaration)decl).isGlobal();
        }
        return false;
    }

    protected static boolean isGlobal(JExpression exp) {
        JSimpleDeclaration decl;
        if (exp instanceof JIdExpression && (decl = ((JIdExpression)exp).getDeclaration()) instanceof ADeclaration) {
            return ((ADeclaration)((Object)decl)).isGlobal();
        }
        return false;
    }

    protected static Pair<AExpression, Boolean> simplifyAssumption(AExpression pExpression, boolean pAssumeTruth) {
        if (ForwardingTransferRelation.isBooleanExpression(pExpression) && pExpression instanceof CBinaryExpression) {
            CBinaryExpression binExp = (CBinaryExpression)pExpression;
            CBinaryExpression.BinaryOperator operator = binExp.getOperator();
            if (ForwardingTransferRelation.isBooleanExpression(binExp.getOperand1()) && binExp.getOperand2().equals(CIntegerLiteralExpression.ZERO)) {
                if (operator == CBinaryExpression.BinaryOperator.EQUALS) {
                    return ForwardingTransferRelation.simplifyAssumption(binExp.getOperand1(), !pAssumeTruth);
                }
                if (operator == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    return ForwardingTransferRelation.simplifyAssumption(binExp.getOperand1(), pAssumeTruth);
                }
            } else if (ForwardingTransferRelation.isBooleanExpression(binExp.getOperand2()) && binExp.getOperand1().equals(CIntegerLiteralExpression.ZERO)) {
                if (operator == CBinaryExpression.BinaryOperator.EQUALS) {
                    return ForwardingTransferRelation.simplifyAssumption(binExp.getOperand2(), !pAssumeTruth);
                }
                if (operator == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    return ForwardingTransferRelation.simplifyAssumption(binExp.getOperand2(), pAssumeTruth);
                }
            }
        }
        return Pair.of(pExpression, pAssumeTruth);
    }

    private static boolean isBooleanExpression(AExpression pExpression) {
        return pExpression instanceof ABinaryExpression && BOOLEAN_BINARY_OPERATORS.contains((Object)((ABinaryExpression)pExpression).getOperator());
    }

    private S notImplemented() throws AssertionError {
        throw new AssertionError((Object)("this method is not implemented in subclass " + this.getClass().getSimpleName()));
    }
}

