/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public abstract class MultiStatistics
implements Statistics {
    private final Collection<Statistics> subStats = new CopyOnWriteArrayList<Statistics>();
    protected final LogManager logger;

    protected MultiStatistics(LogManager pLogger) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
    }

    public Collection<Statistics> getSubStatistics() {
        return this.subStats;
    }

    public void resetSubStatistics() {
        this.subStats.clear();
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        for (Statistics s : this.subStats) {
            StatisticsUtils.printStatistics(s, out, this.logger, result, reached);
        }
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        for (Statistics s : this.subStats) {
            StatisticsUtils.writeOutputFiles(s, this.logger, pResult, pReached);
        }
    }
}

