/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults.precision;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

@Options(prefix="precision")
public class ConfigurablePrecision
extends VariableTrackingPrecision {
    @Option(secure=true, name="variableBlacklist", description="blacklist regex for variables that won't be tracked by the CPA using this precision")
    private Pattern variableBlacklist = Pattern.compile("");
    @Option(secure=true, name="variableWhitelist", description="whitelist regex for variables that will always be tracked by the CPA using this precision")
    private Pattern variableWhitelist = Pattern.compile("");
    @Option(secure=true, description="If this option is used, booleans from the cfa are tracked.")
    private boolean trackBooleanVariables = true;
    @Option(secure=true, description="If this option is used, variables that are only compared for equality are tracked.")
    private boolean trackIntEqualVariables = true;
    @Option(secure=true, description="If this option is used, variables, that are only used in simple calculations (add, sub, lt, gt, eq) are tracked.")
    private boolean trackIntAddVariables = true;
    @Option(secure=true, description="If this option is used, variables that have type double or float are tracked.")
    private boolean trackFloatVariables = true;
    @Option(secure=true, description="If this option is used, variables that are addressed may get tracked depending on the rest of the precision. When this option is disabled, a variable that is addressed is definitely not tracked.")
    private boolean trackAddressedVariables = true;
    @Option(secure=true, description="If this option is used, all variables that are of a different classification than IntAdd, IntEq and Boolean get tracked by the precision.")
    private boolean trackVariablesBesidesEqAddBool = true;
    @Option(secure=true, description="If this option is used, variables that are irrelevantare also tracked.")
    private boolean trackIrrelevantVariables = true;
    private final Optional<VariableClassification> vc;
    private final Class<? extends ConfigurableProgramAnalysis> cpaClass;

    ConfigurablePrecision(Configuration config, Optional<VariableClassification> pVc, Class<? extends ConfigurableProgramAnalysis> cpaClass) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cpaClass = cpaClass;
        this.vc = pVc;
    }

    @Override
    public boolean allowsAbstraction() {
        return !this.trackIrrelevantVariables || !this.trackBooleanVariables || !this.trackIntEqualVariables || !this.trackIntAddVariables || !this.trackAddressedVariables || !this.trackVariablesBesidesEqAddBool || !this.variableBlacklist.toString().isEmpty();
    }

    @Override
    public boolean isTracking(MemoryLocation pVariable, Type pType, CFANode location) {
        if (this.trackFloatVariables) {
            return this.isTracking(pVariable);
        }
        return !(pType instanceof CSimpleType && ((CSimpleType)pType).getType().isFloatingPointType() || pType instanceof JSimpleType && ((JSimpleType)pType).getType().isFloatingPointType() || !this.isTracking(pVariable));
    }

    private boolean isTracking(MemoryLocation pVariable) {
        if (this.isOnWhitelist(pVariable.getIdentifier())) {
            return true;
        }
        if (this.isOnBlacklist(pVariable.getIdentifier())) {
            return false;
        }
        if (pVariable.isReference()) {
            MemoryLocation owner = pVariable.getReferenceStart();
            return this.isInTrackedVarClass(owner.getExtendedQualifiedName());
        }
        return this.isInTrackedVarClass(pVariable.getExtendedQualifiedName());
    }

    private boolean isOnBlacklist(String variable) {
        return !this.variableBlacklist.toString().isEmpty() && this.variableBlacklist.matcher(variable).matches();
    }

    private boolean isOnWhitelist(String variable) {
        return !this.variableWhitelist.toString().isEmpty() && this.variableWhitelist.matcher(variable).matches();
    }

    private boolean isInTrackedVarClass(String variableName) {
        if (!this.vc.isPresent()) {
            return true;
        }
        VariableClassification varClass = this.vc.orElseThrow();
        boolean varIsAddressed = varClass.getAddressedVariables().contains(variableName);
        if (varIsAddressed && !this.trackAddressedVariables) {
            return false;
        }
        if (!this.trackIrrelevantVariables && !varClass.getRelevantVariables().contains(variableName)) {
            return false;
        }
        boolean varIsBoolean = varClass.getIntBoolVars().contains(variableName);
        if (this.trackBooleanVariables && varIsBoolean) {
            return true;
        }
        boolean varIsIntEqual = varClass.getIntEqualVars().contains(variableName);
        if (this.trackIntEqualVariables && varIsIntEqual) {
            return true;
        }
        boolean varIsIntAdd = varClass.getIntAddVars().contains(variableName);
        if (this.trackIntAddVariables && varIsIntAdd) {
            return true;
        }
        if (!(varIsBoolean || varIsIntAdd || varIsIntEqual)) {
            return this.trackVariablesBesidesEqAddBool;
        }
        return false;
    }

    @Override
    public VariableTrackingPrecision withIncrement(Multimap<CFANode, MemoryLocation> pIncrement) {
        return this;
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        writer.write("# configured precision used - nothing to show here");
    }

    @Override
    @CanIgnoreReturnValue
    public VariableTrackingPrecision join(VariableTrackingPrecision consolidatedPrecision) {
        Preconditions.checkArgument((boolean)this.getClass().equals(consolidatedPrecision.getClass()));
        return this;
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public boolean isEmpty() {
        if (!this.variableWhitelist.toString().isEmpty()) {
            return false;
        }
        if (!this.vc.isPresent()) {
            return true;
        }
        VariableClassification varClass = this.vc.orElseThrow();
        boolean trackSomeIntBools = this.trackBooleanVariables && !varClass.getIntBoolVars().isEmpty();
        boolean trackSomeIntEquals = this.trackIntEqualVariables && !varClass.getIntEqualVars().isEmpty();
        boolean trackSomeIntAdds = this.trackIntAddVariables && !varClass.getIntAddVars().isEmpty();
        return !trackSomeIntBools && !trackSomeIntEquals && !trackSomeIntAdds && !this.trackVariablesBesidesEqAddBool;
    }

    @Override
    protected Class<? extends ConfigurableProgramAnalysis> getCPAClass() {
        return this.cpaClass;
    }

    @Override
    public boolean tracksTheSameVariablesAs(VariableTrackingPrecision pOtherPrecision) {
        if (pOtherPrecision.getClass().equals(this.getClass())) {
            ConfigurablePrecision precisionCompare = (ConfigurablePrecision)pOtherPrecision;
            if (this.variableBlacklist.equals(precisionCompare.variableBlacklist) && this.variableWhitelist.equals(precisionCompare.variableWhitelist) && this.trackBooleanVariables == precisionCompare.trackBooleanVariables && this.trackIntEqualVariables == precisionCompare.trackIntEqualVariables && this.trackIntAddVariables == precisionCompare.trackIntAddVariables && this.trackFloatVariables == precisionCompare.trackFloatVariables && this.trackAddressedVariables == precisionCompare.trackAddressedVariables && this.vc.isPresent() == precisionCompare.vc.isPresent() && this.vc.isPresent() && this.vc.orElseThrow().equals(precisionCompare.vc.orElseThrow()) && this.cpaClass.equals(precisionCompare.cpaClass)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ConfigurablePrecision && this.tracksTheSameVariablesAs((ConfigurablePrecision)other);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.variableBlacklist, this.variableWhitelist, this.trackBooleanVariables, this.trackIntEqualVariables, this.trackIntAddVariables, this.trackFloatVariables, this.trackAddressedVariables);
    }

    public String toString() {
        return MoreObjects.toStringHelper(ConfigurablePrecision.class).add("CPA", (Object)this.cpaClass.getSimpleName()).add("blacklist", (Object)this.variableBlacklist).add("whitelist", (Object)this.variableWhitelist).add("trackBooleanVariables", this.trackBooleanVariables).add("trackIntEqualVariables", this.trackIntEqualVariables).add("trackIntAddVariables", this.trackIntAddVariables).add("trackFloatVariables", this.trackFloatVariables).add("trackAddressedVariables", this.trackAddressedVariables).toString();
    }
}

