/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults.precision;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.defaults.precision.RefinablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class LocalizedRefinablePrecision
extends RefinablePrecision {
    private final ImmutableSetMultimap<CFANode, MemoryLocation> rawPrecision;

    LocalizedRefinablePrecision(VariableTrackingPrecision pBaseline) {
        super(pBaseline);
        this.rawPrecision = ImmutableSetMultimap.of();
    }

    private LocalizedRefinablePrecision(VariableTrackingPrecision pBaseline, ImmutableSetMultimap<CFANode, MemoryLocation> pRawPrecision) {
        super(pBaseline);
        this.rawPrecision = pRawPrecision;
    }

    @Override
    public LocalizedRefinablePrecision withIncrement(Multimap<CFANode, MemoryLocation> increment) {
        if (this.rawPrecision.entries().containsAll(increment.entries())) {
            return this;
        }
        ImmutableSetMultimap refinedPrec = LocalizedRefinablePrecision.createBuilder().putAll(this.rawPrecision).putAll(increment).build();
        return new LocalizedRefinablePrecision(super.getBaseline(), (ImmutableSetMultimap<CFANode, MemoryLocation>)refinedPrec);
    }

    private static ImmutableSetMultimap.Builder<CFANode, MemoryLocation> createBuilder() {
        return ImmutableSetMultimap.builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        for (CFANode currentLocation : this.rawPrecision.keySet()) {
            writer.write("\n" + currentLocation + ":\n");
            for (MemoryLocation variable : this.rawPrecision.get((Object)currentLocation)) {
                writer.write(variable.getExtendedQualifiedName() + "\n");
            }
        }
    }

    @Override
    public VariableTrackingPrecision join(VariableTrackingPrecision pConsolidatedPrecision) {
        Preconditions.checkArgument((boolean)this.getClass().equals(pConsolidatedPrecision.getClass()));
        LocalizedRefinablePrecision consolidatedPrecision = (LocalizedRefinablePrecision)pConsolidatedPrecision;
        Preconditions.checkArgument((boolean)super.getBaseline().equals(consolidatedPrecision.getBaseline()));
        ImmutableSetMultimap joinedPrec = LocalizedRefinablePrecision.createBuilder().putAll(this.rawPrecision).putAll(consolidatedPrecision.rawPrecision).build();
        return new LocalizedRefinablePrecision(super.getBaseline(), (ImmutableSetMultimap<CFANode, MemoryLocation>)ImmutableSetMultimap.copyOf((Multimap)joinedPrec));
    }

    @Override
    public int getSize() {
        return this.rawPrecision.size();
    }

    public String toString() {
        return this.rawPrecision.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.rawPrecision.isEmpty();
    }

    @Override
    public boolean isTracking(MemoryLocation pVariable, Type pType, CFANode pLocation) {
        return super.isTracking(pVariable, pType, pLocation) && this.rawPrecision.containsEntry((Object)pLocation, (Object)pVariable);
    }

    @Override
    public boolean tracksTheSameVariablesAs(VariableTrackingPrecision pOtherPrecision) {
        return pOtherPrecision.getClass().equals(this.getClass()) && super.getBaseline().equals(((LocalizedRefinablePrecision)pOtherPrecision).getBaseline()) && this.rawPrecision.equals(((LocalizedRefinablePrecision)pOtherPrecision).rawPrecision);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof LocalizedRefinablePrecision && this.rawPrecision.equals(((LocalizedRefinablePrecision)other).rawPrecision);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.rawPrecision.hashCode();
    }
}

