/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults.precision;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.defaults.precision.RefinablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ScopedRefinablePrecision
extends RefinablePrecision {
    private final ImmutableSortedSet<MemoryLocation> rawPrecision;

    ScopedRefinablePrecision(VariableTrackingPrecision pBaseline) {
        super(pBaseline);
        this.rawPrecision = ImmutableSortedSet.of();
    }

    private ScopedRefinablePrecision(VariableTrackingPrecision pBaseline, Iterable<MemoryLocation> pRawPrecision) {
        super(pBaseline);
        this.rawPrecision = ImmutableSortedSet.copyOf(pRawPrecision);
    }

    @Override
    public ScopedRefinablePrecision withIncrement(Multimap<CFANode, MemoryLocation> increment) {
        if (this.rawPrecision.containsAll(increment.values())) {
            return this;
        }
        Iterable refinedPrec = Iterables.concat(this.rawPrecision, (Iterable)increment.values());
        return new ScopedRefinablePrecision(super.getBaseline(), refinedPrec);
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        ArrayList<String> globals = new ArrayList<String>();
        String previousScope = null;
        for (MemoryLocation variable : this.rawPrecision) {
            if (variable.isOnFunctionStack()) {
                String functionName = variable.getFunctionName();
                if (!functionName.equals(previousScope)) {
                    writer.write("\n" + functionName + ":\n");
                }
                writer.write(variable.getExtendedQualifiedName() + "\n");
                previousScope = functionName;
                continue;
            }
            globals.add(variable.getExtendedQualifiedName());
        }
        if (previousScope != null) {
            writer.write("\n");
        }
        writer.write("*:\n" + Joiner.on((String)"\n").join(globals));
    }

    @Override
    public VariableTrackingPrecision join(VariableTrackingPrecision pConsolidatedPrecision) {
        Preconditions.checkArgument((boolean)this.getClass().equals(pConsolidatedPrecision.getClass()));
        ScopedRefinablePrecision consolidatedPrecision = (ScopedRefinablePrecision)pConsolidatedPrecision;
        Preconditions.checkArgument((boolean)super.getBaseline().equals(consolidatedPrecision.getBaseline()));
        Iterable joinedPrec = Iterables.concat(this.rawPrecision, consolidatedPrecision.rawPrecision);
        return new ScopedRefinablePrecision(super.getBaseline(), joinedPrec);
    }

    @Override
    public int getSize() {
        return this.rawPrecision.size();
    }

    public String toString() {
        return this.rawPrecision.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.rawPrecision.isEmpty();
    }

    @Override
    public boolean isTracking(MemoryLocation pVariable, Type pType, CFANode pLocation) {
        return super.isTracking(pVariable, pType, pLocation) && this.rawPrecision.contains((Object)pVariable);
    }

    @Override
    public boolean tracksTheSameVariablesAs(VariableTrackingPrecision pOtherPrecision) {
        return pOtherPrecision.getClass().equals(this.getClass()) && super.getBaseline().equals(((ScopedRefinablePrecision)pOtherPrecision).getBaseline()) && this.rawPrecision.equals(((ScopedRefinablePrecision)pOtherPrecision).rawPrecision);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof ScopedRefinablePrecision && this.rawPrecision.equals(((ScopedRefinablePrecision)other).rawPrecision);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.rawPrecision.hashCode();
    }
}

