/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults.precision;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.ForOverride;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.defaults.precision.ConfigurablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.LocalizedRefinablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.ScopedRefinablePrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public abstract class VariableTrackingPrecision
implements Precision {
    public static VariableTrackingPrecision createStaticPrecision(Configuration config, Optional<VariableClassification> vc, Class<? extends ConfigurableProgramAnalysis> cpaClass) throws InvalidConfigurationException {
        return new ConfigurablePrecision(config, vc, cpaClass);
    }

    public static VariableTrackingPrecision joinVariableTrackingPrecisionsInReachedSet(UnmodifiableReachedSet reached) {
        Preconditions.checkArgument((reached != null ? 1 : 0) != 0);
        VariableTrackingPrecision joinedPrecision = null;
        for (Precision precision : reached.getPrecisions()) {
            VariableTrackingPrecision prec = Precisions.extractPrecisionByType(precision, VariableTrackingPrecision.class);
            if (prec == null) continue;
            if (joinedPrecision == null) {
                joinedPrecision = prec;
                continue;
            }
            joinedPrecision = joinedPrecision.join(prec);
        }
        return joinedPrecision;
    }

    public static VariableTrackingPrecision createRefineablePrecision(Configuration config, VariableTrackingPrecision pBaseline) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pBaseline);
        RefinablePrecisionOptions options = new RefinablePrecisionOptions(config);
        switch (options.sharing) {
            case LOCATION: {
                return new LocalizedRefinablePrecision(pBaseline);
            }
            case SCOPE: {
                return new ScopedRefinablePrecision(pBaseline);
            }
        }
        throw new AssertionError((Object)"Unhandled case in switch statement");
    }

    public static Predicate<Precision> isMatchingCPAClass(Class<? extends ConfigurableProgramAnalysis> cpaClass) {
        return pPrecision -> pPrecision instanceof VariableTrackingPrecision && ((VariableTrackingPrecision)pPrecision).getCPAClass() == cpaClass;
    }

    public abstract boolean allowsAbstraction();

    public abstract boolean isTracking(MemoryLocation var1, Type var2, CFANode var3);

    public abstract VariableTrackingPrecision withIncrement(Multimap<CFANode, MemoryLocation> var1);

    public abstract int getSize();

    public abstract void serialize(Writer var1) throws IOException;

    public abstract VariableTrackingPrecision join(VariableTrackingPrecision var1);

    public abstract boolean tracksTheSameVariablesAs(VariableTrackingPrecision var1);

    public abstract boolean isEmpty();

    @ForOverride
    protected abstract Class<? extends ConfigurableProgramAnalysis> getCPAClass();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Options(prefix="precision")
    private static class RefinablePrecisionOptions {
        @Option(secure=true, description="whether to track relevant variables only at the exact program location (sharing=location), or within their respective (function-/global-) scope (sharing=scoped).")
        private Sharing sharing = Sharing.SCOPE;

        private RefinablePrecisionOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        static enum Sharing {
            SCOPE,
            LOCATION;

        }
    }
}

