/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.interfaces;

import com.google.common.testing.ClassSanityTester;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;

public class PrecisionAdjustmentResultTest {
    @Test
    public void testCreation() {
        AbstractState state = (AbstractState)Mockito.mock(AbstractState.class);
        Precision precision = (Precision)Mockito.mock(Precision.class);
        PrecisionAdjustmentResult.Action action = PrecisionAdjustmentResult.Action.BREAK;
        PrecisionAdjustmentResult r = PrecisionAdjustmentResult.create(state, precision, action);
        Truth.assertThat((Object)r.abstractState()).isSameInstanceAs((Object)state);
        Truth.assertThat((Object)r.precision()).isSameInstanceAs((Object)precision);
        Truth.assertThat((Comparable)((Object)r.action())).isSameInstanceAs((Object)action);
    }

    @Test
    public void testEquals() {
        new ClassSanityTester().testEquals(PrecisionAdjustmentResult.class);
    }

    @Test
    public void testNulls() {
        new ClassSanityTester().testNulls(PrecisionAdjustmentResult.class);
    }

    @Test
    public void testWithAbstractState() {
        PrecisionAdjustmentResult r1 = PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustmentResult.Action.CONTINUE);
        AbstractState newState = (AbstractState)Mockito.mock(AbstractState.class);
        PrecisionAdjustmentResult r2 = r1.withAbstractState(newState);
        Truth.assertThat((Object)r2.abstractState()).isSameInstanceAs((Object)newState);
        Truth.assertThat((Object)r2.precision()).isSameInstanceAs((Object)r1.precision());
        Truth.assertThat((Comparable)((Object)r2.action())).isSameInstanceAs((Object)r1.action());
        Truth.assertThat((Object)r2.abstractState()).isNotEqualTo((Object)r1.abstractState());
        Truth.assertThat((Object)r2).isNotEqualTo((Object)r1);
    }

    @Test
    public void testWithPrecision() {
        PrecisionAdjustmentResult r1 = PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustmentResult.Action.CONTINUE);
        Precision newPrecision = (Precision)Mockito.mock(Precision.class);
        PrecisionAdjustmentResult r2 = r1.withPrecision(newPrecision);
        Truth.assertThat((Object)r2.abstractState()).isSameInstanceAs((Object)r1.abstractState());
        Truth.assertThat((Object)r2.precision()).isSameInstanceAs((Object)newPrecision);
        Truth.assertThat((Comparable)((Object)r2.action())).isSameInstanceAs((Object)r1.action());
        Truth.assertThat((Object)r2.precision()).isNotEqualTo((Object)r1.precision());
        Truth.assertThat((Object)r2).isNotEqualTo((Object)r1);
    }

    @Test
    public void testWithAction() {
        PrecisionAdjustmentResult r1 = PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustmentResult.Action.CONTINUE);
        PrecisionAdjustmentResult.Action newAction = PrecisionAdjustmentResult.Action.BREAK;
        PrecisionAdjustmentResult r2 = r1.withAction(newAction);
        Truth.assertThat((Object)r2.abstractState()).isSameInstanceAs((Object)r1.abstractState());
        Truth.assertThat((Object)r2.precision()).isSameInstanceAs((Object)r1.precision());
        Truth.assertThat((Comparable)((Object)r2.action())).isSameInstanceAs((Object)newAction);
        Truth.assertThat((Comparable)((Object)r2.action())).isNotEqualTo((Object)r1.action());
        Truth.assertThat((Object)r2).isNotEqualTo((Object)r1);
    }
}

