/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.interfaces.pcc;

import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public interface ProofChecker {
    public boolean areAbstractSuccessors(AbstractState var1, CFAEdge var2, Collection<? extends AbstractState> var3) throws CPATransferException, InterruptedException;

    public boolean isCoveredBy(AbstractState var1, AbstractState var2) throws CPAException, InterruptedException;

    public static interface ProofCheckerCPA
    extends ConfigurableProgramAnalysis,
    ProofChecker {
        @Override
        default public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
            try {
                Collection<? extends AbstractState> computedSuccessors = this.getTransferRelation().getAbstractSuccessorsForEdge(pState, SingletonPrecision.getInstance(), pCfaEdge);
                for (AbstractState abstractState : computedSuccessors) {
                    boolean found = false;
                    for (AbstractState abstractState2 : pSuccessors) {
                        if (!this.isCoveredBy(abstractState, abstractState2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            catch (CPAException e) {
                throw new CPATransferException("Cannot compare abstract successors", e);
            }
            return true;
        }

        @Override
        default public boolean isCoveredBy(AbstractState state, AbstractState otherState) throws CPAException, InterruptedException {
            return this.getAbstractDomain().isLessOrEqual(state, otherState);
        }
    }
}

