/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public abstract class AggregatedReachedSets {
    private AggregatedReachedSets() {
    }

    public static AggregatedReachedSets empty() {
        return new SimpleAggregatedReachedSets((ImmutableSet<UnmodifiableReachedSet>)ImmutableSet.of());
    }

    public static AggregatedReachedSets singleton(UnmodifiableReachedSet pReachedSet) {
        return new SimpleAggregatedReachedSets((ImmutableSet<UnmodifiableReachedSet>)ImmutableSet.of((Object)pReachedSet));
    }

    public abstract Set<UnmodifiableReachedSet> snapShot();

    public static class AggregatedReachedSetManager {
        private final AggregatedThreadedReachedSets reachedView = new AggregatedThreadedReachedSets();

        public void addReachedSet(UnmodifiableReachedSet reached) {
            this.reachedView.addReachedSet(reached);
        }

        public void updateReachedSet(UnmodifiableReachedSet oldReached, UnmodifiableReachedSet newReached) {
            this.reachedView.updateReachedSet(oldReached, newReached);
        }

        public AggregatedReachedSets asView() {
            return this.reachedView;
        }

        public void addAggregated(AggregatedReachedSets pAggregatedReachedSets) {
            this.reachedView.addAggregated(pAggregatedReachedSets);
        }
    }

    private static class AggregatedThreadedReachedSets
    extends AggregatedReachedSets {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private final Set<UnmodifiableReachedSet> reachedSets = new LinkedHashSet<UnmodifiableReachedSet>();
        @GuardedBy(value="lock")
        private final List<AggregatedThreadedReachedSets> otherAggregators = new ArrayList<AggregatedThreadedReachedSets>();

        private AggregatedThreadedReachedSets() {
        }

        @Override
        public Set<UnmodifiableReachedSet> snapShot() {
            this.lock.readLock().lock();
            try {
                ImmutableSet immutableSet = ImmutableSet.builder().addAll(this.reachedSets).addAll((Iterable)FluentIterable.from(this.otherAggregators).transformAndConcat(AggregatedReachedSets::snapShot)).build();
                return immutableSet;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void addReachedSet(UnmodifiableReachedSet reached) {
            this.lock.writeLock().lock();
            try {
                this.reachedSets.add(reached);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void updateReachedSet(UnmodifiableReachedSet oldReached, UnmodifiableReachedSet newReached) {
            this.lock.writeLock().lock();
            try {
                this.reachedSets.remove(oldReached);
                this.reachedSets.add(newReached);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void addAggregated(AggregatedReachedSets pAggregatedReachedSets) {
            this.lock.writeLock().lock();
            try {
                if (pAggregatedReachedSets instanceof AggregatedThreadedReachedSets) {
                    this.otherAggregators.add((AggregatedThreadedReachedSets)pAggregatedReachedSets);
                } else {
                    this.reachedSets.addAll(pAggregatedReachedSets.snapShot());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static class SimpleAggregatedReachedSets
    extends AggregatedReachedSets {
        private final ImmutableSet<UnmodifiableReachedSet> reachedSets;

        private SimpleAggregatedReachedSets(ImmutableSet<UnmodifiableReachedSet> pReachedSets) {
            this.reachedSets = pReachedSets;
        }

        @Override
        public Set<UnmodifiableReachedSet> snapShot() {
            return this.reachedSets;
        }
    }
}

