/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.AbstractSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;

class DefaultReachedSet
implements ReachedSet {
    private final ConfigurableProgramAnalysis cpa;
    private final Map<AbstractState, Precision> reached;
    private final Set<AbstractState> unmodifiableReached;
    private @Nullable AbstractState lastState = null;
    private @Nullable AbstractState firstState = null;
    private final Waitlist waitlist;

    DefaultReachedSet(ConfigurableProgramAnalysis pCpa, Waitlist.WaitlistFactory waitlistFactory) {
        this.cpa = (ConfigurableProgramAnalysis)Preconditions.checkNotNull((Object)pCpa);
        this.reached = new LinkedHashMap<AbstractState, Precision>();
        this.unmodifiableReached = Collections.unmodifiableSet(this.reached.keySet());
        this.waitlist = waitlistFactory.createWaitlistInstance();
    }

    @Override
    public void add(AbstractState state, Precision precision) {
        this.add(state, precision, true);
    }

    @Override
    public void addNoWaitlist(AbstractState state, Precision precision) {
        this.add(state, precision, false);
    }

    private void add(AbstractState state, Precision precision, boolean updateWaitlist) {
        Precision previousPrecision;
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkNotNull((Object)precision);
        if (this.reached.isEmpty()) {
            this.firstState = state;
        }
        if ((previousPrecision = this.reached.put(state, precision)) == null) {
            if (updateWaitlist) {
                this.waitlist.add(state);
            }
            this.lastState = state;
        } else if (!precision.equals(previousPrecision)) {
            this.reached.put(state, previousPrecision);
            throw new IllegalArgumentException("State added to reached set which is already contained, but with a different precision");
        }
    }

    @Override
    public void addAll(Iterable<Pair<AbstractState, Precision>> toAdd) {
        for (Pair<AbstractState, Precision> pair : toAdd) {
            this.add(pair.getFirst(), pair.getSecond());
        }
    }

    @Override
    public void reAddToWaitlist(AbstractState s) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkArgument((boolean)this.reached.containsKey(s), (Object)"State has to be in the reached set");
        if (!this.waitlist.contains(s)) {
            this.waitlist.add(s);
        }
    }

    @Override
    public void updatePrecision(AbstractState s, Precision newPrecision) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkNotNull((Object)newPrecision);
        Precision oldPrecision = this.reached.put(s, newPrecision);
        if (oldPrecision == null) {
            this.reached.remove(s);
            throw new IllegalArgumentException("State needs to be in the reached set in order to change the precision.");
        }
    }

    @Override
    public void remove(AbstractState state) {
        Preconditions.checkNotNull((Object)state);
        int hc = state.hashCode();
        if (this.firstState != null && hc == this.firstState.hashCode() && state.equals(this.firstState)) {
            this.firstState = null;
        }
        if (this.lastState != null && hc == this.lastState.hashCode() && state.equals(this.lastState)) {
            this.lastState = null;
        }
        this.waitlist.remove(state);
        this.reached.remove(state);
    }

    @Override
    public void removeAll(Iterable<? extends AbstractState> toRemove) {
        for (AbstractState abstractState : toRemove) {
            this.remove(abstractState);
        }
    }

    @Override
    public void removeOnlyFromWaitlist(AbstractState state) {
        Preconditions.checkNotNull((Object)state);
        this.waitlist.remove(state);
    }

    @Override
    public void clear() {
        this.firstState = null;
        this.lastState = null;
        this.waitlist.clear();
        this.reached.clear();
    }

    @Override
    public void clearWaitlist() {
        this.waitlist.clear();
    }

    @Override
    public Set<AbstractState> asCollection() {
        return this.unmodifiableReached;
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return this.unmodifiableReached.iterator();
    }

    @Override
    public Stream<AbstractState> stream() {
        return this.reached.keySet().stream();
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections.unmodifiableCollection(this.reached.values());
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState state) {
        Preconditions.checkNotNull((Object)state);
        return this.asCollection();
    }

    @Override
    public Collection<AbstractState> getReached(CFANode location) {
        Preconditions.checkNotNull((Object)location);
        return this.asCollection();
    }

    @Override
    public @Nullable AbstractState getFirstState() {
        return this.firstState;
    }

    @Override
    public AbstractState getLastState() {
        return this.lastState;
    }

    @Override
    public boolean hasWaitingState() {
        return !this.waitlist.isEmpty();
    }

    @Override
    public Collection<AbstractState> getWaitlist() {
        return new AbstractCollection<AbstractState>(){

            @Override
            public Iterator<AbstractState> iterator() {
                return Iterators.unmodifiableIterator(DefaultReachedSet.this.waitlist.iterator());
            }

            @Override
            public boolean contains(Object obj) {
                if (!(obj instanceof AbstractState)) {
                    return false;
                }
                return DefaultReachedSet.this.waitlist.contains((AbstractState)obj);
            }

            @Override
            public boolean isEmpty() {
                return DefaultReachedSet.this.waitlist.isEmpty();
            }

            @Override
            public int size() {
                return DefaultReachedSet.this.waitlist.size();
            }

            @Override
            public String toString() {
                return DefaultReachedSet.this.waitlist.toString();
            }
        };
    }

    @Override
    public AbstractState popFromWaitlist() {
        return this.waitlist.pop();
    }

    @Override
    public Precision getPrecision(AbstractState state) {
        Preconditions.checkNotNull((Object)state);
        Precision prec = this.reached.get(state);
        Preconditions.checkArgument((prec != null ? 1 : 0) != 0, (String)"State not in reached set:\n%s", (Object)state);
        return prec;
    }

    @Override
    public void forEach(BiConsumer<? super AbstractState, ? super Precision> pAction) {
        this.reached.forEach(pAction);
    }

    @Override
    public boolean contains(AbstractState state) {
        Preconditions.checkNotNull((Object)state);
        return this.reached.containsKey(state);
    }

    @Override
    public int size() {
        return this.reached.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.reached.keySet().toString();
    }

    @Override
    public ImmutableMap<String, AbstractStatValue> getStatistics() {
        if (this.waitlist instanceof AbstractSortedWaitlist) {
            return ImmutableMap.copyOf(((AbstractSortedWaitlist)this.waitlist).getDelegationCounts());
        }
        return ImmutableMap.of();
    }

    @Override
    public ConfigurableProgramAnalysis getCPA() {
        return this.cpa;
    }
}

