/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;

public class HistoryForwardingReachedSet
extends ForwardingReachedSet {
    private final List<ReachedSet> usedReachedSets = new ArrayList<ReachedSet>();
    private final List<ConfigurableProgramAnalysis> cpas = new ArrayList<ConfigurableProgramAnalysis>();

    public HistoryForwardingReachedSet(ReachedSet pDelegate) {
        super(pDelegate);
    }

    @Override
    public void setDelegate(ReachedSet pDelegate) {
        super.setDelegate(pDelegate);
        this.usedReachedSets.add(pDelegate);
    }

    public List<ReachedSet> getAllReachedSetsUsedAsDelegates() {
        return ImmutableList.copyOf(this.usedReachedSets);
    }

    public void saveCPA(ConfigurableProgramAnalysis pCurrentCpa) {
        Preconditions.checkNotNull((Object)pCurrentCpa);
        this.cpas.add(pCurrentCpa);
    }

    public List<ConfigurableProgramAnalysis> getCPAs() {
        return ImmutableList.copyOf(this.cpas);
    }
}

